static char     widgets_rcsid[] = "widgets.c,v 1.2 1994/11/28 16:56:24 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  widgets.c,v
 * Revision 1.2  1994/11/28  16:56:24  kerce
 * *** empty log message ***
 *
 * Revision 1.6  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.5  1994/08/21  03:58:12  raju
 * *** empty log message ***
 *
 * Revision 1.4  1994/08/21  03:00:41  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/07/15  18:12:20  raju
 * indented
 *
 * Revision 1.2  1994/07/15  11:59:15  raju
 * Wrote MENUTYPE section, and also the callback ChangeText for
 * changing the text input field.
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Pixmap         radiopix=(Pixmap)NULL;
static Pixmap         actionpix=(Pixmap)NULL;

#define gos_width 16
#define gos_height 16
static char gos_bits[] = {
   0xff, 0xff, 0x01, 0x80, 0x01, 0x80, 0xf9, 0x9f, 0xf9, 0x9f, 0xf9, 0x9f,
   0xf9, 0x9f, 0xf9, 0x9f, 0xf9, 0x9f, 0xf9, 0x9f, 0xf9, 0x9f, 0xf9, 0x9f,
   0xf9, 0x9f, 0x01, 0x80, 0x01, 0x80, 0xff, 0xff};
#define go_width 16
#define go_height 16
static char go_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x03, 0xfe, 0x03, 0x06, 0x00,
   0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x86, 0x33, 0x86, 0x4a,
   0x86, 0x4a, 0xfe, 0x4a, 0xfe, 0x32, 0x00, 0x00};

#define gorev_width 16
#define gorev_height 16
static char gorev_bits[] = {
   0x00, 0x00, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0x0e, 0x70, 0x0e, 0x70,
   0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
   0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0x00, 0x00};

/****************************************************************
 * createpixmaps - Create pixmaps for radio and command buttons.
 */
void createpixmaps()
{


    /*
     * Create Pixmaps for toggle, radio, and command buttons
     */

     actionpix = create_machine_logo(getmainwindow(),
		get_graphics_context(getmainwindow()),
		gos_bits,gos_width,gos_height);

     radiopix = create_machine_logo(getmainwindow(),
		get_graphics_context(getmainwindow()),
		gorev_bits,gorev_width,gorev_height);

}

/***********************************************************
 * createdialogshell - Create and return a dialogshell widget
 */
Widget createdialogshell(Widget parent,char *name,Cardinal x,Cardinal y)
{
	Widget          popup, widget;
	Arg             args[32];
	int             ii;


	ii = 0;
	XtSetArg(args[ii], XtNx, x);
	ii++;
	XtSetArg(args[ii], XtNy, y);
	ii++;
	popup = XtCreatePopupShell((String)"prompt", 
			(WidgetClass)transientShellWidgetClass, 
			(Widget)parent, (ArgList)args, (Cardinal)ii);

	ii = 0;
	widget = XtCreateWidget((String)name, 
			(WidgetClass)dialogWidgetClass, 
			(Widget)popup, (ArgList)args, (Cardinal)ii);
	XtPopup((Widget)popup, (XtGrabKind)XtGrabNone);
	return (widget);
}


/***********************************************************
 * toggletf - Toggle a True or False flag
 */
XtCallbackProc toggletf(w, client_data, call_data)
	Widget          w;
	caddr_t         client_data, call_data;
{
	int             ii;
	Arg             args[32];

	if (QmonToggleGetState(w)) {
		ii = 0;
		XtSetArg(args[ii], XtNlabel, (String) "True ");
		ii++;
		XtSetValues(w, args, ii);
	} else {
		ii = 0;
		XtSetArg(args[ii], XtNlabel, "False");
		ii++;
		XtSetValues(w, args, ii);
	}
}
/***********************************************************
 * ChangeText - Change text in the text widget selected by
 *              the menu widgets.
 */
XtCallbackProc ChangeText(w, client_data, call_data)
	Widget          w;
	Widget          client_data, call_data;
{
	int             ii;
	Arg             args[5];
	String          ptr;

	ii = 0;
	XtSetArg(args[ii], XtNlabel, &ptr);
	ii++;
	XtGetValues(w, args, ii);


	ii = 0;
	XtSetArg(args[ii], XtNstring, ptr);
	ii++;
	XtSetValues(client_data, args, ii);
}


/***********************************************************
 * createmenuoptions - Create and return a options for menu
 */
Widget createmenuoptions(Widget parent,Widget  child,struct optionstruct *menu,XtCallbackProc actionproc)
{
	int             ii;
	int             jj;
	int             len;
	Arg             args[32];

	Widget          widget_rcinputh;
	Widget          widget_rcinputv;
	Widget          widget_separator;
	Widget          widget_rcoption;
	Widget          widget_labelinput;
	Widget          widget_textinput;
	Widget          widget_toggleflag;
	Widget          widget_mainmenu;
	Widget          widget_action;
	Widget          topwidget = NULL;
	Widget          leftform = NULL;
	Widget          radio = NULL;
	Widget          button = NULL;
	Widget          cmenu = NULL;
	Widget          entry = NULL;
	STACK_NODE     *p = NULL;
	char           *ptr1 = NULL;
	char           *ptr2 = NULL;
	char           *tmpptr = NULL;

	/*
	 * Create a horizontal RowColumn widget for menus that are long 
	 */
	/*
	 * ii=0; XtSetArg(args[ii],XtNorientation,XtorientVertical); ii++;
	 * XtSetArg(args[ii],XtNresizable,True); ii++; XtSetArg(args[ii],
	 * XtNfromVert, child); ii++;
	 * widget_rcinputh=XtCreateManagedWidget("rcinputh",formWidgetClass,pa
	 * rent,args,ii); 
	 *
	 */
	for (jj = 0; menu[jj].name; jj++) {

	     if ((jj % 12) == 0) {
		ii = 0;
		XtSetArg(args[ii], XtNresizable, True);
		ii++;
		XtSetArg(args[ii], XtNfromHoriz, leftform);
		ii++;
		XtSetArg(args[ii], XtNfromVert, child);
		ii++;
		leftform = widget_rcinputv = 
		XtCreateManagedWidget((String)"rcinputv", 
			(WidgetClass)formWidgetClass, 
			(Widget)parent, (ArgList)args, (Cardinal)ii);
			topwidget = NULL;
		}
		/*
		 * Create a widget for input 
		 */
		if (menu[jj].type == INPUTTYPE) {
			/*
			 * Create a widget for an input string 
			 */
		   topwidget = widget_rcoption =  
			QmonMakeForm((String)"rcoption",widget_rcinputv,topwidget);

		   widget_labelinput = 
			QmonMakeLabel((String)menu[jj].name,widget_rcoption);
		   widget_textinput = 
			QmonMakeTextInput((String)"TextInput",
			widget_rcoption, widget_labelinput, 
			(String)menu[jj].defaultarg);

		   menu[jj].widgetid = widget_textinput;

		}
		/*
		 * Else create a widget for a boolean flag 
		 */
		else if (menu[jj].type == FLAGTYPE) {
			topwidget = widget_rcoption = 
			QmonMakeForm((String)"rcoption",widget_rcinputv,topwidget);

		   widget_labelinput = 
			QmonMakeLabel((String)menu[jj].name,widget_rcoption);
			ii = 0;
			XtSetArg(args[ii], XtNlabel, (String) "False");
			ii++;
			XtSetArg(args[ii], XtNfromHoriz, widget_labelinput);
			ii++;
			widget_toggleflag =
				XtCreateManagedWidget((String)"toggle", 
					(WidgetClass)toggleWidgetClass, 
					(Widget)widget_rcoption, (ArgList)args,(Cardinal) ii);
			XtAddCallback(widget_toggleflag, XtNcallback, (XtCallbackProc) toggletf, (XtPointer) NULL);
			menu[jj].widgetid = widget_toggleflag;

			/*
			 * See if the initial value should be True 
			 */
			if (menu[jj].defaultarg)
				if (!strcmp("True", menu[jj].defaultarg))
					QmonToggleSetState(menu[jj].widgetid, True);
		}
		/*
		 * Else create a widget for a Radio group 
		 */
		else if (menu[jj].type == RADIOTYPE) {
/*
			widget_rcoption = 
			QmonMakeForm((String)"rcoption",widget_rcinputv,topwidget);
			topwidget = widget_rcoption ; 
*/

			ii = 0;
                        XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
                        ii++;
                        XtSetArg(args[ii], XtNfromVert, topwidget);
                        ii++;
                        XtSetArg(args[ii], XtNresizable, True);
                        ii++;
                        topwidget = widget_rcoption = XtCreateManagedWidget("rcoption", formWidgetClass, widget_rcinputv, args, ii);

		        widget_labelinput = 
			QmonMakeLabel((String)menu[jj].name,widget_rcoption);


			ii = 0;
			XtSetArg(args[ii], XtNlabel, (String) "False");
			ii++;
			XtSetArg(args[ii], XtNbitmap,radiopix); 
			ii++;
			XtSetArg(args[ii], XtNfromHoriz, widget_labelinput);
			ii++;
			if (radio != 0)
				XtSetArg(args[ii], XtNradioGroup, radio);
			ii++;
			widget_toggleflag =
				XtCreateManagedWidget((String)"radiotype", 
				(WidgetClass)toggleWidgetClass, 
				(Widget)widget_rcoption, (ArgList)args, (Cardinal)ii);
			XtAddCallback(widget_toggleflag, XtNcallback, (XtCallbackProc) toggletf, (XtPointer) NULL);
			if (radio == 0)
				radio = widget_toggleflag;
			menu[jj].widgetid = widget_toggleflag;


			/*
			 * See if the initial value should be True
			 * if(menu[jj].defaultarg)
			 * if(!strcmp("True",menu[jj].defaultarg))
			 * QmonToggleSetState(menu[jj].widgetid,True); 
			 */
		}
		/*
		 * Else create a widget for a push button action 
		 */
		else if (menu[jj].type == ACTIONTYPE) {
			/*
			 * Create a widget for an immediate action 
			 */
			topwidget = widget_rcoption =
			QmonMakeForm((String)"rcoption",widget_rcinputv,topwidget);

		   	widget_labelinput = 
			QmonMakeLabel((String)menu[jj].name,widget_rcoption);

			ii = 0;
			XtSetArg(args[ii], XtNfromHoriz, widget_labelinput);
			ii++;
			XtSetArg(args[ii], XtNbitmap, actionpix);
			ii++;
			widget_action =
				XtCreateManagedWidget((String)"actiontype", 
					(WidgetClass) commandWidgetClass, 
					(Widget) widget_rcoption, (ArgList)args,(Cardinal) ii);

			menu[jj].widgetid = widget_action;
			XtAddCallback(menu[jj].widgetid, XtNcallback, (XtCallbackProc) actionproc, (XtPointer) NULL);

		}
		/*                                           
		 * Else create a widget for a menu type action 
		 */
		else if (menu[jj].type == MENUTYPE) {
			topwidget = widget_rcoption =
			QmonMakeForm((String)"rcoption",widget_rcinputv,topwidget);

			if(menu[jj].list) {
			ii = 0;
			XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
			ii++;
			button = XtCreateManagedWidget((String)menu[jj].name, 
				(WidgetClass)menuButtonWidgetClass, 
				(Widget)widget_rcoption, (ArgList)args,(Cardinal) ii);

		        widget_textinput = 
		     	     QmonMakeTextInput((String)menu[jj].name,
			     widget_rcoption, button, (String)NULL);
			     menu[jj].widgetid = widget_textinput;

		        cmenu =
			     XtCreatePopupShell("menu", simpleMenuWidgetClass, button, NULL, ZERO);
		        p = (STACK_NODE *)malloc(sizeof(STACK_NODE));
		        for (p = menu[jj].list ; p != NULL; p = p->next ) {
		            entry = XtCreateManagedWidget(p->name, smeBSBObjectClass, cmenu, NULL, ZERO);
		            XtAddCallback(entry, XtNcallback, (XtCallbackProc) ChangeText, (Widget) widget_textinput);
		        }
		        }
			else {
		   		widget_labelinput = 
					QmonMakeLabel((String)menu[jj].name,widget_rcoption);
		   		widget_textinput = 
					QmonMakeTextInput((String)"TextInput",
					widget_rcoption, widget_labelinput, 
					(String)menu[jj].defaultarg);

		   		menu[jj].widgetid = widget_textinput;
			}

		}
	}
}

/*
 * QmonAddButton - same as XawDialogAddButton () except that it returns the
 * child widget id 
 */
Widget QmonAddButton(Widget parent,String name,XtCallbackProc func,XtPointer client_data)
{
	Widget          button = XtCreateManagedWidget(name, commandWidgetClass, parent, NULL, 0);
	XtAddCallback(button, XtNcallback, (XtCallbackProc) func, (XtPointer) client_data);
	return button;
}

/*
 * QmonAddButtonN - same as XawDialogAddButton () except that it returns the
 * child widget id 
 */
Widget QmonAddButtonN(Widget parent,Widget  neighbor,String name,XtCallbackProc func,XtPointer client_data)
{
	int             ii = 0;
	Arg             args[5];
	Widget          button;

	XtSetArg(args[ii], XtNfromHoriz, neighbor);
	ii++;
	button = XtCreateManagedWidget(name, commandWidgetClass, parent, args, ii);
	XtAddCallback(button, XtNcallback, (XtCallbackProc) func, (XtPointer) client_data);
	return button;
}
/*
 * QmonAddButtonV - same as XawDialogAddButton () except that it returns the
 * child widget id 
 */
Widget QmonAddButtonV(Widget parent,Widget  neighbor,String name,XtCallbackProc func,XtPointer client_data)
{
	int             ii = 0;
	Arg             args[5];
	Widget          button;

	XtSetArg(args[ii], XtNfromVert, neighbor);
	ii++;
	button = XtCreateManagedWidget(name, commandWidgetClass, parent, args, ii);
	XtAddCallback(button, XtNcallback, (XtCallbackProc) func, (XtPointer) client_data);
	return button;
}

/*
 * QmonAddToggle - Add a toggle widget returns widget id 
 */
Widget QmonAddToggle(Widget parent,String name,XtCallbackProc func,XtPointer client_data)
{
	Widget          toggle = XtCreateManagedWidget(name, toggleWidgetClass, parent, NULL, 0);
	XtAddCallback(toggle, XtNcallback, (XtCallbackProc) func, (XtPointer) client_data);
	return toggle;
}
/*
 * QmonAddToggleV - Add a toggle widget returns widget id 
 */
Widget QmonAddToggleV(Widget parent,Widget  neighbor,String name,XtCallbackProc func,XtPointer client_data)
{
	int             ii = 0;
	Arg             args[5];
	Widget          toggle;

	XtSetArg(args[ii], XtNfromVert, neighbor);
	ii++;
	toggle = XtCreateManagedWidget(name, toggleWidgetClass, parent, args, ii);
	XtAddCallback(toggle, XtNcallback, (XtCallbackProc) func, (XtPointer) client_data);
	return toggle;
}

/*
 * QmonTextGetString - Get the string of the text widget returns char pointer
 * to string. 
 */
String QmonTextGetString(Widget w)
{
	int             ii = 0;
	Arg             args[5];
	String          ptr;

	XtSetArg(args[ii], XtNstring, &ptr);
	ii++;
	XtGetValues(w, args, ii);
	ptr[strlen(ptr)]=0;
	return ptr;
}
/*
 * QmonTextSetString - Set the string of the text widget 
 */
void QmonTextSetString(Widget w,String s)
{
	int             ii = 0;
	Arg             args[5];

	XtSetArg(args[ii], XtNstring, s);
	ii++;
	XtSetValues(w, args, ii);
}
/*
 * QmonToggleGetState - Get the state of the toggle widget returns char
 * pointer to string. 
 */
Boolean QmonToggleGetState(Widget w)
{
	int             ii = 0;
	Arg             args[5];
	Boolean         ptr;

	XtSetArg(args[ii], XtNstate, &ptr);
	ii++;
	XtGetValues(w, args, ii);
	return ptr;
}
/*
 * QmonToggleSetState - Set the state of the toggle widget 
 *
 */
void QmonToggleSetState(Widget w,Boolean state)
{
	int             ii = 0;
	Arg             args[5];

	XtSetArg(args[ii], XtNstate, state);
	ii++;
	if (state) {
		XtSetArg(args[ii], XtNlabel, (String) "True ");
		ii++;
	} else {
		XtSetArg(args[ii], XtNlabel, (String) "False");
		ii++;
	}
	XtSetValues(w, args, ii);
}

Widget QmonMakeForm(String name,Widget  parent,Widget topwidget)
{

     int ii;
     Arg args[5];
     Widget w;

     ii = 0;
     XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
     ii++;
     XtSetArg(args[ii], XtNfromVert, topwidget);
     ii++;
     XtSetArg(args[ii], XtNresizable, True);
     ii++;
     w = XtCreateManagedWidget(name,(WidgetClass) formWidgetClass,
             (Widget)parent,(ArgList) args,(Cardinal)ii);

     return w;

}

/*
 ii = 0;
                        XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
                        ii++;
                        XtSetArg(args[ii], XtNfromVert, topwidget);
                        ii++;
                        XtSetArg(args[ii], XtNresizable, True);
                        ii++;
                        topwidget = widget_rcoption = XtCreateManagedWidget("rcoption", formWidgetClass, wid
get_rcinputv, args, ii);
*/


Widget QmonMakeLabel(String name,Widget  parent)
{

     int ii;
     Arg args[5];
     Widget w;

     ii = 0;
     XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
     ii++;
     w = XtCreateManagedWidget(name, (WidgetClass)labelWidgetClass, 
				(Widget)parent,(ArgList)args,
				(Cardinal)ii);
     return w;

}
Widget QmonMakeTextInput(String name,Widget  parent,Widget  neighbor,String defaultarg)
{

     int ii;
     Arg args[5];
     Widget w;


     ii = 0;
     XtSetArg(args[ii], XtNeditType, XawtextEdit);
     ii++;
     XtSetArg(args[ii], XtNstring, defaultarg);
     ii++;
     XtSetArg(args[ii], XtNfromHoriz, neighbor);
     ii++;
     XtSetArg(args[ii], XtNresize, XawtextResizeBoth);
     ii++;
     XtSetArg(args[ii], XtNwidth, (Dimension) 150);
     ii++;
     w = XtCreateManagedWidget(name, 
		(WidgetClass) asciiTextWidgetClass, 
		(Widget)parent,(ArgList)args,(Cardinal)ii);
     return w;

}
