/****************************************************************************
**
** Copyright (C) 2003-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.org>,
**                         Jose Hernandez <joseh@tesco.net>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include <qfile.h>
#include <qstringlist.h>
#include <qtextstream.h>

#include "ccvscommand.h"
#include "directory.h"


CCvsCommand::CCvsCommand (bool Undoable, bool Recursive, bool needRereadTree) :
   m_Undoable (Undoable), m_Recursive (Recursive), m_needRereadTree (needRereadTree)
{
}


CCvsCommand::~CCvsCommand ()
{
}


bool CCvsCommand::isRecursive ()
{
   return m_Recursive;
}


bool CCvsCommand::isUndoable ()
{
   return m_Undoable;
}

bool CCvsCommand::needRereadTree () {
   return m_needRereadTree;
}

/**
 * Construct a "change cvs root" command. 
 *
 * @param	CvsRoot
 *	CvsRoot variable
 * @param	Recursive
 *	apply command recursively.
 */

CCvsCommandChRoot::CCvsCommandChRoot (const QString &CvsRoot, bool Recursive) :
   CCvsCommand (true, Recursive, true), m_CvsRoot (CvsRoot)
{
}


CCvsCommandChRoot::CCvsCommandChRoot (CCvsCommandChRoot &Other) :
   CCvsCommand (Other)
{
}


CCvsCommandChRoot::~CCvsCommandChRoot ()
{
}


/**
 * Changes the cvs root of a sandbox module (directory)
 *
 * @param	Module
 *	Target directory.
 * @return
 *	<i>true</i> on success, <i>false</i> otherwise.
 */

bool CCvsCommandChRoot::execute (Directory &Module)
{
   /* TODO: store unexecution data so that the command can be undone
    * at a later stage if required.
    */  
   QFile file (Module.fullName () + "/CVS/Root");

   if (file.open (IO_WriteOnly))
      {
         QTextStream stream (&file);
         stream << m_CvsRoot << endl;
         file.close ();

         return Module.checkDirForControl ();
      }

   return false;
}


bool CCvsCommandChRoot::unexecute (Directory &)
{
   /* TODO: Add support for undoing this command. */
   return false;
}

