/*
 * @(#)$Id: ccode.h,v 1.1 1994/04/18 16:21:29 shin Exp $
 *	- Chinese coding scheme constants
 */
#ifndef	_ccode_h
#define	_ccode_h

/* Boolean */
#ifndef		FALSE
#define		FALSE	(0)
#define		TRUE	(!FALSE)
#endif

#ifndef	BUFSIZ
#define		BUFSIZ	1024
#endif

/* ASCII control codes */
#define		ASC_SO	0x0e
#define		ASC_SI	0x0f

#define		CODE_STRING	"binetlHp7gho"

#define		CODE_BIG5	0
#define		CODE_IBM5550	1
#define		CODE_NSC	2
#define		CODE_EUC	3
#define		CODE_TCA	4
#define		CODE_TEL	5
#define		CODE_IBMH	6
#define		CODE_NSCP	7

#define		CODE_BIG5_7	8
#define		CODE_GB		9
#define		CODE_HZ		10
#define		CODE_OPT7	11

/* output modes for 7-bit chinese characters */
#define		DST_B5E		CODE_BIG5_7
#define		DST_HZ		CODE_HZ
#define		DST_OPT		CODE_OPT7

/*
 * We can actually set the upper limit down to 0xf9 so that we will not regard
 * characters of the form `~X' as Big5 char. This could avoid ambiguity
 * with ocassional `B5B5B5B5~}' stuffs in a big5 file, whose trailing '~}'
 * is left by an imperfect HZ to BIG5 program.
 */

#define	is_high(x)	((x)>=0xa1&&(x)<=0xfe)
/*
#define	is_high(x)	((x)>=0xa1&&(x)< 0xfe)
#define	is_high(x)	((x)>=0xa1&&(x)<=0xf9)
*/
#define	is_low(x)	(!is_high(x))

#define	is_B51(x)	((x)>=0xa1&&(x)<=0xfe)
#define	is_B52(x)	(((x)>=0x40&&(x)<=0x7e)||((x)>=0xa1&&(x)<=0xfe))

#define	is_GB1(x)	((x)>=0xa1&&(x)<=0xf7)
#define	is_GB2(x)	((x)>=0xa1&&(x)<=0xfe)

#endif	/* _ccode_h */
/*
 * History:
 *
 * $Log: ccode.h,v $
 * Revision 1.1  1994/04/18  16:21:29  shin
 * Initial revision
 *
 */
