/*
 * $Id$
 */
#include	<stdio.h>
#include	"ccode.h"

#ifdef	DEBUG_CNVTCODE
static FILE	*log;
#endif	/* DEBUG_CNVTCODE */

/*
 * @(#)cnvtcode: code conversion between traditional chinese
 *	and simplified chinese codes
 *
 * return:	outlen
 *		wbuff[outlen] = 0;
 */
cnvtcode(buff, wbuff, ic, oc, inlen, outlen)
char	buff[];			/* input buffer */
char	wbuff[];		/* converted output */
int	ic;			/* input code */
int	oc;			/* output code */
int	inlen;			/* length of input buffer */
int	*outlen;		/* length of output buffer */
{
	char tmp[BUFSIZ+1];

	if (ic == oc) {
		bcopy(buff, wbuff, *outlen = inlen);
		wbuff[*outlen] = '\0';
		return(*outlen);
	}

	switch (ic) {
	case CODE_BIG5:
		switch(oc) {
		case CODE_BIG5_7:
			b5encode(buff,wbuff,inlen,outlen,CODE_BIG5,CODE_BIG5_7);
			break;
		case CODE_OPT7:
			b5encode(buff,wbuff,inlen,outlen,CODE_BIG5,CODE_OPT7);
			break;
		case CODE_HZ:
			b5encode(buff,wbuff,inlen,outlen,CODE_BIG5,CODE_HZ);
			break;
		case CODE_GB:
			Big2GB(buff,wbuff,inlen,outlen);
			break;
		default:
			Tch2Tch(buff,wbuff,CODE_BIG5,oc,inlen,outlen);	break;
			break;
		}
	break;
	case CODE_GB:
		switch(oc) {
		case CODE_HZ:
			b5encode(buff,wbuff,inlen,outlen,CODE_GB,CODE_HZ);
			break;
		case CODE_BIG5:
			GB2Big(buff,wbuff,inlen,outlen);
			break;
		case CODE_BIG5_7:
			b5encode(buff,wbuff,inlen,outlen,CODE_GB,CODE_BIG5_7);
			break;
		case CODE_OPT7:
			b5encode(buff,wbuff,inlen,outlen,CODE_GB,CODE_OPT7);
			break;
		default:
			GB2Big(buff,tmp,inlen,outlen);
			Tch2Tch(tmp,wbuff,CODE_BIG5,oc,*outlen,outlen);
			break;
		}
	break;
	case CODE_HZ:
		switch (oc) {
		case CODE_GB:
			b5decode(buff,wbuff,inlen,outlen,CODE_GB);
			break;
		case CODE_BIG5:
			b5decode(buff,wbuff,inlen,outlen,CODE_BIG5);
			break;
		case CODE_BIG5_7:
			b5decode(buff,tmp,inlen,outlen,CODE_GB);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_GB,CODE_BIG5_7);
			break;
		case CODE_OPT7:
			b5decode(buff,tmp,inlen,outlen,CODE_GB);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_GB,CODE_OPT7);
			break;
		default:
			b5decode(buff,tmp,inlen,outlen,CODE_BIG5);
			Tch2Tch(tmp,wbuff,CODE_BIG5,oc,*outlen,outlen);
			break;
		}
	break;
	case CODE_BIG5_7:
		switch(oc) {
		case CODE_BIG5:
			b5decode(buff,wbuff,inlen,outlen,CODE_BIG5);
			break;
		case CODE_GB:
			b5decode(buff,wbuff,inlen,outlen,CODE_GB);
			break;
		case CODE_HZ:
			b5decode(buff,tmp,inlen,outlen,CODE_BIG5);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_BIG5,CODE_HZ);
			break;
		case CODE_OPT7:
			b5decode(buff,tmp,inlen,outlen,CODE_BIG5);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_BIG5,CODE_OPT7);
			break;
		default:
			b5decode(buff,tmp,inlen,outlen,CODE_BIG5);
			Tch2Tch(tmp,wbuff,CODE_BIG5,oc,*outlen,outlen);
			break;
		}
	break;
	case CODE_OPT7:
		switch (oc) {
		case CODE_GB:
			b5decode(buff,wbuff,inlen,outlen,CODE_GB);
			break;
		case CODE_BIG5:
			b5decode(buff,wbuff,inlen,outlen,CODE_BIG5);
			break;
		case CODE_BIG5_7:
			b5decode(buff,tmp,inlen,outlen,CODE_BIG5);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_BIG5,CODE_BIG5_7);
			break;
		case CODE_HZ:
			b5decode(buff,tmp,inlen,outlen,CODE_GB);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_GB,CODE_HZ);
			break;
		default:
			b5decode(buff,tmp,inlen,outlen,CODE_BIG5);
			Tch2Tch(tmp,wbuff,CODE_BIG5,oc,*outlen,outlen);
			break;
		}
	break;
	default:	/* Traditional Chinese => oc */
		switch(oc) {
		case CODE_BIG5_7:
			Tch2Tch(buff,tmp,ic,CODE_BIG5,inlen,outlen);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_BIG5,CODE_BIG5_7);
			break;
		case CODE_GB:
			Tch2Tch(buff,tmp,ic,CODE_BIG5,inlen,outlen);
			Big2GB(tmp,wbuff,*outlen,outlen);
			break;
		case CODE_HZ:
			Tch2Tch(buff,tmp,ic,CODE_BIG5,inlen,outlen);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_BIG5,CODE_HZ);
			break;
		case CODE_OPT7:
			Tch2Tch(buff,tmp,ic,CODE_BIG5,inlen,outlen);
			b5encode(tmp,wbuff,*outlen,outlen,CODE_BIG5,CODE_OPT7);
			break;
		case CODE_BIG5:
		default:
			Tch2Tch(buff,wbuff,ic,oc,inlen,outlen);
			break;
		}
	break;
	} /* switch (ic) */

	wbuff[*outlen] = '\0';
	return(*outlen);
} /* cnvtcode */

