/* $Id: pop_smtp.cpp,v 1.13 2001/07/10 03:22:58 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2001 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

extern cfgfile Config;

#ifdef USE_GPASSWD
#include <gpasswd.h>
extern gPasswd Passwd;
#endif

FD_POPacc *pacc_obj;
static FD_config_send *smtp_obj;
static FD_config_news *nntp_obj;
static FD_config_ldap *ldap_obj;
static FD_acc_pop *pop_acc_obj;
static FD_acc_smtp *smtp_acc_obj;
static int ready = 0;

void pop_account_free();

void SMTP_Host_Call(FL_OBJECT * obj, long param) {
}

void NNTP_Call(FL_OBJECT * obj, long param) {
}

void POP_Call(FL_OBJECT * obj, long param) {
}

void SPOP_Call(FL_OBJECT * obj, long param) {
}

void POP_DMark_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!", "Every retrieved message",
                        "will remain be marked as unretrieved");
}

void POP_2_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!", "SmartPOP features",
                        "will not work with POP2 server");
}

void POP_APOP_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "Make sure APOP is supported by your POP server",
                        "Don't forget to enter APOP shared secret instead of Password");
}

void SPOP_UID_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!", "This feature works only",
                        "on last 3000 messages retrieved");
}

void SPOP_XLST_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!", "This feature is not part of RFC",
                        "and most POP servers does not support it");
}
void POP_Smart_Call(FL_OBJECT * obj, long param) {
}

void SMTP_POP_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "This feature is supported only by few",
                        "POP server implementations");
}

void SMTP_Port_Call(FL_OBJECT * obj, long param) {
}

void SMTP_Bg_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "If background sending is enabled you will not be able",
                        "to recover from errors occured during send process");
}

void SMTP_SMTP_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "XFMail will send mail directly to SMTP gateway",
                        "Make sure that host name is correct and the gateway is accessible from your computer");
}

void Misc_SMail_Call(FL_OBJECT * obj, long param) {
}

void POP_Host_Call(FL_OBJECT * obj, long param) {
}

void POP_Port_Call(FL_OBJECT * obj, long param) {
}

void POP_User_Call(FL_OBJECT * obj, long param) {
}

void POP_Pwd_Call(FL_OBJECT * obj, long param) {
}

void P_Call(FL_OBJECT * obj, long param) {
}

void POP_Store_Pwd_Call(FL_OBJECT * obj, long param) {

  if(fl_get_button(pop_acc_obj->Pop_Storpwd)
#ifdef USE_GPASSWD 
     && (Config.getInt("use_gpasswd",0) == 0)
#endif
     ) {
    fl_show_alert("WARNING", "You are about to store an unencrypted password:",
		  "make sure .xfmsources is not readable by others",1);
  }
}

void NNTP_Store_Pwd_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(nntp_obj->NNTP_Store_Pwd)) {
        fl_show_alert("WARNING", "This is very unsecure option",
                      "make sure your config file (.xfmailrc) is not readable by anyone else",
                      1);
        Config.setFlags("nntpasswd", 0);
    }
}

void POP_Delete_Call(FL_OBJECT * obj, long param) {
}

void pop_acc(struct _retrieve_src *source) {
    struct _pop_src *pop;
    char buf[16];

    pop = (struct _pop_src *) source->spec;
    if(ready)
        return;
    ready = 1;
    pop_acc_obj = create_form_acc_pop();

    fl_set_input(pop_acc_obj->Pop_Host, pop->hostname);
    fl_set_input(pop_acc_obj->Pop_Port, pop->service);
    fl_set_input(pop_acc_obj->Pop_User, pop->username);
    fl_set_input(pop_acc_obj->Pop_Password, pop->password);
    sprintf(buf, "%ld", pop->maxmsg);
    fl_set_input(pop_acc_obj->Pop_Maxmsg, buf);

    fl_set_button(pop_acc_obj->Pop_POP2, (pop->flags & PSRC_POP2) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Delete,
                  (pop->flags & PSRC_DELETE) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Dmark,
                  (pop->flags & PSRC_DMARK) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Storpwd,
                  (pop->flags & PSRC_STOREPWD) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Log,
                  (pop->flags & PSRC_LOGSESSION) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Oheader,
                  (pop->flags & PSRC_GETHEADER) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Skip,
                  (pop->
                   flags & PSRC_SKIPBIG) ? 1 : ((pop->
                                                 flags & PSRC_GETHEADER) ?
                                                0 : 1));
    fl_set_button(pop_acc_obj->Pop_UID,
                  (pop->flags & PSRC_CHECKUID) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Status,
                  (pop->flags & PSRC_CHECKSTAT) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Header,
                  (pop->
                   flags & PSRC_STATHEADER) ? 1 : ((pop->
                                                    flags & PSRC_STATXLST)
                                                   ? 0 : 1));
    fl_set_button(pop_acc_obj->Pop_XLST,
                  (pop->flags & PSRC_STATXLST) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_APOP, (pop->flags & PSRC_APOP) ? 1 : 0);

    fl_show_form(pop_acc_obj->acc_pop, FL_PLACE_CENTER, FL_TRANSIENT,
                 "POP server");
    fl_do_only_forms();

    strncpy(pop->hostname, fl_get_input(pop_acc_obj->Pop_Host),
            MAX_HOST - 1);
    pop->hostname[MAX_HOST - 1] = '\0';
    strncpy(pop->service, fl_get_input(pop_acc_obj->Pop_Port), 15);
    pop->service[15] = '\0';
    strncpy(pop->username, fl_get_input(pop_acc_obj->Pop_User), 
	    POP_MAX_USERNAME_LEN);
    pop->username[POP_MAX_USERNAME_LEN] = '\0';
    strncpy(pop->password, fl_get_input(pop_acc_obj->Pop_Password), 
	    POP_MAX_PASSWD_LEN);
    pop->password[POP_MAX_PASSWD_LEN] = '\0';
    pop->maxmsg = atoi((char *) fl_get_input(pop_acc_obj->Pop_Maxmsg));

    pop->flags = 0;
    if(fl_get_button(pop_acc_obj->Pop_POP2))
        pop->flags |= PSRC_POP2;
    if(fl_get_button(pop_acc_obj->Pop_Delete))
        pop->flags |= PSRC_DELETE;
    if(fl_get_button(pop_acc_obj->Pop_Dmark))
        pop->flags |= PSRC_DMARK;
    if(fl_get_button(pop_acc_obj->Pop_Storpwd))
        pop->flags |= PSRC_STOREPWD;
    if(fl_get_button(pop_acc_obj->Pop_Log))
        pop->flags |= PSRC_LOGSESSION;
    if(fl_get_button(pop_acc_obj->Pop_Oheader))
        pop->flags |= PSRC_GETHEADER;
    if(fl_get_button(pop_acc_obj->Pop_Skip))
        pop->flags |= PSRC_SKIPBIG;
    if(fl_get_button(pop_acc_obj->Pop_UID))
        pop->flags |= PSRC_CHECKUID;
    if(fl_get_button(pop_acc_obj->Pop_Status))
        pop->flags |= PSRC_CHECKSTAT;
    if(fl_get_button(pop_acc_obj->Pop_Header))
        pop->flags |= PSRC_STATHEADER;
    if(fl_get_button(pop_acc_obj->Pop_XLST))
        pop->flags |= PSRC_STATXLST;
    if(fl_get_button(pop_acc_obj->Pop_APOP))
        pop->flags |= PSRC_APOP;

    fl_hide_form(pop_acc_obj->acc_pop);
    fl_free_form(pop_acc_obj->acc_pop);
    fl_free(pop_acc_obj);
    pop_acc_obj = NULL;

    ready = 0;
    return;
}

void POP_Ok_Call(FL_OBJECT * obj, long param) {
}

void pop_account_init() {
    pacc_obj = create_form_POPacc();
}

void pop_account_free() {
    fl_free(pacc_obj);
}

void pop_account(struct _pop_src *pop) {

    if(ready)
        return;

    ready = 1;

    fl_set_input(pacc_obj->P_Username, pop->username);
    fl_set_input(pacc_obj->P_Password, pop->password);
    fl_set_object_label(pacc_obj->P_Server, pop->hostname);
    fl_set_object_label(pacc_obj->P_Title, "POP account on");

    fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);

    fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT,
                 "POP account");

    fl_do_only_forms();

    strncpy(pop->username, (char *) fl_get_input(pacc_obj->P_Username),
	        POP_MAX_USERNAME_LEN);
	pop->username[POP_MAX_USERNAME_LEN] = '\0';


    strncpy(pop->password, (char *) fl_get_input(pacc_obj->P_Password),
	    POP_MAX_PASSWD_LEN);
    pop->password[POP_MAX_PASSWD_LEN] = '\0';


    fl_hide_form(pacc_obj->POPacc);

    ready = 0;
    return;
}

void nntp_account() {

    if(ready)
        return;

    ready = 1;

    fl_set_input(pacc_obj->P_Username,
                 Config.getCString("nntpuser", user_n));
    fl_set_input(pacc_obj->P_Password,
                 Config.getCString("nntpasswd", ""));
    fl_set_object_label(pacc_obj->P_Server,
                        Config.getCString("nntphost", "news"));
    fl_set_object_label(pacc_obj->P_Title, "NNTP authorization on");
    fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);
    fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT,
                 "NEWS login");

    fl_do_only_forms();

    Config.set("nntpuser", (char *) fl_get_input(pacc_obj->P_Username));
    Config.set("nntpasswd", (char *) fl_get_input(pacc_obj->P_Password));
    fl_hide_form(pacc_obj->POPacc);
    ready = 0;
    return;
}

void auth_smtp_account(char * hostname, char * username , char * password) {

    if(ready)
        return;

    ready = 1;

    fl_set_input(pacc_obj->P_Username, username);
    fl_set_input(pacc_obj->P_Password, password);
    fl_set_object_label(pacc_obj->P_Server, hostname);
    fl_set_object_label(pacc_obj->P_Title, "Authenticated SMTP account on");

    fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);

    fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT,
                 "SMTP account");

    fl_do_only_forms();

    strncpy(username, (char *) fl_get_input(pacc_obj->P_Username),
	        SMTP_MAX_USERNAME_LEN);
	*(username+SMTP_MAX_USERNAME_LEN) = '\0';


    strncpy(password, (char *) fl_get_input(pacc_obj->P_Password),
	    SMTP_MAX_PASSWD_LEN);
    *(password + SMTP_MAX_PASSWD_LEN) = '\0';


    fl_hide_form(pacc_obj->POPacc);

    ready = 0;
    return;
}

void news_conf(int set_default, FD_config_news * form) {

    nntp_obj = form;
    fl_set_input(nntp_obj->NNTP_Host,
                 Config.getCStringDefault("nntphost", "news", set_default));
    fl_set_input(nntp_obj->NNTP_Port,
                 Config.getCStringDefault("nntport", "119", set_default));
    fl_set_input(nntp_obj->NNTP_Username,
                 Config.getCStringDefault("nntpuser", user_n, set_default));
    fl_set_input(nntp_obj->NNTP_Password,
                 Config.getCStringDefault("nntpasswd", "", set_default));
    fl_set_button(nntp_obj->NNTP_Store_Pwd,
                  Config.getIntDefault("nntpstorpwd", 0, set_default));
    fl_set_button(nntp_obj->NNTP_Authorize,
                  Config.getIntDefault("nntpauth", 0, set_default));
    fl_set_button(nntp_obj->NNTP_Log, (logging & LOG_NNTP) ? 1 : 0);
    if(fl_get_button(nntp_obj->NNTP_Store_Pwd))
        Config.setFlags("nntpasswd", CF_UNSECURE);
    else
        Config.setFlags("nntpasswd", DONT_STORE | CF_UNSECURE);
}

void handle_news_input(FD_config_news * form) {
    nntp_obj = form;
    Config.set("nntphost", (char *) fl_get_input(nntp_obj->NNTP_Host));
    Config.set("nntport", (char *) fl_get_input(nntp_obj->NNTP_Port));
    Config.set("nntpuser", (char *) fl_get_input(nntp_obj->NNTP_Username));
    Config.set("nntpasswd", (char *) fl_get_input(nntp_obj->NNTP_Password));
    Config.set("nntpstorpwd", fl_get_button(nntp_obj->NNTP_Store_Pwd));
    Config.set("nntpauth", fl_get_button(nntp_obj->NNTP_Authorize));
    if(fl_get_button(nntp_obj->NNTP_Log))
        logging |= LOG_NNTP;
    else
        logging &= ~LOG_NNTP;
    return;
}

void smtp_conf(int set_default, FD_config_send * form) {

    smtp_obj = form;
    fl_set_input(smtp_obj->SMTP_Host,
                 Config.getCStringDefault("smtphost", "127.0.0.1", set_default));
    fl_set_input(smtp_obj->SMTP_Port,
                 Config.getCStringDefault("smtport", "25", set_default));
    switch(Config.getIntDefault("smtpsend", 0, set_default)) {
        case 0:
            fl_set_button(smtp_obj->SMTP_Sendmail, 1);
            break;

        case 1:
            fl_set_button(smtp_obj->SMTP_SMTP, 1);
            break;

        case 2:
            fl_set_button(smtp_obj->SMTP_POP, 1);
            break;

        default:
            fl_set_button(smtp_obj->SMTP_Sendmail, 1);
            break;
    }

    fl_set_input(smtp_obj->SMTP_POPSRC,
                 Config.getCStringDefault("smtppopsrc", "", set_default));
    fl_set_button(smtp_obj->SMTP_Bg,
                  Config.getIntDefault("smtpbg", 0, set_default));
    fl_set_button(smtp_obj->SMTP_Save,
                  Config.getIntDefault("smtpsave", 0, set_default));
    fl_set_button(smtp_obj->SMTP_Bcc,
                  Config.getIntDefault("smtpbcc", 0, set_default));
    fl_set_button(smtp_obj->SMTP_Off,
                  Config.getIntDefault("smtpoffl", 0, set_default));
    fl_set_button(smtp_obj->SMTP_DSN,
                  Config.getIntDefault("smtpdsn", 0, set_default));
    fl_set_input(smtp_obj->Misc_SMail,
                 Config.getCStringDefault("sendmail", _PATH_SENDMAIL, set_default));
    fl_set_input(smtp_obj->Sendmail_Opt,
                 Config.getCStringDefault("sendmailopt", "-i",
                                         set_default));
    fl_set_input(smtp_obj->Sendmail_DSN,
                 Config.getCStringDefault("sendmaildsn",
                                         "-R hdrs -N failure,delay,success",
                                         set_default));
    fl_set_button(smtp_obj->SMTP_Log, (logging & LOG_SMTP) ? 1 : 0);
}


void handle_smtp_input(FD_config_send * form) {
    smtp_obj = form;
    Config.set("smtphost", (char *) fl_get_input(smtp_obj->SMTP_Host));
    Config.set("smtport", (char *) fl_get_input(smtp_obj->SMTP_Port));
    if(fl_get_button(smtp_obj->SMTP_Sendmail))
        Config.set("smtpsend", 0);
    else if(fl_get_button(smtp_obj->SMTP_SMTP))
        Config.set("smtpsend", 1);
    else if(fl_get_button(smtp_obj->SMTP_POP))
        Config.set("smtpsend", 2);
    else
        Config.set("smtpsend", 0);
    Config.set("smtppopsrc", (char *) fl_get_input(smtp_obj->SMTP_POPSRC));
    Config.set("smtpbg", fl_get_button(smtp_obj->SMTP_Bg));
    Config.set("smtpsave", fl_get_button(smtp_obj->SMTP_Save));
    Config.set("smtpbcc", fl_get_button(smtp_obj->SMTP_Bcc));
    Config.set("smtpoffl", fl_get_button(smtp_obj->SMTP_Off));
    Config.set("smtpdsn", fl_get_button(smtp_obj->SMTP_DSN));
    offline = fl_get_button(smtp_obj->SMTP_Off);
    Config.set("sendmail", (char *) fl_get_input(smtp_obj->Misc_SMail));
    Config.set("sendmailopt", (char *) fl_get_input(smtp_obj->Sendmail_Opt));
    Config.set("sendmaildsn", (char *) fl_get_input(smtp_obj->Sendmail_DSN));
    if(fl_get_button(smtp_obj->SMTP_Log))
        logging |= LOG_SMTP;
    else
        logging &= ~LOG_SMTP;
    return;
}

void ldap_conf(int set_default, FD_config_ldap * form) {

    ldap_obj = form;

    fl_set_input(ldap_obj->LDAPserver, Config.getCStringDefault("LDAPserver", "ldap.bigfoot.com", set_default));
    fl_set_input(ldap_obj->LDAPport, Config.getCStringDefault("LDAPport", "389", set_default));
    fl_set_input(ldap_obj->LDAPbase, Config.getCStringDefault("LDAPbase", "", set_default));
    fl_set_counter_value(ldap_obj->LDAPmaxResults, (double) Config.getIntDefault("LDAPmaxResults", 20, set_default));

    return;
} 

void handle_ldap_input(FD_config_ldap * form) {
    ldap_obj = form;

    Config.set("LDAPserver", (char *) fl_get_input(ldap_obj->LDAPserver));
    Config.set("LDAPport", (char *) fl_get_input(ldap_obj->LDAPport));
    Config.set("LDAPbase", (char *) fl_get_input(ldap_obj->LDAPbase));
    Config.set("LDAPmaxResults", (int) fl_get_counter_value(ldap_obj->LDAPmaxResults));

    return;
}

#ifdef USE_GPASSWD
void  set_passphrase() {
  char * p = NULL;
  char passphrase[32];
  
  passphrase[0] = '\0';
  
  while(!p)
    p = (char *) fl_show_input("Please enter your global pass phrase", passphrase);
  
  Passwd.init(string(p));
}
#endif

/* added GUI stuff for SMTP account configuration */

void smtp_acc(struct _smtp_account *smtp) {

    if(ready)
        return;
    ready = 1;
    smtp_acc_obj = create_form_acc_smtp();

    fl_set_input(smtp_acc_obj->SMTP_Acct_Host, smtp->hostname);
    fl_set_input(smtp_acc_obj->SMTP_Acct_Port, smtp->service);
    fl_set_input(smtp_acc_obj->SMTP_Acct_Src,  smtp->src_name);
    fl_set_input(smtp_acc_obj->SMTP_Acct_User, smtp->username);
    fl_set_input(smtp_acc_obj->SMTP_Acct_Pwd, smtp->password);

    /* check that smtp->src_name is STILL a valid  source account */
    if (smtp->flags & SMTP_AUTH_SRC ) {
      switch( search_sources(smtp->src_name)) {
      case RSRC_POP:
      case RSRC_IMAP:
	break;
      default:
	smtp->flags &= ~SMTP_AUTH_SRC  ;
      }
    }
    fl_set_button(smtp_acc_obj->SMTP_Acct_Auth, 
		  (smtp->flags & SMTP_AUTH ) ? 1 : 0);
    fl_set_button(smtp_acc_obj->SMTP_Acct_Use_Src,
                  (smtp->flags & SMTP_AUTH_SRC) ? 1 : 0);
    fl_set_button(smtp_acc_obj->SMTP_Acct_Storpwd,
                  (smtp->flags & SMTP_STOREPWD) ? 1 : 0);

    fl_show_form(smtp_acc_obj->acc_smtp, FL_PLACE_CENTER, FL_TRANSIENT,
                 "SMTP Server Account Configuration");
    fl_do_only_forms();

    strncpy(smtp->hostname, fl_get_input(smtp_acc_obj->SMTP_Acct_Host),
            MAX_HOST - 1);
    smtp->hostname[MAX_HOST - 1] = '\0';
    strncpy(smtp->service, fl_get_input(smtp_acc_obj->SMTP_Acct_Port), 15);
    smtp->service[15] = '\0';


    if(fl_get_button(smtp_acc_obj->SMTP_Acct_Auth)) {
      smtp->flags |= SMTP_AUTH;

      if(fl_get_button(smtp_acc_obj->SMTP_Acct_Use_Src)) { 
        smtp->flags |= SMTP_AUTH_SRC;
	strncpy(smtp->src_name, fl_get_input(smtp_acc_obj->SMTP_Acct_Src), 31);
	smtp->src_name[31] = '\0';
	smtp->username[0] = '\0';
	smtp->password[0] = '\0';
	smtp->flags &= ~SMTP_STOREPWD;
      } else {
	smtp->flags &= ~SMTP_AUTH_SRC;
	smtp->src_name[0] = '\0';
	strncpy(smtp->username, fl_get_input(smtp_acc_obj->SMTP_Acct_User),  
		SMTP_MAX_PASSWD_LEN);
	smtp->username[SMTP_MAX_USERNAME_LEN] = '\0';
	strncpy(smtp->password, fl_get_input(smtp_acc_obj->SMTP_Acct_Pwd),
		SMTP_MAX_USERNAME_LEN);
	smtp->password[SMTP_MAX_PASSWD_LEN] = '\0';
	if(fl_get_button(smtp_acc_obj->SMTP_Acct_Storpwd))
	  smtp->flags |= SMTP_STOREPWD;
	else
	  smtp->flags &= ~SMTP_STOREPWD;
      }
    } else {
      smtp->username[0] = '\0';
      smtp->src_name[0] = '\0';
      smtp->password[0] = '\0';
      smtp->flags &= ~SMTP_AUTH;
      smtp->flags &= ~SMTP_STOREPWD;
      smtp->flags &= ~SMTP_AUTH_SRC;
    }

    fl_hide_form(smtp_acc_obj->acc_smtp);
    fl_free_form(smtp_acc_obj->acc_smtp);
    fl_free(smtp_acc_obj);
    smtp_acc_obj = NULL;


    ready = 0;
    return;
}


void SMTP_Acct_Storepwd_Call(FL_OBJECT * obj, long param) {
  if(fl_get_button(pop_acc_obj->Pop_Storpwd)
#ifdef USE_GPASSWD 
     && (Config.getInt("use_gpasswd",0) == 0)
#endif
     ) {
    fl_show_alert("WARNING", "You are about to store an unencrypted password:",
		  "make sure .xfmsmtp_accts is not readable by others",1);
  }
}


void SMTP_Acct_Call(FL_OBJECT * obj, long param) {
  char clear[2] = ""; 
  if(!fl_get_button(smtp_acc_obj->SMTP_Acct_Auth)) {
      fl_set_input(smtp_acc_obj->SMTP_Acct_User, clear);
      fl_set_input(smtp_acc_obj->SMTP_Acct_Pwd, clear);
      fl_set_input(smtp_acc_obj->SMTP_Acct_Src, clear);
      fl_set_button(smtp_acc_obj->SMTP_Acct_Storpwd, 0);
      fl_set_button(smtp_acc_obj->SMTP_Acct_Use_Src, 0);
  }
  return;
}

void SMTP_Acct_Auth_Call(FL_OBJECT * obj, long param) {
}

 
void SMTP_Acct_Use_Src_Call(FL_OBJECT * obj, long param) {
  char name[32];
  char clear[2] = ""; 
  int type;
  if(fl_get_button(smtp_acc_obj->SMTP_Acct_Use_Src)) {
    /* check if a valid account name is entered in the Account name
       box  (SMTP_Acct_Src) */
    strncpy(name,fl_get_input(smtp_acc_obj->SMTP_Acct_Src),31);
    name[31] = '\0';
  switch(type = search_sources( name )) {
    case RSRC_POP:
    case RSRC_IMAP:
      fl_set_input(smtp_acc_obj->SMTP_Acct_User, clear);
      fl_set_input(smtp_acc_obj->SMTP_Acct_Pwd, clear);
      fl_set_button(smtp_acc_obj->SMTP_Acct_Storpwd, 0);
      fl_set_button(smtp_acc_obj->SMTP_Acct_Auth, 1);
      break;
    default:
      fl_show_alert("WARNING", 
		    "The \"Account Name\" box does not contain",
		    "a valid POP/IMAP receive account name", 1);
      fl_set_button(smtp_acc_obj->SMTP_Acct_Use_Src,0);
    }
  }
  return;
}


