
## MUCAL ported to Python from C by Sam Webb
## Modified ala Corwin Booth to add xsec(11)=total crossection not including current edge
## This is thus a mutilation of a mutilation...
## contact: samwebb@slac.stanford.edu

## * Documentation (adapted from MUCAL.F and MUCAL.C):
## *
## * This is a program to calculate x-sections using McMaster
## * data in May 1969 edition.                            
## *
## * NOTE: this program has data for all the elements from 1 to 94  
## * with the following exceptions:
## *     84  po \
## *     85  at |
## *     87  fr |
## *     88  ra  > Mc Master did not have any data for these
## *     89  ac |
## *     91  pa |
## *     93  np /
## *
## * Python Usage:
## *
## * import mucal
## * [err,energy,xsec,fl_yield,errmsg] = mucal(element, Z, e_phot, unit)
## *
## * where:
## *
## *   element - the name of the element of interest. If Z is given
## *             (see below) element may be left blank.  If both Z
## *             and element are given they must agree.
## *   Z - the Z for the element of interest (0 if unknown). If
## *       element is given, Z may be 0.  If both element and Z
## *       are given they must agree. Z may not be < 0.
## *   e_phot - photon energy for calculation, in kev.  May not 
## *            be <0.  if e_phot=0 no calculations for the scattering 
## *            crossection is done.  Instead, only the various energy-
## *            independent physical constants for the element of interest 
## *            are returned.
## *   unit - units for the scattering crossections.  If 'c' or 'C'
## *          crossections are calculated in cm^2/g.  In all other
## *          cases, the crossections are in barns/atom.
## *   
## * Returned values:
## *
## *   energy - x-ray energies for the element, in keV
## *     energy[0]=k-edge energy 
## *     energy[1]=l1-edge energy
## *     energy[2]=l2-edge energy
## *     energy[3]=l3-edge energy
## *     energy[4]=m-edge energy 
## *     energy[5]=k-alpha1
## *     energy[6]=k-beta1 
## *     energy[7]=l-alpha1
## *     energy[8]=l-beta1 
## *
## *   xsec - various crossections and material constants for the element.
## *     xsec[0]=photoelectric x-section 
## *     xsec[1]=coherent x-section  
## *     xsec[2]=incoherent x-section
## *     xsec[3]=total x-section     
## *     xsec[4]=conversion factor      (cm^2/g to barns/atom)
## *     xsec[5]=absorption coefficient (cm^-1)
## *     xsec[6]=atomic weight          (g/mole)
## *     xsec[7]=density                (g/cm^3)
## *     xsec[8]=l1-edge jump           (fractional)
## *     xsec[9]=l2-edge jump           (fractional)
## *     xsec[10]=l3-edge jump          (fractional)
## *     xsec[11]=total x-section not including current edge
##
## *   fl_yield - fluorescent yield for the element
## *     fl_yield[0]= k fluorescence yield  
## *     fl_yeild[1]= l1 fluorescence yield	
## *     fl_yield[2]= l2 fluorescence yield	
## *     fl_yield[3]= l3 fluorescence yield 
## *
## *   err_msg - text of error message (if any).  contains a 
## *             description of any error conditions that may occur.
## *             must be at least 100 chars long.  when print_flag is
## *             set, the text of this buffer is printed to the terminal
## *
## * Return codes (defined in mucal.h):
## *   no_error    - no error
## *   no_input    - no name, no Z, no service
## *   no_zmatch   - Z does not match name
## *   no_data     - data not avaialble for requested material
## *   bad_z       - bad (negative) Z
## *   bad_name    - invalid element name
## *   bad_energy  - bad (negative) photon energy
## *   within_edge - photon energy within 1 eV of an edge (warning)
## *   m_edge_warn - M-edge data requested for a Z<30 element (warning)
## *   satan_rules - internal error of dubious origin :-)
## *
## * Remarks:
## *    If e_phot = 0 the program returns data for everything but xsec[0-3]
## *
## * Acknowledgment:
## *    The C port of MUCAL was made possible in part by a funds provided
## *    by the Industrial Macromeollecular Crystallography Association (IMCA).
## *
## Original comments follow
## * Original credits and version history follow:
##
## * MUCAL is written by Pathikrit Bandyopadhyay and has been 
## * hereby mutilated by Boyan Boyanov (boyanov@eos.ncsu.edu).  
## * Ported to C from version 1.7 of MUCAL.F, as distributed 
## * on xafsdb.iit.edu. Some of the input parameters have been 
## * renamed and moved around to more logical positions, at 
## * least IMHO.  
## *
## *
## *c     written by pathikrit bandyopadhyay                               |
## *c     at the university of notre dame.i am thankful to                 |
## *c     dr. b. a. bunker and mr. q. t. islam for their helpful           |
## *c     suggestions. special thanks goes to mr. m. zanabria              |
## *c     for helping to get all the data in.                              |
## *
## *c     put all returned values in array xsec/jul,28 _pat                |
## *c     can call it either by element name or z/jul,31 _pat              |
## *c     data input completed on sept 1,1985 ______pat                    |
## *c     change call format,include energy array,includ density           |
## *c     in xsec,add error # & error flag/sep,6 _pat                      |
## *c     correct l-edge calculation using step jump                       |
## *c     and warning for z<30/sep,9 _pat                                  |
## *c     return l-edges /sep 10,_ pat                                     |
## *c     return l-edge jumps,error 6 /sep 12,_ pat                        |
## *c     check for no name & z,error 7 /sep 13,_ pat                      |
## *c     thanks to quazi ljump can not be calculated for z<30 -pat        |
## *c     revision date dec 9,1985 _____________ pat                       |
## *c     l-edges for elements z=12-26 supplied from nsls handbook         |
## *c     & corrections as noted by kim of nrl, april6,1991 ______anne     |
## *c     add if statement so accept energy e=1. kev, and                  |
## *c     print ljump for z=27 and 28,april10,1991______________anne       |
## *c     corrected l2 l3 edge calculation (thanks to boyan)               |
## *c     using l-edge coefficianets instead of m-edge ones.____3/15/95 pat|
## *c     correct AK(1,57) coefficient (for La)                            |
## *c----------------------------------------------------------------------+
## *c     $Log:	mucal.f,v $
## *c Revision 1.9  7/7/95  14:48:38  pat
## *
## *
## * Additions to the C version:
## *    version 1.0:
## *      converted everything to double precision,march 4,95_____boyan
## *      checks for photon energies within 1 eV of l2 and l3
## *      edges march 4, 95_________boyan
## *      issues Z<30 warning for M edges only if Z<30 march 4, 95___boyan
## *    version 1.1:
## *      fix bug in L1 and higher edge calculations april 23, 96___boyan
## *         (thanks to L.Tavora@surrey.ac.uk for finding the bug)
## *    version 1.2:
## *	yet another bug fix in L-edge calculations may 29, 96___boyan
## *	   (thanks to N.Kawada (xnori@osk.threewebnet.or.jp) for
## *          finding the bug)
## *    version 1.3:
## *      correct densitties for several gaceous light elements
## *          april 25, 98___boyan
## */


#############################################################################
##
## START DATA SECTION
##
#############################################################################

Zmax=94
NELEM=103

#element chemical symbols
esym=[  "H" , "He", "Li", "Be", "B" , "C" , "N" , "O" , "F" , "Ne", "Na",
        "Mg", "Al", "Si", "P" , "S" , "Cl", "Ar", "K" , "Ca", "Sc", "Ti",
        "V" , "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As",
        "Se", "Br", "Kr", "Rb", "Sr", "Y" , "Zr", "Nb", "Mo", "Tc", "Ru",
        "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I" , "Xe", "Cs",
        "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy",
        "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W" , "Re", "Os", "Ir",
        "Pt", "Au", "Hd", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra",
        "Ac", "Th", "Pa", "U" , "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es",
        "Fm", "Md", "No", "Lw"]
#K-edges (keV)
kedge={ 1: 0.140000E-01,   2: 0.250000E-01,   3: 0.550000E-01,
    4: 0.112000E+00,   5: 0.188000E+00,   6: 0.284000E+00,
    7: 0.402000E+00,   8: 0.537000E+00,   9: 0.686000E+00,
    10: 0.867000E+00,  11: 0.107200E+01,  12: 0.130500E+01,
    13: 0.156000E+01,  14: 0.183900E+01,  15: 0.214900E+01,
    16: 0.247200E+01,  17: 0.282200E+01,  18: 0.320200E+01,
    19: 0.360700E+01,  20: 0.403800E+01,  21: 0.449300E+01,
    22: 0.496500E+01,  23: 0.546500E+01,  24: 0.598900E+01,
    25: 0.654000E+01,  26: 0.711200E+01,  27: 0.770900E+01,
    28: 0.833300E+01,  29: 0.897900E+01,  30: 0.965900E+01,
    31: 0.103670E+02,  32: 0.111040E+02,  33: 0.118680E+02,
    34: 0.126580E+02,  35: 0.134740E+02,  36: 0.143220E+02,
    37: 0.152000E+02,  38: 0.161050E+02,  39: 0.170800E+02,
    40: 0.179980E+02,  41: 0.189860E+02,  42: 0.199990E+02,
    43: 0.210450E+02,  44: 0.221170E+02,  45: 0.232200E+02,
    46: 0.243500E+02,  47: 0.255140E+02,  48: 0.267110E+02,
    49: 0.279400E+02,  50: 0.292000E+02,  51: 0.304910E+02,
    52: 0.318130E+02,  53: 0.331690E+02,  54: 0.345820E+02,
    55: 0.359850E+02,  56: 0.374410E+02,  57: 0.389250E+02,
    58: 0.404440E+02,  59: 0.419910E+02,  60: 0.435690E+02,
    61: 0.451840E+02,  62: 0.468350E+02,  63: 0.485200E+02,
    64: 0.502400E+02,  65: 0.519960E+02,  66: 0.537890E+02,
    67: 0.556180E+02,  68: 0.574860E+02,  69: 0.593900E+02,
    70: 0.613320E+02,  71: 0.633140E+02,  72: 0.653510E+02,
    73: 0.674140E+02,  74: 0.695240E+02,  75: 0.716760E+02,
    76: 0.738720E+02,  77: 0.761120E+02,  78: 0.783950E+02,
    79: 0.807230E+02,  80: 0.831030E+02,  81: 0.855280E+02,
    82: 0.880060E+02,  83: 0.905270E+02,  84: 0.000000E+00,
    85: 0.000000E+00,  86: 0.984170E+02,  87: 0.000000E+00,
    88: 0.000000E+00,  89: 0.000000E+00,  90: 0.109649E+03,
    91: 0.000000E+00,  92: 0.115603E+03,  93: 0.000000E+00,
    94: 0.121760E+03}
#L1-edges (keV)
l1edge={  1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
          4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
          7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
          10: 0.000000E+00,  11: 0.000000E+00,  12: 0.630000E-01,
          13: 0.870000E-01,  14: 0.118000E+00,  15: 0.153000E+00,
          16: 0.193000E+00,  17: 0.238000E+00,  18: 0.287000E+00,
          19: 0.341000E+00,  20: 0.400000E+00,  21: 0.463000E+00,
          22: 0.531000E+00,  23: 0.604000E+00,  24: 0.682000E+00,
          25: 0.754000E+00,  26: 0.842000E+00,  27: 0.929000E+00,
          28: 0.101200E+01,  29: 0.110000E+01,  30: 0.119600E+01,
          31: 0.130200E+01,  32: 0.141400E+01,  33: 0.153000E+01,
          34: 0.165300E+01,  35: 0.178200E+01,  36: 0.192000E+01,
          37: 0.206500E+01,  38: 0.221600E+01,  39: 0.237300E+01,
          40: 0.253200E+01,  41: 0.269800E+01,  42: 0.286600E+01,
          43: 0.304300E+01,  44: 0.322400E+01,  45: 0.341200E+01,
          46: 0.360500E+01,  47: 0.380600E+01,  48: 0.401800E+01,
          49: 0.423800E+01,  50: 0.446500E+01,  51: 0.469800E+01,
          52: 0.493900E+01,  53: 0.518800E+01,  54: 0.545200E+01,
          55: 0.571300E+01,  56: 0.598700E+01,  57: 0.626700E+01,
          58: 0.654900E+01,  59: 0.683500E+01,  60: 0.712600E+01,
          61: 0.742800E+01,  62: 0.773700E+01,  63: 0.805200E+01,
          64: 0.837600E+01,  65: 0.870800E+01,  66: 0.904700E+01,
          67: 0.939500E+01,  68: 0.975200E+01,  69: 0.101160E+02,
          70: 0.104880E+02,  71: 0.108700E+02,  72: 0.112720E+02,
          73: 0.116800E+02,  74: 0.120980E+02,  75: 0.125250E+02,
          76: 0.129640E+02,  77: 0.134240E+02,  78: 0.138920E+02,
          79: 0.143530E+02,  80: 0.148460E+02,  81: 0.153440E+02,
          82: 0.158600E+02,  83: 0.163850E+02,  84: 0.000000E+00,
          85: 0.000000E+00,  86: 0.180550E+02,  87: 0.000000E+00,
          88: 0.000000E+00,  89: 0.000000E+00,  90: 0.204700E+02,
          91: 0.000000E+00,  92: 0.217560E+02,  93: 0.000000E+00,
          94: 0.230950E+02}
#L2-edges (keV)
l2edge={ 1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
         4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
         7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
         10: 0.000000E+00,  11: 0.000000E+00,  12: 0.496000E-01,
         13: 0.729000E-01,  14: 0.998000E-01,  15: 0.136000E+00,
         16: 0.163600E+00,  17: 0.202000E+00,  18: 0.250600E+00,
         19: 0.297300E+00,  20: 0.349700E+00,  21: 0.403600E+00,
         22: 0.461200E+00,  23: 0.519800E+00,  24: 0.583800E+00,
         25: 0.649900E+00,  26: 0.719900E+00,  27: 0.793300E+00,
         28: 0.872000E+00,  29: 0.952000E+00,  30: 0.104400E+01,
         31: 0.114200E+01,  32: 0.124900E+01,  33: 0.136000E+01,
         34: 0.147700E+01,  35: 0.159600E+01,  36: 0.172600E+01,
         37: 0.186300E+01,  38: 0.200700E+01,  39: 0.215600E+01,
         40: 0.230700E+01,  41: 0.246500E+01,  42: 0.262500E+01,
         43: 0.279300E+01,  44: 0.296700E+01,  45: 0.314600E+01,
         46: 0.333000E+01,  47: 0.352400E+01,  48: 0.372700E+01,
         49: 0.393800E+01,  50: 0.415600E+01,  51: 0.438100E+01,
         52: 0.461200E+01,  53: 0.485200E+01,  54: 0.510000E+01,
         55: 0.535900E+01,  56: 0.562400E+01,  57: 0.589100E+01,
         58: 0.616500E+01,  59: 0.644100E+01,  60: 0.672200E+01,
         61: 0.701300E+01,  62: 0.731200E+01,  63: 0.761800E+01,
         64: 0.793100E+01,  65: 0.825200E+01,  66: 0.858100E+01,
         67: 0.891900E+01,  68: 0.926500E+01,  69: 0.961800E+01,
         70: 0.997800E+01,  71: 0.103490E+02,  72: 0.107390E+02,
         73: 0.111360E+02,  74: 0.115420E+02,  75: 0.119570E+02,
         76: 0.123840E+02,  77: 0.128240E+02,  78: 0.132730E+02,
         79: 0.137330E+02,  80: 0.142090E+02,  81: 0.146980E+02,
         82: 0.151980E+02,  83: 0.157080E+02,  84: 0.000000E+00,
         85: 0.000000E+00,  86: 0.173340E+02,  87: 0.000000E+00,
         88: 0.000000E+00,  89: 0.000000E+00,  90: 0.196920E+02,
         91: 0.000000E+00,  92: 0.209470E+02,  93: 0.000000E+00,
         94: 0.222630E+02}
#L3-edges (keV)
l3edge={ 1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
         4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
         7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
         10: 0.000000E+00,  11: 0.000000E+00,  12: 0.492000E-01,
         13: 0.725000E-01,  14: 0.992000E-01,  15: 0.135000E+00,
         16: 0.162500E+00,  17: 0.200000E+00,  18: 0.248400E+00,
         19: 0.294600E+00,  20: 0.346200E+00,  21: 0.398700E+00,
         22: 0.453800E+00,  23: 0.512100E+00,  24: 0.574100E+00,
         25: 0.638700E+00,  26: 0.706800E+00,  27: 0.778100E+00,
         28: 0.855000E+00,  29: 0.932000E+00,  30: 0.102100E+01,
         31: 0.111500E+01,  32: 0.121800E+01,  33: 0.132500E+01,
         34: 0.143600E+01,  35: 0.155000E+01,  36: 0.167500E+01,
         37: 0.180500E+01,  38: 0.194000E+01,  39: 0.208000E+01,
         40: 0.222300E+01,  41: 0.237100E+01,  42: 0.252000E+01,
         43: 0.267700E+01,  44: 0.283800E+01,  45: 0.300300E+01,
         46: 0.317300E+01,  47: 0.335100E+01,  48: 0.353700E+01,
         49: 0.373000E+01,  50: 0.392900E+01,  51: 0.413200E+01,
         52: 0.434100E+01,  53: 0.455700E+01,  54: 0.478100E+01,
         55: 0.501200E+01,  56: 0.524700E+01,  57: 0.548300E+01,
         58: 0.572400E+01,  59: 0.596500E+01,  60: 0.620800E+01,
         61: 0.646000E+01,  62: 0.671700E+01,  63: 0.697700E+01,
         64: 0.724300E+01,  65: 0.751500E+01,  66: 0.779000E+01,
         67: 0.807100E+01,  68: 0.835800E+01,  69: 0.864800E+01,
         70: 0.894300E+01,  71: 0.924400E+01,  72: 0.956100E+01,
         73: 0.988100E+01,  74: 0.102040E+02,  75: 0.105340E+02,
         76: 0.108710E+02,  77: 0.112150E+02,  78: 0.115640E+02,
         79: 0.119180E+02,  80: 0.122840E+02,  81: 0.126570E+02,
         82: 0.130350E+02,  83: 0.134180E+02,  84: 0.000000E+00,
         85: 0.000000E+00,  86: 0.146120E+02,  87: 0.000000E+00,
         88: 0.000000E+00,  89: 0.000000E+00,  90: 0.163000E+02,
         91: 0.000000E+00,  92: 0.171670E+02,  93: 0.000000E+00,
         94: 0.180530E+02}
#M-edges (keV)
medge={ 1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
        4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
        7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
        10: 0.000000E+00,  11: 0.000000E+00,  12: 0.000000E+00,
        13: 0.000000E+00,  14: 0.000000E+00,  15: 0.000000E+00,
        16: 0.170000E-01,  17: 0.170000E-01,  18: 0.270000E-01,
        19: 0.340000E-01,  20: 0.440000E-01,  21: 0.540000E-01,
        22: 0.590000E-01,  23: 0.670000E-01,  24: 0.740000E-01,
        25: 0.840000E-01,  26: 0.940000E-01,  27: 0.101000E+00,
        28: 0.113000E+00,  29: 0.120000E+00,  30: 0.139000E+00,
        31: 0.158000E+00,  32: 0.181000E+00,  33: 0.206000E+00,
        34: 0.232000E+00,  35: 0.257000E+00,  36: 0.288000E+00,
        37: 0.322000E+00,  38: 0.358000E+00,  39: 0.395000E+00,
        40: 0.431000E+00,  41: 0.468000E+00,  42: 0.505000E+00,
        43: 0.544000E+00,  44: 0.585000E+00,  45: 0.627000E+00,
        46: 0.670000E+00,  47: 0.717000E+00,  48: 0.770000E+00,
        49: 0.825000E+00,  50: 0.884000E+00,  51: 0.944000E+00,
        52: 0.100600E+01,  53: 0.107200E+01,  54: 0.114300E+01,
        55: 0.121800E+01,  56: 0.129300E+01,  57: 0.136300E+01,
        58: 0.143400E+01,  59: 0.150800E+01,  60: 0.157500E+01,
        61: 0.165100E+01,  62: 0.172900E+01,  63: 0.180000E+01,
        64: 0.188200E+01,  65: 0.196700E+01,  66: 0.204600E+01,
        67: 0.212700E+01,  68: 0.221200E+01,  69: 0.230700E+01,
        70: 0.239800E+01,  71: 0.249200E+01,  72: 0.260200E+01,
        73: 0.270300E+01,  74: 0.281800E+01,  75: 0.293100E+01,
        76: 0.305000E+01,  77: 0.317200E+01,  78: 0.329700E+01,
        79: 0.342500E+01,  80: 0.356200E+01,  81: 0.370000E+01,
        82: 0.385000E+01,  83: 0.399900E+01,  84: 0.000000E+00,
        85: 0.000000E+00,  86: 0.447800E+01,  87: 0.000000E+00,
        88: 0.000000E+00,  89: 0.000000E+00,  90: 0.518200E+01,
        91: 0.000000E+00,  92: 0.554900E+01,  93: 0.000000E+00,
        94: 0.591400E+01}
#K alpha1 energies (keV)
kalpha1={  1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
           4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
           7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
           10: 0.000000E+00,  11: 0.104100E+01,  12: 0.125400E+01,
           13: 0.148700E+01,  14: 0.174000E+01,  15: 0.201500E+01,
           16: 0.230800E+01,  17: 0.262200E+01,  18: 0.295700E+01,
           19: 0.331300E+01,  20: 0.369100E+01,  21: 0.409000E+01,
           22: 0.451000E+01,  23: 0.495200E+01,  24: 0.541400E+01,
           25: 0.589800E+01,  26: 0.640300E+01,  27: 0.693000E+01,
           28: 0.747700E+01,  29: 0.804700E+01,  30: 0.863800E+01,
           31: 0.925100E+01,  32: 0.988500E+01,  33: 0.105430E+02,
           34: 0.112210E+02,  35: 0.119230E+02,  36: 0.126480E+02,
           37: 0.133940E+02,  38: 0.141640E+02,  39: 0.149570E+02,
           40: 0.157740E+02,  41: 0.166140E+02,  42: 0.174780E+02,
           43: 0.184100E+02,  44: 0.192780E+02,  45: 0.202140E+02,
           46: 0.211750E+02,  47: 0.221620E+02,  48: 0.231720E+02,
           49: 0.242070E+02,  50: 0.252700E+02,  51: 0.263570E+02,
           52: 0.274710E+02,  53: 0.286100E+02,  54: 0.298020E+02,
           55: 0.309700E+02,  56: 0.321910E+02,  57: 0.334400E+02,
           58: 0.347170E+02,  59: 0.360230E+02,  60: 0.373590E+02,
           61: 0.386490E+02,  62: 0.401240E+02,  63: 0.415290E+02,
           64: 0.429830E+02,  65: 0.444700E+02,  66: 0.459850E+02,
           67: 0.475280E+02,  68: 0.490990E+02,  69: 0.507300E+02,
           70: 0.523600E+02,  71: 0.540630E+02,  72: 0.557570E+02,
           73: 0.575240E+02,  74: 0.593100E+02,  75: 0.611310E+02,
           76: 0.629910E+02,  77: 0.648860E+02,  78: 0.668200E+02,
           79: 0.687790E+02,  80: 0.708210E+02,  81: 0.728600E+02,
           82: 0.749570E+02,  83: 0.770970E+02,  84: 0.000000E+00,
           85: 0.000000E+00,  86: 0.838000E+02,  87: 0.000000E+00,
           88: 0.000000E+00,  89: 0.000000E+00,  90: 0.933340E+02,
           91: 0.000000E+00,  92: 0.984280E+02,  93: 0.000000E+00,
           94: 0.103653E+03}
#K beta1 energies (keV)
kbeta1={ 1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
         4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
         7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
         10: 0.000000E+00,  11: 0.106700E+01,  12: 0.129700E+01,
         13: 0.155300E+01,  14: 0.183200E+01,  15: 0.213600E+01,
         16: 0.246400E+01,  17: 0.281500E+01,  18: 0.319200E+01,
         19: 0.358900E+01,  20: 0.401200E+01,  21: 0.446000E+01,
         22: 0.493100E+01,  23: 0.542700E+01,  24: 0.594600E+01,
         25: 0.649000E+01,  26: 0.705700E+01,  27: 0.764900E+01,
         28: 0.826400E+01,  29: 0.890400E+01,  30: 0.957100E+01,
         31: 0.102630E+02,  32: 0.109810E+02,  33: 0.117250E+02,
         34: 0.124950E+02,  35: 0.132900E+02,  36: 0.141120E+02,
         37: 0.149600E+02,  38: 0.158340E+02,  39: 0.167360E+02,
         40: 0.176660E+02,  41: 0.186210E+02,  42: 0.196070E+02,
         43: 0.205850E+02,  44: 0.216550E+02,  45: 0.227210E+02,
         46: 0.238160E+02,  47: 0.249420E+02,  48: 0.260930E+02,
         49: 0.272740E+02,  50: 0.284830E+02,  51: 0.297230E+02,
         52: 0.309930E+02,  53: 0.322920E+02,  54: 0.336440E+02,
         55: 0.349840E+02,  56: 0.363760E+02,  57: 0.377990E+02,
         58: 0.392550E+02,  59: 0.407460E+02,  60: 0.422690E+02,
         61: 0.439450E+02,  62: 0.454000E+02,  63: 0.470270E+02,
         64: 0.487180E+02,  65: 0.503910E+02,  66: 0.521780E+02,
         67: 0.539340E+02,  68: 0.556900E+02,  69: 0.575760E+02,
         70: 0.593520E+02,  71: 0.612820E+02,  72: 0.632090E+02,
         73: 0.652100E+02,  74: 0.672330E+02,  75: 0.692980E+02,
         76: 0.714040E+02,  77: 0.735490E+02,  78: 0.757360E+02,
         79: 0.779680E+02,  80: 0.802580E+02,  81: 0.825580E+02,
         82: 0.849220E+02,  83: 0.873350E+02,  84: 0.000000E+00,
         85: 0.000000E+00,  86: 0.948770E+02,  87: 0.000000E+00,
         88: 0.000000E+00,  89: 0.000000E+00,  90: 0.105592E+03,
         91: 0.000000E+00,  92: 0.111289E+03,  93: 0.000000E+00,
         94: 0.117146E+03}
#L alpha1 energies (keV)
lalpha1={ 1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
          4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
          7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
          10: 0.000000E+00,  11: 0.000000E+00,  12: 0.000000E+00,
          13: 0.000000E+00,  14: 0.000000E+00,  15: 0.000000E+00,
          16: 0.000000E+00,  17: 0.000000E+00,  18: 0.000000E+00,
          19: 0.000000E+00,  20: 0.000000E+00,  21: 0.000000E+00,
          22: 0.000000E+00,  23: 0.000000E+00,  24: 0.000000E+00,
          25: 0.000000E+00,  26: 0.000000E+00,  27: 0.000000E+00,
          28: 0.000000E+00,  29: 0.000000E+00,  30: 0.100900E+01,
          31: 0.109600E+01,  32: 0.118600E+01,  33: 0.128200E+01,
          34: 0.141900E+01,  35: 0.148000E+01,  36: 0.158700E+01,
          37: 0.169400E+01,  38: 0.180600E+01,  39: 0.192200E+01,
          40: 0.204200E+01,  41: 0.216600E+01,  42: 0.229300E+01,
          43: 0.242400E+01,  44: 0.255800E+01,  45: 0.269600E+01,
          46: 0.283800E+01,  47: 0.298400E+01,  48: 0.313300E+01,
          49: 0.328700E+01,  50: 0.344400E+01,  51: 0.360500E+01,
          52: 0.376900E+01,  53: 0.393700E+01,  54: 0.411100E+01,
          55: 0.428600E+01,  56: 0.446700E+01,  57: 0.465100E+01,
          58: 0.484000E+01,  59: 0.503400E+01,  60: 0.543100E+01,
          61: 0.563600E+01,  62: 0.584600E+01,  63: 0.605900E+01,
          64: 0.627500E+01,  65: 0.649500E+01,  66: 0.672000E+01,
          67: 0.694800E+01,  68: 0.718100E+01,  69: 0.718100E+01,
          70: 0.741400E+01,  71: 0.765400E+01,  72: 0.789800E+01,
          73: 0.814500E+01,  74: 0.839600E+01,  75: 0.865100E+01,
          76: 0.891000E+01,  77: 0.917300E+01,  78: 0.944100E+01,
          79: 0.971100E+01,  80: 0.998700E+01,  81: 0.102660E+02,
          82: 0.105490E+02,  83: 0.108360E+02,  84: 0.000000E+00,
          85: 0.000000E+00,  86: 0.117240E+02,  87: 0.000000E+00,
          88: 0.000000E+00,  89: 0.000000E+00,  90: 0.129660E+02,
          91: 0.000000E+00,  92: 0.136130E+02,  93: 0.000000E+00,
          94: 0.142790E+02}
#L beta1 energies (keV)
lbeta1={ 1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
         4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
         7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
         10: 0.000000E+00,  11: 0.000000E+00,  12: 0.000000E+00,
         13: 0.000000E+00,  14: 0.000000E+00,  15: 0.000000E+00,
         16: 0.000000E+00,  17: 0.000000E+00,  18: 0.000000E+00,
         19: 0.000000E+00,  20: 0.000000E+00,  21: 0.000000E+00,
         22: 0.000000E+00,  23: 0.000000E+00,  24: 0.000000E+00,
         25: 0.000000E+00,  26: 0.000000E+00,  27: 0.000000E+00,
         28: 0.000000E+00,  29: 0.000000E+00,  30: 0.103200E+01,
         31: 0.112200E+01,  32: 0.121600E+01,  33: 0.131700E+01,
         34: 0.137900E+01,  35: 0.152600E+01,  36: 0.163800E+01,
         37: 0.175200E+01,  38: 0.187200E+01,  39: 0.199600E+01,
         40: 0.212400E+01,  41: 0.225700E+01,  42: 0.239500E+01,
         43: 0.253800E+01,  44: 0.268300E+01,  45: 0.283400E+01,
         46: 0.299000E+01,  47: 0.315100E+01,  48: 0.331600E+01,
         49: 0.348700E+01,  50: 0.366200E+01,  51: 0.384300E+01,
         52: 0.402900E+01,  53: 0.422000E+01,  54: 0.442200E+01,
         55: 0.462000E+01,  56: 0.482800E+01,  57: 0.504300E+01,
         58: 0.526200E+01,  59: 0.548900E+01,  60: 0.595600E+01,
         61: 0.620600E+01,  62: 0.645600E+01,  63: 0.671400E+01,
         64: 0.697900E+01,  65: 0.724900E+01,  66: 0.752800E+01,
         67: 0.781000E+01,  68: 0.810300E+01,  69: 0.810300E+01,
         70: 0.840100E+01,  71: 0.870800E+01,  72: 0.902100E+01,
         73: 0.934100E+01,  74: 0.967000E+01,  75: 0.100080E+02,
         76: 0.103540E+02,  77: 0.107060E+02,  78: 0.110690E+02,
         79: 0.114390E+02,  80: 0.118230E+02,  81: 0.122100E+02,
         82: 0.126110E+02,  83: 0.130210E+02,  84: 0.000000E+00,
         85: 0.000000E+00,  86: 0.143160E+02,  87: 0.000000E+00,
         88: 0.000000E+00,  89: 0.000000E+00,  90: 0.162000E+02,
         91: 0.000000E+00,  92: 0.172180E+02,  93: 0.000000E+00,
         94: 0.182780E+02}
#atomic weights (g/mole)
atwt={ 1: 0.100800E+01,   2: 0.400300E+01,   3: 0.694000E+01,
       4: 0.901200E+01,   5: 0.108110E+02,   6: 0.120100E+02,
       7: 0.140080E+02,   8: 0.160000E+02,   9: 0.190000E+02,
       10: 0.201830E+02,  11: 0.229970E+02,  12: 0.243200E+02,
       13: 0.269700E+02,  14: 0.280860E+02,  15: 0.309750E+02,
       16: 0.320660E+02,  17: 0.354570E+02,  18: 0.399440E+02,
       19: 0.391020E+02,  20: 0.400800E+02,  21: 0.449600E+02,
       22: 0.479000E+02,  23: 0.509420E+02,  24: 0.519960E+02,
       25: 0.549400E+02,  26: 0.558500E+02,  27: 0.589330E+02,
       28: 0.586900E+02,  29: 0.635400E+02,  30: 0.653800E+02,
       31: 0.697200E+02,  32: 0.725900E+02,  33: 0.749200E+02,
       34: 0.789600E+02,  35: 0.799200E+02,  36: 0.838000E+02,
       37: 0.854800E+02,  38: 0.876200E+02,  39: 0.889050E+02,
       40: 0.912200E+02,  41: 0.929060E+02,  42: 0.959500E+02,
       43: 0.990000E+02,  44: 0.101070E+03,  45: 0.102910E+03,
       46: 0.106400E+03,  47: 0.107880E+03,  48: 0.112410E+03,
       49: 0.114820E+03,  50: 0.118690E+03,  51: 0.121760E+03,
       52: 0.127600E+03,  53: 0.126910E+03,  54: 0.131300E+03,
       55: 0.132910E+03,  56: 0.137360E+03,  57: 0.138920E+03,
       58: 0.140130E+03,  59: 0.140920E+03,  60: 0.144270E+03,
       61: 0.147000E+03,  62: 0.150350E+03,  63: 0.152000E+03,
       64: 0.157260E+03,  65: 0.158930E+03,  66: 0.162510E+03,
       67: 0.164940E+03,  68: 0.167270E+03,  69: 0.168940E+03,
       70: 0.173040E+03,  71: 0.174990E+03,  72: 0.178500E+03,
       73: 0.180950E+03,  74: 0.183920E+03,  75: 0.186200E+03,
       76: 0.190200E+03,  77: 0.192200E+03,  78: 0.195090E+03,
       79: 0.197200E+03,  80: 0.200610E+03,  81: 0.204390E+03,
       82: 0.207210E+03,  83: 0.209000E+03,  84: 0.000000E+00,
       85: 0.000000E+00,  86: 0.222000E+03,  87: 0.000000E+00,
       88: 0.000000E+00,  89: 0.000000E+00,  90: 0.232000E+03,
       91: 0.000000E+00,  92: 0.238070E+03,  93: 0.000000E+00,
       94: 0.239100E+03}
#density (g/cc)
density={ 1: 0.000089E+00,   2: 0.000179E+00,   3: 0.534000E+00,
          4: 0.184800E+01,   5: 0.234000E+01,   6: 0.226000E+01,
          7: 0.125000E-02,   8: 0.142900E-02,   9: 0.110800E+01,
          10: 0.900000E-03,  11: 0.970000E+00,  12: 0.174000E+01,
          13: 0.272000E+01,  14: 0.233000E+01,  15: 0.182000E+01,
          16: 0.200000E+01,  17: 0.156000E+01,  18: 0.178400E-02,
          19: 0.862000E+00,  20: 0.155000E+01,  21: 0.299200E+01,
          22: 0.454000E+01,  23: 0.611000E+01,  24: 0.719000E+01,
          25: 0.742000E+01,  26: 0.786000E+01,  27: 0.890000E+01,
          28: 0.890000E+01,  29: 0.894000E+01,  30: 0.714000E+01,
          31: 0.590300E+01,  32: 0.532300E+01,  33: 0.573000E+01,
          34: 0.479000E+01,  35: 0.312000E+01,  36: 0.374000E-02,
          37: 0.153200E+01,  38: 0.254000E+01,  39: 0.440500E+01,
          40: 0.653000E+01,  41: 0.857000E+01,  42: 0.102200E+02,
          43: 0.115000E+02,  44: 0.124100E+02,  45: 0.124400E+02,
          46: 0.121600E+02,  47: 0.105000E+02,  48: 0.865000E+01,
          49: 0.728000E+01,  50: 0.531000E+01,  51: 0.669100E+01,
          52: 0.624000E+01,  53: 0.494000E+01,  54: 0.590000E-02,
          55: 0.187300E+01,  56: 0.350000E+01,  57: 0.615000E+01,
          58: 0.667000E+01,  59: 0.676900E+01,  60: 0.696000E+01,
          61: 0.678200E+01,  62: 0.753600E+01,  63: 0.525900E+01,
          64: 0.795000E+01,  65: 0.827200E+01,  66: 0.853600E+01,
          67: 0.880300E+01,  68: 0.905100E+01,  69: 0.933200E+01,
          70: 0.697700E+01,  71: 0.984200E+01,  72: 0.133000E+02,
          73: 0.166000E+02,  74: 0.193000E+02,  75: 0.210200E+02,
          76: 0.225000E+02,  77: 0.224200E+02,  78: 0.213700E+02,
          79: 0.193700E+02,  80: 0.135460E+02,  81: 0.118600E+02,
          82: 0.113400E+02,  83: 0.980000E+01,  84: 0.000000E+00,
          85: 0.000000E+00,  86: 0.973000E-02,  87: 0.000000E+00,
          88: 0.000000E+00,  89: 0.000000E+00,  90: 0.117000E+02,
          91: 0.000000E+00,  92: 0.190500E+02,  93: 0.000000E+00,
          94: 0.197000E+02}
#L1-edge jump (Z>27)
l1jump=0.116000E+01
#L2-edge jump (Z>27)
l2jump=0.141000E+01
#L3-edge jump
l3jump={ 1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
         4: 0.000000E+00,   5: 0.000000E+00,   6: 0.000000E+00,
         7: 0.000000E+00,   8: 0.000000E+00,   9: 0.000000E+00,
         10: 0.000000E+00,  11: 0.000000E+00,  12: 0.000000E+00,
         13: 0.000000E+00,  14: 0.000000E+00,  15: 0.000000E+00,
         16: 0.000000E+00,  17: 0.000000E+00,  18: 0.000000E+00,
         19: 0.000000E+00,  20: 0.000000E+00,  21: 0.000000E+00,
         22: 0.000000E+00,  23: 0.000000E+00,  24: 0.000000E+00,
         25: 0.000000E+00,  26: 0.000000E+00,  27: 0.000000E+00,
         28: 0.277200E+01,  29: 0.287400E+01,  30: 0.568400E+01,
         31: 0.567100E+01,  32: 0.570400E+01,  33: 0.487500E+01,
         34: 0.458700E+01,  35: 0.455700E+01,  36: 0.417000E+01,
         37: 0.422300E+01,  38: 0.390600E+01,  39: 0.403600E+01,
         40: 0.397600E+01,  41: 0.377400E+01,  42: 0.367500E+01,
         43: 0.359100E+01,  44: 0.343100E+01,  45: 0.372100E+01,
         46: 0.340200E+01,  47: 0.322300E+01,  48: 0.324900E+01,
         49: 0.325500E+01,  50: 0.306000E+01,  51: 0.293900E+01,
         52: 0.297900E+01,  53: 0.285600E+01,  54: 0.287900E+01,
         55: 0.284700E+01,  56: 0.283900E+01,  57: 0.271700E+01,
         58: 0.273700E+01,  59: 0.269500E+01,  60: 0.266200E+01,
         61: 0.270200E+01,  62: 0.268000E+01,  63: 0.272300E+01,
         64: 0.270100E+01,  65: 0.271300E+01,  66: 0.904700E+01,
         67: 0.286300E+01,  68: 0.293300E+01,  69: 0.275800E+01,
         70: 0.257300E+01,  71: 0.262000E+01,  72: 0.241500E+01,
         73: 0.260000E+01,  74: 0.261700E+01,  75: 0.267500E+01,
         76: 0.252900E+01,  77: 0.238700E+01,  78: 0.263200E+01,
         79: 0.243900E+01,  80: 0.240000E+01,  81: 0.249800E+01,
         82: 0.246600E+01,  83: 0.233800E+01,  84: 0.000000E+00,
         85: 0.000000E+00,  86: 0.234400E+01,  87: 0.000000E+00,
         88: 0.000000E+00,  89: 0.000000E+00,  90: 0.238800E+01,
         91: 0.000000E+00,  92: 0.229200E+01,  93: 0.000000E+00,
         94: 0.225100E+01}
#conversion factor (cm2/g) to (barnes/atom)
convfac={ 1: 0.167400E+01,   2: 0.664700E+01,   3: 0.115200E+02,
          4: 0.149600E+02,   5: 0.179500E+02,   6: 0.199400E+02,
          7: 0.232600E+02,   8: 0.265700E+02,   9: 0.315500E+02,
          10: 0.335100E+02,  11: 0.381900E+02,  12: 0.403800E+02,
          13: 0.447800E+02,  14: 0.466300E+02,  15: 0.514300E+02,
          16: 0.532400E+02,  17: 0.588700E+02,  18: 0.663200E+02,
          19: 0.649300E+02,  20: 0.665500E+02,  21: 0.746500E+02,
          22: 0.795300E+02,  23: 0.845900E+02,  24: 0.863400E+02,
          25: 0.912200E+02,  26: 0.927400E+02,  27: 0.978500E+02,
          28: 0.974500E+02,  29: 0.105500E+03,  30: 0.108600E+03,
          31: 0.115800E+03,  32: 0.120500E+03,  33: 0.124400E+03,
          34: 0.131100E+03,  35: 0.132700E+03,  36: 0.139100E+03,
          37: 0.141900E+03,  38: 0.145500E+03,  39: 0.147600E+03,
          40: 0.151500E+03,  41: 0.154300E+03,  42: 0.159300E+03,
          43: 0.164400E+03,  44: 0.167800E+03,  45: 0.170900E+03,
          46: 0.176700E+03,  47: 0.179100E+03,  48: 0.186600E+03,
          49: 0.190700E+03,  50: 0.197100E+03,  51: 0.202200E+03,
          52: 0.211900E+03,  53: 0.210700E+03,  54: 0.218000E+03,
          55: 0.220700E+03,  56: 0.228100E+03,  57: 0.230700E+03,
          58: 0.232700E+03,  59: 0.234000E+03,  60: 0.239600E+03,
          61: 0.244100E+03,  62: 0.249600E+03,  63: 0.252400E+03,
          64: 0.261100E+03,  65: 0.263900E+03,  66: 0.269800E+03,
          67: 0.273900E+03,  68: 0.277700E+03,  69: 0.280500E+03,
          70: 0.287300E+03,  71: 0.290600E+03,  72: 0.296400E+03,
          73: 0.300500E+03,  74: 0.305400E+03,  75: 0.309200E+03,
          76: 0.315800E+03,  77: 0.319100E+03,  78: 0.323900E+03,
          79: 0.327400E+03,  80: 0.333100E+03,  81: 0.339400E+03,
          82: 0.344100E+03,  83: 0.347000E+03,  84: 0.000000E+00,
          85: 0.000000E+00,  86: 0.368600E+03,  87: 0.000000E+00,
          88: 0.000000E+00,  89: 0.000000E+00,  90: 0.385200E+03,
          91: 0.000000E+00,  92: 0.395300E+03,  93: 0.000000E+00,
          94: 0.397000E+03}
#K-edge fluo yield
kyield={ 1: 0.000000E+00,   2: 0.000000E+00,   3: 0.000000E+00,
         4: 0.000000E+00,   5: 0.170000E-02,   6: 0.280000E-02,
         7: 0.520000E-02,   8: 0.830000E-02,   9: 0.130000E-01,
         10: 0.180000E-01,  11: 0.230000E-01,  12: 0.300000E-01,
         13: 0.390000E-01,  14: 0.500000E-01,  15: 0.630000E-01,
         16: 0.780000E-01,  17: 0.970000E-01,  18: 0.118000E+00,
         19: 0.140000E+00,  20: 0.163000E+00,  21: 0.188000E+00,
         22: 0.214000E+00,  23: 0.243000E+00,  24: 0.275000E+00,
         25: 0.308000E+00,  26: 0.340000E+00,  27: 0.373000E+00,
         28: 0.406000E+00,  29: 0.440000E+00,  30: 0.474000E+00,
         31: 0.507000E+00,  32: 0.535000E+00,  33: 0.562000E+00,
         34: 0.589000E+00,  35: 0.618000E+00,  36: 0.643000E+00,
         37: 0.667000E+00,  38: 0.690000E+00,  39: 0.710000E+00,
         40: 0.730000E+00,  41: 0.747000E+00,  42: 0.765000E+00,
         43: 0.780000E+00,  44: 0.794000E+00,  45: 0.808000E+00,
         46: 0.820000E+00,  47: 0.831000E+00,  48: 0.843000E+00,
         49: 0.853000E+00,  50: 0.862000E+00,  51: 0.870000E+00,
         52: 0.877000E+00,  53: 0.884000E+00,  54: 0.891000E+00,
         55: 0.897000E+00,  56: 0.902000E+00,  57: 0.907000E+00,
         58: 0.912000E+00,  59: 0.917000E+00,  60: 0.921000E+00,
         61: 0.925000E+00,  62: 0.929000E+00,  63: 0.932000E+00,
         64: 0.935000E+00,  65: 0.938000E+00,  66: 0.941000E+00,
         67: 0.944000E+00,  68: 0.947000E+00,  69: 0.949000E+00,
         70: 0.951000E+00,  71: 0.953000E+00,  72: 0.955000E+00,
         73: 0.957000E+00,  74: 0.958000E+00,  75: 0.959000E+00,
         76: 0.961000E+00,  77: 0.962000E+00,  78: 0.963000E+00,
         79: 0.964000E+00,  80: 0.965000E+00,  81: 0.966000E+00,
         82: 0.967000E+00,  83: 0.968000E+00,  84: 0.968000E+00,
         85: 0.969000E+00,  86: 0.969000E+00,  87: 0.970000E+00,
         88: 0.970000E+00,  89: 0.971000E+00,  90: 0.971000E+00,
         91: 0.972000E+00,  92: 0.972000E+00,  93: 0.973000E+00,
         94: 0.973000E+00}
#L1,L2,L3 fluo yields
lyield={  1 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          2 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          3 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          4 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          5 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          6 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          7 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          8 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          9 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          10 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          11 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00],
          12 :  [ 0.290000E-04,  0.120000E-02,  0.120000E-02],
          13 :  [ 0.260000E-04,  0.750000E-03,  0.750000E-03],
          14 :  [ 0.300000E-04,  0.370000E-03,  0.380000E-03],
          15 :  [ 0.390000E-04,  0.310000E-03,  0.310000E-03],
          16 :  [ 0.740000E-04,  0.260000E-03,  0.260000E-03],
          17 :  [ 0.120000E-03,  0.240000E-03,  0.240000E-03],
          18 :  [ 0.180000E-03,  0.220000E-03,  0.220000E-03],
          19 :  [ 0.240000E-03,  0.270000E-03,  0.270000E-03],
          20 :  [ 0.310000E-03,  0.330000E-03,  0.330000E-03],
          21 :  [ 0.390000E-03,  0.840000E-03,  0.840000E-03],
          22 :  [ 0.470000E-03,  0.150000E-02,  0.150000E-02],
          23 :  [ 0.580000E-03,  0.260000E-02,  0.260000E-02],
          24 :  [ 0.710000E-03,  0.370000E-02,  0.370000E-02],
          25 :  [ 0.840000E-03,  0.500000E-02,  0.500000E-02],
          26 :  [ 0.100000E-02,  0.630000E-02,  0.630000E-02],
          27 :  [ 0.120000E-02,  0.770000E-02,  0.770000E-02],
          28 :  [ 0.140000E-02,  0.860000E-02,  0.930000E-02],
          29 :  [ 0.160000E-02,  0.100000E-01,  0.110000E-01],
          30 :  [ 0.180000E-02,  0.110000E-01,  0.120000E-01],
          31 :  [ 0.210000E-02,  0.120000E-01,  0.130000E-01],
          32 :  [ 0.240000E-02,  0.130000E-01,  0.150000E-01],
          33 :  [ 0.280000E-02,  0.140000E-01,  0.160000E-01],
          34 :  [ 0.320000E-02,  0.160000E-01,  0.180000E-01],
          35 :  [ 0.360000E-02,  0.180000E-01,  0.200000E-01],
          36 :  [ 0.410000E-02,  0.200000E-01,  0.220000E-01],
          37 :  [ 0.460000E-02,  0.220000E-01,  0.240000E-01],
          38 :  [ 0.510000E-02,  0.240000E-01,  0.260000E-01],
          39 :  [ 0.590000E-02,  0.260000E-01,  0.280000E-01],
          40 :  [ 0.680000E-02,  0.280000E-01,  0.310000E-01],
          41 :  [ 0.940000E-02,  0.310000E-01,  0.340000E-01],
          42 :  [ 0.100000E-01,  0.340000E-01,  0.370000E-01],
          43 :  [ 0.110000E-01,  0.370000E-01,  0.400000E-01],
          44 :  [ 0.120000E-01,  0.400000E-01,  0.430000E-01],
          45 :  [ 0.130000E-01,  0.430000E-01,  0.460000E-01],
          46 :  [ 0.140000E-01,  0.470000E-01,  0.490000E-01],
          47 :  [ 0.160000E-01,  0.510000E-01,  0.520000E-01],
          48 :  [ 0.180000E-01,  0.560000E-01,  0.560000E-01],
          49 :  [ 0.200000E-01,  0.610000E-01,  0.600000E-01],
          50 :  [ 0.370000E-01,  0.650000E-01,  0.640000E-01],
          51 :  [ 0.390000E-01,  0.690000E-01,  0.690000E-01],
          52 :  [ 0.410000E-01,  0.740000E-01,  0.740000E-01],
          53 :  [ 0.440000E-01,  0.790000E-01,  0.790000E-01],
          54 :  [ 0.460000E-01,  0.830000E-01,  0.850000E-01],
          55 :  [ 0.490000E-01,  0.900000E-01,  0.910000E-01],
          56 :  [ 0.520000E-01,  0.960000E-01,  0.970000E-01],
          57 :  [ 0.550000E-01,  0.103000E+00,  0.104000E+00],
          58 :  [ 0.580000E-01,  0.110000E+00,  0.111000E+00],
          59 :  [ 0.610000E-01,  0.117000E+00,  0.118000E+00],
          60 :  [ 0.640000E-01,  0.124000E+00,  0.125000E+00],
          61 :  [ 0.660000E-01,  0.132000E+00,  0.132000E+00],
          62 :  [ 0.710000E-01,  0.140000E+00,  0.139000E+00],
          63 :  [ 0.750000E-01,  0.149000E+00,  0.147000E+00],
          64 :  [ 0.790000E-01,  0.158000E+00,  0.155000E+00],
          65 :  [ 0.830000E-01,  0.167000E+00,  0.164000E+00],
          66 :  [ 0.890000E-01,  0.178000E+00,  0.174000E+00],
          67 :  [ 0.940000E-01,  0.189000E+00,  0.182000E+00],
          68 :  [ 0.100000E+00,  0.200000E+00,  0.192000E+00],
          69 :  [ 0.106000E+00,  0.211000E+00,  0.201000E+00],
          70 :  [ 0.112000E+00,  0.222000E+00,  0.210000E+00],
          71 :  [ 0.120000E+00,  0.234000E+00,  0.220000E+00],
          72 :  [ 0.128000E+00,  0.246000E+00,  0.231000E+00],
          73 :  [ 0.137000E+00,  0.258000E+00,  0.243000E+00],
          74 :  [ 0.147000E+00,  0.270000E+00,  0.255000E+00],
          75 :  [ 0.144000E+00,  0.283000E+00,  0.268000E+00],
          76 :  [ 0.130000E+00,  0.295000E+00,  0.281000E+00],
          77 :  [ 0.120000E+00,  0.308000E+00,  0.294000E+00],
          78 :  [ 0.114000E+00,  0.321000E+00,  0.306000E+00],
          79 :  [ 0.107000E+00,  0.334000E+00,  0.320000E+00],
          80 :  [ 0.107000E+00,  0.347000E+00,  0.333000E+00],
          81 :  [ 0.107000E+00,  0.360000E+00,  0.347000E+00],
          82 :  [ 0.112000E+00,  0.373000E+00,  0.360000E+00],
          83 :  [ 0.117000E+00,  0.387000E+00,  0.373000E+00],
          84 :  [ 0.122000E+00,  0.401000E+00,  0.386000E+00],
          85 :  [ 0.128000E+00,  0.415000E+00,  0.399000E+00],
          86 :  [ 0.134000E+00,  0.429000E+00,  0.411000E+00],
          87 :  [ 0.139000E+00,  0.443000E+00,  0.424000E+00],
          88 :  [ 0.146000E+00,  0.456000E+00,  0.437000E+00],
          89 :  [ 0.153000E+00,  0.468000E+00,  0.450000E+00],
          90 :  [ 0.161000E+00,  0.479000E+00,  0.463000E+00],
          91 :  [ 0.162000E+00,  0.472000E+00,  0.476000E+00],
          92 :  [ 0.176000E+00,  0.467000E+00,  0.489000E+00],
          93 :  [ 0.187000E+00,  0.466000E+00,  0.502000E+00],
          94 :  [ 0.205000E+00,  0.464000E+00,  0.514000E+00]}
#coherent scattering x-section coeff (barns/atom)
xseccoh={  1 :  [-0.119075E+00, -0.937086E+00, -0.200538E+00,  0.106587E-01],
           2 :  [ 0.104768E+01, -0.851805E-01, -0.403527E+00,  0.269398E-01],
           3 :  [ 0.134366E+01,  0.181557E+00, -0.423981E+00,  0.266190E-01],
           4 :  [ 0.200860E+01, -0.461920E-01, -0.337018E+00,  0.186939E-01],
           5 :  [ 0.262862E+01, -0.207916E+00, -0.286283E+00,  0.144966E-01],
           6 :  [ 0.310861E+01, -0.260580E+00, -0.271974E+00,  0.135181E-01],
           7 :  [ 0.347760E+01, -0.215762E+00, -0.288874E+00,  0.115131E-01],
           8 :  [ 0.377239E+01, -0.148539E+00, -0.307124E+00,  0.167303E-01],
           9 :  [ 0.400716E+01, -0.560908E-01, -0.332017E+00,  0.187934E-01],
           10 :  [ 0.420151E+01,  0.416247E-01, -0.356754E+00,  0.207585E-01],
           11 :  [ 0.426374E+01,  0.134662E+00, -0.370080E+00,  0.214467E-01],
           12 :  [ 0.439404E+01,  0.137858E+00, -0.359540E+00,  0.202380E-01],
           13 :  [ 0.415995E+01,  0.140549E+00, -0.352441E+00,  0.193692E-01],
           14 :  [ 0.464678E+01,  0.162780E+00, -0.358563E+00,  0.196926E-01],
           15 :  [ 0.478525E+01,  0.168708E+00, -0.360383E+00,  0.197155E-01],
           16 :  [ 0.492707E+01,  0.165746E+00, -0.359424E+00,  0.195505E-01],
           17 :  [ 0.507222E+01,  0.149127E+00, -0.352858E+00,  0.189439E-01],
           18 :  [ 0.521079E+01,  0.135618E+00, -0.347214E+00,  0.184333E-01],
           19 :  [ 0.525587E+01,  0.188040E+00, -0.359623E+00,  0.193085E-01],
           20 :  [ 0.532375E+01,  0.206685E+00, -0.361664E+00,  0.193328E-01],
           21 :  [ 0.543942E+01,  0.200174E+00, -0.359064E+00,  0.191027E-01],
           22 :  [ 0.555039E+01,  0.197697E+00, -0.357694E+00,  0.189866E-01],
           23 :  [ 0.565514E+01,  0.199533E+00, -0.357487E+00,  0.189691E-01],
           24 :  [ 0.577399E+01,  0.203858E+00, -0.359699E+00,  0.192225E-01],
           25 :  [ 0.584604E+01,  0.213814E+00, -0.359718E+00,  0.191459E-01],
           26 :  [ 0.593292E+01,  0.225038E+00, -0.361748E+00,  0.193024E-01],
           27 :  [ 0.601478E+01,  0.237959E+00, -0.364056E+00,  0.194754E-01],
           28 :  [ 0.609024E+01,  0.222770E+00, -0.366568E+00,  0.196586E-01],
           29 :  [ 0.617739E+01,  0.273123E+00, -0.372360E+00,  0.201638E-01],
           30 :  [ 0.623402E+01,  0.284312E+00, -0.372143E+00,  0.200525E-01],
           31 :  [ 0.628298E+01,  0.291334E+00, -0.369391E+00,  0.197029E-01],
           32 :  [ 0.633896E+01,  0.291512E+00, -0.365643E+00,  0.192896E-01],
           33 :  [ 0.639750E+01,  0.288866E+00, -0.361747E+00,  0.188788E-01],
           34 :  [ 0.645637E+01,  0.286737E+00, -0.358794E+00,  0.185618E-01],
           35 :  [ 0.651444E+01,  0.286324E+00, -0.357027E+00,  0.183557E-01],
           36 :  [ 0.657113E+01,  0.287711E+00, -0.356311E+00,  0.182470E-01],
           37 :  [ 0.659750E+01,  0.302389E+00, -0.356755E+00,  0.181706E-01],
           38 :  [ 0.662203E+01,  0.324559E+00, -0.361651E+00,  0.184800E-01],
           39 :  [ 0.667096E+01,  0.325070E+00, -0.360613E+00,  0.183326E-01],
           40 :  [ 0.672275E+01,  0.323964E+00, -0.359463E+00,  0.181890E-01],
           41 :  [ 0.679013E+01,  0.311282E+00, -0.355233E+00,  0.178231E-01],
           42 :  [ 0.684600E+01,  0.302790E+00, -0.351131E+00,  0.174403E-01],
           43 :  [ 0.687599E+01,  0.326165E+00, -0.358969E+00,  0.180482E-01],
           44 :  [ 0.693136E+01,  0.334794E+00, -0.363497E+00,  0.184429E-01],
           45 :  [ 0.697547E+01,  0.346394E+00, -0.367794E+00,  0.187885E-01],
           46 :  [ 0.703216E+01,  0.349838E+00, -0.370099E+00,  0.189983E-01],
           47 :  [ 0.706446E+01,  0.363456E+00, -0.373597E+00,  0.192478E-01],
           48 :  [ 0.709856E+01,  0.372199E+00, -0.375345E+00,  0.193481E-01],
           49 :  [ 0.712708E+01,  0.382082E+00, -0.376855E+00,  0.194151E-01],
           50 :  [ 0.716085E+01,  0.385512E+00, -0.376481E+00,  0.193305E-01],
           51 :  [ 0.719665E+01,  0.385543E+00, -0.375054E+00,  0.191608E-01],
           52 :  [ 0.723460E+01,  0.382493E+00, -0.372715E+00,  0.189194E-01],
           53 :  [ 0.727415E+01,  0.377223E+00, -0.369728E+00,  0.186280E-01],
           54 :  [ 0.731469E+01,  0.370315E+00, -0.366280E+00,  0.183025E-01],
           55 :  [ 0.733490E+01,  0.376825E+00, -0.365713E+00,  0.181843E-01],
           56 :  [ 0.735812E+01,  0.379361E+00, -0.364099E+00,  0.179817E-01],
           57 :  [ 0.739532E+01,  0.369895E+00, -0.359376E+00,  0.175406E-01],
           58 :  [ 0.744255E+01,  0.371328E+00, -0.359642E+00,  0.175852E-01],
           59 :  [ 0.748347E+01,  0.368431E+00, -0.357689E+00,  0.174099E-01],
           60 :  [ 0.752334E+01,  0.366462E+00, -0.356048E+00,  0.172620E-01],
           61 :  [ 0.756222E+01,  0.365055E+00, -0.354511E+00,  0.171214E-01],
           62 :  [ 0.760020E+01,  0.364134E+00, -0.353086E+00,  0.169894E-01],
           63 :  [ 0.763711E+01,  0.363957E+00, -0.351900E+00,  0.168783E-01],
           64 :  [ 0.766938E+01,  0.359752E+00, -0.348899E+00,  0.165890E-01],
           65 :  [ 0.770798E+01,  0.365345E+00, -0.350031E+00,  0.166927E-01],
           66 :  [ 0.774188E+01,  0.367107E+00, -0.349433E+00,  0.166273E-01],
           67 :  [ 0.777470E+01,  0.369722E+00, -0.349132E+00,  0.165862E-01],
           68 :  [ 0.780643E+01,  0.373226E+00, -0.349147E+00,  0.165710E-01],
           69 :  [ 0.783711E+01,  0.377547E+00, -0.349441E+00,  0.165780E-01],
           70 :  [ 0.786662E+01,  0.382933E+00, -0.350126E+00,  0.166173E-01],
           71 :  [ 0.789137E+01,  0.386034E+00, -0.349756E+00,  0.165480E-01],
           72 :  [ 0.791803E+01,  0.387021E+00, -0.348881E+00,  0.164406E-01],
           73 :  [ 0.794534E+01,  0.387299E+00, -0.347926E+00,  0.163230E-01],
           74 :  [ 0.797266E+01,  0.387704E+00, -0.347155E+00,  0.162372E-01],
           75 :  [ 0.799940E+01,  0.388739E+00, -0.346726E+00,  0.161751E-01],
           76 :  [ 0.802574E+01,  0.390458E+00, -0.346658E+00,  0.161455E-01],
           77 :  [ 0.805150E+01,  0.393143E+00, -0.347052E+00,  0.161570E-01],
           78 :  [ 0.808084E+01,  0.395790E+00, -0.348032E+00,  0.162345E-01],
           79 :  [ 0.810524E+01,  0.400576E+00, -0.349340E+00,  0.163264E-01],
           80 :  [ 0.812542E+01,  0.405858E+00, -0.350329E+00,  0.163772E-01],
           81 :  [ 0.814399E+01,  0.408692E+00, -0.349802E+00,  0.162880E-01],
           82 :  [ 0.815996E+01,  0.418031E+00, -0.352330E+00,  0.164660E-01],
           83 :  [ 0.817489E+01,  0.427916E+00, -0.355068E+00,  0.166601E-01],
           84 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
           85 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
           86 :  [ 0.822553E+01,  0.451478E+00, -0.362056E+00,  0.171556E-01],
           87 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
           88 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
           89 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
           90 :  [ 0.827843E+01,  0.479056E+00, -0.367657E+00,  0.174621E-01],
           91 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
           92 :  [ 0.833010E+01,  0.478314E+00, -0.367250E+00,  0.174129E-01],
           93 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
           94 :  [ 0.838174E+01,  0.477085E+00, -0.366556E+00,  0.173422E-01]}
#incoherent scattering x-section coeff (barns/atom)
xsecncoh={  1 :  [-0.215772E+01,  0.132685E+01, -0.305620E+00,  0.185025E-01],
            2 :  [-0.256357E+01,  0.202536E+01, -0.448710E+00,  0.279691E-01],
            3 :  [-0.108740E+01,  0.103368E+01, -0.190377E+00,  0.779955E-02],
            4 :  [-0.690079E+00,  0.946448E+00, -0.171142E+00,  0.651413E-02],
            5 :  [-0.791177E+00,  0.121611E+01, -0.239087E+00,  0.117686E-01],
            6 :  [-0.982878E+00,  0.146693E+01, -0.293743E+00,  0.156005E-01],
            7 :  [-0.123693E+01,  0.174510E+01, -0.354660E+00,  0.198705E-01],
            8 :  [-0.173679E+01,  0.217686E+01, -0.449050E+00,  0.264733E-01],
            9 :  [-0.187570E+01,  0.232016E+01, -0.475412E+00,  0.280680E-01],
            10 :  [-0.175510E+01,  0.224226E+01, -0.447640E+00,  0.255801E-01],
            11 :  [-0.967717E+00,  0.161794E+01, -0.287191E+00,  0.131526E-01],
            12 :  [-0.571611E+00,  0.135498E+01, -0.222491E+00,  0.830141E-02],
            13 :  [-0.439322E+00,  0.130867E+01, -0.211648E+00,  0.754210E-02],
            14 :  [-0.414971E+00,  0.134868E+01, -0.222315E+00,  0.841959E-02],
            15 :  [-0.476903E+00,  0.146032E+01, -0.251331E+00,  0.107202E-01],
            16 :  [-0.656419E+00,  0.165408E+01, -0.298623E+00,  0.142979E-01],
            17 :  [-0.718627E+00,  0.174294E+01, -0.319429E+00,  0.158429E-01],
            18 :  [-0.682105E+00,  0.174279E+01, -0.317646E+00,  0.156467E-01],
            19 :  [-0.344007E+00,  0.149236E+01, -0.254135E+00,  0.107684E-01],
            20 :  [-0.982420E-01,  0.132829E+01, -0.213747E+00,  0.773065E-02],
            21 :  [-0.159831E+00,  0.139055E+01, -0.225849E+00,  0.851954E-02],
            22 :  [-0.230573E+00,  0.145848E+01, -0.239160E+00,  0.938528E-02],
            23 :  [-0.308103E+00,  0.152879E+01, -0.252768E+00,  0.102571E-01],
            24 :  [-0.387641E+00,  0.159727E+01, -0.266240E+00,  0.111523E-01],
            25 :  [-0.247059E+00,  0.149722E+01, -0.238781E+00,  0.893208E-02],
            26 :  [-0.342379E+00,  0.157245E+01, -0.253198E+00,  0.985822E-02],
            27 :  [-0.428804E+00,  0.164129E+01, -0.266013E+00,  0.106512E-01],
            28 :  [-0.504360E+00,  0.170040E+01, -0.276443E+00,  0.112628E-01],
            29 :  [-0.570210E+00,  0.175042E+01, -0.284555E+00,  0.116930E-01],
            30 :  [-0.420535E+00,  0.163400E+01, -0.253646E+00,  0.927233E-02],
            31 :  [-0.358218E+00,  0.160050E+01, -0.244908E+00,  0.861898E-02],
            32 :  [-0.334383E+00,  0.160327E+01, -0.245555E+00,  0.871239E-02],
            33 :  [-0.339189E+00,  0.162535E+01, -0.250783E+00,  0.909103E-02],
            34 :  [-0.432927E+00,  0.172833E+01, -0.277138E+00,  0.111735E-01],
            35 :  [-0.448001E+00,  0.176082E+01, -0.285099E+00,  0.117865E-01],
            36 :  [-0.391810E+00,  0.173010E+01, -0.276824E+00,  0.111280E-01],
            37 :  [-0.128039E+00,  0.153044E+01, -0.227403E+00,  0.739033E-02],
            38 :  [ 0.799161E-01,  0.138397E+01, -0.192225E+00,  0.478611E-02],
            39 :  [ 0.629057E-01,  0.141577E+01, -0.199713E+00,  0.533312E-02],
            40 :  [ 0.366697E-01,  0.145207E+01, -0.208122E+00,  0.595139E-02],
            41 :  [ 0.202289E-03,  0.149347E+01, -0.217419E+00,  0.662245E-02],
            42 :  [-0.562860E-01,  0.155778E+01, -0.233341E+00,  0.785506E-02],
            43 :  [ 0.757616E-01,  0.144950E+01, -0.204890E+00,  0.564745E-02],
            44 :  [-0.424981E-01,  0.154639E+01, -0.226470E+00,  0.718375E-02],
            45 :  [-0.160399E+00,  0.164861E+01, -0.250238E+00,  0.893818E-02],
            46 :  [-0.267564E+00,  0.173740E+01, -0.269883E+00,  0.103248E-01],
            47 :  [-0.166475E+00,  0.165794E+01, -0.248740E+00,  0.866218E-02],
            48 :  [-0.516701E-01,  0.157426E+01, -0.227646E+00,  0.705650E-02],
            49 :  [-0.817283E-02,  0.155865E+01, -0.224492E+00,  0.685776E-02],
            50 :  [ 0.142151E-01,  0.155754E+01, -0.224736E+00,  0.691395E-02],
            51 :  [ 0.156362E-01,  0.157175E+01, -0.228753E+00,  0.726386E-02],
            52 :  [-0.407579E-01,  0.164267E+01, -0.247890E+00,  0.880567E-02],
            53 :  [-0.404420E-01,  0.165596E+01, -0.251067E+00,  0.904874E-02],
            54 :  [-0.282407E-02,  0.164039E+01, -0.247642E+00,  0.882144E-02],
            55 :  [ 0.184861E+00,  0.150030E+01, -0.213333E+00,  0.624264E-02],
            56 :  [ 0.344376E+00,  0.138742E+01, -0.186356E+00,  0.424917E-02],
            57 :  [ 0.409104E+00,  0.133075E+01, -0.170883E+00,  0.304111E-02],
            58 :  [ 0.439881E+00,  0.130925E+01, -0.164548E+00,  0.252641E-02],
            59 :  [ 0.449124E+00,  0.130351E+01, -0.161841E+00,  0.227394E-02],
            60 :  [ 0.437283E+00,  0.131370E+01, -0.162866E+00,  0.229377E-02],
            61 :  [ 0.405823E+00,  0.133837E+01, -0.167229E+00,  0.255570E-02],
            62 :  [ 0.355383E+00,  0.137733E+01, -0.174941E+00,  0.306213E-02],
            63 :  [ 0.280316E+00,  0.144016E+01, -0.188641E+00,  0.401226E-02],
            64 :  [ 0.273133E+00,  0.143842E+01, -0.186137E+00,  0.375240E-02],
            65 :  [ 0.257539E+00,  0.145064E+01, -0.187591E+00,  0.379932E-02],
            66 :  [ 0.242685E+00,  0.146266E+01, -0.189102E+00,  0.385628E-02],
            67 :  [ 0.228493E+00,  0.147438E+01, -0.190559E+00,  0.390903E-02],
            68 :  [ 0.225233E+00,  0.148545E+01, -0.191908E+00,  0.395645E-02],
            69 :  [ 0.202656E+00,  0.149625E+01, -0.193234E+00,  0.400233E-02],
            70 :  [ 0.202248E+00,  0.148804E+01, -0.189143E+00,  0.362264E-02],
            71 :  [ 0.197176E+00,  0.150264E+01, -0.192474E+00,  0.385751E-02],
            72 :  [ 0.199469E+00,  0.150233E+01, -0.191385E+00,  0.374011E-02],
            73 :  [ 0.196871E+00,  0.150623E+01, -0.191396E+00,  0.370889E-02],
            74 :  [ 0.191015E+00,  0.151240E+01, -0.191220E+00,  0.371450E-02],
            75 :  [ 0.189644E+00,  0.150867E+01, -0.189570E+00,  0.349584E-02],
            76 :  [ 0.116448E+00,  0.157615E+01, -0.205332E+00,  0.466731E-02],
            77 :  [ 0.719908E-01,  0.161204E+01, -0.213186E+00,  0.520497E-02],
            78 :  [ 0.420186E-01,  0.163611E+01, -0.217964E+00,  0.552670E-02],
            79 :  [ 0.156916E-01,  0.165406E+01, -0.220982E+00,  0.570751E-02],
            80 :  [ 0.114587E+00,  0.158076E+01, -0.202968E+00,  0.435692E-02],
            81 :  [ 0.147052E+00,  0.156695E+01, -0.200347E+00,  0.420901E-02],
            82 :  [ 0.182167E+00,  0.154661E+01, -0.195973E+00,  0.390772E-02],
            83 :  [ 0.189860E+00,  0.156125E+01, -0.200932E+00,  0.436768E-02],
            84 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
            85 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
            86 :  [ 0.196619E+00,  0.160080E+01, -0.213800E+00,  0.551717E-02],
            87 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
            88 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
            89 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
            90 :  [ 0.170890E+00,  0.165561E+01, -0.229702E+00,  0.692516E-02],
            91 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
            92 :  [ 0.108277E+00,  0.174158E+01, -0.254104E+00,  0.895056E-02],
            93 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
            94 :  [ 0.388791E-01,  0.182229E+01, -0.276099E+00,  0.107392E-01]}
#K post-edge fit coeffs (barns/atom)
kfit={  1 :  [ 0.244964E+01, -0.334953E+01, -0.471370E-01,  0.709962E-02],
        2 :  [ 0.606488E+01, -0.329055E+01, -0.107256E+00,  0.144465E-01],
        3 :  [ 0.775370E+01, -0.281801E+01, -0.241378E+00,  0.262542E-01],
        4 :  [ 0.904511E+01, -0.283487E+01, -0.210021E+00,  0.229526E-01],
        5 :  [ 0.995057E+01, -0.274174E+01, -0.215138E+00,  0.227845E-01],
        6 :  [ 0.106879E+02, -0.271400E+01, -0.200530E+00,  0.207248E-01],
        7 :  [ 0.112765E+02, -0.265400E+01, -0.200445E+00,  0.200765E-01],
        8 :  [ 0.117130E+02, -0.257229E+01, -0.205893E+00,  0.199244E-01],
        9 :  [ 0.120963E+02, -0.244148E+01, -0.234461E+00,  0.219954E-01],
        10 :  [ 0.124485E+02, -0.245819E+01, -0.212591E+00,  0.196489E-01],
        11 :  [ 0.126777E+02, -0.224521E+01, -0.274873E+00,  0.250270E-01],
        12 :  [ 0.128793E+02, -0.212574E+01, -0.299392E+00,  0.267643E-01],
        13 :  [ 0.131738E+02, -0.218203E+01, -0.258960E+00,  0.222840E-01],
        14 :  [ 0.132682E+02, -0.198174E+01, -0.316950E+00,  0.273928E-01],
        15 :  [ 0.133735E+02, -0.186342E+01, -0.339440E+00,  0.288858E-01],
        16 :  [ 0.137394E+02, -0.204786E+01, -0.273259E+00,  0.229976E-01],
        17 :  [ 0.136188E+02, -0.171937E+01, -0.354154E+00,  0.290841E-01],
        18 :  [ 0.139491E+02, -0.182276E+01, -0.328827E+00,  0.274382E-01],
        19 :  [ 0.137976E+02, -0.154015E+01, -0.394528E+00,  0.323561E-01],
        20 :  [ 0.142950E+02, -0.188644E+01, -0.283647E+00,  0.226263E-01],
        21 :  [ 0.139664E+02, -0.140872E+01, -0.414365E+00,  0.334355E-01],
        22 :  [ 0.143506E+02, -0.166322E+01, -0.331539E+00,  0.262065E-01],
        23 :  [ 0.147601E+02, -0.188867E+01, -0.271861E+00,  0.215792E-01],
        24 :  [ 0.148019E+02, -0.182430E+01, -0.279116E+00,  0.217324E-01],
        25 :  [ 0.148965E+02, -0.179872E+01, -0.283664E+00,  0.222095E-01],
        26 :  [ 0.143456E+02, -0.123491E+01, -0.423491E+00,  0.321661E-01],
        27 :  [ 0.147047E+02, -0.138933E+01, -0.386631E+00,  0.303286E-01],
        28 :  [ 0.142388E+02, -0.967736E+00, -0.478070E+00,  0.366138E-01],
        29 :  [ 0.145808E+02, -0.118375E+01, -0.413850E+00,  0.312088E-01],
        30 :  [ 0.144118E+02, -0.933083E+00, -0.477357E+00,  0.362829E-01],
        31 :  [ 0.136182E+02, -0.318459E+00, -0.611348E+00,  0.458138E-01],
        32 :  [ 0.139288E+02, -0.479613E+00, -0.572897E+00,  0.431277E-01],
        33 :  [ 0.134722E+02, -0.773513E-01, -0.660456E+00,  0.492177E-01],
        34 :  [ 0.130756E+02,  0.183235E+00, -0.694264E+00,  0.502280E-01],
        35 :  [ 0.132273E+02,  0.137130E+00, -0.683203E+00,  0.495424E-01],
        36 :  [ 0.135927E+02, -0.305214E-01, -0.651340E+00,  0.477616E-01],
        37 :  [ 0.130204E+02,  0.382736E+00, -0.732427E+00,  0.529874E-01],
        38 :  [ 0.135888E+02,  0.220194E-02, -0.638940E+00,  0.460070E-01],
        39 :  [ 0.134674E+02,  0.191023E+00, -0.686616E+00,  0.497356E-01],
        40 :  [ 0.127538E+02,  0.697409E+00, -0.789307E+00,  0.564531E-01],
        41 :  [ 0.133843E+02,  0.281028E+00, -0.686607E+00,  0.486607E-01],
        42 :  [ 0.139853E+02, -0.117426E+00, -0.591094E+00,  0.417843E-01],
        43 :  [ 0.128214E+02,  0.751993E+00, -0.787006E+00,  0.558668E-01],
        44 :  [ 0.126658E+02,  0.885020E+00, -0.811144E+00,  0.573759E-01],
        45 :  [ 0.121760E+02,  0.119682E+01, -0.866697E+00,  0.606931E-01],
        46 :  [ 0.139389E+02,  0.164528E+00, -0.662117E+00,  0.476289E-01],
        47 :  [ 0.133926E+02,  0.441380E+00, -0.693711E+00,  0.482085E-01],
        48 :  [ 0.125254E+02,  0.107714E+01, -0.831424E+00,  0.579120E-01],
        49 :  [ 0.118198E+02,  0.145768E+01, -0.888529E+00,  0.605982E-01],
        50 :  [ 0.130323E+02,  0.790788E+00, -0.762349E+00,  0.527872E-01],
        51 :  [ 0.906990E+01,  0.328791E+01, -0.126203E+01,  0.853470E-01],
        52 :  [ 0.116656E+02,  0.171052E+01, -0.948281E+00,  0.653213E-01],
        53 :  [ 0.121075E+02,  0.143635E+01, -0.882038E+00,  0.603575E-01],
        54 :  [ 0.110857E+02,  0.208357E+01, -0.101209E+01,  0.690310E-01],
        55 :  [ 0.113750E+02,  0.194161E+01, -0.983232E+00,  0.671986E-01],
        56 :  [ 0.102250E+02,  0.267835E+01, -0.112648E+01,  0.762669E-01],
        57 :  [ 0.109780E+02,  0.223814E+01, -0.103549E+01,  0.702339E-01],
        58 :  [ 0.102725E+02,  0.274562E+01, -0.114174E+01,  0.774162E-01],
        59 :  [ 0.110156E+02,  0.222056E+01, -0.102216E+01,  0.690465E-01],
        60 :  [ 0.117632E+02,  0.179481E+01, -0.936661E+00,  0.635332E-01],
        61 :  [ 0.113864E+02,  0.205593E+01, -0.988180E+00,  0.669106E-01],
        62 :  [ 0.119223E+02,  0.179546E+01, -0.942902E+00,  0.644202E-01],
        63 :  [ 0.116168E+02,  0.197533E+01, -0.970901E+00,  0.658459E-01],
        64 :  [ 0.991968E+01,  0.303111E+01, -0.117520E+01,  0.786750E-01],
        65 :  [ 0.113818E+02,  0.214447E+01, -0.999222E+00,  0.675569E-01],
        66 :  [ 0.114845E+02,  0.210451E+01, -0.989870E+00,  0.669382E-01],
        67 :  [ 0.875203E+01,  0.371822E+01, -0.129273E+01,  0.855026E-01],
        68 :  [ 0.120195E+02,  0.184815E+01, -0.939582E+00,  0.638106E-01],
        69 :  [ 0.125613E+02,  0.157523E+01, -0.890467E+00,  0.609779E-01],
        70 :  [ 0.742791E+01,  0.428955E+01, -0.135167E+01,  0.866136E-01],
        71 :  [ 0.126387E+02,  0.155476E+01, -0.881094E+00,  0.602036E-01],
        72 :  [ 0.758160E+01,  0.447037E+01, -0.142808E+01,  0.939044E-01],
        73 :  [ 0.865271E+01,  0.373117E+01, -0.126359E+01,  0.823539E-01],
        74 :  [ 0.757541E+01,  0.428874E+01, -0.134998E+01,  0.865200E-01],
        75 :  [ 0.136944E+01,  0.779444E+01, -0.199822E+01,  0.126225E+00],
        76 :  [ 0.137534E+02,  0.102122E+01, -0.777126E+00,  0.538811E-01],
        77 :  [ 0.125506E+02,  0.163090E+01, -0.875676E+00,  0.592011E-01],
        78 :  [ 0.127882E+02,  0.163605E+01, -0.898523E+00,  0.618550E-01],
        79 :  [ 0.496352E+01,  0.579212E+01, -0.161842E+01,  0.102911E+00],
        80 :  [ 0.197594E+02, -0.197990E+01, -0.276981E+00,  0.268856E-01],
        81 :  [ 0.152879E+02,  0.273664E+00, -0.638890E+00,  0.457495E-01],
        82 :  [ 0.863374E+01,  0.369400E+01, -0.121312E+01,  0.774601E-01],
        83 :  [ 0.944293E+01,  0.344965E+01, -0.119886E+01,  0.783484E-01],
        84 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        85 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        86 :  [ 0.151782E+02,  0.349020E+00, -0.637638E+00,  0.451377E-01],
        87 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        88 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        89 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        90 :  [ 0.134336E+02,  0.134805E+01, -0.813280E+00,  0.555664E-01],
        91 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        92 :  [ 0.137951E+02,  0.123983E+01, -0.801545E+00,  0.553596E-01],
        93 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        94 :  [ 0.182787E+02, -0.117371E+01, -0.368344E+00,  0.298738E-01]}
#L post-edge fit coeffs (barns/atom)
lfit={  1 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        2 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        3 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        4 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        5 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        6 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        7 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        8 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        9 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        10 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        11 :  [ 0.102355E+02, -0.255905E+01, -0.119524E+00,  0.000000E+00],
        12 :  [ 0.105973E+02, -0.289818E+01,  0.234506E+00,  0.000000E+00],
        13 :  [ 0.108711E+02, -0.277860E+01,  0.175853E+00,  0.000000E+00],
        14 :  [ 0.112237E+02, -0.273694E+01,  0.127557E+00,  0.000000E+00],
        15 :  [ 0.115508E+02, -0.292200E+01,  0.254262E+00,  0.000000E+00],
        16 :  [ 0.118181E+02, -0.264618E+01, -0.968049E-01,  0.000000E+00],
        17 :  [ 0.120031E+02, -0.241694E+01, -0.240897E+00,  0.000000E+00],
        18 :  [ 0.122960E+02, -0.263279E+01, -0.736600E-01,  0.000000E+00],
        19 :  [ 0.124878E+02, -0.253656E+01, -0.104892E+00,  0.000000E+00],
        20 :  [ 0.127044E+02, -0.255011E+01, -0.943195E-01,  0.000000E+00],
        21 :  [ 0.128949E+02, -0.240609E+01, -0.177791E+00,  0.000000E+00],
        22 :  [ 0.131075E+02, -0.253576E+01, -0.957177E-01,  0.000000E+00],
        23 :  [ 0.132514E+02, -0.249765E+01, -0.106383E+00,  0.000000E+00],
        24 :  [ 0.134236E+02, -0.251532E+01, -0.101999E+00,  0.000000E+00],
        25 :  [ 0.135761E+02, -0.249761E+01, -0.105493E+00,  0.000000E+00],
        26 :  [ 0.136696E+02, -0.239195E+01, -0.137680E+00,  0.000000E+00],
        27 :  [ 0.138699E+02, -0.250669E+01, -0.869945E-01,  0.000000E+00],
        28 :  [ 0.139848E+02, -0.248080E+01, -0.888115E-01,  0.000000E+00],
        29 :  [ 0.142439E+02, -0.258677E+01, -0.667398E-01,  0.000000E+00],
        30 :  [ 0.143221E+02, -0.262384E+01, -0.264926E-01,  0.000000E+00],
        31 :  [ 0.144792E+02, -0.254469E+01, -0.757204E-01,  0.000000E+00],
        32 :  [ 0.146813E+02, -0.269285E+01, -0.208355E-01,  0.000000E+00],
        33 :  [ 0.146431E+02, -0.248397E+01, -0.796180E-01,  0.000000E+00],
        34 :  [ 0.147048E+02, -0.238853E+01, -0.105877E+00,  0.000000E+00],
        35 :  [ 0.148136E+02, -0.242347E+01, -0.914590E-01,  0.000000E+00],
        36 :  [ 0.149190E+02, -0.242418E+01, -0.876447E-01,  0.000000E+00],
        37 :  [ 0.149985E+02, -0.239108E+01, -0.959473E-01,  0.000000E+00],
        38 :  [ 0.150114E+02, -0.228169E+01, -0.126485E+00,  0.000000E+00],
        39 :  [ 0.151822E+02, -0.238946E+01, -0.881174E-01,  0.000000E+00],
        40 :  [ 0.152906E+02, -0.238703E+01, -0.912292E-01,  0.000000E+00],
        41 :  [ 0.152088E+02, -0.220278E+01, -0.136759E+00,  0.000000E+00],
        42 :  [ 0.153494E+02, -0.226640E+01, -0.116881E+00,  0.000000E+00],
        43 :  [ 0.155086E+02, -0.233733E+01, -0.987857E-01,  0.000000E+00],
        44 :  [ 0.154734E+02, -0.223080E+01, -0.119454E+00,  0.000000E+00],
        45 :  [ 0.155757E+02, -0.224976E+01, -0.113377E+00,  0.000000E+00],
        46 :  [ 0.155649E+02, -0.217229E+01, -0.127652E+00,  0.000000E+00],
        47 :  [ 0.156869E+02, -0.222636E+01, -0.112223E+00,  0.000000E+00],
        48 :  [ 0.159668E+02, -0.238363E+01, -0.801104E-01,  0.000000E+00],
        49 :  [ 0.162101E+02, -0.251838E+01, -0.540061E-01,  0.000000E+00],
        50 :  [ 0.158638E+02, -0.219019E+01, -0.113539E+00,  0.000000E+00],
        51 :  [ 0.157557E+02, -0.204460E+01, -0.140745E+00,  0.000000E+00],
        52 :  [ 0.161087E+02, -0.227876E+01, -0.929405E-01,  0.000000E+00],
        53 :  [ 0.164086E+02, -0.248214E+01, -0.507179E-01,  0.000000E+00],
        54 :  [ 0.163098E+02, -0.231679E+01, -0.854498E-01,  0.000000E+00],
        55 :  [ 0.165418E+02, -0.246363E+01, -0.542849E-01,  0.000000E+00],
        56 :  [ 0.166217E+02, -0.248972E+01, -0.449623E-01,  0.000000E+00],
        57 :  [ 0.163134E+02, -0.220156E+01, -0.980569E-01,  0.000000E+00],
        58 :  [ 0.165862E+02, -0.236288E+01, -0.654708E-01,  0.000000E+00],
        59 :  [ 0.167118E+02, -0.240326E+01, -0.612619E-01,  0.000000E+00],
        60 :  [ 0.165964E+02, -0.226007E+01, -0.872426E-01,  0.000000E+00],
        61 :  [ 0.168337E+02, -0.238810E+01, -0.645041E-01,  0.000000E+00],
        62 :  [ 0.168725E+02, -0.239051E+01, -0.601080E-01,  0.000000E+00],
        63 :  [ 0.170692E+02, -0.248046E+01, -0.447055E-01,  0.000000E+00],
        64 :  [ 0.171159E+02, -0.247838E+01, -0.437107E-01,  0.000000E+00],
        65 :  [ 0.171499E+02, -0.245507E+01, -0.471370E-01,  0.000000E+00],
        66 :  [ 0.173446E+02, -0.254821E+01, -0.317606E-01,  0.000000E+00],
        67 :  [ 0.176583E+02, -0.272523E+01, -0.819409E-03,  0.000000E+00],
        68 :  [ 0.177988E+02, -0.274671E+01, -0.287580E-02,  0.000000E+00],
        69 :  [ 0.174250E+02, -0.251103E+01, -0.329450E-01,  0.000000E+00],
        70 :  [ 0.169795E+02, -0.222577E+01, -0.732557E-01,  0.000000E+00],
        71 :  [ 0.172638E+02, -0.237189E+01, -0.495994E-01,  0.000000E+00],
        72 :  [ 0.164329E+02, -0.182851E+01, -0.132268E+00,  0.000000E+00],
        73 :  [ 0.172411E+02, -0.230313E+01, -0.591006E-01,  0.000000E+00],
        74 :  [ 0.172533E+02, -0.223874E+01, -0.727338E-01,  0.000000E+00],
        75 :  [ 0.178750E+02, -0.261051E+01, -0.136093E-01,  0.000000E+00],
        76 :  [ 0.173525E+02, -0.228550E+01, -0.588047E-01,  0.000000E+00],
        77 :  [ 0.165270E+02, -0.176315E+01, -0.135232E+00,  0.000000E+00],
        78 :  [ 0.173636E+02, -0.221120E+01, -0.730934E-01,  0.000000E+00],
        79 :  [ 0.174240E+02, -0.223911E+01, -0.663720E-01,  0.000000E+00],
        80 :  [ 0.171857E+02, -0.208470E+01, -0.853294E-01,  0.000000E+00],
        81 :  [ 0.177379E+02, -0.237745E+01, -0.433223E-01,  0.000000E+00],
        82 :  [ 0.177963E+02, -0.237691E+01, -0.455883E-01,  0.000000E+00],
        83 :  [ 0.175348E+02, -0.223353E+01, -0.596161E-01,  0.000000E+00],
        84 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        85 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        86 :  [ 0.175028E+02, -0.214876E+01, -0.724638E-01,  0.000000E+00],
        87 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        88 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        89 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        90 :  [ 0.185481E+02, -0.261281E+01, -0.790574E-02,  0.000000E+00],
        91 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        92 :  [ 0.175258E+02, -0.207237E+06, -0.723932E-01,  0.000000E+00],
        93 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        94 :  [ 0.175519E+02, -0.202162E+01, -0.822940E-01,  0.000000E+00]}
#M post-edge fit coeffs (barns/atom)
mfit={  1 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        2 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        3 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        4 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        5 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        6 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        7 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        8 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        9 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       10 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       11 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       12 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       13 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       14 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       15 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       16 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       17 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       18 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       19 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       20 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       21 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       22 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       23 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       24 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       25 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       26 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       27 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       28 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       29 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       30 :  [ 0.120597E+02, -0.110258E+01,  0.000000E+00,  0.000000E+00],
       31 :  [ 0.122646E+02, -0.268965E+01,  0.000000E+00,  0.000000E+00],
       32 :  [ 0.124133E+02, -0.253085E+01,  0.000000E+00,  0.000000E+00],
       33 :  [ 0.125392E+02, -0.241380E+01,  0.000000E+00,  0.000000E+00],
       34 :  [ 0.126773E+02, -0.239750E+01,  0.000000E+00,  0.000000E+00],
       35 :  [ 0.127612E+02, -0.237730E+01,  0.000000E+00,  0.000000E+00],
       36 :  [ 0.128898E+02, -0.226021E+01,  0.000000E+00,  0.000000E+00],
       37 :  [ 0.130286E+02, -0.238693E+01,  0.000000E+00,  0.000000E+00],
       38 :  [ 0.131565E+02, -0.236655E+01,  0.000000E+00,  0.000000E+00],
       39 :  [ 0.132775E+02, -0.243174E+01,  0.000000E+00,  0.000000E+00],
       40 :  [ 0.134508E+02, -0.250201E+01,  0.000000E+00,  0.000000E+00],
       41 :  [ 0.135434E+02, -0.250135E+01,  0.000000E+00,  0.000000E+00],
       42 :  [ 0.136568E+02, -0.248480E+01,  0.000000E+00,  0.000000E+00],
       43 :  [ 0.137498E+02, -0.244730E+01,  0.000000E+00,  0.000000E+00],
       44 :  [ 0.138782E+02, -0.248066E+01,  0.000000E+00,  0.000000E+00],
       45 :  [ 0.140312E+02, -0.261303E+01,  0.000000E+00,  0.000000E+00],
       46 :  [ 0.141392E+02, -0.257206E+01,  0.000000E+00,  0.000000E+00],
       47 :  [ 0.141673E+02, -0.248078E+01,  0.000000E+00,  0.000000E+00],
       48 :  [ 0.143497E+02, -0.252756E+01,  0.000000E+00,  0.000000E+00],
       49 :  [ 0.144115E+02, -0.249401E+01,  0.000000E+00,  0.000000E+00],
       50 :  [ 0.145572E+02, -0.256792E+01,  0.000000E+00,  0.000000E+00],
       51 :  [ 0.146268E+02, -0.255562E+01,  0.000000E+00,  0.000000E+00],
       52 :  [ 0.147125E+02, -0.254324E+01,  0.000000E+00,  0.000000E+00],
       53 :  [ 0.147496E+02, -0.248179E+01,  0.000000E+00,  0.000000E+00],
       54 :  [ 0.147603E+02, -0.245068E+01,  0.000000E+00,  0.000000E+00],
       55 :  [ 0.149713E+02, -0.253145E+01,  0.000000E+00,  0.000000E+00],
       56 :  [ 0.150844E+02, -0.256341E+01,  0.000000E+00,  0.000000E+00],
       57 :  [ 0.151863E+02, -0.258287E+01,  0.000000E+00,  0.000000E+00],
       58 :  [ 0.152693E+02, -0.258174E+01,  0.000000E+00,  0.000000E+00],
       59 :  [ 0.153379E+02, -0.257086E+01,  0.000000E+00,  0.000000E+00],
       60 :  [ 0.154335E+02, -0.259006E+01,  0.000000E+00,  0.000000E+00],
       61 :  [ 0.155131E+02, -0.259623E+01,  0.000000E+00,  0.000000E+00],
       62 :  [ 0.156000E+02, -0.261328E+01,  0.000000E+00,  0.000000E+00],
       63 :  [ 0.157063E+02, -0.263481E+01,  0.000000E+00,  0.000000E+00],
       64 :  [ 0.157159E+02, -0.260843E+01,  0.000000E+00,  0.000000E+00],
       65 :  [ 0.158412E+02, -0.264040E+01,  0.000000E+00,  0.000000E+00],
       66 :  [ 0.159225E+02, -0.265289E+01,  0.000000E+00,  0.000000E+00],
       67 :  [ 0.160140E+02, -0.267903E+01,  0.000000E+00,  0.000000E+00],
       68 :  [ 0.160672E+02, -0.267580E+01,  0.000000E+00,  0.000000E+00],
       69 :  [ 0.161269E+02, -0.267886E+01,  0.000000E+00,  0.000000E+00],
       70 :  [ 0.161794E+02, -0.267715E+01,  0.000000E+00,  0.000000E+00],
       71 :  [ 0.162289E+02, -0.267128E+01,  0.000000E+00,  0.000000E+00],
       72 :  [ 0.162758E+02, -0.266220E+01,  0.000000E+00,  0.000000E+00],
       73 :  [ 0.163038E+02, -0.266148E+01,  0.000000E+00,  0.000000E+00],
       74 :  [ 0.162613E+02, -0.260672E+01,  0.000000E+00,  0.000000E+00],
       75 :  [ 0.163564E+02, -0.262453E+01,  0.000000E+00,  0.000000E+00],
       76 :  [ 0.164233E+02, -0.263163E+01,  0.000000E+00,  0.000000E+00],
       77 :  [ 0.165144E+02, -0.264832E+01,  0.000000E+00,  0.000000E+00],
       78 :  [ 0.167024E+02, -0.271631E+01,  0.000000E+00,  0.000000E+00],
       79 :  [ 0.164734E+02, -0.257834E+01,  0.000000E+00,  0.000000E+00],
       80 :  [ 0.165903E+02, -0.260670E+01,  0.000000E+00,  0.000000E+00],
       81 :  [ 0.166564E+02, -0.261593E+01,  0.000000E+00,  0.000000E+00],
       82 :  [ 0.167131E+02, -0.261538E+01,  0.000000E+00,  0.000000E+00],
       83 :  [ 0.167078E+02, -0.258648E+01,  0.000000E+00,  0.000000E+00],
       84 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       85 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       86 :  [ 0.169000E+02, -0.260945E+01,  0.000000E+00,  0.000000E+00],
       87 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       88 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       89 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       90 :  [ 0.170483E+02, -0.258569E+01,  0.000000E+00,  0.000000E+00],
       91 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       92 :  [ 0.170353E+02, -0.256903E+01,  0.000000E+00,  0.000000E+00],
       93 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       94 :  [ 0.172953E+02, -0.262164E+01,  0.000000E+00,  0.000000E+00]}
#N post-edge fit coeffs (barns/atom)
nfit={  1 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        2 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        3 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        4 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        5 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        6 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        7 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        8 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
        9 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       10 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       11 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       12 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       13 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       14 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       15 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       16 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       17 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       18 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       19 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       20 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       21 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       22 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       23 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       24 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       25 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       26 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       27 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       28 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       29 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       30 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       31 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       32 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       33 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       34 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       35 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       36 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       37 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       38 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       39 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       40 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       41 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       42 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       43 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       44 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       45 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       46 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       47 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       48 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       49 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       50 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       51 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       52 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       53 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       54 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       55 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       56 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       57 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       58 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       59 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       60 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       61 :  [ 0.155131E+02, -0.259623E+01,  0.000000E+00,  0.000000E+00],
       62 :  [ 0.156006E+02, -0.261328E+01,  0.000000E+00,  0.000000E+00],
       63 :  [ 0.157063E+02, -0.263481E+01,  0.000000E+00,  0.000000E+00],
       64 :  [ 0.157159E+02, -0.260843E+01,  0.000000E+00,  0.000000E+00],
       65 :  [ 0.158415E+02, -0.264040E+01,  0.000000E+00,  0.000000E+00],
       66 :  [ 0.159225E+02, -0.265289E+01,  0.000000E+00,  0.000000E+00],
       67 :  [ 0.160140E+02, -0.267903E+01,  0.000000E+00,  0.000000E+00],
       68 :  [ 0.160672E+02, -0.267580E+01,  0.000000E+00,  0.000000E+00],
       69 :  [ 0.161269E+02, -0.267886E+01,  0.000000E+00,  0.000000E+00],
       70 :  [ 0.139111E+02, -0.240380E+01,  0.000000E+00,  0.000000E+00],
       71 :  [ 0.139813E+02, -0.240841E+01,  0.000000E+00,  0.000000E+00],
       72 :  [ 0.140548E+02, -0.242829E+01,  0.000000E+00,  0.000000E+00],
       73 :  [ 0.141313E+02, -0.247214E+01,  0.000000E+00,  0.000000E+00],
       74 :  [ 0.141536E+02, -0.232580E+01,  0.000000E+00,  0.000000E+00],
       75 :  [ 0.142392E+02, -0.235326E+01,  0.000000E+00,  0.000000E+00],
       76 :  [ 0.142795E+02, -0.221971E+01,  0.000000E+00,  0.000000E+00],
       77 :  [ 0.143422E+02, -0.240183E+01,  0.000000E+00,  0.000000E+00],
       78 :  [ 0.143785E+02, -0.234834E+01,  0.000000E+00,  0.000000E+00],
       79 :  [ 0.144398E+02, -0.232838E+01,  0.000000E+00,  0.000000E+00],
       80 :  [ 0.145195E+02, -0.233016E+01,  0.000000E+00,  0.000000E+00],
       81 :  [ 0.145473E+02, -0.226773E+01,  0.000000E+00,  0.000000E+00],
       82 :  [ 0.145771E+02, -0.225279E+01,  0.000000E+00,  0.000000E+00],
       83 :  [ 0.146832E+02, -0.230940E+01,  0.000000E+00,  0.000000E+00],
       84 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       85 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       86 :  [ 0.147243E+02, -0.212905E+01,  0.000000E+00,  0.000000E+00],
       87 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       88 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       89 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       90 :  [ 0.147730E+02, -0.191192E+01,  0.000000E+00,  0.000000E+00],
       91 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       92 :  [ 0.149036E+02, -0.212148E+01,  0.000000E+00,  0.000000E+00],
       93 :  [ 0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00],
       94 :  [ 0.148535E+02, -0.187733E+01,  0.000000E+00,  0.000000E+00]}

#############################################################################
##
## END OF DATA SECTION
##
#############################################################################

from string import *
from math import *

def name_z(name):
    #given an element name, return the atomic number
    #chop to first two characters and proper capitalization
    if len(name)==1:
        name=upper(name)
    else:
        name=upper(name[0])+lower(name[1])
    try:
        z=esym.index(name)
        return z+1
    except:
        return 0

def mcmaster(ephot,fit):
    #given a photon energy and the fit coefficients, calculaate the McMaster x-section
    xsec=0
    #need special handling for ephot=1
    if float(ephot)==1.0:
        log_e=1
    else:
        log_e=log(ephot)
    i=0
    for c in fit:
        xsec=xsec+c*pow(log_e,i)
        i=i+1
    xsec=exp(xsec)
    return xsec    
        
def mucal(name='ZZ',Z=200,ephot=0,unit='b'):
    #given an element name and photon energy, calculate the x-ray data
    #see top of file for full documentation
    # [err,energy,xsec,fl_yield,errmsg] = mucal(element, Z, e_phot, unit)
    errmsg='0'
    err=0
    ZZ=Z
    Z=0
    shell=0
    #init returns
    energy=[0,0,0,0,0,0,0,0,0]
    xsec=[0,0,0,0,0,0,0,0,0,0,0,0]
    fl_yield=[0,0,0,0]
    #check to make sure name or Z given as inputs
    if name=='ZZ' and ZZ==200:
        errmsg='ERROR mucal: no shirt/name, no shoes/Z, no service'
        print errmsg
        return [1,energy,xsec,fl_yield,errmsg]
    #make sure ZZ is non-negative
    if ZZ<0:
        errmsg='ERROR mucal: Z must be non-negative'
        print errmsg
        return [1,energy,xsec,fl_yield,errmsg]
    #determine material Z, if needed
    if name!='ZZ':
        Z=name_z(name)
        #name and ZZ must be consistent if both given!
        if ZZ!=200 and Z!=ZZ:
            errmsg='ERROR mucal: Z and element name are not consistent'
            print errmsg
            return [1,energy,xsec,fl_yield,errmsg]
        ZZ=Z
    Z=ZZ
    #make sure material is available
    if (Z==85 or Z==85 or Z==87 or Z==88 or Z==89 or Z==91 or Z==93):
        errmsg='ERROR mucal: no data is avaialble for Po, At, Fr, Ra, Ac, Pa, Np'
        print errmsg
        return [1,energy,xsec,fl_yield,errmsg]
    #Z must be less than Zmax
    if Z>Zmax:
        errmsg='ERROR mucal: no data for Z>'+str(Zmax)
        print errmsg
        return [1,energy,xsec,fl_yield,errmsg]
    #must be a valid element symbol
    if not Z:
        errmsg='ERROR mucal: invalid element name '+name
        print errmsg
        return [1,energy,xsec,fl_yield,errmsg]        
    #OK, inout is all good...
    #get name if needed
    if name=='ZZ':
        name=esym[Z-1]
    #make sure energy is positive
    if ephot<0:
        errmsg='ERROR mucal: photon energy must be non-negative'
        print errmsg
        return [1,energy,xsec,fl_yield,errmsg]
    #put the energy independent parts of the return arrays together
    energy[0] = kedge[Z]
    energy[1] = l1edge[Z]
    energy[2] = l2edge[Z]
    energy[3] = l3edge[Z]
    energy[4] = medge[Z]
    energy[5] = kalpha1[Z]
    energy[6] = kbeta1[Z]
    energy[7] = lalpha1[Z]
    energy[8] = lbeta1[Z]
    
    xsec[0] = 0.0    #/* photo */
    xsec[1] = 0.0    #/* coherent */
    xsec[2] = 0.0    #/* incoherent */
    xsec[3] = 0.0    #/* total */
    xsec[4] = 0.0    #/* conversion factor */
    xsec[5] = 0.0    #/* absorption  coef */
    xsec[11]= 0.0    # total xsec not including current edge ala Booth
    xsec[6] = atwt[Z]
    xsec[7] = density[Z]    
    if (Z>27):
        xsec[8] = l1jump
        xsec[9] = l2jump
    else:
        xsec[8] = 0.0
        xsec[9] = 0.0
    xsec[10]=l3jump[Z]
    
    fl_yield[0] = kyield[Z]
    fl_yield[1] = lyield[Z][0]
    fl_yield[2] = lyield[Z][1]
    fl_yield[3] = lyield[Z][2]   

    #if ephot=0, return physical constants only
    if ephot==0:
        return [0,energy,xsec,fl_yield,errmsg]

    #energy dependent section
    #check for middle of edge input
    if ((abs(kedge[Z]-ephot)<=0.001) or 
        (abs(l1edge[Z]-ephot)<=0.001) or 
        (abs(l2edge[Z]-ephot)<=0.001) or 
        (abs(l3edge[Z]-ephot)<=0.001) or 
        (abs(medge[Z]-ephot)<=0.001)):
        errmsg='ERROR mucal: photon energy  is within 1 eV of edge \nfit results may be inaccurate\n\n'
        print errmsg
        err=2
    #determine shell being ionized
    if ephot>=kedge[Z]:     #K-edge
        shell=1
    elif ephot>=l3edge[Z]:    #L-edge
        shell=2
    elif ephot>=medge[Z]:     #M1-subshell
        shell=3
    else:                   #all the rest
        shell=4
    #calculate photo-absorption barns/atom x-section
    if shell==1:
        barn_photo=mcmaster(ephot,kfit[Z])
    if shell==2:
        barn_photo=mcmaster(ephot,lfit[Z])
        if ephot>=l1edge[Z]:    #above L1, no correction
            pass
        elif ephot>=l2edge[Z]:    #between L1 and L2
            barn_photo=barn_photo/l1jump
        elif ephot>=l3edge[Z]:     #between L2 and L3
            barn_photo=barn_photo/(l1jump+l2jump)
    if shell==3:
        barn_photo=mcmaster(ephot,mfit[Z])
    if shell==4:        
        barn_photo=mcmaster(ephot,nfit[Z])

    xshell=shell+1
    #calculate photo-absorption for all but current edge
    if xshell==2:
        barn_pnox=mcmaster(ephot,lfit[Z])
    if xshell==3:
        barn_pnox=mcmaster(ephot,mfit[Z])
    if xshell==4:        
        barn_pnox=mcmaster(ephot,nfit[Z])
    if xshell==5:
        barn_pnox=mcmaster(ephot,nfit[Z])

    #print shell,barn_pnox,barn_photo
    #M edges for Z<30 are unreliable
    if shell>2 and Z<30:
        errmsg2='ERROR mucal: McMaster et al. use L-edge fits for the M edges for Z<30\nWARNING: results may be inaccurate\n\n'
        print errmsg2
        errmsg=errmsg+errmsg2
        err=err+4

    #calculate coherent, incoherent x-sections and total
    barn_coh = mcmaster(ephot, xseccoh[Z])
    barn_ncoh = mcmaster(ephot, xsecncoh[Z])
    barn_tot = barn_photo + barn_coh + barn_ncoh
    barn_11 = barn_pnox + barn_coh + barn_ncoh #

    #stuff xsec array with the barnes/atom data
    xsec[0] = barn_photo
    xsec[1] = barn_coh
    xsec[2] = barn_ncoh
    xsec[3] = barn_tot
    xsec[11]= barn_11
    xsec[4] = convfac[Z]                          #/* conversion factor */
    xsec[5] = barn_tot * density[Z] / convfac[Z]  #/* absorption  coef */    

    #convert to cm**2/g if needed
    if upper(unit)=='C':
        for i in range(4):
            xsec[i]=xsec[i]/xsec[4]
        xsec[11]=xsec[11]/xsec[4]
        
    #ALL DONE! WOO-HOO
    return [err,energy,xsec,fl_yield,errmsg]
        




#tests
#[a,b,c,d,e]=mucal(name='S',ephot=3.0,unit='C')
#print a
#print b
#print c
#print d
