/* pgp4pine pki.c
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* ------------------------------------------------------------ */

int pipe_pgp(const char *cmd, FILE **in, FILE **out)
{
         int pin[2], pout[2], child_pid;

         *in = *out = NULL;

         pipe(pin);
         pipe(pout);

	 documentStatus("pki.c:\n\tpipe_pgp (cmd = '");
	 documentStatus(cmd);
	 documentStatus("', FILE **in, FILE **out)\n");

         if(!(child_pid = fork()))
         {
           // We're the child.
           close(pin[1]);
           dup2(pin[0], 0);
           close(pin[0]);

           close(pout[0]);
           dup2(pout[1], 1);
           close(pout[1]);

           execl("/bin/sh", "sh", "-c", cmd, NULL);
           _exit(127);
         }

         // Only get here if we're the parent.
         close(pout[1]);
         *out = fdopen(pout[0], "r");

         close(pin[0]);
         *in = fdopen(pin[1], "w");

         return(child_pid);
}

// ---------------------------------------------------------------------------------

void fileVerify(const char *inFile,const char *outFile)
{
	char sigFile[MAX_COMMAND_LINE_LENGTH];
	char pgpAppString[MAX_COMMAND_LINE_LENGTH];
	char c;
	FILE *sigf, *outf;
	
	documentStatus("pki.c\n\tfileVerifyDecrypt (inFile = '");
	documentStatus(inFile);
	documentStatus("', outFile = '");
	documentStatus(outFile);
	documentStatus("')\n");
	sprintf(sigFile,"%s.sig",outFile); // Signature file is outfile.sig
	
	switch (myUserPrefs->pgpVersion) {
	case 5:
		sprintf(pgpAppString,"%s -o %s %s 2>%s",myUserPrefs->pgp5pgpv,outFile,inFile,sigFile);
		break;
	case 2:
		sprintf(pgpAppString,"%s %s -o %s 2>%s",myUserPrefs->pgp2pgp,inFile,outFile,sigFile);
		break;
	case 1:
		sprintf(pgpAppString,"%s --no-greeting --output %s --decrypt %s 2>%s",
		   myUserPrefs->pgp1gpg,outFile,inFile,sigFile);
		break;	
	}
	documentStatus("\t\tpgpAppString = '");
	documentStatus(pgpAppString);
	documentStatus("'\n");
	runProcessFG(pgpAppString);

// TODO: Signature-ID check: Unknown -> get keyserver
	
	if (((outf = fopen(outFile,"a")) != NULL) && ((sigf = fopen(sigFile,"r"))!=NULL))
	{
	  fprintf(outf,"------------ Output from %s ------------\n",
	                myUserPrefs->pgpVersion==1?"gpg":"pgp");
          do
	  {
	    c=getc(sigf);
	  } while ((c!=EOF) && (c!='\n')); // Skip first line

	  while ((c=getc(sigf))!=EOF)
	    putc(c,outf);
	  fclose(outf); fclose(sigf);
	} else
	  printf("Signature check failed.");
        remove(sigFile);
}

// ---------------------------------------------------------------------------------

void fileDecrypt(const char *inFile,const char *outFile)
{
	char pgpAppString[MAX_COMMAND_LINE_LENGTH];

	documentStatus("pki.c\n\tfileVerifyDecrypt (inFile = '");
	documentStatus(inFile);
	documentStatus("', outFile = '");
	documentStatus(outFile);
	documentStatus("')\n");

	switch (myUserPrefs->pgpVersion) {
	case 5:
		sprintf(pgpAppString,"%s -o %s %s",myUserPrefs->pgp5pgpv,outFile,inFile);
		break;
	case 2:
		sprintf(pgpAppString,"%s %s -o %s",myUserPrefs->pgp2pgp,inFile,outFile);
		break;
	case 1:
		sprintf(pgpAppString,"%s --no-greeting --output %s --decrypt %s",myUserPrefs->pgp1gpg,outFile,inFile);
		break;	
	}
	documentStatus("\t\tpgpAppString = '");
	documentStatus(pgpAppString);
	documentStatus("'\n");
	runProcessFG(pgpAppString);
}

// ---------------------------------------------------------------------------------

void fileSignEncrypt(const char *inFileName,
		     const char *outFileName,
		     const int sign, const int encrypt,
		     char *recipient, 
		     const int asciiArmor, const int universalText,
		     int encryptToSelf,int detachSigs)
{
	char pgpAppString[MAX_COMMAND_LINE_LENGTH], *commentString;
	char pgpOptions[MAX_COMMAND_LINE_LENGTH], recipList[EMAIL_ADDRESS_MAX_LENGTH];

	documentStatus("pki.c\n\tfileSignEncrypt (inFile = '");
	documentStatus(inFileName);
	documentStatus("', outFile = '");
	documentStatus(outFileName);
	documentStatus("', sign = ");
	if (sign == 1) documentStatus("1"); else documentStatus("0");
	documentStatus(", encrypt = ");
	if (encrypt == 1) documentStatus("1"); else documentStatus("0");
	documentStatus(", recipient = '");
	documentStatus(recipient);
	documentStatus(", asciiArmor = ");
	if (asciiArmor == 1) documentStatus("1"); else documentStatus("0");
	documentStatus(", universalText = ");
	if (universalText == 1) documentStatus("1"); else documentStatus("0");
	documentStatus(", encryptToSelf = ");
	if (encryptToSelf == 1) documentStatus("1"); else documentStatus("0");
	documentStatus(", detachSigs = ");
	if (detachSigs == 1) documentStatus("1"); else documentStatus("0");
	documentStatus("')\n");

	strcpy(pgpOptions," ");
	strcpy(recipList," ");
	strcat(pgpOptions,myUserPrefs->extraOptions);

	if (encryptToSelf > 0) {
		if (strlen(myUserPrefs->myAddress) > 3) {
			strcat(recipient," ");
			strcat(recipient,myUserPrefs->myAddress);
			strcat(recipient," ");
		} else {
			if (myUserPrefs->pgpVersion != 5) printf("Because you didn't specify your email address in ~/.pgp4pinerc,\nI can't auto-encrypt to you as well.\n");
			encryptToSelf = -1;
		}
	}

	switch (myUserPrefs->pgpVersion) {
	case 5:
		if (detachSigs > 0) strcat(pgpOptions," -b ");
		// get recipList...
		if (encrypt > 0) {
//			parseRecipientList(recipient,1);
			strcpy(recipList,recipient);
 			if (sign > 0) strcat(pgpOptions," -s ");
		}
		if (sign > 0 && strlen(mySecretKey) > 3) {
 				strcat(pgpOptions," -u \"");
 				strcat(pgpOptions,mySecretKey);
 				strcat(pgpOptions,"\" ");
		}
		if (asciiArmor > 0) strcat(pgpOptions," -a ");
		if (universalText > 0) strcat(pgpOptions," -t ");
		if (prefsAddComment > 0)
		{
			commentString="--comment=\"Made with pgp4pine " MY_VERSION_STRING "\"";
		}
		else
			commentString = "";

		if (encrypt > 0)
			sprintf(pgpAppString,"%s %s %s %s -o %s %s",myUserPrefs->pgp5pgpe,pgpOptions,commentString,recipList,outFileName,inFileName);
		else
			sprintf(pgpAppString,"%s %s %s -o %s %s",myUserPrefs->pgp5pgps,pgpOptions,commentString,outFileName,inFileName);
		runProcessFG(pgpAppString);
		break;
	case 2:
		strcat(pgpOptions," -"); // we either have to add a e[s] or just s...
		if (encrypt > 0) {
			strcat(pgpOptions,"e");
//			parseRecipientList(recipient,0);
			strcpy(recipList,recipient);
		}
		if (sign > 0) {
			strcat(pgpOptions,"s");
			if (detachSigs > 0) strcat(pgpOptions,"b");
		}
		if (universalText > 0) strcat(pgpOptions,"t");
		if (asciiArmor > 0) strcat(pgpOptions,"a");
		strcat(pgpOptions," ");
		if (sign > 0 && strlen(mySecretKey) > 3) {
			strcat(pgpOptions," -u \"");
			strcat(pgpOptions,mySecretKey);
			strcat(pgpOptions,"\" ");
		}
		if (prefsAddComment > 0) 
			commentString = "+COMMENT=\"Made with pgp4pine\"";
		else
			commentString = "";

		if (encrypt > 0)
			sprintf(pgpAppString,"%s %s %s %s %s",myUserPrefs->pgp2pgp,pgpOptions,commentString,inFileName,recipList);
		else
			sprintf(pgpAppString,"%s %s %s %s",myUserPrefs->pgp2pgp,pgpOptions,commentString,inFileName);
		runProcessFG(pgpAppString); 
		
		// now, we move the <infile>.pgp to <outfile>
		if (detachSigs > 0) {
			// we're detaching a signature, the original file isn't changed....
		} else {
			if (asciiArmor > 0)
				sprintf(pgpAppString,"mv %s.asc %s",inFileName,outFileName);
			else
				sprintf(pgpAppString,"mv %s.pgp %s",inFileName,outFileName);
			runProcessFG(pgpAppString);
		}
		break;
	case 1:
		if (encrypt > 0) {
			strcat(pgpOptions," -e ");
//			parseRecipientList(recipient,1);
			strcpy(recipList,recipient);
			if (myUserPrefs->encryptToSelf == 1) {
				strcat(recipList," -r ");
				strcat(recipList,myUserPrefs->myAddress);
			}
		}
		if (sign > 0) {
			if (detachSigs > 0) strcat(pgpOptions," -b ");
			strcat(pgpOptions," -s ");
			if (encrypt == 0) strcat(pgpOptions," --clearsign ");
			if (strlen(mySecretKey) > 3) {
				strcat(pgpOptions," -u \"");
				strcat(pgpOptions,mySecretKey);
				strcat(pgpOptions,"\" ");
			}
		}
		if (myUserPrefs->asciiArmor > 0) strcat(pgpOptions, " -a ");
		if (myUserPrefs->universalText > 0) strcat(pgpOptions, " -t ");
		// if we're not encrypting, recipList is just a " ", so we're safe...
		// Just moved outfilename to begining of list per email from henrik kg andreasson
		if (prefsAddComment > 0) 
			commentString = "--comment \"Made with pgp4pine\"";
		else
			commentString = "";
			
		sprintf(pgpAppString,"%s -o %s --no-batch %s --no-greeting %s %s %s",myUserPrefs->pgp1gpg,outFileName,commentString,pgpOptions,recipList,inFileName);
		sprintf(debugLine,"DEBUG: GnuPG Run: \"%s\"\n",pgpAppString);
		documentStatus(debugLine);
		runProcessFG(pgpAppString);
		break;
	}
}
// ---------------------------------------------------------------------------------
/* Get unknown keys from keyserver */
void fileAskKey(char *nokeyrecipients)
{
	char pgpAppString[MAX_COMMAND_LINE_LENGTH];
	char tmpEmail[EMAIL_ADDRESS_MAX_LENGTH];
	int  i=0;
	
	if (myUserPrefs->pgpVersion == 2) {
	  printf("Who the hell called this routine ? Anyway, PGP 2 cannot get keys from a keyserver.\n");
	} else {
	  documentStatus("Asking Keyserver for unknown keys");
	
	  do {
		if (i==0) strcpy(tmpEmail,strtok(nokeyrecipients," "));
		else strcpy(tmpEmail,strtok('\0'," "));
		if (strcmp(tmpEmail,".")) {
			if (strlen(tmpEmail) > 1)
			{ 
			  if (myUserPrefs->pgpVersion == 5)
			    sprintf(pgpAppString,"%s -a \"%s\"",myUserPrefs->pgp5pgpk,tmpEmail);
			  else
			    sprintf(pgpAppString,"%s --recv-keys \"%s\"",myUserPrefs->pgp1gpg,tmpEmail);

			  documentStatus(pgpAppString);
			  runProcessFG(pgpAppString);
			}
		}
		i++;
	  } while(strcmp(tmpEmail,"."));
	}
}

/* Parse Recipient list *recipients and correct ambiguous keys. 
Return is key-owners list *recipients and no-key list *nokeyrecipients. */

void parseRecipientList(char *recipients, char *nokeyrecipients, int addDashR)
{
	char tmpEmail[EMAIL_ADDRESS_MAX_LENGTH];
	char recipList[EMAIL_ADDRESS_MAX_LENGTH], nokeyList[EMAIL_ADDRESS_MAX_LENGTH];
	int i=0;

	strcpy(recipList,"");
	strcpy(nokeyList,"");
	
	// recipients is passed back, so it's a pointer
	strcat(recipients," . "); // we add a space so that anything at the end is an item
	// if you don't, strtok() can segfault because there's no terminating " "...
	documentStatus("pki.c\n\tparseRecipientList (recipients = '");
	documentStatus(recipients);
	documentStatus("', addDashR = ");
	if (addDashR == 1) documentStatus("1"); else documentStatus("0");
	documentStatus(")\n");

 	do {
		if (i==0) strcpy(tmpEmail,strtok(recipients," "));
		else strcpy(tmpEmail,strtok('\0'," "));
		if (strcmp(tmpEmail,".")) {
			if (strlen(tmpEmail) > 1)
			{
//			  printf(tmpEmail);
			  if (checkRecipient(tmpEmail) == 1) 
			  {
			     printf(" - key %s found\n",tmpEmail);
			     if (addDashR == 1) strcat(recipList," -r");
			     strcat(recipList," \"");
			     strcat(recipList,tmpEmail);
			     strcat(recipList,"\" ");
			  } else {/* not found */
			     printf(" - no key found\n");
			     strcat(nokeyList,"\"");
			     strcat(nokeyList,tmpEmail);
			     strcat(nokeyList,"\" ");
			  }
			}
		}
		i++;
	} while(strcmp(tmpEmail,"."));
	strcpy(recipients,recipList);
	strcpy(nokeyrecipients,nokeyList);
	documentStatus("Recipients: with key: ");
	documentStatus(recipients);
	documentStatus(" without key: ");
	documentStatus(nokeyrecipients);
	documentStatus("\n");
	strcat(nokeyrecipients," . "); /* Terminate list */
}

int checkRecipient(char *thisRecip)
{
	// This just checks a single recipient, when we parse the recipient list, we check each one...
	struct pkiKey *thisKey = NULL;
	struct pkiKey *lastKey = NULL;
	int found = 0, canLeave = 0;

	documentStatus("pki.c\n\tcheckRecipient (thisRecip = '");
	documentStatus(thisRecip);
	documentStatus("')\n");
	printf("%s... ",thisRecip);

	found = 0;
	if (publicKeyring != NULL) {
		thisKey = publicKeyring;
		lastKey = thisKey;
		while (thisKey != NULL) {
			if (strcasecmp(thisRecip,thisKey->emailAddress) == 0) {
				found++;
				lastKey = thisKey;
			}
			thisKey = thisKey->nextKey;
		}
	}

	if (found < 1) {   /* No key found */
		documentStatus("\tNo key found for ");documentStatus(thisRecip);
		documentStatus("\n");
	} else if (found > 1) {
		int i=0,j=0,k=1;
		// wow..two keys...
		printf("\n\nThe following recipient has multiple keys. Please select one.\n");
		thisKey = publicKeyring; // set back to beginning
		do {
			if (strcasecmp(thisKey->emailAddress,thisRecip) == 0) {
				i++; // number of able and ready keys...
				printKeyInfo((char) ('a'+i-1),thisKey);
			}
			thisKey = thisKey->nextKey;
		} while (thisKey != NULL);
		j = askAlphaRange("Please select the recipient key to use.",'a',(i+'a'-1))-'a';
		thisKey = publicKeyring;
		k=0;
		while (k<=j) {
			documentStatus("\t\tk vs. j loop:\n\t\t\tthisKey->emailAddress = ");
			documentStatus(thisKey->emailAddress);
			documentStatus("\n\t\t\tthisKey->keyID = ");
			documentStatus(thisKey->keyID);
			documentStatus("\n");
			if (strcasecmp(thisKey->emailAddress,thisRecip) == 0) {
				k++;
				documentStatus("\t\t\tKey Matched!\n");
			}
			if (k <= j) thisKey = thisKey->nextKey;
		}
#ifdef USE_DISPLAY_NAME
		strcpy(thisRecip,thisKey->emailAddress);
#else
		strcpy(thisRecip,thisKey->keyID);
#endif
		documentStatus("\t\tThisRecip: ");
		documentStatus(thisRecip);
		documentStatus("\n");
		found = 1;	/* One key found */
	} else {
//		printf("found (%s)\n",lastKey->keyID);
		// only one key for this recipient
#ifdef USE_DISPLAY_NAME
		strcpy(thisRecip,lastKey->emailAddress);
#else
		strcpy(thisRecip,lastKey->keyID);
#endif
	}
	return found;
}

void parseList(char *recipients, char *nokeyrecipients)
{
	printf("\nChecking recipients ...\n\n");
	parseRecipientList(recipients,nokeyrecipients,(myUserPrefs->pgpVersion == 2)?0:1);
	/* addDashR: PGP wants -r before recipients, GPG not */
	printf("\n\n");
}

void printKeyInfo(char c,struct pkiKey *thisKey)
{
	printf("\n%c: %s <%s>\n\tType: %s\tBits: %s\tID: %s\n",c,thisKey->displayName,thisKey->emailAddress,thisKey->keyType,thisKey->keySize,thisKey->keyID);
	return;
}
