// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/orp_cout.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#ifndef include_orp_cout
#define include_orp_cout

#include <stdio.h>
#include "orp_types.h"  // for definition of ORPExport

#ifdef __cplusplus

class orp_out
{
public:

    orp_out& operator<< (const char *string_x);

    orp_out& operator<< (int int_x);

    orp_out& operator<< (unsigned unsigned_x);

    orp_out& operator<< (unsigned long ul_x);

    orp_out& operator<< (__int64 u64_x);

    orp_out& operator<< (double double_x);

    orp_out& operator<< (const void *ptr);

    orp_out& operator<<(orp_out& (* _f)(orp_out&));

    bool hex;
    orp_out();
};

ORPExport orp_out& endl(orp_out& jo);
ORPExport orp_out& hex(orp_out& jo);
ORPExport orp_out& dec(orp_out& jo);
ORPExport orp_out& flush(orp_out& jo);

extern ORPExport orp_out orp_cout;


#endif

#endif
