// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/slot_offset_list.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _SLOT_OFFSET_LIST_H_
#define _SLOT_OFFSET_LIST_H_

//
// An Object List is used to keep track of lists of objects when
// a hash table-style remembered set or object set is overkill.
//


#if 1

#include "platform.h"
#include "object_layout.h"

class slot_offset_list {
public:
    slot_offset_list();

    virtual ~slot_offset_list();

    void add_entry(void **slot, Java_java_lang_Object *p_obj, int offset);

	void next();
    
    bool available();

    void rewind();

    void reset();

    unsigned size();

    void debug_check_list_integrity();

    void debug_dump_list();
    
    // Interior pointers can point at non objects, thus the void.
    void **get_slot ();


    Java_java_lang_Object **get_last_base_slot ();
    
    Java_java_lang_Object *get_base ();

    int get_offset ();

private:

    typedef struct slot_offset_entry {
        void **slot;
        Java_java_lang_Object *base;
        int offset;
    } slot_offset_entry;

    unsigned _current_pointer;

    void _extend();

    unsigned _resident_count;

    unsigned _size_in_entries;

    slot_offset_entry *_store;
};

#endif // was GC_INTERIOR_POINTERS

#endif // _SLOT_OFFSET_LIST_H_

