// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/include/java_net_PlainSocketImpl_common.h,v 1.3 2001/08/23 05:30:23 gwu2 Exp $
//


extern jobject create_inet_addr(JNIEnv *env, int net_address);
extern void create_socket(JNIEnv *jenv, jobject jobj, jboolean is_stream);
extern void close_socket(JNIEnv *jenv, jobject jobj);
extern void  bind_socket(JNIEnv *, jobject, jobject, jint, jboolean);
extern jobject socketGetOption(JNIEnv *jenv, jobject jobj, jint option_type);
extern void socketSetOption(JNIEnv *jenv, jobject jobj, jint option_type, jobject value);

//GetJClassName is defined in jni_utils.cpp
extern const char *GetJClassName(jclass clazz);

// Utility functions to extract and and set values of different fields in 
// PLainSocketImpl annd PlainDatagramSocketImpl.


inline jclass get_plainSocketImpl_class(JNIEnv *jenv)
{
	jclass clazz = jenv->FindClass("java/net/PlainSocketImpl");	
	assert(clazz);
	return clazz;
}

inline jclass get_plainDatagramSocketImpl_class(JNIEnv *jenv)
{
	jclass clazz = jenv->FindClass("java/net/PlainDatagramSocketImpl");	
	assert(clazz);
	return clazz;
}

inline jclass get_InetAddress_class(JNIEnv *jenv)
{
	jclass clazz = jenv->FindClass("java/net/InetAddress");	
	assert(clazz);
	return clazz;
}


inline jclass get_FileDescriptor_class(JNIEnv *jenv)
{
	jclass FD_clazz = jenv->FindClass("java/io/FileDescriptor");	
	assert(FD_clazz);
	return FD_clazz;
}


inline jobject create_new_FD(JNIEnv *jenv, int val)
{
	jvalue jargs[1];
	jargs[0].i = val;
	jclass FD_clazz = get_FileDescriptor_class(jenv);

	jmethodID init_ID = jenv->GetMethodID(FD_clazz, "<init>", "(I)V");
	assert(init_ID);
	jobject fd_object = jenv->NewObjectA(FD_clazz, init_ID, jargs);
	assert(fd_object);
	return fd_object;
}

inline jobject get_socket_fd(JNIEnv *jenv, jclass clazz, jobject jobj)
{ 
	jfieldID fd_field = 
		jenv->GetFieldID(clazz, "fd", "Ljava/io/FileDescriptor;");
	assert(fd_field);
	jobject jfd = jenv->GetObjectField(jobj, fd_field);
	assert(jfd);
	return jfd;
}


inline void set_socket_fd(JNIEnv *jenv, jclass clazz, jobject jobj, jobject jfd)
{ 
	jfieldID fd_field = 
		jenv->GetFieldID(clazz, "fd", "Ljava/io/FileDescriptor;");
	assert(fd_field);
	jenv->SetObjectField(jobj, fd_field, jfd);
}


inline int get_socket_native_fd(JNIEnv *jenv, jclass clazz, jobject jobj)
{
	jfieldID native_fd_field = 
		jenv->GetFieldID(clazz, "native_fd", "I");
	assert(native_fd_field);
	return jenv->GetIntField(jobj, native_fd_field);	
}

inline void set_socket_native_fd(JNIEnv *jenv, jclass clazz, jobject jobj, int sock)
{
	jfieldID native_fd_field = 
		jenv->GetFieldID(clazz, "native_fd", "I");
	assert(native_fd_field);
	jenv->SetIntField(jobj, native_fd_field, sock);	
}


inline int get_socket_localport(JNIEnv *jenv, jclass clazz, jobject jobj)
{
	const char *name = GetJClassName(clazz);
	//in gnu_classpath: SocketImpl has field "localport", but DiagramSocketImpl has "localPort"
	jfieldID localport_field;
	if(strstr(name, "DatagramSocket"))
		localport_field = jenv->GetFieldID(clazz, "localPort", "I");
	else
		localport_field = jenv->GetFieldID(clazz, "localport", "I");

	assert(localport_field);
	return jenv->GetIntField(jobj, localport_field);
}


inline void set_socket_localport(JNIEnv *jenv, jclass clazz, jobject jobj, int localport)
{
	const char *name = GetJClassName(clazz);
	//in gnu_classpath: SocketImpl has field "localport", but DiagramSocketImpl has "localPort"
	jfieldID localport_field;
	if(strstr(name, "DatagramSocket"))
		localport_field = jenv->GetFieldID(clazz, "localPort", "I");
	else
		localport_field = jenv->GetFieldID(clazz, "localport", "I");
	
	assert(localport_field);
	jenv->SetIntField(jobj, localport_field, localport);
}


inline int get_socket_port(JNIEnv *jenv, jclass clazz, jobject jobj)
{
	jfieldID port_field = jenv->GetFieldID(clazz, "port", "I");
	assert(port_field);
	return jenv->GetIntField(jobj, port_field);
}


inline void set_socket_port(JNIEnv *jenv, jclass clazz, jobject jobj, int port)
{
	jfieldID port_field = jenv->GetFieldID(clazz, "port", "I");
	assert(port_field);
	jenv->SetIntField(jobj, port_field, port);
}




// Returns a 32 bit Internet address when passed in an InetAddress object.

inline uint32 get_net_address(JNIEnv *jenv, jobject address)
{
 	jclass inet_class = get_InetAddress_class(jenv);
	assert(inet_class);

	// Now invoke the getAddress() method to get the IP.
	jmethodID meth_id = jenv->GetMethodID(inet_class, "getAddress", "()[B");
	assert(meth_id);
	jarray ret_arr = jenv->CallObjectMethod(address, meth_id);
	assert(ret_arr);

	// Retrieve the bytes comprising the address and convert to network byte order before returning.	
	jsize len = jenv->GetArrayLength(ret_arr);
	assert(len == 4);
	jboolean is_copy;
	jbyte *jbytes = jenv->GetByteArrayElements(ret_arr, &is_copy);
	assert(jbytes);

	uint32 ret_addr =	(((unsigned char)jbytes[0]) << 24) + (((unsigned char)jbytes[1]) << 16) +
						(((unsigned char)jbytes[2]) << 8) +	((unsigned char)jbytes[3]);

	jenv->ReleaseByteArrayElements(ret_arr, jbytes, JNI_ABORT);
	return htonl(ret_addr);
}











