// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/stack.cpp,v 1.2 2001/08/13 09:52:49 xhshi Exp $
//



#include "defines.h"
#include <iostream.h>
#include "stack.h"
#include "Mem_Manager.h"
#include "ir.h"
#include "expression.h"

//
// return ith word on the mimic stack
//
Inst *Stack::ith_word(int ith) {
    unsigned i;
	for (i = 0;ith > 0;i++) {
        assert(_top > i);
		if (_elems[_top - i - 1]->is_64bit())
			ith -= 2;
		else 
			ith--;
	}
	assert(ith == 0);
	return _elems[_top - i];
}

//
// pop n words from the mimic stack
//
void Stack::pop(int n) {
	while (n > 0) {
		_top--;
		if (_elems[_top]->is_64bit())
			n -= 2;
		else
			n--;
	}
	assert(n == 0);
}

//
// return the depth of the mimic stack
//
unsigned Stack::depth() {
    
    unsigned d = 0;
    int i;
	for (i = _top - 1; i >= 0; i--) {
        d += (_elems[i]->is_64bit())? 2 : 1;
	}
	return d;
}
