// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/optimizer.h,v 1.2 2001/08/13 09:52:49 xhshi Exp $
//


#ifndef __OPTIMIZER_H__
#define __OPTIMIZER_H__

class Flow_Graph;
class Expressions;

class Compilation_Env {
public:
	Compile_Handle const comp_handle;
    Class_Handle   const c_handle;
    Method_Handle  const m_handle;
    const Byte *   bc_addr;
    const size_t   bc_size;
    const unsigned max_locals;
    const unsigned max_stack;

    Compilation_Env(Compile_Handle cmp_h, Class_Handle c_h, Method_Handle m_h,
        const Byte *b_addr, size_t b_size, unsigned locals, unsigned stack) :
        comp_handle(cmp_h), c_handle(c_h), m_handle(m_h), bc_addr(b_addr),
        bc_size(b_size), max_locals(locals), max_stack(stack) {}
};

class Optimizer {
    Compilation_Env& comp_env;
    Flow_Graph *const fg;
    Expressions& exprs;
    bool gc_requires_write_barriers;
public:
    Optimizer(Compilation_Env& env, Flow_Graph *f, Expressions& e, bool wb) : 
      comp_env(env), fg(f), exprs(e), gc_requires_write_barriers(wb) {}
    void global_optimization();
};

void fold_branch(Flow_Graph *fg);

#endif // __OPTIMIZER_H__
