// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/opt_bound_elimination.h,v 1.2 2001/08/13 09:52:49 xhshi Exp $
//

#ifndef __OPT_BOUND_ELIMINATION_H__
#define __OPT_BOUND_ELIMINATION_H__

class Expressions;
class Back_Edge;
class Compilation_Env;

#define INVALID_ENTRY (unsigned short) -1

class Bound_Set {
    Exp **_elems;
    unsigned short _size;

    int insert_elem(Exp *i) {
        if (_size == _capacity) return INVALID_ENTRY; // overflow
        _elems[_size] = i;
        return _size++;
    }
public:
    unsigned short const _capacity;

    Bound_Set(Mem_Manager& mm, unsigned max_sz) : _capacity((unsigned short)max_sz){
      _size = 0;
      assert(max_sz > 0 && max_sz < (1<<sizeof(unsigned short)*4) -1);
      _elems = (Exp**) mm.alloc(max_sz*sizeof(Exp*));
    }
    int lookup_elem(Exp *e) {
        int j;
        for (j = 0; j < _size; j++)
            if (_elems[j] == e) return j;
        return INVALID_ENTRY;  // not found
    }
    int add_elem(Exp *e) {
        int entry;
        if ((entry = lookup_elem(e)) == INVALID_ENTRY)
            return insert_elem(e);
        return entry;
    }
    unsigned size()  {return _size;}
    Exp *elem(unsigned i) {assert(i < _size); return _elems[i];}
    void set_elem_killed_by_call(Bit_Vector *bv);
    void set_elem_killed_by(Exp *e,Bit_Vector *bv);
};

typedef unsigned short Count_Int;

class Loop_Bound_Closure : public Closure {
public:
    Bit_Vector *iv_bb; // for holding all i++ appeared in a loop
    Bit_Vector *iinc_and_bb; // for holding all i=(i+imm1)&imm2 appeared in a loop
    Bit_Vector *inner_loop; // set if a loop is the innermost loop
    Bit_Vector *one_exit;
    Bit_Vector *target_within_loop;
    Bit_Vector **iv_reached;  // record pre-increment/decrement cases
    Bit_Vector **iv, **bnd, **elem_kill, **iinc_and;
    unsigned short  *exit_cond; // holding exit expressions
    Count_Int       *n_inst;    // num of IR insts in loops
    Bound_Set& bound_set;
    unsigned short max_bbs;
    unsigned short max_lps;
    unsigned short max_elem;
    bool bad_loop_structure;

    Loop_Bound_Closure(Mem_Manager& mm, Bound_Set& b_set, Cfg_Node **loop_headers, 
                    int max_elem, int max_bbs, int max_lps);
    void create_space_for_iinc_and(Mem_Manager& mm,Cfg_Node **loop_headers);
    void print_bvs_of_loop(Cfg_Node *loop_header);
};

class Bound_Elim {
    Expressions& exprs;
    Mem_Manager& mem;        // mem_manager for temporary uses
    Compilation_Env& comp_env;
    Loop_Bound_Closure& lbc;
    Flow_Graph *const fg;

    void compute_invariant_bounds(Cfg_Node *node, Cfg_Node *header, 
                                  Cfg_Node *tail, Exp *iv, bool iv_reached);
    void init_bound_set(Cfg_Node *node, Cfg_Node *header, 
                        Cfg_Node *tail, Cfg_Node **loops);
    bool is_bound_elimination_cand(Cfg_Node *header, int& inc);
    bool clone_loop(Cfg_Node *tail, Back_Edge& be);
    void build_IR_for_cloned_loop(Cfg_Node *node,         Cfg_Node *old_hd, 
                                  Cfg_Node *new_hd,       Inst_Exp *bnd, 
                                  Inst_Exp *exit,         Exp *exit_var,
                                  unsigned next_bnd_cand, bool loop_invariant,
                                  bool iinc_and_bnd,      int  inc);
    Cfg_Node *build_IR_for_test_node(Cfg_Node *node,      Cfg_Node *old_hd, 
                                     Cfg_Node *new_hd,    Inst_Exp *bnd, 
                                     Inst_Exp *exit,      unsigned next_bnd_cand, 
                                     bool loop_invariant, bool iinc_and_bnd, int  inc);
    void remove_bound_inst(Cfg_Node *node, Bit_Vector* bnd, Bound_Set& bound_set);
    void add_compensation_code(Cfg_Node *header, Cfg_Node *node);
    void maintain_precise_exception(Cfg_Node *node, Cfg_Node *old_hd, Cfg_Node *new_hd);
    bool more_than_once(unsigned entry,Bit_Vector *tmp,Bit_Vector *bv);
public:
    bool gc_requires_write_barriers;
    Bound_Elim(Mem_Manager& mm, Expressions& e, Flow_Graph *const f, 
        Compilation_Env& ce, Loop_Bound_Closure& l, bool wb)
        : mem(mm), exprs(e), comp_env(ce), lbc(l), fg(f), gc_requires_write_barriers(wb) {}
    void start(Back_Edge& be, Cfg_Node **tails);
};

void bound_checking_elimination(Compilation_Env& comp_env,
                                Flow_Graph *fg, 
                                Expressions& exprs,
                                bool gc_requires_write_barriers);

#endif // __OPT_BOUND_ELIMINATION_H__