// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/base/enum_trampoline.cpp,v 1.4 2001/12/07 00:16:00 xli18 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>

#include "object_layout.h"
#include "environment.h"
#include "orp_types.h"
#include "jit_runtime_support.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "orp_threads.h"
#include "orp_utils.h"
#include "jit_intf.h"
#include "jit_intf_cpp.h"

 
#include "gc_for_orp.h"
 

 
#include "compile.h"
#include "orp_stats.h"

#include "root_set_enum.h"
#include "enum_trampoline.h"

#include "../x86/x86.h"
#include "nogc.h"

#ifdef ORP_VTUNE_SUPPORT
//M:
#include "orp_vtune.h"
#endif


#ifdef ORP_POSIX
#include "platform2.h"
#endif

static void __cdecl
orp_stop_thread_for_gc_ret(uint32 edx_arg,
                           uint32 eax_arg,
                           uint32 edi_arg,
                           uint32 esi_arg,
                           uint32 ebx_arg,
                           uint32 ebp_arg,
                           uint32 esp_arg
                           )
{
    assert(p_the_safepoint_control_thread);
    assert(p_the_safepoint_control_thread != p_TLS_orpthread);
    assert(p_TLS_orpthread->thread_is_java_suspended == false);
    
	uint32 *p_trampoline_eip = &esp_arg;
    *p_trampoline_eip = p_TLS_orpthread->hijack_old_eip;

    assert(p_TLS_orpthread->hijack_p_eip);
    uint32 *p_ret_eip = p_TLS_orpthread->hijack_p_eip;

    // NOTE: do not call restore_thread_state() as this will
    // trash the stack by writing hijack_old_eip at stack location
    // hijack_i_eip (which became invalid when we "returned" to orp_stop_thread_for_gc()
    // Instead just set hijack_p_eip to zero.
    p_TLS_orpthread->hijack_p_eip = 0;

    uint32 esp_var = (uint32)p_ret_eip;

    // Now we can setup for enumeration.

    memset(&p_TLS_orpthread->gc_frame_context, 0, sizeof(p_TLS_orpthread->gc_frame_context) );
    p_TLS_orpthread->gc_frame_context.p_eip = p_trampoline_eip;

    // NOTE: esp_var contains the same stack address as when
    // the callee setup outgoing args plus 4 bytes for the return eip 
    // address.  Subtract four to get the context.esp that the JIT expects
    p_TLS_orpthread->gc_frame_context.esp   = esp_var + 4;

    p_TLS_orpthread->gc_frame_context.p_ebp = &ebp_arg;
    p_TLS_orpthread->gc_frame_context.p_ebx = &ebx_arg;
    p_TLS_orpthread->gc_frame_context.p_esi = &esi_arg;
    p_TLS_orpthread->gc_frame_context.p_edi = &edi_arg;
    p_TLS_orpthread->gc_frame_context.ljf   = (uint32)get_orp_last_java_frame();

    // MAKE SURE TO CAUSE EAX ENUMERATION IF THE RETURN VALUE IS A REFERENCE!

    uint32 ret_eip = *p_trampoline_eip;
    JIT_Specific_Info *jit_info = methods.find_deadlock_free((void *)ret_eip);
    assert(jit_info);
    JIT *jit = jit_info->get_jit();

    if(jit->call_returns_a_reference(jit_info->get_method(), &p_TLS_orpthread->gc_frame_context)) {
        p_TLS_orpthread->gc_frame_context.p_eax = &eax_arg;
    }
    else
        p_TLS_orpthread->gc_frame_context.p_eax = 0;

    // We don't have to reinitialize the context, because 
    // jit->call_returns_a_reference doesn't modify its content.

    assert(p_TLS_orpthread->which_trap == x_nothing);
	p_TLS_orpthread->which_trap = x_orp_stop_thread_for_gc_ret;
    assert(p_TLS_orpthread->gc_status != gc_at_safepoint);
    p_TLS_orpthread->gc_status = gc_at_safepoint;

    assert (p_TLS_orpthread->gc_enabled_status == disabled);

    //
    // This following lines atomically moves from disabled -> enabled_hijack and then
    // waits for a signal from the gc thread.
    // The gc thread (atomically with respect to this thread) will move this 
    // thread from enabled_hijack -> disabled and signal this thread to resume.
    // This thread will always enter in a disabled state and leave in a disabled state.
    // this thread                             gc_thread
    // assert state==disabled
    // sets state = enabled_for_hijack
    //                                         notices (state==enable_for_hijack)
    //                                         enumerate etc ...
    //                                         state = disable
    //                                         signals to continue
    // (gc_thread actions appear atomic)
    // continues 
    // assert state==disable
    //
    // Notice that later GCs will force this routine to continue since it will have
    // a disabled state. If "this thread" did the disable after it continued then 
    // the next gc could see this thread in an enabled_for_hijack state but 
    // gated by the current gc to continue whenever it felt like.
    //

    ORP_thread *p_thr = p_TLS_orpthread;
    assert (p_thr->gc_enabled_status == disabled);
    gc_enable_disable_state endis = bogus;
    endis = gc_if_disabled_then_enabled_hijack(&p_thr->gc_enabled_status);    
    assert (endis == disabled);
    // Meanwhile the GC thread takes some action before the following finishes
    DWORD wstat = WaitForSingleObject(p_thr->gc_resume_event_handle, INFINITE);
    assert (wstat != WAIT_FAILED);
    
    assert (p_TLS_orpthread->gc_enabled_status == disabled);

    // The following can be hit if a resume happens after the WaitForSingleObject about
    // at the end of a GC and and another GC begins before we reach this statement. 
    // 
    //    assert(p_the_safepoint_control_thread == 0);  

    assert(p_TLS_orpthread->which_trap == x_nothing);  // toss if hit -- diagnostic use only

} //orp_stop_thread_for_gc_ret


//
// The address of this function replaces the original eip after it has been
// hijacked.
//


void * getaddress__orp_stop_thread_for_gc_ret_trampoline()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = push(ss, &esp_opnd);
    ss = push(ss, &ebp_opnd);
    ss = push(ss, &ebx_opnd);
    ss = push(ss, &esi_opnd);
    ss = push(ss, &edi_opnd);
    ss = push(ss, &eax_opnd);
    ss = push(ss, &edx_opnd);

    ss = call(ss, (char *)orp_stop_thread_for_gc_ret);

    ss = pop(ss, &edx_opnd);
    ss = pop(ss, &eax_opnd);
    ss = pop(ss, &edi_opnd);
    ss = pop(ss, &esi_opnd);
    ss = pop(ss, &ebx_opnd);
    ss = pop(ss, &ebp_opnd);

    ss = ret(ss);
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__orp_stop_thread_for_gc_ret_trampoline",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_stop_thread_for_gc_ret_trampoline
