/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include <vcl\registry.hpp>

#include "Edit.h"
#include "D3DRender.h"
#include "SoftRender.h"
#include "DSoundEngine.h"
#include "music.h"
#include "TexView.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TEditWnd *EditWnd;
extern HINSTANCE hInst;

#define TRANSLATE_X(x) (((x)-centX)*unitSize+cx)
#define TRANSLATE_Y(x) ((-((x)-centY)*unitSize)+cy)

struct
{
    char mapFile[16];
    char mapName[32];
    char mapMusic[32];
} DefaultMapInfo[]=
    {{"e1l1.map","Hollywood Holocaust","STALKER.MID"},
     {"e1l2.map","Red Light District","DETHTOLL.MID"},
     {"e1l3.map","Death Row","STREETS.MID"},
     {"e1l4.map","Toxic Dump","WATRWLD1.MID"},
     {"e1l5.map","The Abyss","SNAKE1.MID"},
     {"e1l6.map","Launch Facility","THECALL.MID"},
     {"e1l7.map","Faces of Death","AHGEEZ.MID"},
     {"e1l8.map","User Map","DETHTOLL.MID"},
     {"e1l9.map","Multiplayer 3","STREETS.MID"},
     {"e1l10.map","Multiplayer 4","WATRWLD1.MID"},
     {"e1l11.map","Multiplayer 5","SNAKE1.MID"},
     {"e2l1.map","Spaceport","FUTURMIL.MID"},
     {"e2l2.map","Incubator","STORM.MID"},
     {"e2l3.map","Warp Factor","GUTWRNCH.MID"},
     {"e2l4.map","Fusion Station","ROBOCREP.MID"},
     {"e2l5.map","Occupied Territory","STALAG.MID"},
     {"e2l6.map","Tiberius Station","PIZZED.MID"},
     {"e2l7.map","Lunar Reactor","ALIENZ.MID"},
     {"e2l8.map","Dark Side","XPLASMA.MID"},
     {"e2l9.map","Overlord","ALFREDH.MID"},
     {"e2l10.map","Spin Cycle","GLOOMY.MID"},
     {"e2l11.map","Lunatic Fringe","INTENTS.MID"},
     {"e3l1.map","Raw Meat","INHIDING.MID"},
     {"e3l2.map","Bank Roll","FATCMDR.MID"},
     {"e3l3.map","Flood Zone","NAMES.MID"},
     {"e3l4.map","L.A. Rumble","SUBWAY.MID"},
     {"e3l5.map","Movie Set","INVADER.MID"},
     {"e3l6.map","Rabid Transit","GOTHAM.MID"},
     {"e3l7.map","Fahrenheit","233C.MID"},
     {"e3l8.map","Hotel Hell","LORDOFLA.MID"},
     {"e3l9.map","Stadium","URBAN.MID"},
     {"e3l10.map","Tier Drops","SPOOK.MID"},
     {"e3l11.map","Freeway","WHOMP.MID"},
     {"e4l1.map","It's Impossible","MISSIMP.MID"},
     {"e4l2.map","Duke-Burger","PREPD.MID"},
     {"e4l3.map","Shop-N-Bag","BAKEDGDS.MID"},
     {"e4l4.map","Babe Land","CF.MID"},
     {"e4l5.map","Pigsty","LEMCHILL.MID"},
     {"e4l6.map","Going Postal","POB.MID"},
     {"e4l7.map","XXX-Stacy","WAREHAUS.MID"},
     {"e4l8.map","Critical Mass","LAYERS.MID"},
     {"e4l9.map","Derelict","FLOGHORN.MID"},
     {"e4l10.map","The Queen","DEPART.MID"},
     {"e4l11.map","Area 51","RESTRICT.MID"},
     {"","",""}};

Render *render;
//---------------------------------------------------------------------------
__fastcall TEditWnd::TEditWnd(TComponent* Owner)
    : TForm(Owner)
{
    curMap=NULL; b1=0; b2=0; render=NULL;
    gridSize=16; zoom=1; centerX=0; centerY=0;
    move3D=false; move2D=false;
    // Create the bitmap for double buffering the 2D view
    bmp2D=new Graphics::TBitmap;
    bmp2D->Width=View2DPanel->ClientWidth;
    bmp2D->Height=View2DPanel->ClientHeight;
    bmp2D->PixelFormat=pf24bit;
    // Open the duke3d.grp file
    strcpy(directory,"c:\\duke3d");
    TRegistry *reg=new TRegistry;
    reg->RootKey=HKEY_LOCAL_MACHINE;
    reg->OpenKey("\\Software\\ACZ\\Duke Nukem 3D",true);
    if (reg->ValueExists("directory"))
        strcpy(directory,reg->ReadString("directory").c_str());
    group=new GroupFile;
    if (!group->Open("duke3d.grp"))
    {
        char file[256];
        if (directory[strlen(directory)-1]=='\\')
            sprintf(file,"%sduke3d.grp",directory);
        else
            sprintf(file,"%s\\duke3d.grp",directory);
        if (!group->Open(file))
        {
            if (!group->Open("c:\\duke3d\\duke3d.grp"))
            {
                TOpenDialog *dlog=new TOpenDialog(this);
                dlog->FileName="duke3d.grp";
                dlog->Filter="Duke Nukem 3D Data File|DUKE3D.GRP";
                dlog->FilterIndex=1;
                dlog->Options.Clear();
                dlog->Options=dlog->Options<<ofPathMustExist<<ofFileMustExist;
                dlog->Title="Locate DUKE3D.GRP in your Duke Nukem 3D directory";
                if (!dlog->Execute())
                {
                    delete reg;
                    exit(1);
                }
                char drive[8],folder[256];
                fnsplit(dlog->FileName.c_str(),drive,folder,NULL,NULL);
                delete dlog;
                sprintf(directory,"%s%s",drive,folder);
                char file[256];
                if (directory[strlen(directory)-1]=='\\')
                    sprintf(file,"%sduke3d.grp",directory);
                else
                    sprintf(file,"%s\\duke3d.grp",directory);
                if (!group->Open(file))
                {
                    MessageBox(NULL,"Could not find DUKE3D.GRP","Error",MB_OK);
                    delete reg;
                    exit(1);
                }
                reg->WriteString("directory",directory);
            }
        }
    }
    delete reg;
    // Put the names of all the maps in the group file
    // into the open submenu
    for (int i=0;DefaultMapInfo[i].mapFile[0];i++)
    {
        if (group->FileSize(DefaultMapInfo[i].mapFile)>0)
        {
            TMenuItem *menuItem=new TMenuItem(OpenfromDuke3Dgrp1);
            char str[64];
            strcpy(str,DefaultMapInfo[i].mapFile);
            str[strlen(str)-4]=0;
            strupr(str);
            strcat(str,"\t");
            strcat(str,DefaultMapInfo[i].mapName);
            menuItem->Caption=str;
            menuItem->OnClick=OpenfromDuke3Dgrp1Click;
            menuItem->Tag=(int)DefaultMapInfo[i].mapFile;
            OpenfromDuke3Dgrp1->Add(menuItem);
        }
    }
    // Get the list of all file names in all
    // open group files
    char *files=new char[group->NumFiles()*13];
    group->FileList(files);
    // Loop though the names and add all sound files
    for (int i=0;i<group->NumFiles();i++)
    {
        if (!strncmp(&files[i*13+strlen(&files[i*13])-4],".voc",4))
            SoundList->Items->Add(&files[i*13]);
    }
    // Loop though the names and add all music files
    for (int i=0;i<group->NumFiles();i++)
    {
        if (!strncmp(&files[i*13+strlen(&files[i*13])-4],".mid",4))
            MusicList->Items->Add(&files[i*13]);
    }
    delete[] files;
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::FormCreate(TObject *Sender)
{
    LightList->ItemIndex=0;
    // Initialize renderer
    render=new D3DRender(hInst,View3DPanel->Handle,View3DPanel->ClientWidth,View3DPanel->ClientHeight,0);
    // Initialize the sound engine and set up the
    // sound channels
    sound=new DirectSoundEngine(Handle);
    // Load the palette and cache the texture information
    art.LoadPalette(0,group,"PALETTE.DAT");
    art.ImportAll(group);
    // Enlarge the texture grid control to allow all
    // textures to be viewed
    TextureGroup->ItemIndex=0;
    TextureGrid->RowCount=(art.GetMaxTextureID()+15)/16;
    // Set up application event handlers
    Application->OnIdle=OnIdle;
    Application->OnMinimize=FormMinimize;
    Application->OnRestore=FormRestore;
    // Set up a new message handler so that we can
    // receive the MCI message which is generated when
    // the currently playing music reaches the end
    WindowProc=MCIWindowProc;
    minimized=false;
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::OnIdle(TObject *,bool& done)
{
    int axis[4],button[8];
    if (b1||b2)
    {
        POINT p;
        GetCursorPos(&p);
        axis[0]=p.x-256;
        axis[1]=p.y-256;
        SetCursorPos(256,256);
        distanceMovedX+=abs(axis[0]);
        distanceMovedY+=abs(axis[1]);
    }
    else
    {
        axis[0]=0;
        axis[1]=0;
    }
    if (move3D)
    {
        if ((b1)&&(!b2))
        {
            // If only the left button is held, movement
            // is forward/back/turn
            render->AddYRotate(-axis[0]/400.0);
            render->GoForward(-axis[1]/8.0);
        }
        else if (b1&&b2)
        {
            // If both buttons are held, movement is
            // up/down/side to side
            render->GoSide(axis[0]/8.0);
            render->AddYPos(-axis[1]/8.0);
        }
        else
        {
            // Otherwise, the mouse is used to look around
            render->AddXRotate(-axis[1]/400.0);
            if (render->GetXRotate()>(M_PI/2.0))
                render->SetXRotate(M_PI/2.0);
            if (render->GetXRotate()<(-M_PI/2.0))
                render->SetXRotate(-M_PI/2.0);
            render->AddYRotate(-axis[0]/400.0);
        }
    }
    else if (move2D)
    {
        if (b1&&b2)
        {
            if (axis[1])
            {
                zoom+=axis[1]/400.0;
                if (zoom<-3)
                    zoom=-3;
                if (zoom>5)
                    zoom=5;
                PaintBox2DPaint(NULL);
            }
        }
        else if (b1)
        {
            if (axis[0]||axis[1])
            {
                centerX+=axis[0]*pow(2,zoom)/2.0;
                centerY-=axis[1]*pow(2,zoom)/2.0;
                if (centerX<-4096) centerX=-4096;
                if (centerX>4096) centerX=4096;
                if (centerY<-4096) centerY=-4096;
                if (centerY>4096) centerY=4096;
                PaintBox2DPaint(NULL);
            }
        }
    }
    if (curMap)
    {
        // If we are still in the sector curSect, there is no
        // need to recalculate the current sector
        if (!curMap->IsInSector(curSect,render->GetXPos()*64,-render->GetZPos()*64,-render->GetYPos()*1024))
        {
            // Find which sector we are now in
            curSect=-1;
            for (int i=0;i<curMap->numSectors;i++)
            {
                if (curMap->IsInSector(i,render->GetXPos()*64,-render->GetZPos()*64,-render->GetYPos()*1024))
                {
                    curSect=i;
                    break;
                }
            }
        }
    }
    // Render the map
    render->BeginRender();
    if (curMap)
        render->RenderMap(curMap,curSect);
    render->StartText();
    // Not rendering at least some text can cause
    // weird input delay problems on some video
    // cards in D3D mode.  There should be a better fix.
    render->RenderText(0,0," ",0xffffffff);
    render->EndText();
    render->EndRender();
    // Set the "done" flag to false so that OnIdle is
    // still called when there are no messages
    done=false;
}

void __fastcall TEditWnd::FormMinimize(TObject *)
{
    minimized=true;
}

void __fastcall TEditWnd::FormRestore(TObject *)
{
    minimized=false;
}

void __fastcall TEditWnd::View3DPanelMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if (Button==mbLeft)
    {
        if ((!b1)&&(!b2))
            GetCursorPos(&oldMousePos);
        b1=1;
        Screen->Cursor=crNone;
        SetCursorPos(256,256);
        SetCapture(View3DPanel->Handle);
        move3D=true;
        distanceMovedX=0;
        distanceMovedY=0;
    }
    else if (Button==mbRight)
    {
        if ((!b1)&&(!b2))
            GetCursorPos(&oldMousePos);
        b2=1;
        Screen->Cursor=crNone;
        SetCursorPos(256,256);
        SetCapture(View3DPanel->Handle);
        move3D=true;
        distanceMovedX=0;
        distanceMovedY=0;
    }
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::View3DPanelMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if (Button==mbLeft)
    {
        b1=0;
        if ((!b1)&&(!b2))
        {
            if (oldMousePos.x==-1) return;
            SetCursorPos(oldMousePos.x,oldMousePos.y);
            oldMousePos=View3DPanel->ScreenToClient(oldMousePos);
            if ((distanceMovedX<=6)&&(distanceMovedY<=6))
            {
                int type,index,sect;
                if (curMap->FindPolyAtPoint(oldMousePos.x,oldMousePos.y,type,index,sect))
                {
                    if (type==POLYTYPE_WALL)
                    {
                        PolyListElem* ptr=curMap->sectorPolys[sect].first;
                        while (ptr)
                        {
                            if (ptr->poly.id==index)
                            {
                                for (int i=0;i<ptr->poly.nVert;i++)
                                    ptr->poly.v[i].color=RGBA_MAKE(255,0,0,255);
                            }
                            ptr=ptr->next;
                        }
                    }
                    else if (type==POLYTYPE_CEILING)
                    {
                        PolyListElem* ptr=curMap->sectorPolys[index].first;
                        while (ptr)
                        {
                            if (ptr->poly.id==WALLINDEX_CEILING)
                            {
                                for (int i=0;i<ptr->poly.nVert;i++)
                                    ptr->poly.v[i].color=RGBA_MAKE(255,0,0,255);
                            }
                            ptr=ptr->next;
                        }
                    }
                    else if (type==POLYTYPE_FLOOR)
                    {
                        PolyListElem* ptr=curMap->sectorPolys[index].first;
                        while (ptr)
                        {
                            if (ptr->poly.id==WALLINDEX_FLOOR)
                            {
                                for (int i=0;i<ptr->poly.nVert;i++)
                                    ptr->poly.v[i].color=RGBA_MAKE(255,0,0,255);
                            }
                            ptr=ptr->next;
                        }
                    }
                }
            }
            oldMousePos.x=-1;
            Screen->Cursor=crDefault;
            ReleaseCapture();
            move3D=false;
        }
        else
            SetCapture(View3DPanel->Handle);
    }
    else if (Button==mbRight)
    {
        b2=0;
        if ((!b1)&&(!b2))
        {
            if (oldMousePos.x==-1) return;
            SetCursorPos(oldMousePos.x,oldMousePos.y);
            oldMousePos.x=-1;
            Screen->Cursor=crDefault;
            ReleaseCapture();
            move3D=false;
        }
        else
            SetCapture(View3DPanel->Handle);
    }
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::View3DPanelResize(TObject *Sender)
{
    if (render)
    {
        render->ChangeResolution(View3DPanel->ClientWidth,View3DPanel->ClientHeight,0);
        art.ReloadTextures();
    }
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::PaintBox1Paint(TObject *Sender)
{
    // Render the map
    render->BeginRender();
    if (curMap)
        render->RenderMap(curMap,curSect);
    render->StartText();
    // Not rendering at least some text can cause
    // weird input delay problems on some video
    // cards in D3D mode.  There should be a better fix.
    render->RenderText(0,0," ",0xffffffff);
    render->EndText();
    render->EndRender();
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::StandardLighting1Click(TObject *Sender)
{
    StandardLighting1->Checked=!StandardLighting1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::Open1Click(TObject *Sender)
{
    if (OpenDialog1->Execute())
    {
        Map *newMap;
        try
        {
            newMap=new Map(group,OpenDialog1->FileName.c_str(),&art);
        }
        catch (char *str)
        {
            MessageBox(Handle,str,"Error",MB_OK);
            return;
        }
        if (curMap) delete curMap;
        curMap=newMap;
        curMap->HideSpecialSprites(false);
        // Set the current position to the starting location
        // from the map
        render->SetXPos(curMap->startX/64.0);
        render->SetYPos(-curMap->startZ/1024.0);
        render->SetZPos(-curMap->startY/64.0);
        curSect=curMap->startSect;
        centerX=curMap->startX/16.0;
        centerY=-curMap->startY/16.0;
        PaintBox2DPaint(NULL);
    }
}
//---------------------------------------------------------------------------

void DrawGrid(TCanvas *canvas,int cx,int cy,float centX,float centY,float unitSize,float gridSize,float minGridSize)
{
    if ((gridSize*unitSize)<4) return;
    if (gridSize!=minGridSize)
        DrawGrid(canvas,cx,cy,centX,centY,unitSize,gridSize/2,minGridSize);
    int left=(int)((centX-((float)cx/unitSize))/gridSize)-1;
    int right=(int)((centX+((float)cx/unitSize))/gridSize)+1;
    int top=(int)((centY-((float)cy/unitSize))/gridSize)-1;
    int bottom=(int)((centY+((float)cy/unitSize))/gridSize)+1;
    if ((left*gridSize)<-4096) left=-4096/gridSize;
    if ((right*gridSize)>4096) right=4096/gridSize;
    if ((top*gridSize)<-4096) top=-4096/gridSize;
    if ((bottom*gridSize)>4096) bottom=4096/gridSize;
    int level=(gridSize==4096)?2:((gridSize/8>=minGridSize)?1:0);
    int color=168+24/(gridSize*unitSize-3)-32*level;
    canvas->Pen->Color=(TColor)((color<<16)+(color<<8)+color);
    for (int x=left;x<=right;x++)
    {
        canvas->MoveTo(TRANSLATE_X(x*gridSize),
            TRANSLATE_Y(top*gridSize));
        canvas->LineTo(TRANSLATE_X(x*gridSize),
            TRANSLATE_Y(bottom*gridSize));
    }
    for (int y=top;y<=bottom;y++)
    {
        canvas->MoveTo(TRANSLATE_X(left*gridSize),
            TRANSLATE_Y(y*gridSize));
        canvas->LineTo(TRANSLATE_X(right*gridSize),
            TRANSLATE_Y(y*gridSize));
    }
}

void __fastcall TEditWnd::PaintBox2DPaint(TObject *Sender)
{
    bmp2D->Canvas->Brush->Color=clSilver;
    bmp2D->Canvas->Pen->Color=clSilver;
    bmp2D->Canvas->Rectangle(0,0,bmp2D->Width,bmp2D->Height);
    float unitSize=1/pow(2,zoom);
    unitSize*=PaintBox2D->Width/400.0;
    int cx=PaintBox2D->Width>>1;
    int cy=PaintBox2D->Height>>1;
    float centX=centerX;
    float centY=centerY;
    DrawGrid(bmp2D->Canvas,cx,cy,centX,centY,unitSize,65536,gridSize);
    if (curMap)
    {
        bmp2D->Canvas->Pen->Color=clNavy;
        for (int i=0;i<curMap->numSectors;i++)
        {
            int count=curMap->sector[i].wallnum;
            int *wallUsed=new int[count];
            memset(wallUsed,0,4*count);
            int startWall=curMap->sector[i].wallptr;
            int wallIndex=startWall;
            bmp2D->Canvas->MoveTo(TRANSLATE_X(curMap->wall[wallIndex].x/16.0),
                TRANSLATE_Y(-curMap->wall[wallIndex].y/16.0));
            while (count)
            {
                // Mark the wall as used
                wallUsed[wallIndex-curMap->sector[i].wallptr]=1;
                count--;
                wallIndex=curMap->wall[wallIndex].point2;
                bmp2D->Canvas->LineTo(TRANSLATE_X(curMap->wall[wallIndex].x/16.0),
                    TRANSLATE_Y(-curMap->wall[wallIndex].y/16.0));
                if (wallIndex==startWall)
                {
                    if (count>1)
                    {
                        // If there are still vertices left, find
                        // one of them and get ready to add that
                        // polygon
                        for (wallIndex=curMap->sector[i].wallptr;;wallIndex++)
                        {
                            if (!wallUsed[wallIndex-curMap->sector[i].wallptr])
                                break;
                        }
                        startWall=wallIndex;
                        bmp2D->Canvas->MoveTo(TRANSLATE_X(curMap->wall[wallIndex].x/16.0),
                            TRANSLATE_Y(-curMap->wall[wallIndex].y/16.0));
                    }
                }
            }
        }
    }
    PaintBox2D->Canvas->Draw(0,0,bmp2D);
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::PaintBox2DMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if (Button==mbLeft)
    {
        if ((!b1)&&(!b2))
            GetCursorPos(&oldMousePos);
        b1=1;
        Screen->Cursor=crNone;
        SetCursorPos(256,256);
        SetCapture(View2DPanel->Handle);
        move2D=true;
    }
    else if (Button==mbRight)
    {
        if ((!b1)&&(!b2))
            GetCursorPos(&oldMousePos);
        b2=1;
        Screen->Cursor=crNone;
        SetCursorPos(256,256);
        SetCapture(View2DPanel->Handle);
        move2D=true;
    }
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::PaintBox2DMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if (Button==mbLeft)
    {
        b1=0;
        if ((!b1)&&(!b2))
        {
            if (oldMousePos.x==-1) return;
            SetCursorPos(oldMousePos.x,oldMousePos.y);
            oldMousePos.x=-1;
            Screen->Cursor=crDefault;
            ReleaseCapture();
            move2D=false;
        }
        else
            SetCapture(View2DPanel->Handle);
    }
    else if (Button==mbRight)
    {
        b2=0;
        if ((!b1)&&(!b2))
        {
            if (oldMousePos.x==-1) return;
            SetCursorPos(oldMousePos.x,oldMousePos.y);
            oldMousePos.x=-1;
            Screen->Cursor=crDefault;
            ReleaseCapture();
            move2D=false;
        }
        else
            SetCapture(View2DPanel->Handle);
    }
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::View2DPanelResize(TObject *Sender)
{
    bmp2D->Width=View2DPanel->ClientWidth;
    bmp2D->Height=View2DPanel->ClientHeight;
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::Exit1Click(TObject *Sender)
{
    Close();    
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::OpenfromDuke3Dgrp1Click(TObject *Sender)
{
    Map *newMap;
    try
    {
        newMap=new Map(group,(char *)(((TMenuItem*)Sender)->Tag),&art);
    }
    catch (char *str)
    {
        MessageBox(Handle,str,"Error",MB_OK);
        return;
    }
    if (curMap) delete curMap;
    curMap=newMap;
    curMap->HideSpecialSprites(false);
    // Set the current position to the starting location
    // from the map
    render->SetXPos(curMap->startX/64.0);
    render->SetYPos(-curMap->startZ/1024.0);
    render->SetZPos(-curMap->startY/64.0);
    curSect=curMap->startSect;
    centerX=curMap->startX/16.0;
    centerY=-curMap->startY/16.0;
    PaintBox2DPaint(NULL);
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::LightColorMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if (ColorDialog1->Execute())
        LightColor->Brush->Color=ColorDialog1->Color;
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::SoundListDblClick(TObject *Sender)
{
    if (SoundList->ItemIndex==-1) return;
    Sound *file=LoadSound(group,SoundList->Items->Strings[SoundList->ItemIndex].c_str());
    sound->PlaySound(file,0,0,0);
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::MusicListDblClick(TObject *Sender)
{
    if (MusicList->ItemIndex==-1) return;
    RequestMusic(group,MusicList->Items->Strings[MusicList->ItemIndex].c_str());
    ProcessMusicRequest(Handle);
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::MusicStopClick(TObject *Sender)
{
    StopMusic();
}
//---------------------------------------------------------------------------
void __fastcall TEditWnd::MCIWindowProc(TMessage& msg)
{
    if ((msg.Msg==MM_MCINOTIFY)&&(IsMusicPlaying()))
    {
        // Restart music if the music reached the end
    	char strRet[256];
	    mciSendString("status duke mode",strRet,256,Handle);
        if (!strcmp(strRet,"stopped"))
    	    mciSendString("play duke from 0 notify",strRet,256,Handle);
    }
    else
        WndProc(msg);
}

void __fastcall TEditWnd::TextureGridDrawCell(TObject *Sender, int ACol,
      int ARow, TRect &Rect, TGridDrawState State)
{
    int i=ARow*16+ACol;
    char numStr[16];
    sprintf(numStr,"%d",i);
    TextureGrid->Canvas->TextOut(Rect.Left+33-
        TextureGrid->Canvas->TextWidth(numStr)/2,
        Rect.Top+66,numStr);
    art.RequestTextureData(i);
    if (!art.data) return;
    Graphics::TBitmap *tex=new Graphics::TBitmap;
    Graphics::TBitmap *bmp=new Graphics::TBitmap;
    tex->Width=art.origSizeX[i];
    tex->Height=art.origSizeY[i];
    tex->PixelFormat=pf24bit;
    for (int y=0;y<art.origSizeY[i];y++)
    {
        char *buf=(char*)tex->ScanLine[y];
        for (int x=0;x<art.origSizeX[i];x++)
        {
            *(buf++)=art.palB[0][art.data[i][y*art.sizeX[i]+x]];
            *(buf++)=art.palG[0][art.data[i][y*art.sizeX[i]+x]];
            *(buf++)=art.palR[0][art.data[i][y*art.sizeX[i]+x]];
        }
    }
    bmp->Width=64;
    bmp->Height=64;
    bmp->PixelFormat=pf24bit;
    bmp->Canvas->Brush->Color=TextureGrid->Canvas->Brush->Color;
    bmp->Canvas->Pen->Color=TextureGrid->Canvas->Brush->Color;
    bmp->Canvas->Rectangle(0,0,64,64);
    if ((tex->Width>64)||(tex->Height>64))
    {
        int w=tex->Width;
        int h=tex->Height;
        if (w>64)
        {
            h=h*64/w;
            w=64;
        }
        if (h>64)
        {
            w=w*64/h;
            h=64;
        }
        TRect r;
        r.Left=(64-w)/2; r.Right=r.Left+w;
        r.Top=(64-h)/2; r.Bottom=r.Top+h;
        bmp->Canvas->StretchDraw(r,tex);
    }
    else
    {
        bmp->Canvas->Draw((64-tex->Width)/2,
            (64-tex->Height)/2,tex);
    }
    TextureGrid->Canvas->Draw(Rect.Left+1,Rect.Top+1,bmp);
    delete tex;
    delete bmp;
}
//---------------------------------------------------------------------------

void __fastcall TEditWnd::TextureGridDblClick(TObject *Sender)
{
    int i=TextureGrid->Row*16+TextureGrid->Col;
    if ((art.sizeX[i]==0)||(art.sizeY[i]==0))
        return;
    TTextureViewWnd *wnd=new TTextureViewWnd(this,&art,i);
    wnd->Show();
}
//---------------------------------------------------------------------------

