/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#pragma hdrstop
#define INITGUID
#include "DirectInput.h"
#include "console.h"

/*static GUID joystickGUID;

BOOL CALLBACK JoystickEnum(const DIDEVICEINSTANCE *lpddi,LPVOID)
{
	joystickGUID=lpddi->guidInstance;
	return DIENUM_STOP;
}*/

CDirectInput::CDirectInput(HINSTANCE inst,HWND wnd)
{
	hWnd=wnd; hInst=inst; init=0;
    lpDI=NULL; lpMouse=NULL; lpStick=NULL;
    HMODULE dinput=LoadLibrary("dinput.dll");
    if (dinput==NULL)
    {
		cprintf("DirectInput is not installed\n");
        return;
    }
    HRESULT WINAPI (*dic)(HINSTANCE,DWORD,LPVOID*,LPUNKNOWN)=
        (HRESULT WINAPI (*)(HINSTANCE,DWORD,LPVOID*,LPUNKNOWN))
        GetProcAddress(dinput,"DirectInputCreateA");
    if (dic==NULL)
    {
		cprintf("DirectInput is not installed\n");
        return;
    }
	// Create DirectInput object
	if (dic(hInst,0x300,(void**)&lpDI,NULL)!=DI_OK)
    {
		cprintf("Could not initialize DirectInput\n");
        lpDI=NULL;
        return;
    }
	// Create and set up the mouse device
	if (lpDI->CreateDevice(GUID_SysMouse,(LPDIRECTINPUTDEVICE*)&lpMouse,
		NULL)!=DI_OK)
    {
		cprintf("Could not access mouse from DirectInput\n");
        lpDI->Release(); lpDI=NULL;
        return;
    }
	if (lpMouse->SetDataFormat(&c_dfDIMouse)!=DI_OK)
    {
		cprintf("Could not set mouse data format in DirectInput\n");
        lpMouse->Release(); lpMouse=NULL;
        lpDI->Release(); lpDI=NULL;
        return;
    }
	if (lpMouse->SetCooperativeLevel(hWnd,DISCL_EXCLUSIVE|
		DISCL_FOREGROUND)!=DI_OK)
    {
		cprintf("Failed to set cooperative level for mouse in DirectInput\n");
        lpMouse->Release(); lpMouse=NULL;
        lpDI->Release(); lpDI=NULL;
        return;
    }
	DIPROPDWORD dpd;
	dpd.diph.dwSize=sizeof(DIPROPDWORD);
	dpd.diph.dwHeaderSize=sizeof(DIPROPHEADER);
	dpd.diph.dwObj=0;
	dpd.diph.dwHow=DIPH_DEVICE;
	dpd.dwData=64;
	if (lpMouse->SetProperty(DIPROP_BUFFERSIZE,&dpd.diph)!=DI_OK)
    {
		cprintf("Could not set buffer size for mouse in DirectInput\n");
        return;
    }
	lpStick=NULL;
/*	// Create and set up the joystick device
	lpDI->EnumDevices(DIDEVTYPE_JOYSTICK,JoystickEnum,NULL,
		DIEDFL_ATTACHEDONLY);
	lpDI->CreateDevice(joystickGUID,(LPDIRECTINPUTDEVICE*)&lpStick,NULL);
	if (lpStick==NULL) return;
	lpStick->SetDataFormat(&c_dfDIJoystick);
	lpStick->SetCooperativeLevel(hWnd,DISCL_EXCLUSIVE|
		DISCL_FOREGROUND);
	DIPROPRANGE dipr;
	dipr.diph.dwSize=sizeof(dipr);
	dipr.diph.dwHeaderSize=sizeof(dipr.diph);
	dipr.diph.dwObj=DIJOFS_X;
	dipr.diph.dwHow=DIPH_BYOFFSET;
	dipr.lMin=-1000;
	dipr.lMax=1000;
	lpStick->SetProperty(DIPROP_RANGE,&dipr.diph);
	dipr.diph.dwObj=DIJOFS_Y;
	lpStick->SetProperty(DIPROP_RANGE,&dipr.diph);
	dipr.diph.dwObj=DIJOFS_Z;
	lpStick->SetProperty(DIPROP_RANGE,&dipr.diph);
	dipr.diph.dwObj=DIJOFS_RZ;
	lpStick->SetProperty(DIPROP_RANGE,&dipr.diph);
	dpd.diph.dwSize=sizeof(DIPROPDWORD);
	dpd.diph.dwHeaderSize=sizeof(DIPROPHEADER);
	dpd.diph.dwObj=DIJOFS_X;
	dpd.diph.dwHow=DIPH_BYOFFSET;	
	dpd.dwData=500;
	lpStick->SetProperty(DIPROP_DEADZONE,&dpd.diph);
	dpd.diph.dwObj=DIJOFS_Y;
	lpStick->SetProperty(DIPROP_DEADZONE,&dpd.diph);
	dpd.diph.dwObj=DIJOFS_RZ;
	lpStick->SetProperty(DIPROP_DEADZONE,&dpd.diph);
	dpd.diph.dwObj=DIJOFS_Z;
	lpStick->SetProperty(DIPROP_DEADZONE,&dpd.diph);*/
    init=1;
    cprintf("DirectInput initialized\n");
}

CDirectInput::~CDirectInput()
{
	if (lpMouse) { lpMouse->Release(); lpMouse=NULL; }
	if (lpStick) { lpStick->Release(); lpStick=NULL; }
	if (lpDI) { lpDI->Release(); lpDI=NULL; }
}

int CDirectInput::Initialized()
{
    return init;
}

void CDirectInput::Acquire(int device)
{
    if (!init) return;
	if ((device==DINPUT_MOUSE)||(device==DINPUT_ALL))
		lpMouse->Acquire();
//	if ((device==DINPUT_JOYSTICK)||(device==DINPUT_ALL))
//		lpStick->Acquire();
}

void CDirectInput::Unacquire(int device)
{
    if (!init) return;
	if ((device==DINPUT_MOUSE)||(device==DINPUT_ALL))
		lpMouse->Unacquire();
//	if ((device==DINPUT_JOYSTICK)||(device==DINPUT_ALL))
//		lpStick->Unacquire();
}

void CDirectInput::GetInput(int device,int axis[4],int button[8])
{
	int i;
	for (i=0;i<4;i++) axis[i]=0;
	for (i=0;i<8;i++) button[i]=0;
    if (!init) return;
	if ((device==DINPUT_MOUSE)||(device==DINPUT_ALL))
	{
		DIDEVICEOBJECTDATA data[64];
		DWORD count=64;

		// Get the events from the device
		int err=lpMouse->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),
			data,&count,0);
		if (err==DIERR_INPUTLOST)
		{
			lpMouse->Acquire();
			return;
		}
		else if (err!=DI_OK)
			return;

		// Process the events
		for (DWORD i=0;i<count;i++)
		{
			switch(data[i].dwOfs)
			{
				case DIMOFS_X: axis[0]+=(int)data[i].dwData; break;
				case DIMOFS_Y: axis[1]+=(int)data[i].dwData; break;
				case DIMOFS_BUTTON0:
					if (data[i].dwData&0x80) button[0+MB_DOWN]++;
					else button[0+MB_UP]++;
					break;
				case DIMOFS_BUTTON1:
					if (data[i].dwData&0x80) button[1+MB_DOWN]++;
					else button[1+MB_UP]++;
					break;
			}
		}
//		axis[0]*=64; axis[1]*=64;
	}
/*	if ((device==DINPUT_JOYSTICK)||(device==DINPUT_ALL))
	{
		DIJOYSTATE js;
		if (!lpStick) return;
		lpStick->Poll();
		if (lpStick->GetDeviceState(sizeof(DIJOYSTATE),&js)!=DI_OK)
		{
			lpStick->Acquire();
			return;
		}
		axis[0]+=js.lX; axis[1]+=js.lY; axis[2]+=js.lZ; axis[3]+=js.lRz;
		button[0]=js.rgbButtons[0]?1:0;
		button[1]=js.rgbButtons[1]?1:0;
		button[2]=js.rgbButtons[2]?1:0;
		button[3]=js.rgbButtons[3]?1:0;
	}*/
}
