/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#include "CSDL.h"
#include "console.h"

int showCursor=1;
#if 0
extern error;
#endif
//extern int error;
int error;

#define FAIL_INIT(err) \
{ \
    error=1; \
    cprintf("SDL error: %s\n",err); \
	return; \
}

CSDL::CSDL(int sx,int sy,int depth,bool _old):
	scrnX(sx),scrnY(sy),scrnDepth(depth)
{
	Uint8 flags = SDL_SWSURFACE;

	inAWindow = depth?0:1;
	if (inAWindow)
		flags |= SDL_FULLSCREEN;
	MainBuffer = SDL_SetVideoMode (scrnX,scrnY,16,flags);
	if (MainBuffer == NULL)
		FAIL_INIT("Couldn't set requested video mode\n");

	SDL_WM_SetCaption("Duke Nukem 3D Clone", "DUKECLONE");
#if 0
	DDSURFACEDESC2 ddsd;
	DDSCAPS2 caps;
	DDSURFACEDESC ddsd1;
	DDSCAPS caps1;

	inAWindow=depth?0:1;
    hWnd=_hWnd;
    old=_old;
    lpFrontBuffer=lpBackBuffer=NULL; lpDD=NULL;
    lpFrontBuffer3=lpBackBuffer3=NULL; lpDD3=NULL;

    if (ddrawLib==NULL)
        ddrawLib=LoadLibrary("ddraw.dll");
    if (ddrawLib==NULL) FAIL_INIT("DirectDraw not installed");
    if (!old)
    {
        HRESULT WINAPI (*ddc)(GUID FAR*,LPVOID *,REFIID,IUnknown FAR *)=
            (HRESULT WINAPI (*)(GUID FAR*,LPVOID *,REFIID,IUnknown FAR *))
            GetProcAddress(ddrawLib,"DirectDrawCreateEx");
        if (!ddc) FAIL_INIT("DirectX 7 or above needed");
    	if (ddc(NULL,(void**)&lpDD,IID_IDirectDraw7,NULL)!=DD_OK) FAIL_INIT("Could not initialize DirectDraw");
        if (lpDD->SetCooperativeLevel(scrnDepth?hWnd:NULL,scrnDepth?DDSCL_EXCLUSIVE|
            DDSCL_FULLSCREEN:DDSCL_NORMAL)!=DD_OK) FAIL_INIT("Could not set cooperative level");
        if (scrnDepth)
        {
            if (lpDD->SetDisplayMode(scrnX,scrnY,scrnDepth,0,0)!=DD_OK)
                FAIL_INIT("Could not change display mode");
            memset(&ddsd,0,sizeof(ddsd));
            ddsd.dwSize=sizeof(ddsd);
            ddsd.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
            ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                DDSCAPS_COMPLEX|DDSCAPS_3DDEVICE;
            ddsd.dwBackBufferCount=1;
            if (lpDD->CreateSurface(&ddsd,&lpFrontBuffer,NULL)!=DD_OK)
            {
                ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                    DDSCAPS_COMPLEX;
                if (lpDD->CreateSurface(&ddsd,&lpFrontBuffer,NULL)!=DD_OK)
                    FAIL_INIT("Could not obtain front buffer");
            }
            memset(&caps,0,sizeof(caps));
            caps.dwCaps=DDSCAPS_BACKBUFFER;
            if (lpFrontBuffer->GetAttachedSurface(&caps,&lpBackBuffer)!=DD_OK)
                FAIL_INIT("Could not obtain back buffer");
        }
        else
        {
            lpDD->CreateClipper(0,&lpClipper,NULL);
            lpClipper->SetHWnd(0,hWnd);
            memset(&ddsd,0,sizeof(ddsd));
            ddsd.dwSize=sizeof(ddsd);
            ddsd.dwFlags=DDSD_CAPS;
            ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE;
            if (lpDD->CreateSurface(&ddsd,&lpFrontBuffer,NULL)!=DD_OK)
                FAIL_INIT("Could not obtain front buffer");
            lpFrontBuffer->GetSurfaceDesc(&ddsd);
            scrnDepth=ddsd.ddpfPixelFormat.dwRGBBitCount;
            lpFrontBuffer->SetClipper(lpClipper);
            ddsd.dwFlags=DDSD_WIDTH|DDSD_HEIGHT|DDSD_CAPS|DDSD_PIXELFORMAT;
            ddsd.dwWidth=scrnX;
            ddsd.dwHeight=scrnY;
            ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_3DDEVICE|
                DDSCAPS_VIDEOMEMORY;
            if (lpDD->CreateSurface(&ddsd,&lpBackBuffer,NULL)!=DD_OK)
            {
                ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
                if (lpDD->CreateSurface(&ddsd,&lpBackBuffer,NULL)!=DD_OK)
                    FAIL_INIT("Could not obtain back buffer");
            }
        }
    }
    else
    {
        HRESULT WINAPI (*ddc)(GUID FAR*,LPVOID *,IUnknown FAR *)=
            (HRESULT WINAPI (*)(GUID FAR*,LPVOID *,IUnknown FAR *))
            GetProcAddress(ddrawLib,"DirectDrawCreate");
        if (!ddc) FAIL_INIT("DirectDraw not installed");
    	if (ddc(NULL,(void**)&lpDD3,NULL)!=DD_OK) FAIL_INIT("Could not initialize DirectDraw");
        if (lpDD3->SetCooperativeLevel(scrnDepth?hWnd:NULL,scrnDepth?DDSCL_EXCLUSIVE|
            DDSCL_FULLSCREEN:DDSCL_NORMAL)!=DD_OK) FAIL_INIT("Could not set cooperative level");
        if (scrnDepth)
        {
            if (lpDD3->SetDisplayMode(scrnX,scrnY,scrnDepth)!=DD_OK)
                FAIL_INIT("Could not change display mode");
            memset(&ddsd1,0,sizeof(ddsd1));
            ddsd1.dwSize=sizeof(ddsd1);
            ddsd1.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
            ddsd1.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                DDSCAPS_COMPLEX|DDSCAPS_3DDEVICE;
            ddsd1.dwBackBufferCount=1;
            if (lpDD3->CreateSurface(&ddsd1,&lpFrontBuffer3,NULL)!=DD_OK)
            {
                ddsd1.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                    DDSCAPS_COMPLEX;
                if (lpDD3->CreateSurface(&ddsd1,&lpFrontBuffer3,NULL)!=DD_OK)
                    FAIL_INIT("Could not obtain front buffer");
            }
            memset(&caps1,0,sizeof(caps));
            caps1.dwCaps=DDSCAPS_BACKBUFFER;
            if (lpFrontBuffer3->GetAttachedSurface(&caps1,&lpBackBuffer3)!=DD_OK)
                FAIL_INIT("Could not obtain back buffer");
        }
        else
        {
            lpDD3->CreateClipper(0,&lpClipper,NULL);
            lpClipper->SetHWnd(0,hWnd);
            memset(&ddsd1,0,sizeof(ddsd1));
            ddsd1.dwSize=sizeof(ddsd1);
            ddsd1.dwFlags=DDSD_CAPS;
            ddsd1.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE;
            if (lpDD3->CreateSurface(&ddsd1,&lpFrontBuffer3,NULL)!=DD_OK)
                FAIL_INIT("Could not obtain front buffer");
            lpFrontBuffer3->GetSurfaceDesc(&ddsd1);
            scrnDepth=ddsd1.ddpfPixelFormat.dwRGBBitCount;
            lpFrontBuffer3->SetClipper(lpClipper);
            ddsd1.dwFlags=DDSD_WIDTH|DDSD_HEIGHT|DDSD_CAPS|DDSD_PIXELFORMAT;
            ddsd1.dwWidth=scrnX;
            ddsd1.dwHeight=scrnY;
            ddsd1.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_3DDEVICE|
                DDSCAPS_VIDEOMEMORY;
            if (lpDD3->CreateSurface(&ddsd1,&lpBackBuffer3,NULL)!=DD_OK)
            {
                ddsd1.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
                if (lpDD3->CreateSurface(&ddsd1,&lpBackBuffer3,NULL)!=DD_OK)
                    FAIL_INIT("Could not obtain back buffer");
            }
        }
    }
	allowFlip=1;
    x1=0; x2=scrnX; y1=0; y2=scrnY;
#endif
}

CSDL::~CSDL()
{
#if 0
    if (lpBackBuffer) { lpBackBuffer->Release(); lpBackBuffer=NULL; }
    if (lpFrontBuffer) { lpFrontBuffer->Release(); lpFrontBuffer=NULL; }
    if (lpBackBuffer3) { lpBackBuffer3->Release(); lpBackBuffer3=NULL; }
    if (lpFrontBuffer3) { lpFrontBuffer3->Release(); lpFrontBuffer3=NULL; }
	if (lpDD)
    {
        lpDD->SetCooperativeLevel(NULL,DDSCL_NORMAL);
        lpDD->Release();
        lpDD=NULL;
    }
	if (lpDD3)
    {
        lpDD3->SetCooperativeLevel(NULL,DDSCL_NORMAL);
        lpDD3->Release();
        lpDD3=NULL;
    }
#endif
}

#if 0
void CSDL::ChangeResolution(HWND _hWnd,int sx,int sy,int depth)
#endif
void CSDL::ChangeResolution(int sx,int sy,int depth)
{
	MainBuffer = SDL_SetVideoMode (sx,sy,16,SDL_GetVideoSurface()->flags);
	if (MainBuffer == NULL) {
		error = 1;
                cprintf("Invalid resolution\n");
	}
#if 0
	DDSURFACEDESC2 ddsd;
	DDSCAPS2 caps;
	DDSURFACEDESC ddsd1;
	DDSCAPS caps1;
    LPDIRECTDRAW dd;

    scrnX=sx; scrnY=sy; scrnDepth=depth; hWnd=_hWnd;
	inAWindow=depth?0:1;
    if (old)
    {
        if (lpBackBuffer3) { lpBackBuffer3->Release(); lpBackBuffer3=NULL; }
        if (lpFrontBuffer3) { lpFrontBuffer3->Release(); lpFrontBuffer3=NULL; }
        if (lpDD3->SetCooperativeLevel(scrnDepth?hWnd:NULL,scrnDepth?DDSCL_EXCLUSIVE|
            DDSCL_FULLSCREEN:DDSCL_NORMAL)!=DD_OK) FAIL_INIT("Could not set cooperative level");
        if (scrnDepth)
        {
            if (lpDD3->SetDisplayMode(scrnX,scrnY,scrnDepth)!=DD_OK)
            {
                cprintf("Invalid resolution\n");
                error=1;
                return;
            }
            memset(&ddsd1,0,sizeof(ddsd1));
            ddsd1.dwSize=sizeof(ddsd1);
            ddsd1.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
            ddsd1.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                DDSCAPS_COMPLEX|DDSCAPS_3DDEVICE;
            ddsd1.dwBackBufferCount=1;
            if (lpDD3->CreateSurface(&ddsd1,&lpFrontBuffer3,NULL)!=DD_OK)
            {
                ddsd1.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                    DDSCAPS_COMPLEX;
                if (lpDD3->CreateSurface(&ddsd1,&lpFrontBuffer3,NULL)!=DD_OK)
                {
                    cprintf("Could not obtain front buffer\n");
                    error=1;
                    return;
                }
            }
            memset(&caps1,0,sizeof(caps1));
            caps1.dwCaps=DDSCAPS_BACKBUFFER;
            if (lpFrontBuffer3->GetAttachedSurface(&caps1,&lpBackBuffer3)!=DD_OK)
            {
                cprintf("Could not obtain back buffer\n");
                error=1;
                return;
            }
        }
        else
        {
            lpDD3->CreateClipper(0,&lpClipper,NULL);
            lpClipper->SetHWnd(0,hWnd);
            memset(&ddsd1,0,sizeof(ddsd1));
            ddsd1.dwSize=sizeof(ddsd1);
            ddsd1.dwFlags=DDSD_CAPS;
            ddsd1.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE;
            if (lpDD3->CreateSurface(&ddsd1,&lpFrontBuffer3,NULL)!=DD_OK)
            {
                cprintf("Could not obtain front buffer\n");
                error=1;
                return;
            }
            lpFrontBuffer3->GetSurfaceDesc(&ddsd1);
            scrnDepth=ddsd1.ddpfPixelFormat.dwRGBBitCount;
            lpFrontBuffer3->SetClipper(lpClipper);
            ddsd1.dwFlags=DDSD_WIDTH|DDSD_HEIGHT|DDSD_CAPS|DDSD_PIXELFORMAT;
            ddsd1.dwWidth=scrnX;
            ddsd1.dwHeight=scrnY;
            ddsd1.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_3DDEVICE|
                DDSCAPS_VIDEOMEMORY;
            if (lpDD3->CreateSurface(&ddsd1,&lpBackBuffer3,NULL)!=DD_OK)
            {
                ddsd1.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
                if (lpDD3->CreateSurface(&ddsd1,&lpBackBuffer3,NULL)!=DD_OK)
                {
                    cprintf("Could not obtain back buffer\n");
                    error=1;
                    return;
                }
            }
        }
    }
    else
    {
        if (lpBackBuffer) { lpBackBuffer->Release(); lpBackBuffer=NULL; }
        if (lpFrontBuffer) { lpFrontBuffer->Release(); lpFrontBuffer=NULL; }
        if (lpDD->SetCooperativeLevel(scrnDepth?hWnd:NULL,scrnDepth?DDSCL_EXCLUSIVE|
            DDSCL_FULLSCREEN:DDSCL_NORMAL)!=DD_OK) FAIL_INIT("Could not set cooperative level");
        if (scrnDepth)
        {
            if (lpDD->SetDisplayMode(scrnX,scrnY,scrnDepth,0,0)!=DD_OK)
            {
                cprintf("Invalid resolution\n");
                error=1;
                return;
            }
            memset(&ddsd,0,sizeof(ddsd));
            ddsd.dwSize=sizeof(ddsd);
            ddsd.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
            ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                DDSCAPS_COMPLEX|DDSCAPS_3DDEVICE;
            ddsd.dwBackBufferCount=1;
            if (lpDD->CreateSurface(&ddsd,&lpFrontBuffer,NULL)!=DD_OK)
            {
                ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                    DDSCAPS_COMPLEX;
                if (lpDD->CreateSurface(&ddsd,&lpFrontBuffer,NULL)!=DD_OK)
                {
                    cprintf("Could not obtain front buffer\n");
                    error=1;
                    return;
                }
            }
            memset(&caps,0,sizeof(caps));
            caps.dwCaps=DDSCAPS_BACKBUFFER;
            if (lpFrontBuffer->GetAttachedSurface(&caps,&lpBackBuffer)!=DD_OK)
            {
                cprintf("Could not obtain back buffer\n");
                error=1;
                return;
            }
        }
        else
        {
            lpDD->CreateClipper(0,&lpClipper,NULL);
            lpClipper->SetHWnd(0,hWnd);
            memset(&ddsd,0,sizeof(ddsd));
            ddsd.dwSize=sizeof(ddsd);
            ddsd.dwFlags=DDSD_CAPS;
            ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE;
            if (lpDD->CreateSurface(&ddsd,&lpFrontBuffer,NULL)!=DD_OK)
            {
                cprintf("Could not obtain front buffer\n");
                error=1;
                return;
            }
            lpFrontBuffer->GetSurfaceDesc(&ddsd);
            scrnDepth=ddsd.ddpfPixelFormat.dwRGBBitCount;
            lpFrontBuffer->SetClipper(lpClipper);
            ddsd.dwFlags=DDSD_WIDTH|DDSD_HEIGHT|DDSD_CAPS|DDSD_PIXELFORMAT;
            ddsd.dwWidth=scrnX;
            ddsd.dwHeight=scrnY;
            ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_3DDEVICE|
                DDSCAPS_VIDEOMEMORY;
            if (lpDD->CreateSurface(&ddsd,&lpBackBuffer,NULL)!=DD_OK)
            {
                ddsd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
                if (lpDD->CreateSurface(&ddsd,&lpBackBuffer,NULL)!=DD_OK)
                {
                    cprintf("Could not obtain back buffer\n");
                    error=1;
                    return;
                }
            }
        }
    }
	allowFlip=1;
    x1=0; x2=scrnX; y1=0; y2=scrnY;
#endif
}

#if 0
IDirectDraw7* CSDL::GetDD()
{
	return lpDD;
}
#endif

#if 0
LPDIRECTDRAW CSDL::GetDD3()
{
	return lpDD3;
}
#endif

void CSDL::Update()
{
	Flip();
}

int CSDL::GetScrnX()
{
	return scrnX;
}

int CSDL::GetScrnY()
{
	return scrnY;
}

int CSDL::GetScrnDepth()
{
	return scrnDepth;
}

#if 0
HWND CSDL::GetWindow()
{
	return hWnd;
}
#endif

// SDL Version - DDOI
int CSDL::GetWindow()
{
	return 1;
}

#if 0
void CSDL::BeginGDI()
{
	showCursor=1;
	SetCursor(LoadCursor(NULL,IDC_ARROW));
    if (old)
        lpDD3->FlipToGDISurface();
    else
        lpDD->FlipToGDISurface();
}
#endif

#if 0
void CSDL::EndGDI()
{
	showCursor=0;
	SetCursor(NULL);
}
#endif

#if 0
IDirectDrawSurface7* CSDL::GetBackBuffer()
{
	return lpBackBuffer;
}
#endif

#if 0
LPDIRECTDRAWSURFACE CSDL::GetBackBuffer3()
{
	return lpBackBuffer3;
}
#endif

void CSDL::Flip()
{
	SDL_UpdateRect(MainBuffer, 0, 0, 0, 0);
#if 0
    if (old)
    {
        if ((inAWindow)||(!allowFlip))
        {
            RECT r,d,w;
            POINT lt;

            GetClientRect(hWnd,&w);
            lt.x=w.left; lt.y=w.top;
            ClientToScreen(hWnd,&lt);
            r.left=x1; r.right=x2; r.top=y1; r.bottom=y2;
            d.left=x1+lt.x; d.right=x2+lt.x;
            d.top=y1+lt.y; d.bottom=y2+lt.y;
            if (lpFrontBuffer3->Blt(&d,lpBackBuffer3,&r,DDBLT_WAIT,NULL)!=DD_OK)
            {
                lpFrontBuffer3->Restore();
                lpBackBuffer3->Restore();
                lpFrontBuffer3->Blt(&d,lpBackBuffer3,&r,DDBLT_WAIT,NULL);
            }
        }
        else
        {
            if (lpFrontBuffer3->Flip(NULL,DDFLIP_WAIT)!=DD_OK)
            {
                lpFrontBuffer3->Restore();
                lpBackBuffer3->Restore();
                lpFrontBuffer3->Flip(NULL,DDFLIP_WAIT);
            }
        }
    }
    else
    {
        if ((inAWindow)||(!allowFlip))
        {
            RECT r,d,w;
            POINT lt;

            GetClientRect(hWnd,&w);
            lt.x=w.left; lt.y=w.top;
            ClientToScreen(hWnd,&lt);
            r.left=x1; r.right=x2; r.top=y1; r.bottom=y2;
            d.left=x1+lt.x; d.right=x2+lt.x;
            d.top=y1+lt.y; d.bottom=y2+lt.y;
            if (lpFrontBuffer->Blt(&d,lpBackBuffer,&r,DDBLT_WAIT,NULL)!=DD_OK)
            {
                lpFrontBuffer->Restore();
                lpBackBuffer->Restore();
                lpFrontBuffer->Blt(&d,lpBackBuffer,&r,DDBLT_WAIT,NULL);
            }
        }
        else
        {
            if (lpFrontBuffer->Flip(NULL,DDFLIP_WAIT)!=DD_OK)
            {
                lpFrontBuffer->Restore();
                lpBackBuffer->Restore();
                lpFrontBuffer->Flip(NULL,DDFLIP_WAIT);
            }
        }
    }
#endif
}

void CSDL::SetViewport(int x,int y,int w,int h)
{
	x1=x; x2=x+w; y1=y; y2=y+h;
}

void CSDL::ResetViewport()
{
    x1=0; x2=scrnX; y1=0; y2=scrnY;
}

