/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __POLY_H__
#define __POLY_H__

#include <string.h>

#define DEFAULT_VERTS 4

#define PT_NONSOLID 0
#define PT_SOLID 1

#define PF_INVISIBLE 1
#define PF_DELETED 2
#define PF_INTREE 4
#define PF_REFLECT 8
#define PF_TWOSIDED 16
#define PF_REVERSE 32
#define PF_NONTEXTURED 64
#define PF_PRIORITY 128
#define PF_ZBIAS 256

#define TLOC_MEMORY 0
#define TLOC_BMP 1
#define TLOC_3DR 2

struct Vertex
{
    float x,y,z;
    unsigned long color;
    float u,v;
    float lu,lv;
};

struct MemoryTexture
{
    int width;
    int height;
    unsigned short *data;
};

#define TEXTYPE_REPEAT 0
#define TEXTYPE_BITMAP 1
#define TEXTYPE_BITMAP_NOBORDER 2

struct Texture
{
    int location;
    char *name;
    char *file;
    char *alphaFile;
    MemoryTexture memTex;
    void *data;
    int pal;
    int type;
};

struct Poly
{
    Vertex *v;
    Texture* texture;
    Texture* lightMap;
    int maxVerts,nVert,minRange,solid;
    int flags,id,sect;
    Poly *origPoly;
    unsigned long *origColor;
    Poly() { v=new Vertex[DEFAULT_VERTS]; origColor=new unsigned long[DEFAULT_VERTS]; texture=NULL; lightMap=NULL; maxVerts=DEFAULT_VERTS; nVert=0; minRange=0; solid=PT_SOLID; flags=0; origPoly=NULL; }
    Poly(Poly &poly) { v=new Vertex[poly.maxVerts]; memcpy(v,poly.v,poly.maxVerts*sizeof(Vertex)); origColor=new unsigned long[poly.maxVerts]; memcpy(origColor,poly.origColor,poly.maxVerts*sizeof(unsigned long)); texture=poly.texture; lightMap=poly.lightMap; maxVerts=poly.maxVerts; nVert=poly.nVert; minRange=poly.minRange; solid=poly.solid; flags=poly.flags; origPoly=poly.origPoly; id=poly.id; sect=poly.sect; }
    ~Poly() { delete[] v; delete[] origPoly; }
    void AddVert(float _x,float _y,float _z,float _u,float _v,float _lu,float _lv,unsigned long _color) { if (nVert==maxVerts) { Vertex *nv=new Vertex[maxVerts+DEFAULT_VERTS]; memcpy(nv,v,maxVerts*sizeof(Vertex)); delete[] v; v=nv; unsigned long *nc=new unsigned long[maxVerts+DEFAULT_VERTS]; memcpy(nc,origColor,maxVerts*sizeof(unsigned long)); delete[] origColor; origColor=nc; maxVerts+=DEFAULT_VERTS; } v[nVert].x=_x; v[nVert].y=_y; v[nVert].z=_z; v[nVert].u=_u; v[nVert].v=_v; v[nVert].lu=_lu; v[nVert].lv=_lv; v[nVert].color=_color; origColor[nVert++]=_color; }
    void AddVert(Vertex &_v) { if (nVert==maxVerts) { Vertex *nv=new Vertex[maxVerts+DEFAULT_VERTS]; memcpy(nv,v,maxVerts*sizeof(Vertex)); delete[] v; v=nv; unsigned long *nc=new unsigned long[maxVerts+DEFAULT_VERTS]; memcpy(nc,origColor,maxVerts*sizeof(unsigned long)); delete[] origColor; origColor=nc; maxVerts+=DEFAULT_VERTS; } v[nVert]=_v; origColor[nVert++]=_v.color; }
    void Clear() { nVert=0; }
    void CalcMinRange() { if (nVert==0) return; int minX=(int)v[0].x,maxX=(int)v[0].x,minY=(int)v[0].y,maxY=(int)v[0].y,minZ=(int)v[0].z,maxZ=(int)v[0].z; for (int i=1;i<nVert;i++) { if (v[i].x<minX) minX=(int)v[i].x; if (v[i].x>maxX) maxX=(int)v[i].x; if (v[i].y<minY) minY=(int)v[i].y; if (v[i].y>maxY) maxY=(int)v[i].y; if (v[i].z<minZ) minZ=(int)v[i].z; if (v[i].z>maxZ) maxZ=(int)v[i].z; } if (((maxX-minX)<(maxY-minY))&&((maxX-minX)<(maxZ-minZ))) minRange=0; if (((maxY-minY)<(maxX-minX))&&((maxY-minY)<(maxZ-minZ))) minRange=1; if (((maxZ-minZ)<(maxX-minX))&&((maxZ-minZ)<(maxY-minY))) minRange=2; }
};

struct PolyListElem
{
    PolyListElem *next;
    Poly poly;
    PolyListElem() { next=NULL; }
};

struct PolyList
{
    PolyListElem *first;
    PolyListElem *last;
    PolyList() { first=NULL; last=NULL; }
};

struct Vector
{
    float x,y,z;
    Vector() {}
    Vector(float _x,float _y,float _z) { x=_x; y=_y; z=_z; }
};

struct Plane
{
    float A,B,C,D;
    Plane() {}
    Plane(float _A,float _B,float _C,float _D) { A=_A; B=_B; C=_C; D=_D; }
    float Evaluate(float x,float y,float z) { return A*x+B*y+C*z+D; }
};

extern Plane PlaneFromPoly(const Poly& poly);
extern Vector PolyNormal(const Poly& poly);
extern int IsBackFace(const Poly& poly,Vector& pos);
extern PolyListElem* AddPolyToList(PolyList& list,Poly& poly);
extern void FreeList(PolyList& list);
extern Vector VectorCrossProduct(const Vector& u, const Vector& v);

#endif
