/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * WSDLQNames.java
 *
 * Created on November 17, 2005, 6:01 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.wlm.model.impl;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

/**
 * 
 * @author rico
 */
public enum WLMQNames {
	TASKS(createWLMQName("tasks")), TASK(createWLMQName("task")), IMPORT(
			createWLMQName("import")), ASSIGNMENT(createWLMQName("assignment")), USER(
			createWLMQName("user")), GROUP(createWLMQName("group")), ROLE(
			createWLMQName("role")), TIMEOUT(createWLMQName("timeout")), ESCALATION(
			createWLMQName("escalation")), DURATION(createWLMQName("duration")), DEADLINE(
			createWLMQName("deadline")), NOTIFICATION(
			createWLMQName("notification")), ACTION(createWLMQName("action")), RECIPIENT(
			createWLMQName("recipient")), ADDRESS(createWLMQName("address"));

	public static final String WLM_NS_URI = "http://jbi.com.sun/wfse";

	public static final String WLM_PREFIX = "wlm";

	public static QName createWLMQName(String localName) {
		return new QName(WLM_NS_URI, localName, WLM_PREFIX);
	}

	WLMQNames(QName name) {
		qName = name;
	}

	QName getQName() {
		return qName;
	}

	private static Set<QName> qnames = null;

	public static Set<QName> getQNames() {
		if (qnames == null) {
			qnames = new HashSet<QName>();
			for (WLMQNames wq : values()) {
				qnames.add(wq.getQName());
			}
		}
		return qnames;
	}

	private final QName qName;
}
