/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.aspect.project.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AspectMapReader {
    private static final String PARTNERLINK_ATTR = "partnerLink";
    private static final String SERVICE_NAME_ATTR = "serviceName";
    private static final String PORTTYPE_ATTR = "portType";
    private static final String ROLE_NAME_ATTR = "roleName";
    private static final String EXCHANGETYPE_ATTR = "exchangeType";
    private static final String PORT_NAME_ATTR = "portName";
    private static final String ASPECT_TAG = "aspect";
    
    protected AspectMapReader() {
    }
    
    /**
     * Parses Cache Aspect service unit configuration file.
     *
     * @param aspectmapfile The service unit configuration file.
     * @return list of transformation mappings.
     * @throws org.xml.sax.SAXException if a parsing error occurs.
     * @throws java.io.IOException if an error occurs reading configuration file.
     * @throws javax.xml.parsers.ParserConfigurationException if a parsing error occurs.
     */
    public static List parse(File aspectmapfile)
    throws org.xml.sax.SAXException,
            java.io.IOException,
            javax.xml.parsers.ParserConfigurationException {
        // parse entries into list
        List retList = new ArrayList();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(aspectmapfile);
        Element elem = doc.getDocumentElement();
        NodeList portmaps = elem.getElementsByTagName(ASPECT_TAG);
        for (int i = 0; i < portmaps.getLength(); i++) {
            Element mappingElem = (Element) portmaps.item(i);
            String type = mappingElem.getAttribute(EXCHANGETYPE_ATTR);
            
            // assume only one input per aspect tag.
            Element inputElem = (Element)mappingElem.getElementsByTagName(
                    AspectMapEntry.INPUT_MESSAGE_TYPE).item(0);
            QName partnerLink = null;
            QName portType = null;
            String roleName = null;
            if (inputElem != null) {                
                partnerLink = getQName(inputElem.getAttribute(PARTNERLINK_ATTR));
                portType = getQName(inputElem.getAttribute(PORTTYPE_ATTR));
                roleName = inputElem.getAttribute(ROLE_NAME_ATTR);                
            }
            retList.add(AspectMapEntry.newProvidesEndpointEntry(partnerLink, 
                    portType, roleName));
            
            // now add all outputs elements.
            partnerLink = null;
            portType = null;
            roleName = null;            
            NodeList outputs = mappingElem.getElementsByTagName(AspectMapEntry.OUTPUT_MESSAGE_TYPE);
            for(int j = 0; j < outputs.getLength(); j++) {
                Element output = (Element)outputs.item(j);
                if(output != null) {
                    if(output.getAttribute(PARTNERLINK_ATTR) == null ||
                            output.getAttribute(ROLE_NAME_ATTR) == null ||
                            output.getAttribute(PARTNERLINK_ATTR).equals("") ||
                            output.getAttribute(ROLE_NAME_ATTR).equals("")) {
                            partnerLink = getQName(output.getAttribute(SERVICE_NAME_ATTR));
                            roleName = output.getAttribute(PORT_NAME_ATTR);
                    } else {
                            partnerLink = getQName(output.getAttribute(PARTNERLINK_ATTR));
                            roleName = output.getAttribute(ROLE_NAME_ATTR);                        
                    }
                    portType = getQName(output.getAttribute(PORTTYPE_ATTR));
                    retList.add(AspectMapEntry.newConsumesEndpointEntry(partnerLink, 
                            portType, roleName));
                }
            }
        }
        return retList;
    }
    
    private static QName getQName(String qname) {
        return QName.valueOf(qname);
    }
}
