/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.aspect.editor.property.propBeans;

import java.util.HashMap;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.netbeans.modules.aspect.editor.jaxbutils.AspectConstants;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;

/**
 *
 *
 * @author $Author: bharanim $
 * @version $Revision: 1.1 $
 */

public class autoReconnect {
    
    private AdviceType adviceType;
    private HashMap propModel;
    
    public autoReconnect(AdviceType ad){
        this.adviceType = ad;
        propModel = AspectMapBuilder.getAspectMapBuilder().getAdviceProperties(ad);
    }
    
    public String getRate(){
        return (String)propModel.get(AspectConstants.RETRY_PROP_RATE);
    }
    
    public void setRate(String rate){
        AspectMapBuilder.getAspectMapBuilder().setAdviceProperties(this.adviceType , AspectConstants.RETRY_PROP_RATE, rate);
    }
    
    public String getTimeout(){
        return (String)propModel.get(AspectConstants.RETRY_PROP_TIMEOUT);
    }
    
    public void setTimeout(String timeout){
        AspectMapBuilder.getAspectMapBuilder().setAdviceProperties(this.adviceType, AspectConstants.RETRY_PROP_TIMEOUT, timeout);
    }
    
}
