/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.evaluators.database;

import java.util.HashMap;
import java.util.Map;

import org.netbeans.modules.sql.framework.model.SQLObject;

import com.sun.sql.framework.exception.BaseException;

/**
 * @author Ritesh Adval
 * @version $Revision: 1.2 $
 */
public abstract class AbstractEvaluatorFactory {

    public AbstractDB db;

    private Map objectToEvaluatorClassMap;

    private Map evaluatorMap = new HashMap();

    private StatementContext emptyContext = new StatementContext();

    public AbstractEvaluatorFactory(AbstractDB database) {
        this.db = database;
        objectToEvaluatorClassMap = initializeObjectToEvaluatorMap();
    }

    public String evaluate(SQLObject obj, StatementContext context) throws BaseException {
        String objectClass = obj.getClass().getName();
        Integer objType = new Integer(obj.getObjectType());

        Evaluator evaluator = (Evaluator) evaluatorMap.get(objType);

        if (evaluator == null) {
            String className = (String) objectToEvaluatorClassMap.get(objType);
            if (className != null) {
                try {
                    Class cls = Class.forName(className);
                    evaluator = (Evaluator) cls.newInstance();
                    evaluator.setEvaluatorFactory(this);
                    evaluatorMap.put(objType, evaluator);
                } catch (ClassNotFoundException ex1) {
                    throw new BaseException("Cannot create an instance of evaluator for object of class " + objectClass, ex1);
                } catch (InstantiationException ex2) {
                    throw new BaseException("Cannot create an instance of evaluator for object of class " + objectClass, ex2);
                } catch (IllegalAccessException ex3) {
                    throw new BaseException("Cannot create an instance of evaluator for object of class " + objectClass, ex3);
                }
            }
        }

        if (evaluator == null) {
            throw new BaseException("Cannot create an instance of evaluator for object of class " + objectClass);
        }

        if (context == null) {
            context = emptyContext;
        }

        return evaluator.evaluate(obj, context);
    }

    public AbstractDB getDB() {
        return db;
    }

    public abstract Map initializeObjectToEvaluatorMap();

}
