/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import java.util.logging.Level;

import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.AssignChild;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromChild;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.xpath.view.visitor.MapperTreeUtility;

import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeLinkCreatorVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.CanvasNode;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StandardRootNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;
import org.netbeans.modules.bpel.xpath.view.VariableExpressionCommand;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.netbeans.modules.bpel.xpath.view.visitor.FindMapperTreeNodeVisitor;
import org.netbeans.modules.bpel.xpath.view.visitor.FindMapperTreeNodeWithoutQuery;
import org.netbeans.modules.bpel.xpath.view.visitor.NodeCreatorVisitor;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathException;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.netbeans.modules.xml.xpath.XPathVariableReference;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public class AssignRenderer extends AbstractRenderer {
    
    public AssignRenderer(MapperView mapper) {
        super(mapper);
    }
    
    public void draw(Object element) {
        if (!(element instanceof Assign)) {
            return;
        }
        
        Assign assign = (Assign) element;
        
        AssignChild[] children = assign.getAssignChildren();
        if (children != null) {
            for (int i = 0; i < children.length; i++) {
                AssignChild child = children[i];
                if (child instanceof Copy) {
                    drawCopy((Copy) child);
                }
            }
        }
        
        layout();
    }
    
    private void drawCopy(Copy copy) {
        try {
            renderCopy(copy);
        } catch(Exception ex) {
            LOGGER.log(Level.SEVERE, NbBundle.getMessage(AssignRenderer.class,
                    "STR_FAIL_TO_RENDER_X", // NOI18N
                    copy), ex);
        }
    }
    
    /**
     * Describe <code>drawMaperNodeForCopy</code> method here.
     *
     * @param copy - an <code>Copy</code> value
     * @param pathContext - path context
     * @exception Exception if an error occurs
     */
    private void renderCopy(Copy copy) throws Exception {
        
        if (copy == null) {
            throw new Exception(
                    NbBundle.getMessage(AssignRenderer.class,
                        "STR_COPY_INSTANCE_OF_ASSIGN_NOT_WELL_FORMED"));    // NOI18N
        }
        
        From f = copy.getFrom();
        To t = copy.getTo();
        
        if (f == null || t == null) {
            // Fix for issue 106496: strange throw replaced 
            // with return from method
            return;
            // throw new Exception(NbBundle.getMessage(AssignRenderer.class,
            //        "STR_FROM_OR_TO_INSTANCE_OF_ASSIGN_NOT_WELL_FORMED"));  // NOI18N
        }
        
        IMapperNode sourceNode = renderFrom(f);
        IMapperTreeNode destNode = renderTo(t);
        if (sourceNode != null && destNode != null) {
            Node sNode = (Node) sourceNode.getNodeObject();
            TreeNode tNode = (TreeNode) destNode.getPath().getLastPathComponent();
            if (sNode != null && tNode != null) {
                tNode.setMapperNode(destNode);
                if (sNode instanceof CanvasNode) {
                    ((CanvasNode) sNode).addOutput(tNode);
                }
            }
        }
        if (sourceNode instanceof IMethoidNode) {
            IMethoidNode methoidNode = (IMethoidNode) sourceNode;
            IFieldNode fieldNode = (IFieldNode) methoidNode.getOutputFieldNodes().get(0);
            addLink(fieldNode, destNode, copy);
        } else {
            addLink(sourceNode, destNode, copy);
        }
    }
    
    private Literal getLiteral(From from) {
      FromChild child = from.getFromChild();

      if ( !(child instanceof Literal)) {
        return null;
      }
      return (Literal) child;
    }

    private IMapperNode renderFrom(From f) {
        XPathModel xpImpl = AbstractXPathModelHelper.getInstance().newXPathModel();
        
        IMapperNode mNode = null;
        String expression = null;
        
        XPathExpression xpExpr = null;
        
        if (getContent(f) != null && getContent(f).length() > 0
                && getLiteral(f) == null) {
            expression = getContent(f);
            
            try {
                xpExpr = xpImpl.parseExpression(expression);
                
                NodeCreatorVisitor nVisitor = new NodeCreatorVisitor(
                        getMapper(),
                        getBpelMapper().getPredicatesManager(),
                        f);
                xpExpr.accept(nVisitor);
                
                Node rootNode = nVisitor.getRootNode();
                if (rootNode != null) {
                    mNode = rootNode.getMapperNode();
                    BpelEntity bEntity = (BpelEntity) f;
                    NodeLinkCreatorVisitor nlCreator = new NodeLinkCreatorVisitor(
                            getBpelMapper(),
                            getMapper());
                    rootNode.accept(nlCreator);
                }
            } catch (XPathException e) {
                // We expect to have some parsing errors as the user is typing.
                // Any invalid expression may be entered by the user.
                LOGGER.log(Level.FINEST, e.getMessage(), e);
            }
            
        } else if (f.getVariable() != null) {
            IMapperTreeView srcTreeView = getMapper().getMapperViewManager().getSourceView();
            
            //TODO: we directly get variable/part so no need to convert string
            //representation then finding var/part object again from node
            BpelReference<VariableDeclaration> varRef = f.getVariable();
            WSDLReference<Part> partRef = f.getPart();
            return findMapperTreeNode(srcTreeView, varRef, partRef);
            
        } else if (getLiteral(f) != null) {
            //String lit = getLiteral(f).getContent();
            String lit = getContent(getLiteral(f));
            if (lit != null && !lit.equals("")) {
                expression = lit;
            }
            //TODO: deal with <from> <literal> <literal> </from> here
            try {
                xpExpr = xpImpl.parseExpression(expression);
                
                NodeCreatorVisitor nVisitor = new NodeCreatorVisitor(
                        getMapper(),
                        getBpelMapper().getPredicatesManager(),
                        f);
                xpExpr.accept(nVisitor);
                
                Node rootNode = nVisitor.getRootNode();
                if (rootNode != null) {
                    mNode = rootNode.getMapperNode();
                    BpelEntity bEntity = (BpelEntity) f;
                    NodeLinkCreatorVisitor nlCreator = new NodeLinkCreatorVisitor(
                            getBpelMapper(),
                            getMapper());
                    rootNode.accept(nlCreator);
                }
            } catch (XPathException e) {
                // We expect to have some parsing errors as the user is typing.
                // Any invalid expression may be entered by the user.
                LOGGER.log(Level.FINEST, e.getMessage(), e);
            }            
        }
        
        return mNode;
    }
    
    private IMapperTreeNode renderTo(To to) {
        String containerName = null;
        String partName = null;
        String toQuery = null;
        IMapperTreeView destTreeView = getMapper().getMapperViewManager().getDestView();
        StandardRootNode variablesRootNode = (StandardRootNode) destTreeView.getTree().getModel().getRoot();
        
        if (to.getContent() != null && to.getContent().length() > 0) {
            XPathExpression expr = null;
            try {
                VariableExpressionCommand cmd = new VariableExpressionCommand(to.getContent());
                cmd.execute();
                expr = cmd.getXPathExpression();
                containerName = cmd.getContainerName();
                partName = cmd.getPartName();
                toQuery = cmd.getSubQuery();
            } catch (XPathException ex) {
                LOGGER.log(Level.SEVERE, NbBundle.getMessage(AssignRenderer.class,
                        "STR_EXCEPTION_GETTING_VARIABLES"), ex);    // NOI18N
                
                return null;
            }
            
            VariablesNode variablesNode = variablesRootNode.getVariablesNode();
            VariableNode variableNode = null;
            if (containerName == null && expr instanceof XPathVariableReference) {
                XPathVariableReference variableReference = (XPathVariableReference) expr;
                if (variablesNode != null) {
                    variableNode = variablesNode.getVariableNode(variableReference.getVariableName().toString());
                }
            } else {
                if (variablesNode != null) {
                    variableNode = variablesNode.getVariableNode(containerName);
                }
            }
            if (variableNode != null) {
                PartNode partNode = variableNode.getPartNode(partName);
                FindMapperTreeNodeVisitor fmtVisitor =
                        new FindMapperTreeNodeVisitor(
                            destTreeView,
                            getBpelMapper().getPredicatesManager(),
                            variableNode,
                            partNode,
                            to);
                expr.accept(fmtVisitor);
                return fmtVisitor.getMapperTreeNode();
            }
            
            return null;
            
        } else {
            //TODO: we directly get variable/part so no need to convert string
            //representation then finding var/part object again from node
            BpelReference<VariableDeclaration> varRef = to.getVariable();
            WSDLReference<Part> partRef = to.getPart();
            return findMapperTreeNode(destTreeView, varRef, partRef);
        }
    }
    
    private IMapperTreeNode findMapperTreeNode(
            IMapperTreeView treeView,
            BpelReference<VariableDeclaration> varRef,
            WSDLReference<Part> partRef) {
        
        String variableName = null;
        String partName = null;
        
        if (varRef != null) {
            VariableDeclaration vd = varRef.get();
            if(vd != null) {
                variableName = vd.getVariableName();
            }
        }
        
        if (partRef != null) {
            Part part = partRef.get();
            if(part != null) {
                partName = part.getName();
            }
        }
        
        //since Query on to now represents $variableName.partName/<subquery> form
        //this case is already handled by above if condition
        //toQuery = removeIterationInsertion(t.getQuery());
        if (variableName != null && partName != null) {
            VariableNode variableNode = MapperTreeUtility.findVariable(variableName, treeView.getTree().getModel());
            if (variableNode != null) {
                PartNode partNode = variableNode.getPartNode(partName);
                return FindMapperTreeNodeWithoutQuery.findPartMapperTreeNode(partNode, variableNode, treeView);
            }
        } else if (variableName != null) {
            VariableNode variableNode = MapperTreeUtility.findVariable(variableName, treeView.getTree().getModel());
//            VariableDeclaration variable = variableNode.getVariable();
            return FindMapperTreeNodeWithoutQuery.findVariableMapperTreeNode(variableNode, treeView);
        }
        
        return null;
    }
    
    private String getContent(From from) {
        String content = null;
        if (from != null) {
            Literal literal = getLiteral(from);
            if (literal != null) {
                // has literal so return text from literal                        
                return getContent(literal);            
            } else {
                return from.getContent();
            }       
        }
        return content;
    }
    
    private String getContent(Literal literal) {           
        String content = null;
        if (literal != null) {
            content = applyQuotes(literal.getContent());
        }
        return content;        
    }    
    
    private String applyQuotes(String expression) {
        String result = expression;
        if (expression != null) {            
            if ((!expression.startsWith("'")) && (!expression.endsWith("'"))) {
                StringBuffer buf = new StringBuffer();
                // make it a literal
                buf.append("'");
                buf.append(expression);
                buf.append("'");
                result = buf.toString();
            } else {
                result = expression;
            }
        }
        return result;
    }
    
    private String removeQuotes(String expression) {
        String result = expression;
        if (expression != null) {            
            if ((expression.startsWith("'")) && (expression.endsWith("'"))
                    && (expression.length() > 1)) {
                java.lang.StringBuffer buf = new java.lang.StringBuffer(expression);
                buf.deleteCharAt(0);
                buf.deleteCharAt(buf.length() - 1);
                result = buf.toString();
            }
        }
        return result;
    }       
}
