/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.api.support;

import java.util.Iterator;

import javax.xml.namespace.NamespaceContext;

/**
 * This interface is extension for standart J2SE NamespaceContext interface. It
 * adds some function to existing for work with namespace.
 *
 * @author ads
 */
public interface ExNamespaceContext extends NamespaceContext {

    /**
     * @return All prefixes that exists in current context.
     */
    Iterator<String> getPrefixes();

    /**
     * Adds new namespace to the context. If namesapce already exists then
     * nothing will happen. One of its prefix will be return. If namespace
     * doesn't exist then it will be added with generated automatically prefix
     * and this prefix will be return. This namespace could be added at any
     * scope that contains current element. This is up to implementation to
     * determine place where namespace will be added.
     * 
     * @param uri
     *            Uri of namespace.
     * @return Prefix for added namespace.
     * @throws InvalidNamespaceException
     *             Will be thrown if uri is not acceptable for namespace.
     */
    String addNamespace( String uri ) throws InvalidNamespaceException;

    /**
     * Adds new namespace to the context. Prefix passed as argument will be used
     * for namespace. If such prefix already exist with other uri then
     * InvalidNamespaceException will be thrown. If namespace declaration with
     * specified prefix already exists then nothing will happen. If such prefix
     * doesn't exist then new namespace declaration will be added. See previus
     * method about scope for adding namespace.
     * 
     * @param prefix Prefix that suppose to be set for namespace uri.
     * @param uri   Namespace uri that will be added in to namespaces declaration.
     * @throws InvalidNamespaceException
     *             Will be thrown if uri is not acceptable for namespace, bad
     *             prefix is specified or prefix already exist.
     */
    void addNamespace( String prefix, String uri )
            throws InvalidNamespaceException;
}
