/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.repository.testbench;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Random;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.repository.disk.BaseDiskRepositoryImpl;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.disk.AbstractDiskRepository;

/**
 *
 * @author Nickolay Dalmatov
 */
public class DiskRepositoryBench {
    
    /** Creates a new instance of Main */
    public DiskRepositoryBench() {
    }
    public class TestFactory implements org.netbeans.modules.cnd.repository.spi.PersistentFactory {
        public void write(DataOutput out, Persistent obj) throws IOException {
            
            TestClass testObj = (TestClass) obj;
            //OutputStreamWriter osw = new OutputStreamWriter(out);
            try {
                out.writeUTF(testObj.field_1);
                out.writeInt(testObj.getDepth());
                for (int i = 0 ; i < testObj.getDepth(); i++) {
                    out.writeUTF(testObj.getAt(i));
                }
                //osw.flush();
            } catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
            
        }
        
        public Persistent read(DataInput in) throws IOException {
            TestClass testObj = new TestClass();
            try {
              testObj.field_1 = in.readUTF();
              testObj.levels  = new String [in.readInt()] ;
              
              for (int i = 0; i < testObj.levels.length; i++) {
                  testObj.levels[i] = in.readUTF();
              }
              
            } catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
            
            return testObj;
        }

        public boolean canWrite(Persistent obj) {
            return true;
        }
    }
    
    
    public class TestClass implements org.netbeans.modules.cnd.repository.spi.Persistent, 
            org.netbeans.modules.cnd.repository.spi.Key {
        
        public String field_1;
        public String[]  levels;
        public TestFactory theFactory = new TestFactory();
        
        TestClass() {
            levels = new String [3];
        }
        
        TestClass (int depth) {
            levels = new String[depth];
        }
        
        
        public PersistentFactory getPersistentFactory() {
            
            return theFactory;
        }
        
        public int getDepth() {
            return levels.length;
        }
        
        public String getAt(int level) {
           return levels[level];       
        }

        public int getSecondaryDepth() {
            return 0;
        }

        public int getSecondaryAt(int level) {
            throw new IndexOutOfBoundsException();
        }

        public String getUnit() {
            return "UNIT"; // NOI18N
        }

        public Key.Behavior getBehavior() {
            return Key.Behavior.Default;
        }
        
        
    }
    


public void run_Randomly(int numOfThreads) {
    BaseDiskRepositoryImpl bR = new BaseDiskRepositoryImpl();
    final AbstractDiskRepository theRep = bR;
    
    final TestClass[] testClasses = new TestClass[5000];
    
    for (int i = 0; i < testClasses.length ; ++i) {
        testClasses[i] = new TestClass(3);
        testClasses[i].field_1 = "Test string number " + i; //NOI18N
        testClasses[i].levels[0]= "0"; //NOI18N
        testClasses[i].levels[1] = i/20 +""; 
        testClasses[i].levels[2] = i +"";
            try {
                theRep.write(testClasses[i], testClasses[i]);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
    }
    
    
    
    
    final Thread[] threads = new Thread[numOfThreads];
    
    for (int k=0; k<threads.length; ++k) {
        threads[k] = new Thread() {
            public void run() {
                final Random rndGen = new Random(Thread.currentThread().getId());
                for (int j = 0; j < 10000/threads.length; ++j) {
                    int index;
                    for (int k = 0; k < 10; ++k) {
                        index = rndGen.nextInt(testClasses.length/100);
                        if (rndGen.nextBoolean()) {
                                try {
                                    theRep.get(testClasses[index]);
                                } catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                        } else {
                                try {
                                    theRep.write(testClasses[index], testClasses[index]);
                                } catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                        }
                    }
                    
                    index = rndGen.nextInt(testClasses.length);
                    if (rndGen.nextBoolean()) {
                            try {
                                theRep.get(testClasses[index]);
                            } catch (IOException ex) {
                                ex.printStackTrace();
                            }
                    } else {
                            try {
                                theRep.write(testClasses[index], testClasses[index]);
                            } catch (IOException ex) {
                                ex.printStackTrace();
                            }
                    }
                }
          }  
        };
    }
    
      // start
    for (int i = 0; i < threads.length; i++) {
        threads[i].start();
    }
    
    // wait to finish
    for (int i = 0; i < threads.length; i++) {
        try {
            threads[i].join();
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
   
   for (int i = 0; i < testClasses.length ; ++i) {
            try {
        
                theRep.remove(testClasses[i]);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
    }    
    
}

public void run_parallelly(int numOfThreads) {
    
    BaseDiskRepositoryImpl bR = new BaseDiskRepositoryImpl();
    final AbstractDiskRepository theRep = bR;
    final TestClass[] cl_in = new TestClass[2*10*1000];
    final TestClass[] cl_out = new TestClass[2*10*1000];
    
    // prepare ethalon objects
    for (int i = 0; i < 2; ++i) {
        for (int j = 0; j < 10; ++j) {
            for (int k = 0; k < 1000; ++k) {
                int index = k + j*1000 + i * 10000;
                cl_in[index] = new TestClass(3);
                cl_in[index].field_1 = "the string with key " + i + ":"+j+ ":" + k; //NOI18N
                cl_in[index].levels[0] = i+""; 
                cl_in[index].levels[1] = j+""; 
                cl_in[index].levels[2] = k+""; 
            }
        }
    }
    
    Thread[] threads = new Thread[numOfThreads];
    
    for (int i = 0; i < threads.length; i++) {
        final int start = i * cl_in.length/threads.length;
        final int end = start + cl_in.length/threads.length;
        threads[i] = new Thread() {
            int st = start;
            int en   = end;
            
            public void run() {
                for (int j = st; j < en; j ++ ) {
                    try {
                    theRep.write(cl_in[j], cl_in[j]);
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        
    }
    
    // start
    for (int i = 0; i < threads.length; i++) {
        threads[i].start();
    }
    
    // wait to finish
    for (int i = 0; i < threads.length; i++) {
        try {
            threads[i].join();
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
    
    System.err.println("STEP 1 OF 4 FINISHED" ); //NOI18N
    
    for (int i = 0; i < threads.length; i++) {
        final int start = i * cl_in.length/threads.length;
        final int end = start + cl_in.length/threads.length;
        threads[i] = new Thread() {
            int st = start;
            int en   = end;
            
            public void run() {
                for (int j = st; j < en; j ++ ) {
                    try {
                    cl_out[j] = (TestClass)theRep.get(cl_in[j]);
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        
    }
    
    // start
    for (int i = 0; i < threads.length; i++) {
        threads[i].start();
    }
    
    // wait to finish
    for (int i = 0; i < threads.length; i++) {
        try {
            threads[i].join();
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
    
    System.err.println("STEP 2 OF 4 FINISHED" ); //NOI18N
    
    // compare
    final AtomicInteger numOfErrors = new AtomicInteger(0);
    
    for (int i = 0; i < threads.length; i++) {
        final int start = i * cl_in.length/threads.length;
        final int end = start + cl_in.length/threads.length;
        threads[i] = new Thread() {
            int st = start;
            int en   = end;
            
            public void run() {
                try {
                for (int j = st; j < en; j ++ ) {
                    if (cl_in[j].field_1.equals(cl_out[j].field_1) &&
                            (cl_in[j].levels.length == cl_out[j].levels.length)) {
                        for (int g = 0; g < cl_in[j].levels.length; g++) {
                            if (!(cl_in[j].levels[g]).equals( cl_out[j].levels[g])) {
                                numOfErrors.incrementAndGet();
                                break;
                            }
                        }
                    } else {
                        numOfErrors.incrementAndGet();
                    }
                }
                }catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        
    }
    
    // start
    for (int i = 0; i < threads.length; i++) {
        threads[i].start();
    }
    
    // wait to finish
    for (int i = 0; i < threads.length; i++) {
        try {
            threads[i].join();
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
    
   System.err.println("STEP 3 OF 4 FINISHED" ); //NOI18N
    
    if (numOfErrors.intValue() > 0) {
        System.err.println("The number of errors = " + numOfErrors.intValue()); //NOI18N
    }
    
    
    for (int i = 0; i < threads.length; i++) {
        final int start = i * cl_in.length/threads.length;
        final int end = start + cl_in.length/threads.length;
        threads[i] = new Thread() {
            int st = start;
            int en   = end;
            
            public void run() {
                for (int j = st; j < en; j ++ ) {
                        try {
                            theRep.remove(cl_in[j]);
                        } catch (IOException ex) {
                            ex.printStackTrace();
                        }
                }
            }
        };
        
    }
    
    // start
    for (int i = 0; i < threads.length; i++) {
        threads[i].start();
    }
    
    // wait to finish
    for (int i = 0; i < threads.length; i++) {
        try {
            threads[i].join();
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
    
    System.err.println("STEP 4 OF 4 FINISHED" ); //NOI18N
        try {
            System.in.read();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
}

public void run() {
    BaseDiskRepositoryImpl bR = new BaseDiskRepositoryImpl();
    AbstractDiskRepository theRep = bR;
    
    
    
    TestClass[] cl_in = new TestClass[2*10*1000];
    TestClass[] cl_out = new TestClass[2*10*1000];
    
    // prepare ethalon objects
    for (int i = 0; i < 2; ++i) {
        for (int j = 0; j < 10; ++j) {
            for (int k = 0; k < 1000; ++k) {
                int index = k + j*1000 + i * 10000;
                cl_in[index] = new TestClass(3);
                cl_in[index].field_1 = "the string with key " + i + ":"+j+ ":" + k; //NOI18N
                cl_in[index].levels[0] = i+""; 
                cl_in[index].levels[1] = j+""; 
                cl_in[index].levels[2] = k+""; 
            }
        }
    }
    
    
    for (int z = 0; z < 10; ++z) {
            try {
                bR.setOpenFilesLimit(50 - 4 * z);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        
        // serialize
        for (int index = 0 ; index < cl_in.length; index++) {
                try {
                    theRep.write(cl_in[index], cl_in[index]);
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
        }
        
        //deserialize
        for (int index = 0 ; index < cl_in.length; index++) {
                try {
                    cl_out[index] = (TestClass)theRep.get(cl_in[index]);
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
        }
        
        // compare
        int numOfErrors = 0;
        for (int f = 0; f < cl_in.length; f++) {
            if (cl_in[f].field_1.equals(cl_out[f].field_1) && 
                    (cl_in[f].levels.length == cl_out[f].levels.length))
            {
                for (int g = 0; g < cl_in[f].levels.length; g++) {
                    if (!(cl_in[f].levels[g]).equals(cl_out[f].levels[g])) {
                        numOfErrors++;
                        break;
                    }
                }
            } else {
                numOfErrors++;
            }
        }
        
        if (numOfErrors > 0) {
            System.err.println("The number of errors = " + numOfErrors); //NOI18N
        }
        
        for (int index = 0 ; index < cl_in.length; index++) {
                try {
                    theRep.remove(cl_out[index]);
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
        }
    }
}


/**
 * @param args the command line arguments
 */


public static void main(String[] args) {
    // TODO code application logic here
    DiskRepositoryBench atest = new DiskRepositoryBench();
    
    
    
    //atest.run();
    //atest.run_Randomly();
    int number = 4;
    int testNum = 1;
    if ((args != null) && (args.length >= 1) ){
        number = (new Integer(args[0])).intValue();
        if(args.length > 1) {
            testNum = (new Integer(args[1])).intValue();
        }
    }
    
    
    if (testNum == 1)
        atest.run_parallelly(number);
    else if (testNum == 2) 
        atest.run_Randomly(number);
    System.err.println("FINISHED"); //NOI18N
    
    
    
    
    
    //
    
}

}
