/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpJdmkLcd;
import com.sun.management.internal.snmp.SnmpLcd;
import com.sun.management.internal.snmp.SnmpMsgProcessingModel;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSysImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpSecurityModel;
import com.sun.management.internal.snmp.SnmpSecurityModelV1V2;
import com.sun.management.internal.snmp.SnmpSecuritySubSysImpl;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.internal.snmp.SnmpUsmKeyHandlerImpl;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.mpm.SnmpMsgProcessingModelV1V2;
import com.sun.management.snmp.mpm.SnmpMsgProcessingModelV3;
import com.sun.management.snmp.usm.SnmpUserSecurityModel;
import com.sun.management.snmp.usm.SnmpUsm;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.management.snmp.usm.SnmpUsmDesAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmHmacMd5;
import com.sun.management.snmp.usm.SnmpUsmHmacSha;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmPasswordLcd;
import java.net.UnknownHostException;

public class SnmpBaseEngineFactory
implements SnmpEngineFactory {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpBaseEngineFactory");
    private String dbgTag = "SnmpBaseEngineFactory";

    public SnmpEngine createEngine(SnmpEngineParameters snmpEngineParameters) throws IllegalArgumentException {
        String string = snmpEngineParameters.getSecurityFile();
        SnmpEngineId snmpEngineId = snmpEngineParameters.getEngineId();
        SnmpLcd snmpLcd = this.createEngineLcd(string);
        SnmpEngineImpl snmpEngineImpl = null;
        try {
            snmpEngineImpl = new SnmpEngineImpl((SnmpEngineFactory)this, snmpLcd, snmpEngineId);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("Unknown host: " + unknownHostException.getMessage());
        }
        this.init(snmpEngineParameters, snmpEngineImpl, snmpLcd);
        return snmpEngineImpl;
    }

    public SnmpEngine createEngine(SnmpEngineParameters snmpEngineParameters, InetAddressAcl inetAddressAcl) {
        return this.createEngine(snmpEngineParameters);
    }

    protected SnmpLcd createEngineLcd(String string) throws IllegalArgumentException {
        return new SnmpJdmkLcd(string);
    }

    protected SnmpUsmAlgorithmManager createAlgorithmManager(SnmpEngine snmpEngine) {
        return new SnmpUsmAlgorithmManager();
    }

    protected SnmpSecuritySubSystem createSecuritySubSystem(SnmpEngine snmpEngine) {
        return new SnmpSecuritySubSysImpl(snmpEngine);
    }

    protected SnmpMsgProcessingSubSystem createMsgProcessingSubSystem(SnmpEngine snmpEngine) {
        return new SnmpMsgProcessingSubSysImpl(snmpEngine);
    }

    protected SnmpUsmLcd createUsmLcd(SnmpEngine snmpEngine, SnmpLcd snmpLcd, SnmpSecuritySubSystem snmpSecuritySubSystem, String string) throws IllegalArgumentException {
        return new SnmpUsmPasswordLcd(snmpEngine, snmpSecuritySubSystem, snmpLcd, string);
    }

    protected SnmpUsm createUsmSecurityModel(SnmpEngine snmpEngine, SnmpUsmLcd snmpUsmLcd, SnmpSecuritySubSystem snmpSecuritySubSystem) {
        SnmpUserSecurityModel snmpUserSecurityModel = new SnmpUserSecurityModel((SnmpSubSystem)snmpSecuritySubSystem, snmpUsmLcd);
        return snmpUserSecurityModel;
    }

    void fillAlgorithmManager(SnmpEngineParameters snmpEngineParameters, SnmpUsmAlgorithmManager snmpUsmAlgorithmManager, SnmpEngineImpl snmpEngineImpl) {
        if (snmpUsmAlgorithmManager.getAlgorithm("usmHMACMD5AuthProtocol") == null) {
            snmpUsmAlgorithmManager.addAlgorithm(new SnmpUsmHmacMd5());
        }
        if (snmpUsmAlgorithmManager.getAlgorithm("usmHMACSHAAuthProtocol") == null) {
            snmpUsmAlgorithmManager.addAlgorithm(new SnmpUsmHmacSha());
        }
        if (snmpEngineParameters.isEncryptionEnabled()) {
            block8: {
                if (logger.finestOn()) {
                    logger.finest("init", "Usm encryption activated.");
                }
                try {
                    if (snmpUsmAlgorithmManager.getAlgorithm("usmDESPrivProtocol") == null) {
                        snmpUsmAlgorithmManager.addAlgorithm(new SnmpUsmDesAlgorithm(snmpEngineImpl));
                    }
                }
                catch (SnmpUsmException snmpUsmException) {
                    if (!logger.finerOn()) break block8;
                    logger.finer("init", "Problemm initializing encryption, check your classpath: " + snmpUsmException.toString());
                }
            }
            if (logger.finestOn()) {
                logger.finest("init", "Usm encryption algos added.");
            }
        }
    }

    protected SnmpSecurityModel createCommunityStringSecurityModel(SnmpEngine snmpEngine, SnmpSecuritySubSystem snmpSecuritySubSystem) {
        return new SnmpSecurityModelV1V2(snmpSecuritySubSystem);
    }

    protected SnmpMsgProcessingModel createSnmpV1MsgProcessingModel(SnmpEngine snmpEngine, SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem) {
        return new SnmpMsgProcessingModelV1V2(snmpMsgProcessingSubSystem, null);
    }

    protected SnmpMsgProcessingModel createSnmpV2MsgProcessingModel(SnmpEngine snmpEngine, SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpMsgProcessingModel snmpMsgProcessingModel) {
        return snmpMsgProcessingModel;
    }

    protected SnmpMsgProcessingModel createSnmpV3MsgProcessingModel(SnmpEngine snmpEngine, SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpMsgProcessingModel snmpMsgProcessingModel) {
        return new SnmpMsgProcessingModelV3(snmpMsgProcessingSubSystem, null);
    }

    private void init(SnmpEngineParameters snmpEngineParameters, SnmpEngineImpl snmpEngineImpl, SnmpLcd snmpLcd) {
        if (logger.finestOn()) {
            logger.finest("init", "Starting...");
        }
        SnmpSecuritySubSystem snmpSecuritySubSystem = this.createSecuritySubSystem(snmpEngineImpl);
        SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = this.createMsgProcessingSubSystem(snmpEngineImpl);
        snmpMsgProcessingSubSystem.setSecuritySubSystem(snmpSecuritySubSystem);
        snmpEngineImpl.setSecuritySubSystem(snmpSecuritySubSystem);
        snmpEngineImpl.setMsgProcessingSubSystem(snmpMsgProcessingSubSystem);
        if (logger.finestOn()) {
            logger.finest("init", "Sub Systems created.");
        }
        SnmpUsmLcd snmpUsmLcd = this.createUsmLcd(snmpEngineImpl, snmpLcd, snmpSecuritySubSystem, snmpEngineParameters.getSecurityFile());
        snmpLcd.addModelLcd(snmpSecuritySubSystem, 3, snmpUsmLcd);
        if (logger.finestOn()) {
            logger.finest("init", "Usm Lcd added.");
        }
        SnmpUsm snmpUsm = this.createUsmSecurityModel(snmpEngineImpl, snmpUsmLcd, snmpSecuritySubSystem);
        SnmpSecurityModel snmpSecurityModel = this.createCommunityStringSecurityModel(snmpEngineImpl, snmpSecuritySubSystem);
        if (logger.finestOn()) {
            logger.finest("init", "Security models V1 V2 v3 added.");
        }
        SnmpUsmAlgorithmManager snmpUsmAlgorithmManager = this.createAlgorithmManager(snmpEngineImpl);
        this.fillAlgorithmManager(snmpEngineParameters, snmpUsmAlgorithmManager, snmpEngineImpl);
        if (logger.finestOn()) {
            logger.finest("init", "Usm algos added.");
        }
        snmpUsmLcd.setAlgorithmManager(snmpUsmAlgorithmManager);
        snmpUsmLcd.syncDataSource();
        if (logger.finestOn()) {
            logger.finest("init", "Usm configuration sync.");
        }
        SnmpMsgProcessingModel snmpMsgProcessingModel = this.createSnmpV1MsgProcessingModel(snmpEngineImpl, snmpMsgProcessingSubSystem);
        SnmpMsgProcessingModel snmpMsgProcessingModel2 = this.createSnmpV2MsgProcessingModel(snmpEngineImpl, snmpMsgProcessingSubSystem, snmpMsgProcessingModel);
        if (logger.finestOn()) {
            logger.finest("init", "V1 V2 processing model added. Can speak V1V2");
        }
        SnmpMsgProcessingModel snmpMsgProcessingModel3 = null;
        snmpMsgProcessingModel3 = this.createSnmpV3MsgProcessingModel(snmpEngineImpl, snmpMsgProcessingSubSystem, snmpMsgProcessingModel2);
        if (logger.finestOn()) {
            logger.finest("init", "V3 processing model added. Can speak V3");
        }
        SnmpUsmKeyHandlerImpl snmpUsmKeyHandlerImpl = new SnmpUsmKeyHandlerImpl(snmpUsmAlgorithmManager);
        snmpEngineImpl.setUsmKeyHandler(snmpUsmKeyHandlerImpl);
    }
}

