/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoGlobal;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class JGoImage
extends JGoObject
implements ImageObserver {
    public static final int ChangedImage = 901;
    public static final int ChangedTransparentColor = 903;
    public static final int ChangedURL = 904;
    public static final int ChangedFilename = 905;
    private static URL myDefaultBase = null;
    private static HashMap myImageMap = new HashMap();
    private transient Image myImage = null;
    private transient Dimension myNaturalSize = null;
    private URL myURL = null;
    private String myFilename = null;
    private Color myTransparentColor = null;

    public JGoImage() {
    }

    public JGoImage(Point location, Dimension size) {
        super(location, size);
    }

    public JGoImage(Rectangle rect) {
        super(rect);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoImage newobj = (JGoImage)super.copyObject(env);
        if (newobj != null) {
            newobj.myImage = this.myImage;
            if (this.myNaturalSize != null) {
                newobj.myNaturalSize = new Dimension(this.myNaturalSize);
            }
            newobj.myURL = this.myURL;
            newobj.myFilename = this.myFilename;
            newobj.myTransparentColor = this.myTransparentColor;
        }
        return newobj;
    }

    public boolean loadImage(Image img, boolean wait) {
        this.setImage(img);
        return true;
    }

    public Image getImage(URL url) {
        if (url == null) {
            return null;
        }
        Image img = (Image)JGoImage.getImageMap().get(url);
        if (img == null && (img = JGoGlobal.getToolkit().createImage(url)) != null) {
            JGoImage.getImageMap().put(url, img);
        }
        return img;
    }

    public Image getImage(String path) {
        if (path == null) {
            return null;
        }
        Image img = (Image)JGoImage.getImageMap().get(path);
        if (img == null && (img = JGoGlobal.getToolkit().createImage(path)) != null) {
            JGoImage.getImageMap().put(path, img);
        }
        return img;
    }

    public static void resetImage(URL url) {
        JGoImage.getImageMap().remove(url);
    }

    public static void resetImage(String path) {
        JGoImage.getImageMap().remove(path);
    }

    public static void resetAllImages() {
        JGoImage.getImageMap().clear();
    }

    boolean waitForImage(boolean wait) {
        if (wait) {
            MediaTracker mt = new MediaTracker(JGoGlobal.getComponent());
            mt.addImage(this.myImage, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException ie) {
                return false;
            }
            return !mt.isErrorID(0);
        }
        return true;
    }

    public boolean loadImage(URL url, boolean wait) {
        URL oldURL = this.myURL;
        String oldFilename = this.myFilename;
        if (oldURL == null || !oldURL.equals(url)) {
            this.myURL = url;
            this.myFilename = null;
            if (oldURL != null) {
                this.update(904, 0, oldURL);
            } else {
                this.update(904, 0, oldFilename);
            }
        }
        this.myNaturalSize = null;
        this.myImage = this.getImage(url);
        return this.waitForImage(wait);
    }

    public boolean loadImage(String filename, boolean wait) {
        URL oldURL = this.myURL;
        String oldFilename = this.myFilename;
        if (oldFilename == null || !oldFilename.equals(filename)) {
            this.myURL = null;
            this.myFilename = filename;
            if (oldFilename != null) {
                this.update(905, 0, oldFilename);
            } else {
                this.update(905, 0, oldURL);
            }
        }
        Image newimg = null;
        if (JGoImage.getDefaultBase() != null) {
            URL imgURL = null;
            try {
                imgURL = new URL(JGoImage.getDefaultBase(), filename);
            }
            catch (Exception x) {
                // empty catch block
            }
            if (imgURL != null) {
                newimg = this.getImage(imgURL);
            }
        }
        if (newimg == null) {
            newimg = this.getImage(filename);
        }
        this.myNaturalSize = null;
        this.myImage = newimg;
        return this.waitForImage(wait);
    }

    public void setImage(Image img) {
        Image oldImage = this.getImage();
        if (oldImage != img) {
            this.myImage = img;
            this.myNaturalSize = null;
            this.update(901, 0, oldImage);
        }
    }

    public Image getImage() {
        return this.myImage;
    }

    public URL getURL() {
        return this.myURL;
    }

    public String getFilename() {
        return this.myFilename;
    }

    public Dimension getNaturalSize() {
        Image img;
        if (this.myNaturalSize == null) {
            this.myNaturalSize = new Dimension(-1, -1);
        }
        if ((img = this.getImage()) != null && (this.myNaturalSize.width < 0 || this.myNaturalSize.height < 0)) {
            this.myNaturalSize.width = img.getWidth(this);
            this.myNaturalSize.height = img.getHeight(this);
        }
        return this.myNaturalSize;
    }

    public Color getTransparentColor() {
        return this.myTransparentColor;
    }

    public void setTransparentColor(Color trans) {
        Color oldColor = this.myTransparentColor;
        if (oldColor == null) {
            if (trans != null) {
                this.myTransparentColor = trans;
                this.update(903, 0, oldColor);
            }
        } else if (!oldColor.equals(trans)) {
            this.myTransparentColor = trans;
            this.update(903, 0, oldColor);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 901: {
                e.setNewValue(this.getImage());
                return;
            }
            case 903: {
                e.setNewValue(this.getTransparentColor());
                return;
            }
            case 904: 
            case 905: {
                if (this.getURL() != null) {
                    e.setNewValue(this.getURL());
                } else {
                    e.setNewValue(this.getFilename());
                }
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 901: {
                this.setImage((Image)e.getValue(undo));
                return;
            }
            case 903: {
                this.setTransparentColor((Color)e.getValue(undo));
                return;
            }
            case 904: 
            case 905: {
                if (undo) {
                    if (e.getOldValue() instanceof URL) {
                        this.loadImage((URL)e.getOldValue(), false);
                    } else if (e.getOldValue() instanceof String) {
                        this.loadImage((String)e.getOldValue(), false);
                    }
                } else if (e.getNewValue() instanceof URL) {
                    this.loadImage((URL)e.getNewValue(), false);
                } else if (e.getNewValue() instanceof String) {
                    this.loadImage((String)e.getNewValue(), false);
                }
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoImage = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoImage", jGoElementGroup);
            if (this.getFilename() != null) {
                jGoImage.setAttribute("imagefilename", this.getFilename());
            }
            if (this.getURL() != null) {
                jGoImage.setAttribute("imageurl", this.getURL().toString());
            }
            if (this.getTransparentColor() != null) {
                jGoImage.setAttribute("imagetransparentcolor", Integer.toString(this.getTransparentColor().getRGB()));
            }
        }
        if (svgDoc.SVGOutputEnabled()) {
            DomElement element = svgDoc.createElement("image");
            this.SVGWriteAttributes(element);
            jGoElementGroup.appendChild(element);
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        try {
            if (jGoChildElement != null) {
                if (jGoChildElement.getAttribute("imagefilename").length() > 0) {
                    this.loadImage(jGoChildElement.getAttribute("imagefilename"), false);
                }
                if (jGoChildElement.getAttribute("imageurl").length() > 0) {
                    this.loadImage(new URL(jGoChildElement.getAttribute("imageurl")), false);
                }
                if (jGoChildElement.getAttribute("imagetransparentcolor").length() > 0) {
                    int rgb = Integer.parseInt(jGoChildElement.getAttribute("imagetransparentcolor"));
                    this.setTransparentColor(new Color(rgb));
                }
                super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
            } else if (svgElement.getTagName().equalsIgnoreCase("image")) {
                this.SVGReadAttributes(svgElement);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        super.SVGWriteAttributes(svgElement);
        svgElement.setAttribute("x", Integer.toString(this.getTopLeft().x));
        svgElement.setAttribute("y", Integer.toString(this.getTopLeft().y));
        svgElement.setAttribute("width", Integer.toString(this.getWidth()));
        svgElement.setAttribute("height", Integer.toString(this.getHeight()));
        if (this.getURL() != null) {
            svgElement.setAttribute("xlink:href", this.getURL().toString());
        } else if (this.getFilename() != null) {
            String filename = this.getFilename();
            if (JGoImage.getDefaultBase() != null) {
                String base = JGoImage.getDefaultBase().toString();
                svgElement.setAttribute("xlink:href", base + filename);
            } else {
                svgElement.setAttribute("xlink:href", filename);
            }
        }
    }

    public void SVGReadAttributes(DomElement svgElement) {
        super.SVGReadAttributes(svgElement);
        String nX = svgElement.getAttribute("x");
        String nY = svgElement.getAttribute("y");
        this.setTopLeft(new Point(Integer.parseInt(nX), Integer.parseInt(nY)));
        String nWidth = svgElement.getAttribute("width");
        String nHeight = svgElement.getAttribute("height");
        this.setWidth(Integer.parseInt(nWidth));
        this.setHeight(Integer.parseInt(nHeight));
        String sRef = svgElement.getAttribute("xlink:href");
        if (sRef.length() > 0) {
            try {
                this.loadImage(new URL(sRef), false);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics2D g, JGoView view) {
        if (this.getImage() == null) {
            if (this.getURL() != null) {
                this.loadImage(this.getURL(), false);
            } else if (this.getFilename() != null) {
                this.loadImage(this.getFilename(), false);
            }
        }
        if (this.getImage() != null) {
            Rectangle rect = this.getBoundingRect();
            if (this.getTransparentColor() == null) {
                g.drawImage(this.getImage(), rect.x, rect.y, rect.width, rect.height, this);
            } else {
                g.drawImage(this.getImage(), rect.x, rect.y, rect.width, rect.height, this.getTransparentColor(), this);
            }
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            this.update();
            return false;
        }
        if ((infoflags & 0x10) != 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                this.update();
                return false;
            }
            this.update();
            return true;
        }
        return true;
    }

    public static URL getDefaultBase() {
        return myDefaultBase;
    }

    public static void setDefaultBase(URL u) {
        myDefaultBase = u;
    }

    public static HashMap getImageMap() {
        return myImageMap;
    }
}

