/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.ServerSocketFactory;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

class PortWatcher
implements Runnable {
    private static Vector pool = new Vector();
    Session session;
    int lport;
    int rport;
    String host;
    InetAddress boundaddress;
    Runnable thread;
    ServerSocket ss;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = pool;
        synchronized (pool) {
            int n;
            for (n = 0; n < pool.size(); ++n) {
                PortWatcher portWatcher = (PortWatcher)pool.elementAt(n);
                if (portWatcher.session != session) continue;
                vector.addElement(portWatcher.lport + ":" + portWatcher.host + ":" + portWatcher.rport);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PortWatcher getPort(Session session, String string, int n) throws JSchException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new JSchException("PortForwardingL: invalid address " + string + " specified.");
        }
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                PortWatcher portWatcher = (PortWatcher)pool.elementAt(i);
                if (portWatcher.session != session || portWatcher.lport != n || !portWatcher.boundaddress.isAnyLocalAddress() && !portWatcher.boundaddress.equals(inetAddress)) continue;
                return portWatcher;
            }
            return null;
        }
    }

    static PortWatcher addPort(Session session, String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        if (PortWatcher.getPort(session, string, n) != null) {
            throw new JSchException("PortForwardingL: local port " + string + ":" + n + " is already registered.");
        }
        PortWatcher portWatcher = new PortWatcher(session, string, n, string2, n2, serverSocketFactory);
        pool.addElement(portWatcher);
        return portWatcher;
    }

    static void delPort(Session session, String string, int n) throws JSchException {
        PortWatcher portWatcher = PortWatcher.getPort(session, string, n);
        if (portWatcher == null) {
            throw new JSchException("PortForwardingL: local port " + string + ":" + n + " is not registered.");
        }
        portWatcher.delete();
        pool.removeElement(portWatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        Vector vector = pool;
        synchronized (vector) {
            PortWatcher portWatcher;
            int n;
            PortWatcher[] portWatcherArray = new PortWatcher[pool.size()];
            int n2 = 0;
            for (n = 0; n < pool.size(); ++n) {
                portWatcher = (PortWatcher)pool.elementAt(n);
                if (portWatcher.session != session) continue;
                portWatcher.delete();
                portWatcherArray[n2++] = portWatcher;
            }
            for (n = 0; n < n2; ++n) {
                portWatcher = portWatcherArray[n];
                pool.removeElement(portWatcher);
            }
        }
    }

    PortWatcher(Session session, String string, int n, String string2, int n2, ServerSocketFactory serverSocketFactory) throws JSchException {
        this.session = session;
        this.lport = n;
        this.host = string2;
        this.rport = n2;
        try {
            this.boundaddress = InetAddress.getByName(string);
            this.ss = serverSocketFactory == null ? new ServerSocket(n, 0, this.boundaddress) : serverSocketFactory.createServerSocket(n, 0, this.boundaddress);
        }
        catch (Exception exception) {
            System.out.println(exception);
            throw new JSchException("PortForwardingL: local port " + string + ":" + n + " cannot be bound.");
        }
    }

    public void run() {
        Buffer buffer = new Buffer(300);
        Packet packet = new Packet(buffer);
        this.thread = this;
        try {
            while (this.thread != null) {
                Socket socket = this.ss.accept();
                socket.setTcpNoDelay(true);
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ChannelDirectTCPIP channelDirectTCPIP = new ChannelDirectTCPIP();
                channelDirectTCPIP.init();
                channelDirectTCPIP.setInputStream(inputStream);
                channelDirectTCPIP.setOutputStream(outputStream);
                this.session.addChannel(channelDirectTCPIP);
                channelDirectTCPIP.setHost(this.host);
                channelDirectTCPIP.setPort(this.rport);
                channelDirectTCPIP.setOrgIPAddress(socket.getInetAddress().getHostAddress());
                channelDirectTCPIP.setOrgPort(socket.getPort());
                channelDirectTCPIP.connect();
                if (channelDirectTCPIP.exitstatus == -1) continue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delete();
    }

    void delete() {
        this.thread = null;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
            this.ss = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

