/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.runtime;

import com.sun.encoder.EncoderConfigurationException;
import com.sun.encoder.coco.appinfo.CocoEncoding;
import com.sun.encoder.coco.model.CocoDescriptionEntry;
import com.sun.encoder.coco.model.CocoPicture;
import com.sun.encoder.coco.runtime.CobolCharacteristics;
import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import com.sun.encoder.codegen.Emit;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;

public class RuleNode {
    private static final ErrorManager cErrorMgr = ErrorManager.getManager("OpenESB.encoder.COBOLCopybook." + RuleNode.class.getName());
    private boolean mSuper = false;
    private boolean mTop = false;
    private RuleContext mContext;
    private RuleNode mParentNode;
    private int mIndex;
    private QName mQName;
    private int mMinOccurs;
    private int mMaxOccurs;
    private RuleNode mOccursDependOn;
    private String mCharEncoding;
    private RuleNode[] mChildren;
    private List<RuleNode> mChildList = new ArrayList<RuleNode>();
    private CobolCharacteristics mCharacteristics;
    private String mPicture;
    private int mRedefineIndex = -1;
    private int mOccursDependOnIndex = -1;
    private RuleNode mRedefinedNode;

    public RuleContext getContext() {
        return this.mContext;
    }

    public RuleNode getParentNode() {
        return this.mParentNode;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean isSuper() {
        return this.mSuper;
    }

    public boolean isTop() {
        return this.mTop;
    }

    public QName getQName() {
        return this.mQName;
    }

    public int getMinOccurs() {
        return this.mMinOccurs;
    }

    public int getMaxOccurs() {
        return this.mMaxOccurs;
    }

    public int getOccursDependOnIndex() {
        return this.mOccursDependOnIndex;
    }

    public RuleNode getOccursDependOn() {
        return this.mOccursDependOn;
    }

    public String getCharEncoding() {
        if (this.mCharEncoding != null) {
            return this.mCharEncoding;
        }
        if (this.mCharacteristics.getPicCategory() == 6) {
            return this.mContext.mDisplay1CharEncoding;
        }
        return this.mContext.mDisplayCharEncoding;
    }

    public int getRedefineIndex() {
        return this.mRedefineIndex;
    }

    public RuleNode getRedefinedNode() {
        return this.mRedefinedNode;
    }

    public RuleNode[] getChildren() {
        return this.mChildren;
    }

    public CobolCharacteristics getCharacteristics() {
        return this.mCharacteristics;
    }

    public String getPicture() {
        return this.mPicture;
    }

    public String toString() {
        if (this.mQName == null) {
            return super.toString();
        }
        return this.mQName.toString();
    }

    public void dump(Emit emit) {
        emit.part("(name=");
        this.emitValue(emit, this.mQName);
        emit.down(" ");
        emit.indent();
        emit.part("minOccurs=");
        this.emitValue(emit, this.mMinOccurs);
        emit.emit();
        emit.part("maxOccurs=");
        this.emitValue(emit, this.mMaxOccurs);
        emit.emit();
        emit.part("charEncoding=");
        this.emitValue(emit, this.mCharEncoding);
        emit.emit();
        emit.part("occursDependOn=");
        this.emitValue(emit, this.mOccursDependOn == null ? "<null>" : this.mOccursDependOn.getQName());
        emit.emit();
        emit.part("occursDependOnIndex=");
        this.emitValue(emit, this.mOccursDependOnIndex);
        emit.emit();
        emit.part("redefine=");
        this.emitValue(emit, this.mRedefinedNode == null ? "<null>" : this.mRedefinedNode.getQName());
        emit.emit();
        emit.part("redefineIndex=");
        this.emitValue(emit, this.mRedefineIndex);
        emit.emit();
        emit.part("picture=");
        this.emitValue(emit, this.mPicture);
        emit.emit();
        emit.part("characteristics=");
        this.emitValue(emit, this.mCharacteristics);
        emit.emit();
        emit.undent();
        for (int i = 0; this.mChildren != null && i < this.mChildren.length; ++i) {
            this.mChildren[i].dump(emit);
        }
        emit.undent();
        emit.emit(")");
    }

    private void emitValue(Emit emit, Object value) {
        emit.part("\"");
        emit.part(value == null ? "<null>" : value.toString());
        emit.part("\"");
    }

    public static RuleNode wrapAsSuperNode(RuleNode topNode) {
        RuleNode superNode = new RuleNode();
        superNode.mSuper = true;
        superNode.mQName = new QName("super");
        superNode.mChildren = new RuleNode[]{topNode};
        superNode.mMaxOccurs = 1;
        superNode.mMinOccurs = 1;
        topNode.mParentNode = superNode;
        topNode.mIndex = 0;
        return superNode;
    }

    public static RuleNode readRules(SchemaTypeSystem ts, QName topElemName) throws EncoderConfigurationException {
        SchemaGlobalElement topElem = ts.findElement(topElemName);
        if (topElem == null) {
            Message msg = MessageCatalog.getMessage("CCCR4033");
            String err = msg.formatText(new Object[]{topElemName});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new EncoderConfigurationException(err);
        }
        RuleNode topRule = new RuleNode();
        topRule.mTop = true;
        RuleContext context = new RuleContext();
        context.mTopRule = topRule;
        topRule.mContext = context;
        RuleNode.readRule(topRule, (SchemaLocalElement)topElem);
        RuleContext.access$302(context, context.mRedefinedNodeList.toArray(new RuleNode[0]));
        context.mRedefinedNodeList.clear();
        RuleContext.access$502(context, context.mOccursDependOnList.toArray(new RuleNode[0]));
        context.mOccursDependOnList.clear();
        return topRule;
    }

    private static void readRule(RuleNode current, SchemaLocalElement elem) throws EncoderConfigurationException {
        String err;
        Message msg;
        CocoPicture picture;
        String err2;
        Message msg2;
        CobolCharacteristics characteristics;
        RuleContext context = current.getContext();
        CocoEncoding encoding = null;
        SchemaAnnotation anno = elem.getAnnotation();
        if (anno != null) {
            XmlObject[] xmlObjs = anno.getApplicationInformation();
            for (int i = 0; i < xmlObjs.length; ++i) {
                if (xmlObjs[i] instanceof CocoEncoding) {
                    encoding = (CocoEncoding)xmlObjs[i];
                    break;
                }
                XmlCursor cursor = xmlObjs[i].newCursor();
                String source = cursor.getAttributeText(new QName("source"));
                cursor.dispose();
                if (!"urn:com.sun:encoder".equals(source)) continue;
                Reader reader = xmlObjs[i].newReader();
                try {
                    encoding = CocoEncoding.Factory.parse((Reader)reader);
                    reader.close();
                    break;
                }
                catch (XmlException e) {
                    Message msg3 = MessageCatalog.getMessage("CCCR4035");
                    String err3 = msg3.formatText(new Object[]{elem.getName()});
                    cErrorMgr.log(ErrorManager.Severity.ERROR, null, err3 + e.getLocalizedMessage());
                    throw new EncoderConfigurationException(err3, (Throwable)e);
                }
                catch (IOException e) {
                    Message msg4 = MessageCatalog.getMessage("CCCR4035");
                    String err4 = msg4.formatText(new Object[]{elem.getName()});
                    cErrorMgr.log(ErrorManager.Severity.ERROR, null, err4 + e.getLocalizedMessage());
                    throw new EncoderConfigurationException(err4, (Throwable)e);
                }
            }
        }
        if (encoding == null) {
            Message msg5 = MessageCatalog.getMessage("CCCR4034");
            String err5 = msg5.formatText(new Object[]{elem.getName()});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err5);
            throw new EncoderConfigurationException(err5);
        }
        current.mQName = elem.getName();
        if (elem instanceof SchemaGlobalElement) {
            current.mMinOccurs = 1;
            current.mMaxOccurs = 1;
        } else {
            current.mMinOccurs = elem.getMinOccurs().intValue();
            int n = current.mMaxOccurs = elem.getMaxOccurs() == null ? -1 : elem.getMaxOccurs().intValue();
        }
        if (current.mTop) {
            if (encoding.isSetDisplayCharEncoding()) {
                current.mContext.mDisplayCharEncoding = encoding.getDisplayCharEncoding();
            }
            if (encoding.isSetDisplay1CharEncoding()) {
                current.mContext.mDisplay1CharEncoding = encoding.getDisplay1CharEncoding();
            }
            if (encoding.isSetPreDecodeCharCoding()) {
                current.mContext.mPreDecodeCharCoding = encoding.getPreDecodeCharCoding();
            }
            if (encoding.isSetPostEncodeCharCoding()) {
                current.mContext.mPostEncodeCharCoding = encoding.getPostEncodeCharCoding();
            }
        }
        current.mCharacteristics = characteristics = new CobolCharacteristics();
        characteristics.setBlankWhenZero(encoding.isSetBlankWhenZero());
        characteristics.setJustified(encoding.isSetJustified());
        if (encoding.isSetRedefine()) {
            if (current.mTop) {
                Message msg6 = MessageCatalog.getMessage("CCCR4036");
                String err6 = msg6.formatText(new Object[]{elem.getName()});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, err6);
                throw new EncoderConfigurationException(err6);
            }
            RuleNode redefinedNode = RuleNode.findSibling(current, encoding.getRedefine());
            if (redefinedNode == null) {
                msg2 = MessageCatalog.getMessage("CCCR4037");
                err2 = msg2.formatText(new Object[]{elem, encoding.getRedefine()});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, err2);
                throw new EncoderConfigurationException(err2);
            }
            if (redefinedNode.mRedefineIndex == -1) {
                redefinedNode.mRedefineIndex = context.mRedefinedNodeList.size();
                context.mRedefinedNodeList.add(redefinedNode);
            }
            current.mRedefinedNode = redefinedNode;
        }
        if (encoding.isSetOccursDependOn()) {
            RuleNode dependedNode = RuleNode.findNode(context.mTopRule, encoding.getOccursDependOn().getPath());
            if (dependedNode == null) {
                msg2 = MessageCatalog.getMessage("CCCR4038");
                err2 = msg2.formatText(new Object[]{elem, encoding.getOccursDependOn().getPath()});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, err2);
                throw new EncoderConfigurationException(err2);
            }
            if (dependedNode.mOccursDependOnIndex == -1) {
                dependedNode.mOccursDependOnIndex = context.mOccursDependOnList.size();
                context.mOccursDependOnList.add(dependedNode);
            }
            current.mOccursDependOn = dependedNode;
        }
        if (encoding.isSetPicture()) {
            try {
                picture = new CocoPicture(encoding.getPicture());
            }
            catch (IllegalArgumentException e) {
                msg = MessageCatalog.getMessage("CCCR4039");
                err = msg.formatText(new Object[]{elem, encoding.getPicture()});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, err + e.getLocalizedMessage());
                throw new EncoderConfigurationException(err, (Throwable)e);
            }
            characteristics.setDecimalPosition(picture.getDecimalPosition());
            characteristics.setDecimalScalingPositions(picture.getDecimalScalingPositions());
            characteristics.setSigned(picture.hasSign());
            characteristics.setPicCategory(RuleNode.cvtPictureCategory(picture.getCategory()));
            current.mPicture = picture.getPicture();
        } else {
            picture = null;
        }
        if (encoding.isSetUsage()) {
            characteristics.setUsage(RuleNode.cvtUsage(encoding.getUsage()));
        }
        characteristics.setSignLeading(characteristics.isSigned() && encoding.isSetSign() && encoding.getSign().isSetLeading());
        characteristics.setSignSeparate(characteristics.isSigned() && encoding.isSetSign() && encoding.getSign().isSetSeparate());
        SchemaType xmlType = elem.getType();
        if (xmlType == null || xmlType.isURType()) {
            msg = MessageCatalog.getMessage("CCCR4040");
            err = msg.formatText(new Object[]{elem.getName()});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new EncoderConfigurationException(err);
        }
        if (xmlType.isSimpleType()) {
            characteristics.setSize(CocoDescriptionEntry.computeElementarySize(picture, RuleNode.cvtUsage(characteristics.getUsage()), characteristics.isSignSeparate()));
        } else {
            SchemaParticle model = xmlType.getContentModel();
            if (model == null || model.getParticleType() == 5 || model.getParticleType() != 4 && model.countOfParticleChild() == 0) {
                Message msg7 = MessageCatalog.getMessage("CCCR4041");
                String err7 = msg7.formatText(new Object[]{elem.getName()});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, err7);
                throw new EncoderConfigurationException(err7);
            }
            SchemaParticle[] parts = model.getParticleType() == 4 ? new SchemaParticle[]{model} : xmlType.getContentModel().getParticleChildren();
            int size = 0;
            for (int i = 0; i < parts.length; ++i) {
                if (!(parts[i] instanceof SchemaLocalElement)) {
                    Message msg8 = MessageCatalog.getMessage("CCCR4042");
                    String err8 = msg8.formatText(new Object[]{elem, new Integer(i)});
                    cErrorMgr.log(ErrorManager.Severity.ERROR, null, err8);
                    throw new EncoderConfigurationException(err8);
                }
                RuleNode childNode = new RuleNode();
                childNode.mParentNode = current;
                childNode.mIndex = i;
                childNode.mContext = context;
                RuleNode.readRule(childNode, (SchemaLocalElement)parts[i]);
                current.mChildList.add(childNode);
                int occurs = childNode.getOccursDependOn() != null ? 1 : childNode.getMaxOccurs();
                size += occurs * childNode.getCharacteristics().getSize();
            }
            characteristics.setSize(size);
            current.mChildren = current.mChildList.toArray(new RuleNode[0]);
        }
    }

    private static RuleNode findSibling(RuleNode current, String localName) {
        if (current.mParentNode.mChildList == null) {
            return null;
        }
        for (RuleNode node : current.mParentNode.mChildList) {
            if (!node.getQName().getLocalPart().equals(localName)) continue;
            return node;
        }
        return null;
    }

    private static RuleNode findNode(RuleNode top, String path) {
        if (path == null || path.length() == 0) {
            return top;
        }
        String[] steps = path.split("/");
        RuleNode current = top;
        RuleNode found = null;
        for (int i = 0; i < steps.length; ++i) {
            found = null;
            if (current.mChildList == null) break;
            for (RuleNode node : current.mChildList) {
                if (!steps[i].equals(node.getQName().getLocalPart())) continue;
                found = node;
                break;
            }
            if (found == null) break;
            current = found;
        }
        return found;
    }

    private static int cvtPictureCategory(int cocoPictureCategory) {
        switch (cocoPictureCategory) {
            case 1: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return 0;
    }

    private static int cvtUsage(CocoEncoding.Usage usage) {
        if (usage.isSetBinary()) {
            return 2;
        }
        if (usage.isSetComp() || usage.isSetComputational()) {
            return 3;
        }
        if (usage.isSetComp1() || usage.isSetComputational1()) {
            return 8;
        }
        if (usage.isSetComp2() || usage.isSetComputational2()) {
            return 9;
        }
        if (usage.isSetComp3() || usage.isSetComputational3()) {
            return 6;
        }
        if (usage.isSetComp4() || usage.isSetComputational4()) {
            return 4;
        }
        if (usage.isSetComp5() || usage.isSetComputational5()) {
            return 7;
        }
        if (usage.isSetDisplay()) {
            return 1;
        }
        if (usage.isSetDisplay1()) {
            return 10;
        }
        if (usage.isSetIndex()) {
            return 11;
        }
        if (usage.isSetPackedDecimal()) {
            return 5;
        }
        return 0;
    }

    private static int cvtUsage(int usage) {
        switch (usage) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 8: {
                return 21;
            }
            case 9: {
                return 22;
            }
            case 6: {
                return 23;
            }
            case 4: {
                return 24;
            }
            case 7: {
                return 25;
            }
            case 1: {
                return 3;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 5;
            }
            case 5: {
                return 4;
            }
        }
        return 3;
    }

    public static void main(String[] argv) {
        try {
            String xsdLocation = "test/data/redefcob2a.xsd";
            SchemaDocument schemaDoc = SchemaDocument.Factory.parse((File)new File(xsdLocation));
            SchemaTypeSystem ts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{schemaDoc}, (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), null);
            RuleNode topRule = RuleNode.readRules(ts, new QName("TESTCOB"));
            StringWriter writer = new StringWriter();
            topRule.dump(new Emit((Writer)writer, 0, 4));
            System.out.println(writer.toString());
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EncoderConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static class RuleContext {
        private RuleNode mTopRule;
        private List<RuleNode> mRedefinedNodeList = new ArrayList<RuleNode>();
        private List<RuleNode> mOccursDependOnList = new ArrayList<RuleNode>();
        private RuleNode[] mRedefinedNodes;
        private RuleNode[] mOccursDependOnNodes;
        private String mDisplayCharEncoding;
        private String mDisplay1CharEncoding;
        private String mPreDecodeCharCoding;
        private String mPostEncodeCharCoding;

        public RuleNode getTopRule() {
            return this.mTopRule;
        }

        public RuleNode[] getRedefinedNodes() {
            return this.mRedefinedNodes;
        }

        public RuleNode[] getOccursDependOnNodes() {
            return this.mOccursDependOnNodes;
        }

        public String getPreDecodeCharCoding() {
            return this.mPreDecodeCharCoding;
        }

        public String getPostEncodeCharCoding() {
            return this.mPostEncodeCharCoding;
        }

        static /* synthetic */ RuleNode[] access$302(RuleContext x0, RuleNode[] x1) {
            x0.mRedefinedNodes = x1;
            return x1;
        }

        static /* synthetic */ RuleNode[] access$502(RuleContext x0, RuleNode[] x1) {
            x0.mOccursDependOnNodes = x1;
            return x1;
        }
    }
}

