/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.runtime;

import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CobolCharacteristics {
    private static final int STRBUF_INITIAL_SIZE = 80;
    public static final int PIC_DEGENERATE = 0;
    public static final int PIC_ALPHA = 1;
    public static final int PIC_ALPHANUM = 2;
    public static final int PIC_ALPHANUME = 3;
    public static final int PIC_NUM = 4;
    public static final int PIC_NUME = 5;
    public static final int PIC_DBCS = 6;
    public static final int PIC_EXFLOAT = 7;
    public static final int MAX_PIC_VALUE = 7;
    public static final int USAGE_DEGENERATE = 0;
    public static final int USAGE_DISPLAY = 1;
    public static final int USAGE_BINARY = 2;
    public static final int USAGE_COMP = 3;
    public static final int USAGE_COMP4 = 4;
    public static final int USAGE_PACKED = 5;
    public static final int USAGE_COMP3 = 6;
    public static final int USAGE_COMP5 = 7;
    public static final int USAGE_COMP1 = 8;
    public static final int USAGE_COMP2 = 9;
    public static final int USAGE_DISPLAY1 = 10;
    public static final int USAGE_INDEX = 11;
    public static final int MAX_USAGE_VALUE = 11;
    private static Map<String, Integer> PIC_MAP;
    private static String[] PIC_ARRAY;
    private static Map<String, Integer> USAGE_MAP;
    private static String[] USAGE_ARRAY;
    private static final String DEGENERATE_PIC = "Degenerate.PIC";
    private static final String ALPHA_PIC = "Alphabetic";
    private static final String ALPHANUM_PIC = "Alphanumeric";
    private static final String ALPHANUME_PIC = "Alphanumeric-edited";
    private static final String NUM_PIC = "Numeric";
    private static final String NUME_PIC = "Numeric-edited";
    private static final String DBCS_PIC = "DBCS";
    private static final String EXFLOAT_PIC = "External floating point";
    private static final String DEGENERATE_USAGE = "Degenerate.USAGE";
    private static final String DISPLAY_USAGE = "Display";
    private static final String BINARY_USAGE = "Binary";
    private static final String COMP_USAGE = "Comp";
    private static final String COMP4_USAGE = "Comp4";
    private static final String PACKED_USAGE = "Packed";
    private static final String COMP3_USAGE = "Comp3";
    private static final String COMP5_USAGE = "Comp5";
    private static final String COMP1_USAGE = "Comp1";
    private static final String COMP2_USAGE = "Comp2";
    private static final String DISPLAY1_USAGE = "Display1";
    private static final String INDEX_USAGE = "Index";
    private final ErrorManager mErrorMgr = ErrorManager.getManager("STC.eWay.converter.COBOLCopybook." + CobolCharacteristics.class.getName());
    private int mUsage = 1;
    private int mPicture = 1;
    private int mSize;
    private int mScale;
    private int mScalingPositions;
    private boolean mIsSigned;
    private boolean mIsSignLeading;
    private boolean mIsSignSeparate;
    private boolean mIsBlankWhenZero;
    private boolean mIsJustified;

    public String toString() {
        return this.serialize();
    }

    public void fromString(String spec) {
        this.initialize(spec);
    }

    private String serialize() {
        StringBuffer strbuf = new StringBuffer(80);
        this.serializeCategory(strbuf);
        strbuf.append("!");
        this.serializeUsage(strbuf);
        strbuf.append("!");
        this.serializeScaling(strbuf);
        strbuf.append("!");
        this.serializeSize(strbuf);
        strbuf.append("!");
        this.serializeBasicFlags(strbuf);
        strbuf.append("!");
        this.serializeSignFlags(strbuf);
        return strbuf.toString();
    }

    private void initialize(String spec) {
        if (spec == null) {
            throw new NullPointerException();
        }
        StringTokenizer tokr = new StringTokenizer(spec, "!");
        try {
            this.initializeCategory(tokr);
            this.initializeUsage(tokr);
            this.initializeScaling(tokr);
            this.initializeSize(tokr);
            this.initializeBasicFlags(tokr);
            this.initializeSignFlags(tokr);
            this.initializeRedefinitionFlags(tokr);
        }
        catch (Exception e) {
            Message msg = MessageCatalog.getMessage("CCCD4005");
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, e, msg.formatText(new Object[]{e.getLocalizedMessage()}));
        }
    }

    private void initializeCategory(StringTokenizer tokr) {
        if (!tokr.hasMoreTokens()) {
            throw new IllegalArgumentException("Category unreadable");
        }
        String categoryToken = tokr.nextToken();
        Integer category = PIC_MAP.get(categoryToken);
        if (category == null) {
            throw new IllegalArgumentException("Invalid category information; scalar: " + categoryToken);
        }
        this.mPicture = category;
    }

    private void serializeCategory(StringBuffer buf) {
        buf.append(PIC_ARRAY[this.mPicture]);
    }

    private void initializeUsage(StringTokenizer tokr) {
        if (!tokr.hasMoreTokens()) {
            throw new IllegalArgumentException("Usage unreadable");
        }
        String usageToken = tokr.nextToken();
        Integer usage = USAGE_MAP.get(usageToken);
        if (usage == null) {
            throw new IllegalArgumentException("Invalid usage information; scalar: " + usageToken);
        }
        this.mUsage = usage;
    }

    private void serializeUsage(StringBuffer buf) {
        buf.append(USAGE_ARRAY[this.mUsage]);
    }

    private void initializeScaling(StringTokenizer tokr) {
        if (!tokr.hasMoreTokens()) {
            throw new IllegalArgumentException("Scaling unreadable");
        }
        String tuple = tokr.nextToken();
        StringTokenizer tupleTokr = new StringTokenizer(tuple, ",");
        if (tupleTokr.countTokens() < 2) {
            throw new IllegalArgumentException("Scaling 2-tuple unreadable");
        }
        Integer val = new Integer(tupleTokr.nextToken());
        this.mScale = val;
        val = new Integer(tupleTokr.nextToken());
        this.mScalingPositions = val;
    }

    private void serializeScaling(StringBuffer buf) {
        buf.append(this.mScale);
        buf.append(',');
        buf.append(this.mScalingPositions);
    }

    private void initializeSize(StringTokenizer tokr) {
        if (!tokr.hasMoreTokens()) {
            throw new IllegalArgumentException("Size unreadable");
        }
        Integer val = new Integer(tokr.nextToken());
        this.mSize = val;
    }

    private void serializeSize(StringBuffer buf) {
        buf.append(this.mSize);
    }

    private void initializeBasicFlags(StringTokenizer tokr) {
        if (!tokr.hasMoreTokens()) {
            throw new IllegalArgumentException("Basic flags unreadable");
        }
        StringTokenizer flagTokr = new StringTokenizer(tokr.nextToken(), ",");
        if (flagTokr.countTokens() < 3) {
            throw new IllegalArgumentException("Basic flag tuple unreadable");
        }
        this.mIsBlankWhenZero = this.flagToBoolean(flagTokr.nextToken());
        this.mIsJustified = this.flagToBoolean(flagTokr.nextToken());
    }

    private void serializeBasicFlags(StringBuffer buf) {
        buf.append(this.booleanToFlag(this.mIsBlankWhenZero));
        buf.append(',');
        buf.append(this.booleanToFlag(this.mIsJustified));
    }

    private void initializeSignFlags(StringTokenizer tokr) {
        if (!tokr.hasMoreTokens()) {
            throw new IllegalArgumentException("Sign flags unreadable");
        }
        StringTokenizer signTokr = new StringTokenizer(tokr.nextToken(), ",");
        if (signTokr.countTokens() < 3) {
            throw new IllegalArgumentException("Sign flag tuple unreadable");
        }
        this.mIsSigned = this.flagToBoolean(signTokr.nextToken());
        this.mIsSignLeading = this.flagToBoolean(signTokr.nextToken());
        this.mIsSignSeparate = this.flagToBoolean(signTokr.nextToken());
    }

    private void serializeSignFlags(StringBuffer buf) {
        buf.append(this.booleanToFlag(this.mIsSigned));
        buf.append(',');
        buf.append(this.booleanToFlag(this.mIsSignLeading));
        buf.append(',');
        buf.append(this.booleanToFlag(this.mIsSignSeparate));
    }

    private void initializeRedefinitionFlags(StringTokenizer tokr) {
        if (!tokr.hasMoreTokens()) {
            throw new IllegalArgumentException("Redefinition flags unreadable");
        }
        StringTokenizer redefTokr = new StringTokenizer(tokr.nextToken(), ",");
        if (redefTokr.countTokens() < 2) {
            throw new IllegalArgumentException("Redefinition flag tuple unreadable");
        }
    }

    private boolean flagToBoolean(String val) {
        switch (val.charAt(0)) {
            case '0': {
                return false;
            }
            case '1': {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid flag value " + val);
    }

    private char booleanToFlag(boolean bool) {
        if (bool) {
            return '1';
        }
        return '0';
    }

    public void setPicCategory(int category) {
        if (category < 0 || category >= PIC_ARRAY.length) {
            throw new ArrayIndexOutOfBoundsException(category);
        }
        this.mPicture = category;
    }

    public int getPicCategory() {
        return this.mPicture;
    }

    public void setUsage(int usage) {
        if (usage < 0 || usage >= USAGE_ARRAY.length) {
            throw new ArrayIndexOutOfBoundsException(usage);
        }
        this.mUsage = usage;
    }

    public int getUsage() {
        return this.mUsage;
    }

    public void setDecimalPosition(int pos) {
        this.mScale = pos = Math.max(0, pos);
    }

    public int getDecimalPosition() {
        return this.mScale;
    }

    public void setDecimalScalingPositions(int posses) {
        this.mScalingPositions = posses = Math.max(0, posses);
    }

    public int getDecimalScalingPositions() {
        return this.mScalingPositions;
    }

    public void setSize(int size) {
        this.mSize = size = Math.max(0, size);
    }

    public int getSize() {
        return this.mSize;
    }

    public void setJustified(boolean val) {
        this.mIsJustified = val;
    }

    public boolean isJustified() {
        return this.mIsJustified;
    }

    public void setSignSeparate(boolean val) {
        this.mIsSignSeparate = val;
    }

    public boolean isSignSeparate() {
        return this.mIsSignSeparate;
    }

    public void setSignLeading(boolean val) {
        this.mIsSignLeading = val;
    }

    public boolean isSignLeading() {
        return this.mIsSignLeading;
    }

    public void setSigned(boolean val) {
        this.mIsSigned = val;
    }

    public boolean isSigned() {
        return this.mIsSigned;
    }

    public void setBlankWhenZero(boolean val) {
        this.mIsBlankWhenZero = val;
    }

    public boolean isBlankWhenZero() {
        return this.mIsBlankWhenZero;
    }

    static {
        PIC_ARRAY = new String[8];
        USAGE_ARRAY = new String[12];
        PIC_MAP = new HashMap<String, Integer>();
        PIC_MAP.put(DEGENERATE_PIC, new Integer(0));
        PIC_MAP.put(ALPHA_PIC, new Integer(1));
        PIC_MAP.put(ALPHANUM_PIC, new Integer(2));
        PIC_MAP.put(ALPHANUME_PIC, new Integer(3));
        PIC_MAP.put(NUM_PIC, new Integer(4));
        PIC_MAP.put(NUME_PIC, new Integer(5));
        PIC_MAP.put(DBCS_PIC, new Integer(6));
        PIC_MAP.put(EXFLOAT_PIC, new Integer(7));
        PIC_MAP = Collections.unmodifiableMap(PIC_MAP);
        CobolCharacteristics.PIC_ARRAY[0] = DEGENERATE_PIC;
        CobolCharacteristics.PIC_ARRAY[1] = ALPHA_PIC;
        CobolCharacteristics.PIC_ARRAY[2] = ALPHANUM_PIC;
        CobolCharacteristics.PIC_ARRAY[3] = ALPHANUME_PIC;
        CobolCharacteristics.PIC_ARRAY[4] = NUM_PIC;
        CobolCharacteristics.PIC_ARRAY[5] = NUME_PIC;
        CobolCharacteristics.PIC_ARRAY[6] = DBCS_PIC;
        CobolCharacteristics.PIC_ARRAY[7] = EXFLOAT_PIC;
        USAGE_MAP = new HashMap<String, Integer>();
        USAGE_MAP.put(DEGENERATE_USAGE, new Integer(0));
        USAGE_MAP.put(DISPLAY_USAGE, new Integer(1));
        USAGE_MAP.put(BINARY_USAGE, new Integer(2));
        USAGE_MAP.put(COMP_USAGE, new Integer(3));
        USAGE_MAP.put(COMP4_USAGE, new Integer(4));
        USAGE_MAP.put(PACKED_USAGE, new Integer(5));
        USAGE_MAP.put(COMP3_USAGE, new Integer(6));
        USAGE_MAP.put(COMP5_USAGE, new Integer(7));
        USAGE_MAP.put(COMP1_USAGE, new Integer(8));
        USAGE_MAP.put(COMP2_USAGE, new Integer(9));
        USAGE_MAP.put(DISPLAY1_USAGE, new Integer(10));
        USAGE_MAP.put(INDEX_USAGE, new Integer(11));
        USAGE_MAP = Collections.unmodifiableMap(USAGE_MAP);
        CobolCharacteristics.USAGE_ARRAY[0] = DEGENERATE_USAGE;
        CobolCharacteristics.USAGE_ARRAY[1] = DISPLAY_USAGE;
        CobolCharacteristics.USAGE_ARRAY[2] = BINARY_USAGE;
        CobolCharacteristics.USAGE_ARRAY[3] = COMP_USAGE;
        CobolCharacteristics.USAGE_ARRAY[4] = COMP4_USAGE;
        CobolCharacteristics.USAGE_ARRAY[5] = PACKED_USAGE;
        CobolCharacteristics.USAGE_ARRAY[6] = COMP3_USAGE;
        CobolCharacteristics.USAGE_ARRAY[7] = COMP5_USAGE;
        CobolCharacteristics.USAGE_ARRAY[8] = COMP1_USAGE;
        CobolCharacteristics.USAGE_ARRAY[9] = COMP2_USAGE;
        CobolCharacteristics.USAGE_ARRAY[10] = DISPLAY1_USAGE;
        CobolCharacteristics.USAGE_ARRAY[11] = INDEX_USAGE;
    }
}

