/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.MemberInfoVisitor;

public class MemberInfoAccessFilter
implements MemberInfoVisitor {
    private static final int ACCESS_MASK = 7;
    private int requiredSetAccessFlags;
    private int requiredUnsetAccessFlags;
    private int requiredOneSetAccessFlags;
    private MemberInfoVisitor memberInfoVisitor;

    public MemberInfoAccessFilter(int n, int n2, MemberInfoVisitor memberInfoVisitor) {
        this.requiredSetAccessFlags = n & 0xFFFFFFF8;
        this.requiredUnsetAccessFlags = n2;
        this.requiredOneSetAccessFlags = n & 7;
        this.memberInfoVisitor = memberInfoVisitor;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (this.accepted(programFieldInfo.getAccessFlags())) {
            this.memberInfoVisitor.visitProgramFieldInfo(programClassFile, programFieldInfo);
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (this.accepted(programMethodInfo.getAccessFlags())) {
            this.memberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        if (this.accepted(libraryFieldInfo.getAccessFlags())) {
            this.memberInfoVisitor.visitLibraryFieldInfo(libraryClassFile, libraryFieldInfo);
        }
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        if (this.accepted(libraryMethodInfo.getAccessFlags())) {
            this.memberInfoVisitor.visitLibraryMethodInfo(libraryClassFile, libraryMethodInfo);
        }
    }

    private boolean accepted(int n) {
        return (this.requiredSetAccessFlags & ~n) == 0 && (this.requiredUnsetAccessFlags & n) == 0 && (this.requiredOneSetAccessFlags == 0 || (this.requiredOneSetAccessFlags & n) != 0);
    }
}

