/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class ClassesFromClasspath {
    private Vector errors;
    private int sizeErrors;
    private Vector<Path> entries;
    private int pos;
    private Path currentEntry;
    private boolean isIgnorableTrack = false;
    private final ClassLoader loader;

    public ClassesFromClasspath(boolean isIgnorableTrack) throws SecurityException {
        this(ClassesFromClasspath.getClasspath(), isIgnorableTrack);
    }

    public ClassesFromClasspath(String path, boolean isIgnorableTrack) {
        this.isIgnorableTrack = isIgnorableTrack;
        this.entries = new Vector();
        this.pos = 0;
        this.sizeErrors = 0;
        this.errors = new Vector();
        this.currentEntry = null;
        Vector<String> pathEntries = new Vector<String>();
        ArrayList<URL> urls = new ArrayList<URL>();
        while (path != null && path.length() > 0) {
            try {
                File pathEntry;
                String s;
                int index = path.indexOf(File.pathSeparatorChar);
                if (index == -1) {
                    s = path;
                    path = null;
                } else {
                    s = path.substring(0, index);
                    path = path.substring(index + 1);
                }
                if (s.endsWith(File.separator)) {
                    s = s.substring(0, s.length() - File.separator.length());
                }
                File canonicalEntry = pathEntry = new File(s);
                try {
                    canonicalEntry = pathEntry.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (pathEntries.contains(canonicalEntry.getPath())) continue;
                pathEntries.addElement(canonicalEntry.getPath());
                urls.add(canonicalEntry.toURL());
                if (pathEntry.isDirectory()) {
                    this.entries.addElement(new DirE(pathEntry));
                    continue;
                }
                try {
                    this.entries.addElement(new ZipE(pathEntry));
                }
                catch (IOException e) {
                    String error = "Ignoring " + pathEntry.getAbsolutePath() + ": " + e;
                    if (this.errors.contains(error) || !isIgnorableTrack) continue;
                    this.errors.addElement(error);
                }
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(ClassesFromClasspath.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.loader = new URLClassLoader(urls.toArray(new URL[0]));
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public boolean isThrowsTracked() {
        try {
            Class<ClassesFromClasspath> c = ClassesFromClasspath.class;
            Method met = c.getDeclaredMethod("getCurrentClass", new Class[0]);
            Class<?>[] exep = met.getExceptionTypes();
            return exep != null && exep.length != 0;
        }
        catch (Throwable t) {
            this.errors.addElement("Can not track that Method.getExceptionTypes() works correctly. " + t + " thrown.");
            ++this.sizeErrors;
            return false;
        }
    }

    public static String getClasspath() {
        String sysPath = System.getProperty("java.sys.class.path");
        String path = System.getProperty("java.class.path");
        if (sysPath == null || sysPath.equals("")) {
            return path;
        }
        return sysPath + File.pathSeparatorChar + path;
    }

    public int printErrors(PrintWriter out) {
        if (out == null) {
            return this.sizeErrors;
        }
        for (int i = 0; i < this.errors.size(); ++i) {
            out.println((String)this.errors.elementAt(i));
        }
        return this.sizeErrors;
    }

    public void clear() {
        this.pos = 0;
        this.currentEntry = null;
    }

    public String nextClassName() {
        String name = null;
        while ((this.currentEntry == null || (name = this.currentEntry.nextClassName()) == null) && this.pos < this.entries.size()) {
            this.currentEntry = this.entries.elementAt(this.pos);
            this.currentEntry.clear();
            ++this.pos;
        }
        return name;
    }

    public InputStream getCurrentClass() throws IOException {
        if (this.currentEntry == null) {
            return null;
        }
        return this.currentEntry.getCurrentClass();
    }

    public InputStream findClass(String name) throws IOException, ClassNotFoundException {
        for (int i = 0; i < this.entries.size(); ++i) {
            Path temp = this.entries.elementAt(i);
            try {
                InputStream classFile = temp.findClass(name);
                return classFile;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
        }
        throw new ClassNotFoundException(name);
    }

    private class ZipE
    implements Path {
        ZipFile zipfile;
        Enumeration entries;
        ZipEntry currentEntry;
        String lastName;

        ZipE(File zipfile) throws IOException {
            this.zipfile = new ZipFile(zipfile);
            this.entries = this.zipfile.entries();
            this.currentEntry = null;
            this.lastName = null;
        }

        public String nextClassName() {
            String name = "";
            while (!name.endsWith(".class") && this.entries.hasMoreElements()) {
                this.currentEntry = (ZipEntry)this.entries.nextElement();
                name = this.currentEntry.getName();
            }
            this.lastName = !name.endsWith(".class") ? null : name.substring(0, name.length() - 6).replace('/', '.');
            return this.lastName;
        }

        public InputStream getCurrentClass() throws IOException {
            if (this.currentEntry == null || this.lastName == null) {
                throw new IOException("The current class not exist.");
            }
            return this.zipfile.getInputStream(this.currentEntry);
        }

        public void clear() {
            this.entries = this.zipfile.entries();
            this.currentEntry = null;
            this.lastName = null;
        }

        public InputStream findClass(String name) throws IOException, ClassNotFoundException {
            ZipEntry zipEntry = this.zipfile.getEntry(name.replace('.', '/') + ".class");
            if (zipEntry == null) {
                throw new ClassNotFoundException();
            }
            return this.zipfile.getInputStream(zipEntry);
        }
    }

    private class DirE
    implements Path {
        String path;
        Vector classes;
        int pos;
        String lastName;

        DirE(File dir) {
            this.path = dir.getAbsolutePath();
            this.classes = new Vector();
            this.pos = -1;
            this.scanDir(dir, "");
            this.lastName = null;
        }

        private void scanDir(File dir, String pkg) {
            try {
                String[] files = dir.list();
                if (files == null) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    File f = new File(dir, files[i]);
                    if (files[i].endsWith(".class")) {
                        String prefName = pkg.equals("") ? pkg : pkg + ".";
                        this.classes.addElement(prefName + files[i].substring(0, files[i].length() - 6));
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    this.scanDir(f, pkg.equals("") ? files[i] : pkg + "." + files[i]);
                }
            }
            catch (SecurityException e) {
                String error = "The Security constraints does not allow to track " + pkg;
                if (!ClassesFromClasspath.this.errors.contains(error)) {
                    ClassesFromClasspath.this.errors.addElement(error);
                }
                ClassesFromClasspath.this.sizeErrors++;
            }
        }

        public String nextClassName() {
            ++this.pos;
            this.lastName = this.pos < this.classes.size() ? (String)this.classes.elementAt(this.pos) : null;
            return this.lastName;
        }

        public InputStream getCurrentClass() throws IOException {
            if (this.pos < 0 || this.lastName == null) {
                throw new IOException("The current class not exist.");
            }
            String name = (String)this.classes.elementAt(this.pos);
            if (File.separator.length() == 1) {
                name = this.path + File.separator + name.replace('.', File.separator.charAt(0)) + ".class";
            } else {
                String temp = this.path;
                while (name.indexOf(46) > 0) {
                    int n = name.indexOf(46);
                    temp = temp + File.separator + name.substring(0, n);
                    if (n >= name.length() - 1) break;
                    name = name.substring(n + 1);
                }
                name = temp;
            }
            File cl = new File(name);
            return new FileInputStream(cl);
        }

        public void clear() {
            this.pos = -1;
            this.lastName = null;
        }

        public InputStream findClass(String name) throws IOException, ClassNotFoundException {
            if (this.classes.contains(name)) {
                if (File.separator.length() == 1) {
                    name = this.path + File.separator + name.replace('.', File.separator.charAt(0)) + ".class";
                } else {
                    String temp = this.path;
                    while (name.indexOf(46) > 0) {
                        int n = name.indexOf(46);
                        temp = temp + File.separator + name.substring(0, n);
                        if (n >= name.length() - 1) break;
                        name = name.substring(n + 1);
                    }
                    name = temp;
                }
                File cl = new File(name);
                return new FileInputStream(cl);
            }
            throw new ClassNotFoundException(name);
        }
    }

    private static interface Path {
        public String nextClassName();

        public InputStream getCurrentClass() throws IOException;

        public void clear();

        public InputStream findClass(String var1) throws IOException, ClassNotFoundException;
    }
}

