/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.messageformat.commarea;

import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.messageformat.FieldDescriptor;
import it.imolinfo.jbi4cics.messageformat.commarea.CommareaBeanMappingDescriptor;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolType;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolTypeDescriptor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;

public class NestingHandler {
    private static final Messages MESSAGES = Messages.getMessages(NestingHandler.class);

    public static CommareaBeanMappingDescriptor handleNesting(CommareaBeanMappingDescriptor commareaBeanMappingDescriptor) throws FormatException {
        CommareaBeanMappingDescriptor result;
        CommareaBeanMappingDescriptor currentCommareaBeanMappingDescriptor = result = new CommareaBeanMappingDescriptor();
        Integer currentLevel = 0;
        Stack<CommareaBeanMappingDescriptor> commareaStack = new Stack<CommareaBeanMappingDescriptor>();
        Stack<Integer> levelStack = new Stack<Integer>();
        Map<String, FieldDescriptor> fieldMap = commareaBeanMappingDescriptor.getFieldMap();
        ArrayList<String> fieldList = new ArrayList<String>(fieldMap.keySet());
        block5: for (int i = 0; i < fieldList.size(); ++i) {
            String propertyName = (String)fieldList.get(i);
            CobolTypeDescriptor cobolTypeDescriptor = (CobolTypeDescriptor)fieldMap.get(propertyName);
            if (i == 0) {
                currentLevel = cobolTypeDescriptor.getLevel();
            }
            if (i == fieldList.size() - 1) {
                currentCommareaBeanMappingDescriptor.addFieldMapping(propertyName, cobolTypeDescriptor.getName(), (FieldDescriptor)cobolTypeDescriptor);
                continue;
            }
            Integer nextLevel = ((CobolTypeDescriptor)fieldMap.get(fieldList.get(i + 1))).getLevel();
            switch (currentLevel.compareTo(nextLevel)) {
                case 0: {
                    currentCommareaBeanMappingDescriptor.addFieldMapping(propertyName, cobolTypeDescriptor.getName(), (FieldDescriptor)cobolTypeDescriptor);
                    continue block5;
                }
                case -1: {
                    if (cobolTypeDescriptor.getType() != CobolType.NESTED_COMMAREA && cobolTypeDescriptor.getType() != CobolType.OCCURS) {
                        throw new FormatException(MESSAGES.getString("CIC001704_Not_nested_field", cobolTypeDescriptor.getName(), currentLevel, nextLevel));
                    }
                    currentCommareaBeanMappingDescriptor.addFieldMapping(propertyName, cobolTypeDescriptor.getName(), (FieldDescriptor)cobolTypeDescriptor);
                    levelStack.push(currentLevel);
                    currentLevel = nextLevel;
                    commareaStack.push(currentCommareaBeanMappingDescriptor);
                    currentCommareaBeanMappingDescriptor = new CommareaBeanMappingDescriptor();
                    cobolTypeDescriptor.setNestedCommarea(currentCommareaBeanMappingDescriptor);
                    continue block5;
                }
                case 1: {
                    currentCommareaBeanMappingDescriptor.addFieldMapping(propertyName, cobolTypeDescriptor.getName(), (FieldDescriptor)cobolTypeDescriptor);
                    currentLevel = (Integer)levelStack.pop();
                    currentCommareaBeanMappingDescriptor = (CommareaBeanMappingDescriptor)commareaStack.pop();
                    continue block5;
                }
                default: {
                    throw new FormatException(MESSAGES.getString("CIC001705_Unreachable_code", new Object[0]));
                }
            }
        }
        return result;
    }
}

