/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection.jdbc.util;

import it.imolinfo.jbi4cics.connection.jdbc.util.StatementInvocationHandler;
import java.sql.SQLException;
import java.sql.Statement;

class PreparedStatementInvocationHandler
extends StatementInvocationHandler {
    protected String sql;
    protected int autoGeneratedKeys = -1;
    protected int[] columnIndexes;
    protected String[] columnNames;

    public PreparedStatementInvocationHandler(String sql) {
        this.sql = sql;
    }

    public PreparedStatementInvocationHandler(String sql, int autoGeneratedKeys) {
        this.sql = sql;
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public PreparedStatementInvocationHandler(String sql, int[] columnIndexes) {
        this.sql = sql;
        this.columnIndexes = columnIndexes;
    }

    public PreparedStatementInvocationHandler(String sql, int resultSetType, int resultSetConcurrency) {
        super(resultSetType, resultSetConcurrency);
        this.sql = sql;
    }

    public PreparedStatementInvocationHandler(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.sql = sql;
    }

    public PreparedStatementInvocationHandler(String sql, String[] columnNames) {
        this.sql = sql;
        this.columnNames = columnNames;
    }

    protected Statement createStatement() throws SQLException {
        if (this.columnNames != null) {
            return this.getConnection().prepareStatement(this.sql, this.columnNames);
        }
        if (this.columnIndexes != null) {
            return this.getConnection().prepareStatement(this.sql, this.columnIndexes);
        }
        if (this.autoGeneratedKeys != -1) {
            return this.getConnection().prepareStatement(this.sql, this.autoGeneratedKeys);
        }
        return this.getConnection().prepareStatement(this.sql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }
}

