/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PDFRenderer {
    public static void renderToPDF(String url, String pdf) throws IOException, DocumentException {
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocument(url);
        PDFRenderer.doRenderToPDF(renderer, pdf);
    }

    public static void renderToPDF(File file, String pdf) throws IOException, DocumentException {
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocument(file);
        PDFRenderer.doRenderToPDF(renderer, pdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRenderToPDF(ITextRenderer renderer, String pdf) throws IOException, DocumentException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(pdf);
            renderer.layout();
            renderer.createPDF(os);
            ((OutputStream)os).close();
            os = null;
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) throws IOException, DocumentException {
        String url;
        if (args.length != 2) {
            PDFRenderer.usage("Incorrect argument list.");
        }
        if ((url = args[0]).indexOf("://") == -1) {
            File f = new File(url);
            if (f.exists()) {
                PDFRenderer.renderToPDF(f, args[1]);
            } else {
                PDFRenderer.usage("File to render is not found: " + url);
            }
        } else {
            PDFRenderer.renderToPDF(url, args[1]);
        }
    }

    private static void usage(String err) {
        if (err != null && err.length() > 0) {
            System.err.println("==>" + err);
        }
        System.err.println("Usage: ... [url] [pdf]");
        System.exit(1);
    }
}

