/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.component.runtime;

import it.imolinfo.jbi4corba.jbi.component.runtime.MessageExchangeHandler;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;

public class MessageExchangeReceiver {
    private static final long DC_ACCEPT_TIME_OUT = 3000L;
    private static final long RECEIVER_WAIT_TIME = 2000L;
    private static final long RECEIVER_SHUTDOWN_WAIT_TIME = 10L;
    private static final long HANDLERS_SHUTDOWN_WAIT_TIME = 30L;
    private static final int HANDLER_THREAD_POOL_SIZE = 5;
    private Boolean mCanAccept = false;
    private Boolean mContinue = true;
    private ExecutorService mReceiverThreadMgr;
    private ExecutorService mHandlerThreadPool;

    public final void initReceiver() throws Exception {
        this.mHandlerThreadPool = Executors.newFixedThreadPool(5);
        this.mReceiverThreadMgr = Executors.newSingleThreadExecutor();
        this.mReceiverThreadMgr.execute(new Runnable(){

            public void run() {
                Thread t = Thread.currentThread();
                while (MessageExchangeReceiver.this.mContinue.booleanValue()) {
                    if (MessageExchangeReceiver.this.mCanAccept.booleanValue()) {
                        MessageExchangeReceiver.this.receiveAndProcessMessageExchange();
                        continue;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptException) {
                        RuntimeHelper.logDebug("Interrupted the MessageReceiverThread in Sleep");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdownReceiver() throws Exception {
        Boolean bl = this.mContinue;
        synchronized (bl) {
            this.mContinue = false;
        }
        boolean terminated = false;
        try {
            this.mReceiverThreadMgr.shutdown();
            terminated = this.mReceiverThreadMgr.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            RuntimeHelper.logDebug(ex);
        }
        finally {
            if (!terminated) {
                RuntimeHelper.logDebug("Message Receiver not shutdown. Forcing shutdown");
                this.mReceiverThreadMgr.shutdownNow();
            }
        }
        this.shutdownHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void shutdownHandlers() throws Exception {
        boolean terminated = false;
        try {
            this.mHandlerThreadPool.shutdown();
            terminated = this.mHandlerThreadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            RuntimeHelper.logDebug(ex);
        }
        finally {
            if (!terminated) {
                RuntimeHelper.logDebug("Handler threads not shutdown. Forcing shutdown");
                this.mHandlerThreadPool.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startProcessing() throws Exception {
        Boolean bl = this.mCanAccept;
        synchronized (bl) {
            this.mCanAccept = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopProcessing() throws Exception {
        Boolean bl = this.mCanAccept;
        synchronized (bl) {
            this.mCanAccept = false;
        }
    }

    private void receiveAndProcessMessageExchange() {
        try {
            DeliveryChannel channel = RuntimeHelper.getDeliveryChannel();
            MessageExchange msgExchange = null;
            if (channel == null) {
                RuntimeHelper.logDebug("DeliveryChannel Not Opened for receiving messages");
                return;
            }
            msgExchange = channel.accept(3000L);
            if (msgExchange == null) {
                return;
            }
            MessageExchangeHandler handler = this.findMessageExchangeHandler(msgExchange);
            if (handler == null) {
                RuntimeHelper.logError("######## MessageExchagneHandler is NULL. CAN NOT PROCESS RECEIVED MESSAGE EXCHANGE ######### \n" + msgExchange);
                return;
            }
            handler.setMessageExchange(msgExchange);
            this.mHandlerThreadPool.execute(handler);
        }
        catch (MessagingException ex) {
            RuntimeHelper.logWarning((Object)ex);
            ex.printStackTrace();
        }
    }

    private MessageExchangeHandler findMessageExchangeHandler(MessageExchange msgExchange) {
        MessageExchangeHandler handler = null;
        handler = RuntimeContext.getInstance().newMessageExchangeHandler(msgExchange);
        return handler;
    }
}

