/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.awt;

import com.sun.perseus.awt.SVGComponent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ZoomPanInteractor
implements MouseListener,
KeyListener {
    protected SVGComponent cmp;
    protected int singleStepPan = 10;
    protected int largeStepPan = 50;
    protected float zoomFactor = 1.1f;

    public ZoomPanInteractor(SVGComponent cmp) {
        this(cmp, 10, 50, 1.1f);
    }

    public ZoomPanInteractor(SVGComponent cmp, int singleStepPan, int largeStepPan, float zoomFactor) {
        this.cmp = cmp;
        this.singleStepPan = singleStepPan;
        this.largeStepPan = largeStepPan;
        this.zoomFactor = zoomFactor;
        cmp.addMouseListener(this);
        cmp.addKeyListener(this);
    }

    public void zoomAbout(float zoomFactor, float aboutX, float aboutY) {
        if (zoomFactor == 0.0f) {
            throw new IllegalArgumentException();
        }
        this.cmp.addZoomPan(zoomFactor, -aboutX + aboutX / zoomFactor, -aboutY + aboutY / zoomFactor);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            if (e.isShiftDown()) {
                this.zoomAbout(1.0f / this.zoomFactor, e.getX(), e.getY());
            } else {
                this.zoomAbout(this.zoomFactor, e.getX(), e.getY());
            }
        }
        this.cmp.requestFocus();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        block17: {
            block14: {
                int panStep;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block16: {
                                        block15: {
                                            if (!e.isControlDown()) break block14;
                                            panStep = this.singleStepPan;
                                            if (e.isShiftDown()) {
                                                panStep = this.largeStepPan;
                                            }
                                            if (e.getKeyCode() == 37) break block15;
                                            if (e.getKeyCode() == 226) break block15;
                                            if (e.getKeyCode() != 74) break block16;
                                        }
                                        this.cmp.addZoomPan(1.0f, -panStep, 0.0f);
                                        break block17;
                                    }
                                    if (e.getKeyCode() == 39) break block18;
                                    if (e.getKeyCode() == 227) break block18;
                                    if (e.getKeyCode() != 76) break block19;
                                }
                                this.cmp.addZoomPan(1.0f, panStep, 0.0f);
                                break block17;
                            }
                            if (e.getKeyCode() == 38) break block20;
                            if (e.getKeyCode() == 224) break block20;
                            if (e.getKeyCode() != 73) break block21;
                        }
                        this.cmp.addZoomPan(1.0f, 0.0f, -panStep);
                        break block17;
                    }
                    if (e.getKeyCode() == 40) break block22;
                    if (e.getKeyCode() == 225) break block22;
                    if (e.getKeyCode() != 77) break block17;
                }
                this.cmp.addZoomPan(1.0f, 0.0f, panStep);
                break block17;
            }
            if (e.getKeyCode() == 90) {
                this.zoomAbout(this.zoomFactor, 50.0f, 50.0f);
            } else if (e.getKeyCode() == 88) {
                this.zoomAbout(1.0f / this.zoomFactor, 50.0f, 50.0f);
            } else if (e.getKeyCode() == 85) {
                this.cmp.addZoomPan(1.0f, 0.0f, -this.singleStepPan);
            } else if (e.getKeyCode() == 68) {
                this.cmp.addZoomPan(1.0f, 0.0f, this.singleStepPan);
            } else if (e.getKeyCode() == 82) {
                this.cmp.addZoomPan(1.0f, this.singleStepPan, 0.0f);
            } else if (e.getKeyCode() == 76) {
                this.cmp.addZoomPan(1.0f, -this.singleStepPan, 0.0f);
            }
        }
    }
}

