/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.webservice.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class JarUtil {
    private static final int BUFFER_LENGTH = 1024;

    private JarUtil() {
    }

    public static void unjar(File jarFile, File targetDir) throws IOException {
        if (targetDir.exists()) {
            targetDir.delete();
        }
        targetDir.mkdirs();
        String targetPath = targetDir.getAbsolutePath() + File.separatorChar;
        byte[] buffer = new byte[0x100000];
        JarFile input = new JarFile(jarFile, false, 1);
        Enumeration<JarEntry> enumeration = input.entries();
        while (enumeration.hasMoreElements()) {
            int read;
            JarEntry entry = enumeration.nextElement();
            if (entry.isDirectory() || entry.getName().indexOf("package cache") != -1) continue;
            String path = targetPath + entry.getName();
            File file = new File(path);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            InputStream in = input.getInputStream(entry);
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            in.close();
            out.close();
        }
    }

    public static void unjar(File jarFile, String resource, File targetDir) throws IOException {
        if (targetDir.exists()) {
            targetDir.delete();
        }
        targetDir.mkdirs();
        String targetPath = targetDir.getAbsolutePath() + File.separatorChar;
        byte[] buffer = new byte[0x100000];
        JarFile input = new JarFile(jarFile, false, 1);
        Enumeration<JarEntry> enumeration = input.entries();
        while (enumeration.hasMoreElements()) {
            int read;
            JarEntry entry = enumeration.nextElement();
            if (entry.isDirectory() || !entry.getName().equals(resource)) continue;
            String path = targetPath + entry.getName();
            File file = new File(path);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            InputStream in = input.getInputStream(entry);
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            in.close();
            out.close();
        }
    }
}

