/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.idoc;

import com.sap.mw.idoc.util.Enum;
import com.sap.mw.idoc.util.ObjectList;
import com.sap.mw.idoc.util.SyncDateFormat;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class IDoc {
    public static final int CHECK_MANDATORY_DOCUMENT_FIELDS = 1;
    public static final int CHECK_DOCUMENT_FIELD_VALUES = 2;
    public static final int CHECK_MANDATORY_SEGMENTS = 4;
    public static final int CHECK_SEGMENTS_OCCURRENCE_LIMITS = 8;
    public static final int CHECK_MANDATORY_CHILD_SEGMENTS = 4;
    public static final int CHECK_CHILD_SEGMENTS_OCCURRENCE_LIMITS = 8;
    public static final int CHECK_SEGMENT_FIELD_VALUES = 512;
    public static final int CHECK_CURRENT_SEGMENT_ONLY = 65536;
    public static final int ITERATE_OVER_ALL = 1;
    public static final int ITERATE_OVER_ALL_OF_SAME_TYPE = 2;
    public static final int ITERATE_OVER_SIBLINGS = 3;
    public static final int ITERATE_OVER_SIBLINGS_OF_SAME_TYPE = 4;
    public static final int ITERATE_OVER_CHILDREN = 5;
    public static final int ITERATE_OVER_DESCENDANTS = 6;
    protected static final String ROOT = "ROOT";
    protected static final String ROOT_SEGMENT_DESCRIPTION = "General root segment";
    private static String m_systemDefaultCharEncoding = null;

    protected IDoc() {
    }

    protected static int compareVersions(String version1, String version2) throws NumberFormatException {
        if (version1 == null) {
            if (version2 == null) {
                return 0;
            }
            if (version2.length() == 0) {
                return -1;
            }
            if (version2.equals("0")) {
                return -1;
            }
            version1 = "0";
        }
        if (version2 == null) {
            if (version1.length() == 0) {
                return 1;
            }
            if (version1.equals("0")) {
                return 1;
            }
            version2 = "0";
        }
        if (version1.length() == 0) {
            if (version2.length() == 0) {
                return 0;
            }
            if (version2.equals("0")) {
                return -1;
            }
            version1 = "0";
        }
        if (version2.length() == 0) {
            if (version1.equals("0")) {
                return 1;
            }
            version2 = "0";
        }
        int e1 = -1;
        int e2 = -1;
        int v1 = 0;
        int v2 = 0;
        do {
            int s1 = e1 + 1;
            int s2 = e2 + 1;
            e1 = version1.indexOf(46, s1);
            e2 = version2.indexOf(46, s2);
            if (e1 == -1) {
                e1 = version1.length();
            }
            if (e2 == -1) {
                e2 = version2.length();
            }
            if ((v1 = Integer.parseInt(version1.substring(s1, e1))) > (v2 = Integer.parseInt(version2.substring(s2, e2)))) {
                return 1;
            }
            if (v1 >= v2) continue;
            return -1;
        } while (e1 < version1.length() && e2 < version2.length());
        if (e1 == version1.length() && e2 == version2.length()) {
            return 0;
        }
        if (e1 == version1.length()) {
            return -1;
        }
        return 1;
    }

    protected static void copySegmentDataToCharArray(Segment segment, char[] dest, int destOffset, int destLength) {
        if (segment == null || dest == null || destOffset < 0 || destOffset > dest.length || destLength <= 0) {
            return;
        }
        RecordMetaData recordMetaData = segment.getRecordMetaData();
        if (recordMetaData == null) {
            return;
        }
        int destEndOffset = destOffset + destLength;
        if (destEndOffset >= dest.length) {
            destEndOffset = dest.length - 1;
        }
        String field = null;
        int numFields = recordMetaData.getNumFields();
        int metaLength = 0;
        int metaOffset = 0;
        int offset = 0;
        int endOffset = 0;
        int numChars = 0;
        int i = 0;
        while (i < numFields) {
            field = segment.getString(recordMetaData.getName(i));
            metaLength = recordMetaData.getInternalLength(i);
            metaOffset = recordMetaData.getOffset(i);
            offset = destOffset + metaOffset;
            if (i + 1 < numFields) {
                endOffset = destOffset + recordMetaData.getOffset(i + 1);
                if (endOffset > destEndOffset) {
                    endOffset = destEndOffset;
                    i = numFields;
                }
            } else {
                endOffset = destEndOffset;
            }
            if (field != null) {
                numChars = field.length();
                if (offset + metaLength > endOffset) {
                    metaLength = endOffset - offset;
                }
                if (numChars > metaLength) {
                    numChars = metaLength;
                }
                field.getChars(0, numChars, dest, offset);
                offset += numChars;
            }
            while (offset < endOffset) {
                dest[offset++] = 32;
            }
            ++i;
        }
    }

    public static String getVersion() {
        return "1.0.4 (2006-10-10)";
    }

    protected static String getSystemDefaultCharEncoding() {
        if (m_systemDefaultCharEncoding == null) {
            m_systemDefaultCharEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
        }
        return m_systemDefaultCharEncoding;
    }

    protected static String removeAllDotsFromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(46) < 0) {
            return string;
        }
        int length = string.length();
        StringBuffer strBuf = new StringBuffer(length - 1);
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c != '.') {
                strBuf.append(c);
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static class SyntaxException
    extends Exception {
        private Record m_record = null;
        private String m_fieldName = null;

        protected SyntaxException(String detailMessage) {
            super(1, detailMessage);
        }

        public SyntaxException(Record record, String detailMessage) {
            this(detailMessage);
            this.m_record = record;
        }

        public SyntaxException(Record record, String fieldName, String detailMessage) {
            this(detailMessage);
            this.m_record = record;
            this.m_fieldName = fieldName;
        }

        public Document getDocument() {
            if (this.m_record instanceof Document) {
                return (Document)this.m_record;
            }
            if (this.m_record instanceof Segment) {
                return ((Segment)this.m_record).getDocument();
            }
            return null;
        }

        public String getFieldName() {
            return this.m_fieldName;
        }

        public Record getRecord() {
            return this.m_record;
        }

        public Segment getSegment() {
            if (this.m_record instanceof Segment) {
                return (Segment)this.m_record;
            }
            return null;
        }
    }

    public static class SegmentMetaData
    implements Serializable {
        private static final long serialVersionUID = 1000L;
        protected String m_iDocType = null;
        protected String m_iDocTypeExtension = null;
        protected String m_systemRelease = null;
        protected String m_applicationRelease = null;
        protected String m_type = null;
        protected String m_definition = null;
        protected int m_hierarchyLevel = 0;
        protected String m_description = null;
        protected boolean m_mandatoryFlag = false;
        protected long m_minOccurrence = 0L;
        protected long m_maxOccurrence = 0L;
        protected boolean m_qualifiedFlag = false;
        protected SegmentMetaData m_parent = null;
        protected RecordMetaData m_recordMetaData = null;
        protected SegmentMetaDataList m_childs = new SegmentMetaDataList(5);
        protected transient String m_key = null;

        protected SegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, String definition, int hierarchyLevel, String description, RecordMetaData recordMetaData) {
            this.m_iDocType = iDocType != null ? iDocType : "";
            this.m_iDocTypeExtension = iDocTypeExtension != null ? iDocTypeExtension : "";
            this.m_systemRelease = systemRelease != null ? IDoc.removeAllDotsFromString(systemRelease) : "";
            this.m_applicationRelease = applicationRelease != null ? IDoc.removeAllDotsFromString(applicationRelease) : "";
            this.m_type = type != null ? type : "";
            this.m_definition = definition != null ? definition : "";
            this.m_hierarchyLevel = hierarchyLevel;
            this.m_description = description != null ? description : "";
            this.m_mandatoryFlag = true;
            this.m_minOccurrence = 1L;
            this.m_maxOccurrence = 1L;
            this.m_qualifiedFlag = false;
            this.m_recordMetaData = recordMetaData;
        }

        protected SegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, String definition, int hierarchyLevel, String description, boolean mandatoryFlag, long minOccurrence, long maxOccurrence, boolean qualifiedFlag, RecordMetaData recordMetaData) {
            this.m_iDocType = iDocType != null ? iDocType : "";
            this.m_iDocTypeExtension = iDocTypeExtension != null ? iDocTypeExtension : "";
            this.m_systemRelease = systemRelease != null ? IDoc.removeAllDotsFromString(systemRelease) : "";
            this.m_applicationRelease = applicationRelease != null ? IDoc.removeAllDotsFromString(applicationRelease) : "";
            this.m_type = type != null ? type : "";
            this.m_definition = definition != null ? definition : "";
            this.m_hierarchyLevel = hierarchyLevel;
            this.m_description = description != null ? description : "";
            this.m_mandatoryFlag = mandatoryFlag;
            this.m_minOccurrence = minOccurrence;
            this.m_maxOccurrence = maxOccurrence;
            this.m_qualifiedFlag = qualifiedFlag;
            this.m_recordMetaData = recordMetaData;
        }

        protected void addChild(SegmentMetaData child) {
            this.m_childs.add(child);
            child.m_parent = this;
        }

        protected static final String calculateTypeFromDefinition(String definition, boolean enableVersionDeletion) {
            int length;
            if (definition == null) {
                return null;
            }
            StringBuffer type = null;
            if (enableVersionDeletion && (length = definition.length()) > 3) {
                boolean versionDetected = true;
                int i = length - 1;
                while (versionDetected && i > length - 4) {
                    if (!Character.isDigit(definition.charAt(i))) {
                        versionDetected = false;
                    }
                    --i;
                }
                if (versionDetected) {
                    type = new StringBuffer(definition.substring(0, length - 3));
                }
            }
            if (type == null) {
                type = new StringBuffer(definition);
            }
            if (type.length() > 1 && type.charAt(0) != '/' && type.charAt(1) == '2') {
                type.setCharAt(1, '1');
            }
            return type.toString();
        }

        public static String createKey(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
            StringBuffer key = new StringBuffer(100);
            key.append(iDocType);
            key.append('|');
            if (iDocTypeExtension != null) {
                key.append(iDocTypeExtension);
            }
            key.append('|');
            if (systemRelease != null) {
                key.append(IDoc.removeAllDotsFromString(systemRelease));
            }
            key.append('|');
            if (applicationRelease != null) {
                key.append(IDoc.removeAllDotsFromString(applicationRelease));
            }
            key.append('|');
            key.append(definition);
            return key.toString();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof SegmentMetaData)) {
                return false;
            }
            SegmentMetaData segmentMetaData = (SegmentMetaData)object;
            if (this.m_iDocType != null ? !this.m_iDocType.equals(segmentMetaData.getIDocType()) : segmentMetaData.getIDocType() != null) {
                return false;
            }
            if (this.m_iDocTypeExtension != null ? !this.m_iDocTypeExtension.equals(segmentMetaData.getIDocTypeExtension()) : segmentMetaData.getIDocTypeExtension() != null) {
                return false;
            }
            if (this.m_systemRelease != null ? !this.m_systemRelease.equals(segmentMetaData.getSystemRelease()) : segmentMetaData.getSystemRelease() != null) {
                return false;
            }
            if (this.m_applicationRelease != null ? !this.m_applicationRelease.equals(segmentMetaData.getApplicationRelease()) : segmentMetaData.getApplicationRelease() != null) {
                return false;
            }
            if (this.m_type != null ? !this.m_type.equals(segmentMetaData.getType()) : segmentMetaData.getType() != null) {
                return false;
            }
            if (this.m_definition != null ? !this.m_definition.equals(segmentMetaData.getDefinition()) : segmentMetaData.getDefinition() != null) {
                return false;
            }
            if (this.m_hierarchyLevel != segmentMetaData.getHierarchyLevel()) {
                return false;
            }
            if (this.m_description != null ? !this.m_description.equals(segmentMetaData.getDescription()) : segmentMetaData.getDescription() != null) {
                return false;
            }
            if (this.m_mandatoryFlag != segmentMetaData.isMandatory()) {
                return false;
            }
            if (this.m_minOccurrence != segmentMetaData.getMinOccurrence()) {
                return false;
            }
            if (this.m_maxOccurrence != segmentMetaData.getMaxOccurrence()) {
                return false;
            }
            if (this.m_qualifiedFlag != segmentMetaData.isQualified()) {
                return false;
            }
            if (this.m_recordMetaData != null ? !this.m_recordMetaData.equals(segmentMetaData.getRecordMetaData()) : segmentMetaData.getRecordMetaData() != null) {
                return false;
            }
            if (this.m_childs.size() != segmentMetaData.getNumChildren()) {
                return false;
            }
            SegmentMetaData myRootSegmentMetaData = this;
            while (!myRootSegmentMetaData.isRoot()) {
                myRootSegmentMetaData = myRootSegmentMetaData.getParent();
                if (!segmentMetaData.isRoot()) {
                    segmentMetaData = segmentMetaData.getParent();
                    continue;
                }
                return false;
            }
            if (!segmentMetaData.isRoot()) {
                return false;
            }
            return myRootSegmentMetaData.equalsIgnoreParent(segmentMetaData);
        }

        public boolean equalsIgnoreParent(SegmentMetaData segmentMetaData) {
            if (segmentMetaData == this) {
                return true;
            }
            if (segmentMetaData == null) {
                return false;
            }
            if (this.m_iDocType != null ? !this.m_iDocType.equals(segmentMetaData.m_iDocType) : segmentMetaData.m_iDocType != null) {
                return false;
            }
            if (this.m_iDocTypeExtension != null ? !this.m_iDocTypeExtension.equals(segmentMetaData.m_iDocTypeExtension) : segmentMetaData.m_iDocTypeExtension != null) {
                return false;
            }
            if (this.m_systemRelease != null ? !this.m_systemRelease.equals(segmentMetaData.m_systemRelease) : segmentMetaData.m_systemRelease != null) {
                return false;
            }
            if (this.m_applicationRelease != null ? !this.m_applicationRelease.equals(segmentMetaData.m_applicationRelease) : segmentMetaData.m_applicationRelease != null) {
                return false;
            }
            if (this.m_type != null ? !this.m_type.equals(segmentMetaData.m_type) : segmentMetaData.m_type != null) {
                return false;
            }
            if (this.m_definition != null ? !this.m_definition.equals(segmentMetaData.m_definition) : segmentMetaData.m_definition != null) {
                return false;
            }
            if (this.m_hierarchyLevel != segmentMetaData.m_hierarchyLevel) {
                return false;
            }
            if (this.m_description != null ? !this.m_description.equals(segmentMetaData.m_description) : segmentMetaData.m_description != null) {
                return false;
            }
            if (this.m_mandatoryFlag != segmentMetaData.m_mandatoryFlag) {
                return false;
            }
            if (this.m_minOccurrence != segmentMetaData.m_minOccurrence) {
                return false;
            }
            if (this.m_maxOccurrence != segmentMetaData.m_maxOccurrence) {
                return false;
            }
            if (this.m_qualifiedFlag != segmentMetaData.m_qualifiedFlag) {
                return false;
            }
            if (this.m_recordMetaData != null ? !this.m_recordMetaData.equals(segmentMetaData.m_recordMetaData) : segmentMetaData.m_recordMetaData != null) {
                return false;
            }
            if (this.m_childs != segmentMetaData.m_childs) {
                if (this.m_childs == null || segmentMetaData.m_childs == null) {
                    return false;
                }
                if (this.m_childs.size() != segmentMetaData.m_childs.size()) {
                    return false;
                }
                int i = 0;
                while (i < this.m_childs.size()) {
                    if (!this.m_childs.get(i).equalsIgnoreParent(segmentMetaData.m_childs.get(i))) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        public String getApplicationRelease() {
            return this.m_applicationRelease;
        }

        public SegmentMetaData getChild(int index) {
            return this.m_childs.get(index);
        }

        public SegmentMetaData getChildByDefinition(String definition) {
            if (definition != null) {
                SegmentMetaData child = null;
                int numChilds = this.m_childs.size();
                int i = 0;
                while (i < numChilds) {
                    child = this.m_childs.get(i);
                    if (definition.equals(child.getDefinition())) {
                        return child;
                    }
                    ++i;
                }
            }
            return null;
        }

        public SegmentMetaData getChildByType(String type) {
            if (type != null) {
                SegmentMetaData child = null;
                int numChilds = this.m_childs.size();
                int i = 0;
                while (i < numChilds) {
                    child = this.m_childs.get(i);
                    if (type.equals(child.getType())) {
                        return child;
                    }
                    ++i;
                }
            }
            return null;
        }

        public SegmentMetaData getChildMatchingDefinition(String definition) {
            String type;
            SegmentMetaData child = null;
            if (definition != null && this.m_childs != null && (child = this.getChildByDefinition(definition)) == null && (child = this.getChildByType(type = SegmentMetaData.calculateTypeFromDefinition(definition, true))) == null && type.length() < definition.length()) {
                type = SegmentMetaData.calculateTypeFromDefinition(definition, false);
                child = this.getChildByType(type);
            }
            return child;
        }

        public SegmentMetaData[] getChildren() {
            return this.m_childs.toArray();
        }

        public String[] getChildTypes() {
            int numChildren = this.m_childs.size();
            String[] childTypes = new String[numChildren];
            int i = 0;
            while (i < numChildren) {
                childTypes[i] = this.m_childs.get(i).getType();
                ++i;
            }
            return childTypes;
        }

        public String getDefinition() {
            return this.m_definition;
        }

        public String getDescription() {
            return this.m_description;
        }

        public FieldMetaData getFieldMetaData(int index) {
            if (this.m_recordMetaData == null) {
                return null;
            }
            return this.m_recordMetaData.getFieldMetaData(index);
        }

        public FieldMetaData getFieldMetaData(String fieldName) {
            if (this.m_recordMetaData == null) {
                return null;
            }
            return this.m_recordMetaData.getFieldMetaData(fieldName);
        }

        public int getHierarchyLevel() {
            return this.m_hierarchyLevel;
        }

        public String getIDocType() {
            return this.m_iDocType;
        }

        public String getIDocTypeExtension() {
            return this.m_iDocTypeExtension;
        }

        public String getKey() {
            if (this.m_key == null) {
                this.m_key = SegmentMetaData.createKey(this.m_iDocType, this.m_iDocTypeExtension, this.m_systemRelease, this.m_applicationRelease, this.m_definition);
            }
            return this.m_key;
        }

        public long getMaxOccurrence() {
            return this.m_maxOccurrence;
        }

        public long getMinOccurrence() {
            return this.m_minOccurrence;
        }

        public String getName() {
            if (this.m_recordMetaData == null) {
                return this.m_definition;
            }
            return this.m_recordMetaData.getName();
        }

        public int getNumChildren() {
            return this.m_childs.size();
        }

        public SegmentMetaData getParent() {
            return this.m_parent;
        }

        public RecordMetaData getRecordMetaData() {
            return this.m_recordMetaData;
        }

        public String getSystemRelease() {
            return this.m_systemRelease;
        }

        public String getType() {
            return this.m_type;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public int indexOfChild(SegmentMetaData segmentMetaData) {
            return this.m_childs.indexOf(segmentMetaData);
        }

        public boolean isMandatory() {
            return this.m_mandatoryFlag;
        }

        public boolean isParent() {
            return this.m_childs.size() > 0;
        }

        public boolean isQualified() {
            return this.m_qualifiedFlag;
        }

        public boolean isRoot() {
            return this.m_parent == null;
        }
    }

    protected static class SegmentMetaDataList
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1000L;
        protected ObjectList m_list = null;

        public SegmentMetaDataList() {
            this.m_list = new ObjectList();
        }

        public SegmentMetaDataList(int initialCapacity) {
            this.m_list = new ObjectList(initialCapacity);
        }

        public SegmentMetaDataList(int initialCapacity, int incrementCapacity) {
            this.m_list = new ObjectList(initialCapacity, incrementCapacity);
        }

        public final boolean add(SegmentMetaData segmentMetaData) {
            return this.m_list.add(segmentMetaData);
        }

        public final void add(int index, SegmentMetaData segmentMetaData) {
            this.m_list.add(index, segmentMetaData);
        }

        public final int addAfter(SegmentMetaData afterSegmentMetaData, SegmentMetaData newSegmentMetaData) {
            return this.m_list.addAfter(afterSegmentMetaData, newSegmentMetaData);
        }

        public final int addBefore(SegmentMetaData beforeSegmentMetaData, SegmentMetaData newSegmentMetaData) {
            return this.m_list.addBefore(beforeSegmentMetaData, newSegmentMetaData);
        }

        public final int capacity() {
            return this.m_list.capacity();
        }

        public final void clear() {
            this.m_list.clear();
        }

        public Object clone() {
            try {
                SegmentMetaDataList cloned = (SegmentMetaDataList)super.clone();
                cloned.m_list = (ObjectList)this.m_list.clone();
                return cloned;
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public final boolean contains(SegmentMetaData segmentMetaData) {
            return this.m_list.contains(segmentMetaData);
        }

        public final void ensureCapacity(int minCapacity) {
            this.m_list.ensureCapacity(minCapacity);
        }

        public final SegmentMetaData first() {
            return (SegmentMetaData)this.m_list.first();
        }

        public final SegmentMetaData get(int index) {
            return (SegmentMetaData)this.m_list.get(index);
        }

        public final SegmentMetaData getNext(SegmentMetaData segmentMetaData) {
            return (SegmentMetaData)this.m_list.getNext(segmentMetaData);
        }

        public final SegmentMetaData getPrevious(SegmentMetaData segmentMetaData) {
            return (SegmentMetaData)this.m_list.getPrevious(segmentMetaData);
        }

        public final int indexOf(SegmentMetaData segmentMetaData) {
            return this.m_list.indexOf(segmentMetaData);
        }

        public final int indexOf(SegmentMetaData segmentMetaData, int startIndex) {
            return this.m_list.indexOf(segmentMetaData, startIndex);
        }

        public final int indexOf(SegmentMetaData segmentMetaData, int startIndex, boolean directionForward) {
            return this.m_list.indexOf(segmentMetaData, startIndex, directionForward);
        }

        public final int indexOf(SegmentMetaData segmentMetaData, int startIndex, boolean directionForward, boolean wrapAround) {
            return this.m_list.indexOf(segmentMetaData, startIndex, directionForward, wrapAround);
        }

        public final boolean isEmpty() {
            return this.m_list.isEmpty();
        }

        public final SegmentMetaData last() {
            return (SegmentMetaData)this.m_list.last();
        }

        public final int lastIndexOf(SegmentMetaData segmentMetaData) {
            return this.m_list.lastIndexOf(segmentMetaData);
        }

        public final SegmentMetaData remove(int index) {
            return (SegmentMetaData)this.m_list.remove(index);
        }

        public final boolean remove(SegmentMetaData segmentMetaData) {
            return this.m_list.remove(segmentMetaData);
        }

        public final SegmentMetaData set(int index, SegmentMetaData segmentMetaData) {
            return (SegmentMetaData)this.m_list.set(index, segmentMetaData);
        }

        public final int size() {
            return this.m_list.size();
        }

        public final SegmentMetaData[] toArray() {
            Object[] objectArray = this.m_list.toArray();
            SegmentMetaData[] segmentMetaDataArray = new SegmentMetaData[objectArray.length];
            System.arraycopy(objectArray, 0, segmentMetaDataArray, 0, objectArray.length);
            return segmentMetaDataArray;
        }

        public final void trimToSize() {
            this.m_list.trimToSize();
        }
    }

    protected static class SegmentList
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1000L;
        protected ObjectList m_list = null;

        public SegmentList() {
            this.m_list = new ObjectList();
        }

        public SegmentList(int initialCapacity) {
            this.m_list = new ObjectList(initialCapacity);
        }

        public SegmentList(int initialCapacity, int incrementCapacity) {
            this.m_list = new ObjectList(initialCapacity, incrementCapacity);
        }

        public final boolean add(Segment segment) {
            return this.m_list.add(segment);
        }

        public final void add(int index, Segment segment) {
            this.m_list.add(index, segment);
        }

        public final int addAfter(Segment afterSegment, Segment newSegment) {
            return this.m_list.addAfter(afterSegment, newSegment);
        }

        public final int addBefore(Segment beforeSegment, Segment newSegment) {
            return this.m_list.addBefore(beforeSegment, newSegment);
        }

        public final int capacity() {
            return this.m_list.capacity();
        }

        public final void clear() {
            this.m_list.clear();
        }

        public Object clone() {
            try {
                SegmentList cloned = (SegmentList)super.clone();
                cloned.m_list = (ObjectList)this.m_list.clone();
                return cloned;
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public final boolean contains(Segment segment) {
            return this.m_list.contains(segment);
        }

        public final void ensureCapacity(int minCapacity) {
            this.m_list.ensureCapacity(minCapacity);
        }

        public final Segment first() {
            return (Segment)this.m_list.first();
        }

        public final Segment get(int index) {
            return (Segment)this.m_list.get(index);
        }

        public final Segment getNext(Segment segment) {
            return (Segment)this.m_list.getNext(segment);
        }

        public final Segment getPrevious(Segment segment) {
            return (Segment)this.m_list.getPrevious(segment);
        }

        public final int indexOf(Segment segment) {
            return this.m_list.indexOf(segment);
        }

        public final int indexOf(Segment segment, int startIndex) {
            return this.m_list.indexOf(segment, startIndex);
        }

        public final int indexOf(Segment segment, int startIndex, boolean directionForward) {
            return this.m_list.indexOf(segment, startIndex, directionForward);
        }

        public final int indexOf(Segment segment, int startIndex, boolean directionForward, boolean wrapAround) {
            return this.m_list.indexOf(segment, startIndex, directionForward, wrapAround);
        }

        public final boolean isEmpty() {
            return this.m_list.isEmpty();
        }

        public final Segment last() {
            return (Segment)this.m_list.last();
        }

        public final int lastIndexOf(Segment segment) {
            return this.m_list.lastIndexOf(segment);
        }

        public final Segment remove(int index) {
            return (Segment)this.m_list.remove(index);
        }

        public final boolean remove(Segment segment) {
            return this.m_list.remove(segment);
        }

        public final Segment set(int index, Segment segment) {
            return (Segment)this.m_list.set(index, segment);
        }

        public final int size() {
            return this.m_list.size();
        }

        public final Segment[] toArray() {
            Object[] objectArray = this.m_list.toArray();
            Segment[] segmentArray = new Segment[objectArray.length];
            System.arraycopy(objectArray, 0, segmentArray, 0, objectArray.length);
            return segmentArray;
        }

        public final void trimToSize() {
            this.m_list.trimToSize();
        }
    }

    public static class SegmentIterator
    implements Iterator {
        protected Segment m_currentSegment = null;
        protected Segment m_nextSegment = null;
        protected String m_segmentType = null;
        protected int m_iterationType = 0;
        protected int m_parentLevel = -1;

        public SegmentIterator(int iterationType, Segment firstSegment) {
            if (iterationType < 1 && iterationType > 4) {
                throw new IllegalArgumentException("Invalid iteration type (iterationType == " + iterationType + ")");
            }
            if (firstSegment == null) {
                return;
            }
            this.m_iterationType = iterationType;
            this.m_nextSegment = firstSegment;
            if (iterationType == 2 || iterationType == 4) {
                this.m_segmentType = firstSegment.getType();
            }
        }

        public SegmentIterator(Segment parentSegment, int iterationType) {
            if (iterationType < 5 && iterationType > 6) {
                throw new IllegalArgumentException("Invalid iteration type (iterationType == " + iterationType + ")");
            }
            if (parentSegment == null) {
                return;
            }
            this.m_nextSegment = parentSegment.getFirstChild();
            switch (iterationType) {
                case 5: {
                    this.m_iterationType = 3;
                    break;
                }
                case 6: {
                    this.m_iterationType = 1;
                    this.m_parentLevel = parentSegment.getHierarchyLevel();
                }
            }
        }

        public SegmentIterator(Segment parentSegment, int iterationType, String segmentType) {
            if (iterationType < 5 && iterationType > 6) {
                throw new IllegalArgumentException("Invalid iteration type (iterationType == " + iterationType + ")");
            }
            if (parentSegment == null) {
                return;
            }
            this.m_nextSegment = parentSegment.getFirstChild(segmentType);
            this.m_segmentType = segmentType;
            switch (iterationType) {
                case 5: {
                    this.m_iterationType = 4;
                    break;
                }
                case 6: {
                    this.m_iterationType = 2;
                    this.m_parentLevel = parentSegment.getHierarchyLevel();
                }
            }
        }

        public boolean hasNext() {
            if (this.m_nextSegment != null) {
                return true;
            }
            if (this.m_currentSegment == null) {
                return false;
            }
            switch (this.m_iterationType) {
                case 1: {
                    this.m_nextSegment = this.m_currentSegment.getNext();
                    break;
                }
                case 2: {
                    this.m_nextSegment = this.m_currentSegment.getNext(this.m_segmentType);
                    break;
                }
                case 3: {
                    this.m_nextSegment = this.m_currentSegment.getNextSibling();
                    return this.m_nextSegment != null;
                }
                case 4: {
                    this.m_nextSegment = this.m_currentSegment.getNextSibling(this.m_segmentType);
                    return this.m_nextSegment != null;
                }
            }
            if (this.m_nextSegment == null) {
                return false;
            }
            if (this.m_parentLevel > -1 && this.m_nextSegment.getHierarchyLevel() <= this.m_parentLevel) {
                this.m_nextSegment = null;
                return false;
            }
            return true;
        }

        public Object next() {
            return this.nextSegment();
        }

        public Segment nextSegment() {
            if (this.hasNext()) {
                this.m_currentSegment = this.m_nextSegment;
                this.m_nextSegment = null;
                return this.m_currentSegment;
            }
            this.m_currentSegment = null;
            throw new NoSuchElementException("SegmentIterator.nextSegment()");
        }

        public void remove() {
            if (this.m_currentSegment == null) {
                throw new IllegalStateException("SegmentIterator.remove()");
            }
            switch (this.m_iterationType) {
                case 1: {
                    this.m_nextSegment = this.m_currentSegment.getNextSibling();
                    if (this.m_nextSegment != null) break;
                    this.m_nextSegment = this.m_currentSegment.getNext();
                    if (this.m_parentLevel <= -1 || this.m_nextSegment == null || this.m_nextSegment.getHierarchyLevel() > this.m_parentLevel) break;
                    this.m_nextSegment = null;
                    break;
                }
                case 2: {
                    this.m_nextSegment = this.m_currentSegment.getNextSibling(this.m_segmentType);
                    if (this.m_nextSegment != null) break;
                    this.m_nextSegment = this.m_currentSegment.getNext(this.m_segmentType);
                    if (this.m_parentLevel <= -1 || this.m_nextSegment == null || this.m_nextSegment.getHierarchyLevel() > this.m_parentLevel) break;
                    this.m_nextSegment = null;
                    break;
                }
                case 3: {
                    this.m_nextSegment = this.m_currentSegment.getNextSibling();
                    break;
                }
                case 4: {
                    this.m_nextSegment = this.m_currentSegment.getNextSibling(this.m_segmentType);
                }
            }
            this.m_currentSegment.remove();
            this.m_currentSegment = null;
        }
    }

    public static interface Segment
    extends Record {
        public Segment addChild(String var1);

        public Segment addChild(String var1, boolean var2);

        public Segment addSibling();

        public Segment addSibling(boolean var1);

        public Segment addSibling(String var1);

        public Segment addSibling(String var1, boolean var2);

        public void checkChildSegmentsOccurrenceLimits();

        public void checkMandatoryChildSegments();

        public void checkSyntax();

        public void checkSyntax(int var1);

        public void disableFieldValueChecking(boolean var1);

        public void enableFieldValueChecking(boolean var1);

        public Segment getChild(int var1);

        public Segment[] getChildren();

        public Segment[] getChildren(String var1);

        public SegmentIterator getChildrenIterator();

        public SegmentIterator getChildrenIterator(String var1);

        public String getDefinition();

        public SegmentIterator getDescendantsIterator();

        public String getDescription();

        public Document getDocument();

        public Segment getFirstChild();

        public Segment getFirstChild(String var1);

        public Segment getFirstChild(String var1, int var2, String var3);

        public Segment getFirstChild(String var1, String var2, String var3);

        public Segment getFirstDescendant(String var1);

        public Segment getFirstDescendant(String var1, int var2, String var3);

        public Segment getFirstDescendant(String var1, String var2, String var3);

        public int getHierarchyLevel();

        public Segment getLastChild();

        public Segment getLastChild(String var1);

        public Segment getLastChild(String var1, int var2, String var3);

        public Segment getLastChild(String var1, String var2, String var3);

        public Segment getNext();

        public Segment getNext(String var1);

        public Segment getNext(String var1, int var2, String var3);

        public Segment getNext(String var1, String var2, String var3);

        public Segment getNextDescendant(String var1);

        public Segment getNextDescendant(String var1, int var2, String var3);

        public Segment getNextDescendant(String var1, String var2, String var3);

        public Segment getNextSibling();

        public Segment getNextSibling(String var1);

        public Segment getNextSibling(String var1, int var2, String var3);

        public Segment getNextSibling(String var1, String var2, String var3);

        public int getNumChildren();

        public int getNumChildren(String var1);

        public int getNumDescendants();

        public int getNumDescendants(String var1);

        public Segment getParent();

        public Segment getPrevious();

        public Segment getPrevious(String var1);

        public Segment getPrevious(String var1, int var2, String var3);

        public Segment getPrevious(String var1, String var2, String var3);

        public Segment getPreviousSibling();

        public Segment getPreviousSibling(String var1);

        public Segment getPreviousSibling(String var1, int var2, String var3);

        public Segment getPreviousSibling(String var1, String var2, String var3);

        public SegmentMetaData getSegmentMetaData();

        public String getType();

        public boolean isLeaf();

        public boolean isParent();

        public boolean isRoot();

        public boolean remove();

        public boolean removeChild(Segment var1);
    }

    public static interface Repository
    extends Serializable {
        public void addSegmentMetaDataToCache(SegmentMetaData var1);

        public void addSegmentMetaDataTreeToCache(SegmentMetaData var1);

        public void clear();

        public String[][] getCachedIDocTypes();

        public String getName();

        public Repository getNextRepository();

        public SegmentMetaData getRootSegmentMetaData(String var1, String var2, String var3, String var4);

        public SegmentMetaData getRootSegmentMetaData(String var1, String var2, String var3, String var4, Vector var5);

        public SegmentMetaData getSegmentMetaData(String var1, String var2, String var3, String var4, String var5);

        public SegmentMetaData getSegmentMetaData(String var1, String var2, String var3, String var4, String var5, Vector var6);

        public SegmentMetaData removeRootSegmentMetaDataFromCache(String var1, String var2, String var3, String var4);

        public SegmentMetaData removeRootSegmentMetaDataTreeFromCache(String var1, String var2, String var3, String var4);

        public SegmentMetaData removeSegmentMetaDataFromCache(String var1, String var2, String var3, String var4, String var5);

        public boolean removeSegmentMetaDataFromCache(SegmentMetaData var1);

        public SegmentMetaData removeSegmentMetaDataTreeFromCache(String var1, String var2, String var3, String var4, String var5);

        public boolean removeSegmentMetaDataTreeFromCache(SegmentMetaData var1);

        public void setNextRepository(Repository var1);
    }

    public static interface RecordMetaData
    extends Serializable {
        public int getDecimals(int var1);

        public int getDecimals(String var1);

        public String getDefault(int var1);

        public String getDefault(String var1);

        public String getDescription(int var1);

        public String getDescription(String var1);

        public FieldMetaData getFieldMetaData(int var1);

        public FieldMetaData getFieldMetaData(String var1);

        public int getInternalLength(int var1);

        public int getInternalLength(String var1);

        public int getLength();

        public int getLength(int var1);

        public int getLength(String var1);

        public String getName();

        public String getName(int var1);

        public int getNumFields();

        public int getOffset(int var1);

        public int getOffset(String var1);

        public int getType(int var1);

        public int getType(String var1);

        public String getTypeAsString(int var1);

        public String getTypeAsString(String var1);

        public int indexOf(String var1);
    }

    public static interface Record
    extends Serializable {
        public void checkFieldValue(int var1);

        public void checkFieldValues();

        public void disableFieldValueChecking();

        public void enableFieldValueChecking();

        public BigDecimal getBigDecimal(int var1);

        public BigDecimal getBigDecimal(String var1);

        public BigInteger getBigInteger(int var1);

        public BigInteger getBigInteger(String var1);

        public byte[] getByteArray(int var1);

        public byte[] getByteArray(String var1);

        public char getChar(int var1);

        public char getChar(String var1);

        public Date getDate(int var1);

        public Date getDate(String var1);

        public double getDouble(int var1);

        public double getDouble(String var1);

        public int getInt(int var1);

        public int getInt(String var1);

        public long getLong(int var1);

        public long getLong(String var1);

        public String getName();

        public String getName(int var1);

        public int getNumFields();

        public short getShort(int var1);

        public short getShort(String var1);

        public String getString(int var1);

        public String getString(String var1);

        public RecordMetaData getRecordMetaData();

        public Date getTime(int var1);

        public Date getTime(String var1);

        public Object getValue(int var1);

        public Object getValue(String var1);

        public int indexOf(String var1);

        public boolean isFieldValueCheckingEnabled();

        public void setField(int var1, byte[] var2);

        public void setField(int var1, char var2);

        public void setField(int var1, double var2);

        public void setField(int var1, int var2);

        public void setField(int var1, long var2);

        public void setField(int var1, Object var2);

        public void setField(int var1, short var2);

        public void setField(int var1, String var2);

        public void setField(String var1, byte[] var2);

        public void setField(String var1, char var2);

        public void setField(String var1, double var2);

        public void setField(String var1, int var2);

        public void setField(String var1, long var2);

        public void setField(String var1, Object var2);

        public void setField(String var1, short var2);

        public void setField(String var1, String var2);
    }

    public static class NestedException
    extends Exception {
        protected Throwable m_nestedThrowable = null;

        public NestedException(int group, String detailMessage, Throwable throwable) {
            super(group, detailMessage);
            this.m_nestedThrowable = throwable;
        }

        public Throwable getNestedThrowable() {
            return this.m_nestedThrowable;
        }
    }

    public static class FieldMetaData
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1000L;
        protected static final SyncDateFormat m_dateFormat = new SyncDateFormat("yyyyMMdd");
        protected static final SyncDateFormat m_timeFormat = new SyncDateFormat("HHmmss");
        protected String m_fieldName = null;
        protected int m_internalLength = 0;
        protected int m_outputLength = 0;
        protected String m_dataTypeName = null;
        protected String m_dataElementName = null;
        protected String m_domainName = null;
        protected String m_description = null;
        protected String m_checkTableName = null;
        protected boolean m_isISOCode = false;
        protected ObjectList m_valueRangeList = null;
        protected Datatype m_datatype = null;

        protected FieldMetaData(String fieldName, int internalLength, int outputLength, String dataTypeName, String dataElementName, String domainName, String description, String checkTableName, boolean isISOCode) {
            this.m_fieldName = fieldName;
            this.m_internalLength = internalLength;
            this.m_outputLength = outputLength;
            this.m_dataTypeName = dataTypeName;
            this.m_dataElementName = dataElementName;
            this.m_domainName = domainName;
            this.m_description = description;
            this.m_checkTableName = checkTableName;
            this.m_isISOCode = isISOCode;
            this.m_datatype = Datatype.parseDataDictionaryType(this.m_dataTypeName);
        }

        public void addValue(String value) {
            this.addValueRange(new ValueRange(value, null, null));
        }

        public void addValue(String value, String description) {
            this.addValueRange(new ValueRange(value, null, description));
        }

        public void addValueRange(String lowValue, String highValue) {
            this.addValueRange(new ValueRange(lowValue, highValue, null));
        }

        public void addValueRange(String lowValue, String highValue, String description) {
            this.addValueRange(new ValueRange(lowValue, highValue, description));
        }

        private final void addValueRange(ValueRange valueRange) {
            if (this.m_valueRangeList != null) {
                this.m_valueRangeList.add(valueRange);
            } else {
                this.m_valueRangeList = new ObjectList(valueRange);
            }
        }

        protected Object clone() {
            try {
                FieldMetaData cloned = (FieldMetaData)super.clone();
                if (this.m_valueRangeList != null) {
                    cloned.m_valueRangeList = (ObjectList)this.m_valueRangeList.clone();
                }
                return cloned;
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public static String createKey(String recordType, String fieldName) {
            StringBuffer key = new StringBuffer(61);
            key.append(recordType);
            key.append('|');
            key.append(fieldName);
            return key.toString();
        }

        public String getCheckTableName() {
            return this.m_checkTableName;
        }

        public Datatype getDatatype() {
            return this.m_datatype;
        }

        public String getDataTypeName() {
            return this.m_dataTypeName;
        }

        public String getDataElementName() {
            return this.m_dataElementName;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getDomainName() {
            return this.m_domainName;
        }

        public int getInternalLength() {
            return this.m_internalLength;
        }

        public String getFieldName() {
            return this.m_fieldName;
        }

        public int getOutputLength() {
            return this.m_outputLength;
        }

        public String getValueDescription(String value) {
            if (this.m_valueRangeList != null) {
                ValueRange valueRange = null;
                int numValueRanges = this.m_valueRangeList.size();
                int i = 0;
                while (i < numValueRanges) {
                    valueRange = (ValueRange)this.m_valueRangeList.get(i);
                    if (valueRange.isInValueRange(value)) {
                        return valueRange.getDescription();
                    }
                    ++i;
                }
            }
            return null;
        }

        public String[] getValueDescriptions() {
            String[] descriptions = null;
            if (this.m_valueRangeList != null) {
                int numValueRanges = this.m_valueRangeList.size();
                descriptions = new String[numValueRanges];
                int i = 0;
                while (i < numValueRanges) {
                    descriptions[i] = ((ValueRange)this.m_valueRangeList.get(i)).getDescription();
                    ++i;
                }
            } else {
                descriptions = new String[]{};
            }
            return descriptions;
        }

        public String[][] getValueRanges() {
            String[][] valueRanges = null;
            if (this.m_valueRangeList != null) {
                ValueRange valueRange = null;
                int numValueRanges = this.m_valueRangeList.size();
                valueRanges = new String[numValueRanges][2];
                int i = 0;
                while (i < numValueRanges) {
                    valueRange = (ValueRange)this.m_valueRangeList.get(i);
                    valueRanges[i][0] = valueRange.getLowValue();
                    valueRanges[i][1] = valueRange.getHighValue();
                    ++i;
                }
            } else {
                valueRanges = new String[0][0];
            }
            return valueRanges;
        }

        public String[] getValues() {
            String[] values = null;
            if (this.m_valueRangeList != null) {
                ValueRange valueRange = null;
                int numValueRanges = this.m_valueRangeList.size();
                values = new String[numValueRanges];
                int i = 0;
                while (i < numValueRanges) {
                    valueRange = (ValueRange)this.m_valueRangeList.get(i);
                    values[i] = valueRange.getHighValue() == null ? valueRange.getLowValue() : valueRange.getLowValue() + " - " + valueRange.getHighValue();
                    ++i;
                }
            } else {
                values = new String[]{};
            }
            return values;
        }

        public boolean isISOCode() {
            return this.m_isISOCode;
        }

        public boolean isValidValue(String value) {
            return this.isValidValue(value, true, null);
        }

        public boolean isValidValue(String value, boolean checkDatatype) {
            return this.isValidValue(value, checkDatatype, null);
        }

        private boolean isValidValue(String value, Repository repository) {
            return this.isValidValue(value, true, repository);
        }

        private boolean isValidValue(String value, boolean checkDatatype, Repository repository) {
            boolean valid = true;
            if (checkDatatype) {
                valid = this.isValueMatchingDatatype(value);
            }
            if (valid && this.m_valueRangeList != null) {
                valid = false;
                int numValueRanges = this.m_valueRangeList.size();
                int i = 0;
                while (i < numValueRanges) {
                    if (((ValueRange)this.m_valueRangeList.get(i)).isInValueRange(value)) {
                        valid = true;
                        break;
                    }
                    ++i;
                }
            }
            return valid;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isValueMatchingDatatype(String value) {
            block48: {
                block50: {
                    block51: {
                        block49: {
                            if (value == null) {
                                return true;
                            }
                            len = value.length();
                            if (len == 0) {
                                return true;
                            }
                            if (this.m_datatype == Datatype.STRING || this.m_datatype == Datatype.BINARY) {
                                return true;
                            }
                            i = 0;
                            while (i < len && value.charAt(i) == ' ') {
                                ++i;
                            }
                            if (i == len) {
                                return true;
                            }
                            c = 32;
                            if (this.m_datatype == Datatype.NUMERIC) ** GOTO lbl85
                            if (this.m_datatype != Datatype.INTEGER) break block49;
                            if ((c = (int)value.charAt(i++)) == 45 || c == 43) {
                                if (i == len) {
                                    return false;
                                }
                                if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                                    return false;
                                }
                            } else if (c < 48 || c > 57) {
                                return false;
                            }
                            ** GOTO lbl91
                        }
                        if (this.m_datatype != Datatype.DECIMAL) break block50;
                        dotParsed = false;
                        expParsed = false;
                        if ((c = (int)value.charAt(i++)) != 45 && c != 43) break block51;
                        if (i == len) {
                            return false;
                        }
                        if ((c = (int)value.charAt(i++)) == 46) {
                            if (i == len) {
                                return false;
                            }
                            if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                                return false;
                            }
                            dotParsed = true;
                        } else if (c < 48 || c > 57) {
                            return false;
                        }
                        ** GOTO lbl114
                    }
                    if (c == 46) {
                        if (i == len) {
                            return false;
                        }
                        if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                            return false;
                        }
                        dotParsed = true;
                    } else if (c < 48 || c > 57) {
                        return false;
                    }
                    ** GOTO lbl114
                }
                if (this.m_datatype == Datatype.DATE) {
                    if (i + 8 > len) {
                        return false;
                    }
                    date = value.substring(i, i + 8);
                    if (!date.equals("00000000") && !date.equals("99999999")) {
                        try {
                            FieldMetaData.m_dateFormat.parse(date);
                        }
                        catch (ParseException ex) {
                            return false;
                        }
                    }
                    i += 8;
                    break block48;
                } else {
                    if (this.m_datatype != Datatype.TIME) {
                        return true;
                    }
                    if (i + 6 > len) {
                        return false;
                    }
                    time = value.substring(i, i + 6);
                    if (!time.equals("240000")) {
                        try {
                            FieldMetaData.m_timeFormat.parse(time);
                        }
                        catch (ParseException ex) {
                            return false;
                        }
                    }
                    i += 6;
                }
                break block48;
                while ((c = (int)value.charAt(i++)) != 32) {
                    if (c < 48 || c > 57) {
                        return false;
                    }
lbl85:
                    // 3 sources

                    if (i < len) continue;
                    break block48;
                }
                break block48;
                while ((c = (int)value.charAt(i++)) != 32) {
                    if (c < 48 || c > 57) {
                        return false;
                    }
lbl91:
                    // 4 sources

                    if (i < len) continue;
                    break block48;
                }
                break block48;
                while ((c = (int)value.charAt(i++)) != 32) {
                    if (c == 46 && !dotParsed) {
                        if (i == len) {
                            return false;
                        }
                        if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                            return false;
                        }
                        dotParsed = true;
                    } else if (!(c != 69 && c != 101 || expParsed)) {
                        if (i + 1 >= len) {
                            return false;
                        }
                        if ((c = (int)value.charAt(i++)) != 43 && c != 45) {
                            return false;
                        }
                        if ((c = (int)value.charAt(i++)) < 48 || c > 57) {
                            return false;
                        }
                        dotParsed = true;
                        expParsed = true;
                    } else if (c < 48 || c > 57) {
                        return false;
                    }
lbl114:
                    // 8 sources

                    if (i < len) continue;
                }
            }
            while (i < len) {
                if (value.charAt(i++) == ' ') continue;
                return false;
            }
            return true;
        }

        protected static class ValueRange
        implements Serializable {
            private static final long serialVersionUID = 1000L;
            protected String m_lowValueString = null;
            protected String m_highValueString = null;
            protected String m_description = null;

            public ValueRange(String value) {
                this(value, null, null);
            }

            public ValueRange(String lowValue, String highValue) {
                this(lowValue, highValue, null);
            }

            public ValueRange(String lowValue, String highValue, String description) {
                if (lowValue != null) {
                    if (highValue == null || highValue.length() == 0) {
                        this.m_lowValueString = lowValue;
                    } else {
                        int compare = lowValue.compareTo(highValue);
                        if (compare < 0) {
                            this.m_lowValueString = lowValue;
                            this.m_highValueString = highValue;
                        } else if (compare == 0) {
                            this.m_lowValueString = lowValue;
                        } else {
                            this.m_lowValueString = highValue;
                            this.m_highValueString = lowValue;
                        }
                    }
                } else {
                    this.m_lowValueString = highValue;
                }
                this.m_description = description;
            }

            public final String getDescription() {
                return this.m_description;
            }

            public final String getHighValue() {
                return this.m_highValueString;
            }

            public final String getLowValue() {
                return this.m_lowValueString;
            }

            public final boolean isInValueRange(String value) {
                if (value == null) {
                    return false;
                }
                return this.m_highValueString == null ? value.equals(this.m_lowValueString) : value.compareTo(this.m_lowValueString) >= 0 && value.compareTo(this.m_highValueString) <= 0;
            }
        }

        public static class Datatype
        extends Enum
        implements Serializable {
            private static final long serialVersionUID = 1000L;
            public static final Datatype STRING = new Datatype("STRING");
            public static final Datatype NUMERIC = new Datatype("NUMERIC");
            public static final Datatype INTEGER = new Datatype("INTEGER");
            public static final Datatype DECIMAL = new Datatype("DECIMAL");
            public static final Datatype DATE = new Datatype("DATE");
            public static final Datatype TIME = new Datatype("TIME");
            public static final Datatype BINARY = new Datatype("BINARY");

            protected Datatype(String name) {
                super(name);
            }

            public static Datatype parse(String name) throws Enum.Exception {
                if (name != null) {
                    if (name.equals(Datatype.STRING.name)) {
                        return STRING;
                    }
                    if (name.equals(Datatype.NUMERIC.name)) {
                        return NUMERIC;
                    }
                    if (name.equals(Datatype.INTEGER.name)) {
                        return INTEGER;
                    }
                    if (name.equals(Datatype.DECIMAL.name)) {
                        return DECIMAL;
                    }
                    if (name.equals(Datatype.DATE.name)) {
                        return DATE;
                    }
                    if (name.equals(Datatype.TIME.name)) {
                        return TIME;
                    }
                    if (name.equals(Datatype.BINARY.name)) {
                        return BINARY;
                    }
                }
                throw new Enum.Exception("ParseException: Unknown type '" + name + "'");
            }

            protected static Datatype parseDataDictionaryType(String type) {
                if (type != null) {
                    if (type.length() == 4) {
                        if (type.equals("CHAR")) {
                            return STRING;
                        }
                        if (type.equals("QUAN")) {
                            return DECIMAL;
                        }
                        if (type.equals("UNIT")) {
                            return STRING;
                        }
                        if (type.equals("NUMC")) {
                            return NUMERIC;
                        }
                        if (type.equals("DATS")) {
                            return DATE;
                        }
                        if (type.equals("TIMS")) {
                            return TIME;
                        }
                        if (type.equals("CURR")) {
                            return DECIMAL;
                        }
                        if (type.equals("CUKY")) {
                            return STRING;
                        }
                        if (type.equals("LANG")) {
                            return STRING;
                        }
                        if (type.equals("CLNT")) {
                            return STRING;
                        }
                        if (type.equals("INT1")) {
                            return INTEGER;
                        }
                        if (type.equals("INT2")) {
                            return INTEGER;
                        }
                        if (type.equals("INT4")) {
                            return INTEGER;
                        }
                        if (type.equals("FLTP")) {
                            return DECIMAL;
                        }
                        if (type.equals("ACCP")) {
                            return NUMERIC;
                        }
                        if (type.equals("PREC")) {
                            return NUMERIC;
                        }
                        if (type.equals("LRAW")) {
                            return BINARY;
                        }
                    } else if (type.length() == 3) {
                        if (type.equals("DEC")) {
                            return DECIMAL;
                        }
                        if (type.equals("RAW")) {
                            return BINARY;
                        }
                    } else {
                        if (type.equals("STRING")) {
                            return STRING;
                        }
                        if (type.equals("RAWSTRING")) {
                            return BINARY;
                        }
                    }
                }
                return STRING;
            }
        }
    }

    public static class Exception
    extends RuntimeException {
        public static final int IDOC_ERROR_INTERNAL = 0;
        public static final int IDOC_ERROR_SYNTAX = 1;
        public static final int IDOC_ERROR_METADATA_UNAVAILABLE = 2;
        public static final int IDOC_ERROR_ILLEGAL_TYPE = 3;
        public static final int IDOC_ERROR_UNSUPPORTED_OPERATION = 4;
        public static final int IDOC_ERROR_IO_OPERATION = 5;
        public static final int IDOC_ERROR_FIELD_CONVERSION = 6;
        public static final int IDOC_ERROR_RECORD_OPERATION = 7;
        public static final int IDOC_ERROR_INITIALIZATION = 8;
        private int m_group;

        public Exception(int group, String detailMessage) {
            super(detailMessage);
            this.m_group = group;
        }

        public final int getGroup() {
            return this.m_group;
        }

        public String getKey() {
            switch (this.m_group) {
                case 0: {
                    return "IDOC_ERROR_INTERNAL";
                }
                case 1: {
                    return "IDOC_ERROR_SYNTAX";
                }
                case 2: {
                    return "IDOC_ERROR_METADATA_UNAVAILABLE";
                }
                case 3: {
                    return "IDOC_ERROR_ILLEGAL_TYPE";
                }
                case 4: {
                    return "IDOC_ERROR_UNSUPPORTED_OPERATION";
                }
                case 5: {
                    return "IDOC_ERROR_IO_OPERATION";
                }
                case 6: {
                    return "IDOC_ERROR_FIELD_CONVERSION";
                }
                case 7: {
                    return "IDOC_ERROR_RECORD_OPERATION";
                }
                case 8: {
                    return "IDOC_ERROR_INITIALIZATION";
                }
            }
            return "IDOC_ERROR_UNKNOWN";
        }

        public String toString() {
            return this.getClass().getName() + ": " + "(" + this.m_group + ") " + this.getKey() + ": " + this.getMessage();
        }
    }

    public static interface DocumentList
    extends Serializable {
        public boolean add(Document var1);

        public Document addDocument(String var1);

        public Document addDocument(String var1, String var2);

        public Document addDocument(String var1, String var2, String var3);

        public Document addDocument(String var1, String var2, String var3, String var4);

        public void clear();

        public void ensureCapacity(int var1);

        public Document first();

        public Document get(int var1);

        public Document getNext(Document var1);

        public int getNumDocuments();

        public Document getPrevious(Document var1);

        public int indexOf(Document var1);

        public int indexOf(Document var1, int var2);

        public boolean isEmpty();

        public DocumentIterator iterator();

        public Document last();

        public int lastIndexOf(Document var1);

        public Document remove(int var1);

        public boolean remove(Document var1);

        public int size();

        public Document[] toArray();

        public String toXML();

        public String toXML(String var1);

        public void trimToSize();

        public void writeXML(OutputStreamWriter var1);

        public void writeXML(String var1);

        public void writeXML(String var1, String var2);

        public void writeXML(Writer var1);
    }

    public static class DocumentIterator
    implements Iterator {
        protected DocumentList m_documentList = null;
        protected Document m_currentDocument = null;
        protected Document m_nextDocument = null;

        public DocumentIterator(DocumentList documentList) {
            if (documentList == null) {
                return;
            }
            this.m_documentList = documentList;
            this.m_nextDocument = documentList.first();
        }

        public boolean hasNext() {
            if (this.m_nextDocument != null) {
                return true;
            }
            if (this.m_currentDocument == null) {
                return false;
            }
            this.m_nextDocument = this.m_documentList.getNext(this.m_currentDocument);
            return this.m_nextDocument != null;
        }

        public Object next() {
            return this.nextDocument();
        }

        public Document nextDocument() {
            if (this.hasNext()) {
                this.m_currentDocument = this.m_nextDocument;
                this.m_nextDocument = null;
                return this.m_currentDocument;
            }
            this.m_currentDocument = null;
            throw new NoSuchElementException("DocumentIterator.nextDocument()");
        }

        public void remove() {
            if (this.m_currentDocument == null) {
                throw new IllegalStateException("DocumentIterator.remove()");
            }
            this.m_nextDocument = this.m_documentList.getNext(this.m_currentDocument);
            this.m_documentList.remove(this.m_currentDocument);
            this.m_currentDocument = null;
        }
    }

    public static interface Document
    extends Record,
    Serializable {
        public void checkMandatoryFields();

        public void checkSyntax();

        public void checkSyntax(int var1);

        public void disableFieldValueChecking();

        public void disableFieldValueChecking(boolean var1);

        public void enableFieldValueChecking(boolean var1);

        public void enableFieldValueChecking();

        public int getNumSegments();

        public int getNumSegments(String var1);

        public Segment getRootSegment();

        public String getArchiveKey();

        public String getClient();

        public Date getCreationDate();

        public String getCreationDateAsString();

        public Date getCreationTime();

        public String getCreationTimeAsString();

        public String getDirection();

        public String getEDIMessage();

        public String getEDIMessageGroup();

        public String getEDIMessageType();

        public String getEDIStandardFlag();

        public String getEDIStandardVersion();

        public String getEDITransmissionFile();

        public String getExpressFlag();

        public String getIDocNumber();

        public String getIDocSAPRelease();

        public String getIDocCompoundType();

        public String getIDocType();

        public String getIDocTypeExtension();

        public String getMessageCode();

        public String getMessageFunction();

        public String getMessageType();

        public String getOutputMode();

        public String getRecipientAddress();

        public String getRecipientLogicalAddress();

        public String getRecipientPartnerFunction();

        public String getRecipientPartnerNumber();

        public String getRecipientPartnerType();

        public String getRecipientPort();

        public String getSenderAddress();

        public String getSenderLogicalAddress();

        public String getSenderPartnerFunction();

        public String getSenderPartnerNumber();

        public String getSenderPartnerType();

        public String getSenderPort();

        public String getSerialization();

        public String getStatus();

        public String getTableStructureName();

        public String getTestFlag();

        public void setArchiveKey(String var1);

        public void setClient(String var1);

        public void setCreationDate(Date var1);

        public void setCreationDate(String var1);

        public void setCreationTime(Date var1);

        public void setCreationTime(String var1);

        public void setDirection(String var1);

        public void setEDIMessage(String var1);

        public void setEDIMessageGroup(String var1);

        public void setEDIMessageType(String var1);

        public void setEDIStandardFlag(String var1);

        public void setEDIStandardVersion(String var1);

        public void setEDITransmissionFile(String var1);

        public void setExpressFlag(String var1);

        public void setIDocNumber(String var1);

        public void setIDocSAPRelease(String var1);

        public void setIDocCompoundType(String var1);

        public void setIDocType(String var1);

        public void setIDocTypeExtension(String var1);

        public void setMessageCode(String var1);

        public void setMessageFunction(String var1);

        public void setMessageType(String var1);

        public void setOutputMode(String var1);

        public void setRecipientAddress(String var1);

        public void setRecipientLogicalAddress(String var1);

        public void setRecipientPartnerFunction(String var1);

        public void setRecipientPartnerNumber(String var1);

        public void setRecipientPartnerType(String var1);

        public void setRecipientPort(String var1);

        public void setSenderAddress(String var1);

        public void setSenderLogicalAddress(String var1);

        public void setSenderPartnerFunction(String var1);

        public void setSenderPartnerNumber(String var1);

        public void setSenderPartnerType(String var1);

        public void setSenderPort(String var1);

        public void setSerialization(String var1);

        public void setStatus(String var1);

        public void setTestFlag(String var1);

        public String toXML();

        public String toXML(String var1);

        public void writeXML(OutputStreamWriter var1);

        public void writeXML(String var1);

        public void writeXML(String var1, String var2);

        public void writeXML(Writer var1);
    }

    public static class BasicRepository
    implements Repository {
        private static final long serialVersionUID = 1000L;
        protected String m_name = null;
        protected Hashtable m_segmentMetaDataCache = new Hashtable(101);
        protected transient Repository m_nextRepository = null;

        protected BasicRepository(String name) {
            this.m_name = name;
        }

        public void addSegmentMetaDataToCache(SegmentMetaData segmentMetaData) {
            if (segmentMetaData != null) {
                this.m_segmentMetaDataCache.put(segmentMetaData.getKey(), segmentMetaData);
            }
        }

        public void addSegmentMetaDataTreeToCache(SegmentMetaData segmentMetaData) {
            if (segmentMetaData != null) {
                this.m_segmentMetaDataCache.put(segmentMetaData.getKey(), segmentMetaData);
                int numChilds = segmentMetaData.getNumChildren();
                int i = 0;
                while (i < numChilds) {
                    this.addSegmentMetaDataTreeToCache(segmentMetaData.getChild(i));
                    ++i;
                }
            }
        }

        public void clear() {
            this.m_segmentMetaDataCache = new Hashtable(101);
        }

        public String[][] getCachedIDocTypes() {
            String key;
            Enumeration keys = this.m_segmentMetaDataCache.keys();
            ObjectList rootKeys = new ObjectList(this.m_segmentMetaDataCache.size());
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                if (!key.endsWith(IDoc.ROOT)) continue;
                rootKeys.add(key);
            }
            String[][] iDocTypes = new String[rootKeys.size()][4];
            int i = 0;
            while (i < rootKeys.size()) {
                key = (String)rootKeys.get(i);
                int endIndex = key.indexOf(124);
                iDocTypes[i][0] = key.substring(0, endIndex);
                int beginIndex = endIndex + 1;
                endIndex = key.indexOf(124, beginIndex);
                iDocTypes[i][1] = key.substring(beginIndex, endIndex);
                beginIndex = endIndex + 1;
                endIndex = key.indexOf(124, beginIndex);
                iDocTypes[i][2] = key.substring(beginIndex, endIndex);
                beginIndex = endIndex + 1;
                endIndex = key.indexOf(124, beginIndex);
                iDocTypes[i][3] = key.substring(beginIndex, endIndex);
                ++i;
            }
            return iDocTypes;
        }

        public SegmentMetaData getCachedRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            String key = SegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, IDoc.ROOT);
            return (SegmentMetaData)this.m_segmentMetaDataCache.get(key);
        }

        public SegmentMetaData getCachedSegmentMetaData(String key) {
            return (SegmentMetaData)this.m_segmentMetaDataCache.get(key);
        }

        public SegmentMetaData getCachedSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
            if (IDoc.ROOT.equals(definition)) {
                return this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            }
            String key = SegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
            return (SegmentMetaData)this.m_segmentMetaDataCache.get(key);
        }

        public String getName() {
            return this.m_name;
        }

        public Repository getNextRepository() {
            return this.m_nextRepository;
        }

        public SegmentMetaData getRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            return this.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, null);
        }

        public SegmentMetaData getRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, Vector queriedRepositories) {
            Repository nextRepository;
            if (queriedRepositories != null && queriedRepositories.contains(this)) {
                return null;
            }
            SegmentMetaData rootSegmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            if (rootSegmentMetaData == null && (nextRepository = this.m_nextRepository) != null) {
                if (queriedRepositories == null) {
                    queriedRepositories = new Vector<BasicRepository>(5);
                }
                queriedRepositories.add(this);
                rootSegmentMetaData = nextRepository.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, queriedRepositories);
            }
            return rootSegmentMetaData;
        }

        public SegmentMetaData getSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
            if (IDoc.ROOT.equals(definition)) {
                return this.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, null);
            }
            return this.getSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition, null);
        }

        public SegmentMetaData getSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition, Vector queriedRepositories) {
            if (IDoc.ROOT.equals(definition)) {
                return this.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, queriedRepositories);
            }
            if (queriedRepositories != null && queriedRepositories.contains(this)) {
                return null;
            }
            String key = SegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
            SegmentMetaData segmentMetaData = this.getCachedSegmentMetaData(key);
            if (segmentMetaData == null) {
                Repository nextRepository;
                SegmentMetaData rootSegmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
                if (rootSegmentMetaData != null) {
                    this.addSegmentMetaDataTreeToCache(rootSegmentMetaData);
                    segmentMetaData = this.getCachedSegmentMetaData(key);
                }
                if (segmentMetaData == null && (nextRepository = this.m_nextRepository) != null) {
                    if (queriedRepositories == null) {
                        queriedRepositories = new Vector<BasicRepository>(5);
                    }
                    queriedRepositories.add(this);
                    segmentMetaData = nextRepository.getSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition, queriedRepositories);
                }
            }
            return segmentMetaData;
        }

        public SegmentMetaData removeRootSegmentMetaDataFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            SegmentMetaData segmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            if (this.removeSegmentMetaDataFromCache(segmentMetaData)) {
                return segmentMetaData;
            }
            return null;
        }

        public SegmentMetaData removeRootSegmentMetaDataTreeFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            SegmentMetaData segmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            if (this.removeSegmentMetaDataTreeFromCache(segmentMetaData)) {
                return segmentMetaData;
            }
            return null;
        }

        public boolean removeSegmentMetaDataFromCache(SegmentMetaData segmentMetaData) {
            if (segmentMetaData == null) {
                return false;
            }
            boolean removed = this.m_segmentMetaDataCache.remove(segmentMetaData.getKey()) != null;
            return removed;
        }

        public boolean removeSegmentMetaDataTreeFromCache(SegmentMetaData segmentMetaData) {
            if (segmentMetaData == null) {
                return false;
            }
            boolean removed = this.m_segmentMetaDataCache.remove(segmentMetaData.getKey()) != null;
            int numChilds = segmentMetaData.getNumChildren();
            int i = 0;
            while (i < numChilds) {
                this.removeSegmentMetaDataTreeFromCache(segmentMetaData.getChild(i));
                ++i;
            }
            return removed;
        }

        public SegmentMetaData removeSegmentMetaDataFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
            if (IDoc.ROOT.equals(definition)) {
                return this.removeRootSegmentMetaDataFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            }
            SegmentMetaData segmentMetaData = this.getCachedSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
            if (this.removeSegmentMetaDataFromCache(segmentMetaData)) {
                return segmentMetaData;
            }
            return null;
        }

        public SegmentMetaData removeSegmentMetaDataTreeFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
            if (IDoc.ROOT.equals(definition)) {
                return this.removeRootSegmentMetaDataTreeFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            }
            SegmentMetaData segmentMetaData = this.getCachedSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
            if (this.removeSegmentMetaDataTreeFromCache(segmentMetaData)) {
                return segmentMetaData;
            }
            return null;
        }

        public void setNextRepository(Repository nextRepository) {
            this.m_nextRepository = nextRepository != this ? nextRepository : null;
        }
    }

    public static abstract class BasicDocumentList
    implements DocumentList,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1000L;
        protected ObjectList m_list = new ObjectList(10, 0);

        protected BasicDocumentList() {
        }

        public void clear() {
            this.m_list.clear();
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public void ensureCapacity(int minCapacity) {
            this.m_list.ensureCapacity(minCapacity);
        }

        public Document first() {
            return (Document)this.m_list.first();
        }

        public Document get(int index) {
            return (Document)this.m_list.get(index);
        }

        public Document getNext(Document document) {
            return (Document)this.m_list.getNext(document);
        }

        public int getNumDocuments() {
            return this.m_list.size();
        }

        public Document getPrevious(Document document) {
            return (Document)this.m_list.getPrevious(document);
        }

        public int indexOf(Document document) {
            return this.m_list.indexOf(document);
        }

        public int indexOf(Document document, int startIndex) {
            return this.m_list.indexOf(document, startIndex);
        }

        public boolean isEmpty() {
            return this.m_list.isEmpty();
        }

        public DocumentIterator iterator() {
            return new DocumentIterator(this);
        }

        public Document last() {
            return (Document)this.m_list.last();
        }

        public int lastIndexOf(Document document) {
            return this.m_list.lastIndexOf(document);
        }

        public Document remove(int index) {
            return (Document)this.m_list.remove(index);
        }

        public boolean remove(Document document) {
            return this.m_list.remove(document);
        }

        public int size() {
            return this.m_list.size();
        }

        public Document[] toArray() {
            Object[] objectArray = this.m_list.toArray();
            Document[] documentArray = new Document[objectArray.length];
            System.arraycopy(objectArray, 0, documentArray, 0, objectArray.length);
            return documentArray;
        }

        public final void trimToSize() {
            this.m_list.trimToSize();
        }

        public void writeXML(OutputStreamWriter writer) {
            PrintWriter os = null;
            os = new PrintWriter(writer);
            os.print("<?xml version=\"1.0\" ");
            String encoding = writer.getEncoding().toLowerCase(Locale.ENGLISH);
            if (!(encoding.startsWith("utf") && (encoding.endsWith("8") || encoding.endsWith("16")) || encoding.indexOf("ascii") >= 0)) {
                os.print("encoding=\"" + writer.getEncoding() + "\" ");
            }
            os.println("?>");
            os.println(this.toXML());
            os.flush();
            os.close();
        }

        public void writeXML(String filename) {
            this.writeXML(filename, "UTF-8");
        }

        public void writeXML(String filename, String charEncoding) {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(filename);
                this.writeXML(new OutputStreamWriter((OutputStream)os, charEncoding));
                os.close();
            }
            catch (IOException ex) {
                throw new NestedException(5, "java.lang.IOException occurred while writing IDoc.DocumentList to XML file '" + filename + "'.", ex);
            }
        }

        public void writeXML(Writer writer) {
            PrintWriter os = null;
            os = new PrintWriter(writer);
            os.println("<?xml version=\"1.0\" ?>");
            os.println(this.toXML());
            os.flush();
            os.close();
        }

        public abstract String toXML(String var1);

        public abstract String toXML();

        public abstract Document addDocument(String var1, String var2, String var3, String var4);

        public abstract Document addDocument(String var1, String var2, String var3);

        public abstract Document addDocument(String var1, String var2);

        public abstract Document addDocument(String var1);

        public abstract boolean add(Document var1);
    }
}

