/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.axiondb.AxionException;
import org.axiondb.parser.AxionDateTimeFormatParser;
import org.axiondb.types.TimestampType;

public final class DateTimeUtils {
    public static final int MILLISECOND = 1;
    public static final int SECOND = 2;
    public static final int MINUTE = 4;
    public static final int HOUR = 8;
    public static final int DAY = 16;
    public static final int WEEK = 32;
    public static final int MONTH = 64;
    public static final int QUARTER = 128;
    public static final int YEAR = 256;
    private static final TimestampType TIMESTAMP_TYPE = new TimestampType();
    private static Pattern YEAR_PATTERN_1 = Pattern.compile("^[^Y]*YY([^Y]).*$", 2);
    private static Pattern YEAR_PATTERN_2 = Pattern.compile("^.*[^Y](YY)$", 2);
    private static Pattern YEAR_4_PATTERN_1 = Pattern.compile("^[^Y]*YYYY([^Y]).*$", 2);
    private static Pattern YEAR_4_PATTERN_2 = Pattern.compile("^.*[^Y](YYYY)$", 2);
    private static Logger _log = Logger.getLogger(DateTimeUtils.class.getName());

    public static String convertToChar(Timestamp timestamp, String formatStr) throws AxionException {
        return DateTimeUtils.convertToChar(timestamp, formatStr, TimestampType.getTimeZone(), Locale.getDefault());
    }

    public static String convertToChar(Timestamp timestamp, String formatStr, TimeZone timezone) throws AxionException {
        return DateTimeUtils.convertToChar(timestamp, formatStr, timezone, Locale.getDefault());
    }

    public static String convertToChar(Timestamp timestamp, String formatStr, TimeZone timezone, Locale locale) throws AxionException {
        try {
            String javaFormat = DateTimeUtils.processFormatString(formatStr);
            SimpleDateFormat sdf = new SimpleDateFormat(javaFormat, locale);
            sdf.setCalendar(Calendar.getInstance(timezone));
            sdf.setLenient(false);
            return sdf.format(timestamp).toUpperCase();
        }
        catch (IllegalArgumentException e) {
            throw new AxionException(e.getLocalizedMessage());
        }
    }

    public static Timestamp convertToTimestamp(String dateStr, String formatStr) throws AxionException {
        return DateTimeUtils.convertToTimestamp(dateStr, formatStr, TimestampType.getTimeZone(), Locale.getDefault());
    }

    public static Timestamp convertToTimestamp(String dateStr, String formatStr, TimeZone timezone) throws AxionException {
        return DateTimeUtils.convertToTimestamp(dateStr, formatStr, timezone, Locale.getDefault());
    }

    public static Timestamp convertToTimestamp(String dateStr, String formatStr, TimeZone timezone, Locale locale) throws AxionException {
        try {
            String javaFormat = DateTimeUtils.processFormatString(formatStr);
            SimpleDateFormat sdf = new SimpleDateFormat(javaFormat, locale);
            sdf.setCalendar(Calendar.getInstance(timezone, locale));
            sdf.setLenient(false);
            ParsePosition pos = new ParsePosition(0);
            Date parsedDate = sdf.parse(dateStr, pos);
            if (pos.getIndex() == dateStr.length()) {
                String upperCaseFormat = formatStr.toUpperCase();
                if (upperCaseFormat.indexOf("YYYY") != -1) {
                    DateTimeUtils.assertDateStrMatchesFourYearFormatStr(dateStr, javaFormat);
                } else if (upperCaseFormat.indexOf("YY") != -1) {
                    DateTimeUtils.assertDateStrMatchesTwoYearFormatStr(dateStr, javaFormat);
                }
                return (Timestamp)TIMESTAMP_TYPE.convert(parsedDate);
            }
            if (parsedDate == null) {
                throw new AxionException("Date string does not match format: " + formatStr);
            }
            throw new AxionException("Extraneous characters detected in " + dateStr);
        }
        catch (IllegalArgumentException e) {
            throw new AxionException(e.getLocalizedMessage(), 22007);
        }
    }

    private static void assertDateStrMatchesTwoYearFormatStr(String dateStr, String formatStr) throws AxionException {
        String nonYearMatch;
        Matcher matcher = YEAR_PATTERN_1.matcher(formatStr);
        if (matcher.lookingAt() && (nonYearMatch = matcher.group(1)) != null) {
            char charFollowingYear = nonYearMatch.charAt(0);
            switch (charFollowingYear) {
                case ' ': 
                case '-': 
                case '.': 
                case '/': {
                    int charFollowingYearPos = matcher.start(1);
                    if (charFollowingYear != dateStr.charAt(charFollowingYearPos)) {
                        throw new AxionException("Date string, " + dateStr + ", does not match format: " + formatStr);
                    }
                    return;
                }
            }
            if (dateStr.length() != formatStr.length()) {
                throw new AxionException("Date string, " + dateStr + ", does not match format: " + formatStr);
            }
            return;
        }
        matcher = YEAR_PATTERN_2.matcher(formatStr);
        if (matcher.lookingAt()) {
            int startOfYearPos = matcher.start(1);
            if (dateStr.substring(startOfYearPos).length() != 2) {
                throw new AxionException("Date string, " + dateStr + ", does not match format: " + formatStr);
            }
            return;
        }
    }

    private static void assertDateStrMatchesFourYearFormatStr(String dateStr, String formatStr) throws AxionException {
        String nonYearMatch;
        Matcher matcher = YEAR_4_PATTERN_1.matcher(formatStr);
        if (matcher.lookingAt() && (nonYearMatch = matcher.group(1)) != null) {
            char charFollowingYear = nonYearMatch.charAt(0);
            switch (charFollowingYear) {
                case ' ': 
                case '-': 
                case '.': 
                case '/': {
                    int charFollowingYearPos = matcher.start(1);
                    if (charFollowingYear != dateStr.charAt(charFollowingYearPos)) {
                        throw new AxionException("Date string, " + dateStr + ", does not match format: " + formatStr);
                    }
                    return;
                }
            }
            int dateLength = dateStr.length();
            if (formatStr.indexOf("T") != -1) {
                dateLength += 2;
            }
            if (dateLength != formatStr.length()) {
                throw new AxionException("Date string, " + dateStr + ", does not match format: " + formatStr);
            }
            return;
        }
        matcher = YEAR_4_PATTERN_2.matcher(formatStr);
        if (matcher.lookingAt()) {
            int startOfYearPos = matcher.start(1);
            if (dateStr.substring(startOfYearPos).length() != 4) {
                throw new AxionException("Date string, " + dateStr + ", does not match format: " + formatStr);
            }
            return;
        }
    }

    public static String getDatePart(Timestamp t, String partIdent) throws AxionException {
        return DateTimeUtils.getDatePart(t, partIdent, Locale.getDefault());
    }

    public static String getDatePart(Timestamp t, String partIdent, Locale locale) throws AxionException {
        if ("q".equals(partIdent)) {
            int month = Integer.parseInt(DateTimeUtils.convertToChar(t, "mm"));
            return Integer.toString((month + 2) / 3);
        }
        if ("dow".equals(partIdent)) {
            String dayOfWeek = DateTimeUtils.convertToChar(t, "dy").toUpperCase();
            String[] shortDays = new DateFormatSymbols(locale).getShortWeekdays();
            for (int i = 1; i <= 7; ++i) {
                if (!shortDays[i].equalsIgnoreCase(dayOfWeek)) continue;
                return String.valueOf(i);
            }
            throw new AxionException("Unrecognized day of week: " + dayOfWeek);
        }
        return DateTimeUtils.convertToChar(t, partIdent);
    }

    static String processFormatString(String rawFormat) throws AxionException {
        AxionDateTimeFormatParser parser = new AxionDateTimeFormatParser();
        String cookedFormat = parser.parseDateTimeFormatToJava(rawFormat);
        _log.log(Level.FINE, "raw format: " + rawFormat + "; cooked format: " + cookedFormat);
        return cookedFormat;
    }

    public static int labelToCode(String value) throws AxionException {
        String string = value = value != null ? value.toUpperCase() : null;
        if ("DAY".equals(value)) {
            return 16;
        }
        if ("MONTH".equals(value)) {
            return 64;
        }
        if ("YEAR".equals(value)) {
            return 256;
        }
        if ("HOUR".equals(value)) {
            return 8;
        }
        if ("MINUTE".equals(value)) {
            return 4;
        }
        if ("SECOND".equals(value)) {
            return 2;
        }
        if ("WEEK".equals(value)) {
            return 32;
        }
        if ("QUARTER".equals(value)) {
            return 128;
        }
        if ("MILLISECOND".equals(value)) {
            return 1;
        }
        throw new AxionException(22006);
    }

    public static String getPartMnemonicFor(String partString) throws AxionException {
        String string = partString = partString != null ? partString.toUpperCase() : null;
        if ("WEEKDAY".equals(partString)) {
            return "dow";
        }
        if ("WEEKDAY3".equals(partString)) {
            return "dy";
        }
        if ("WEEKDAYFULL".equals(partString)) {
            return "day";
        }
        if ("DAY".equals(partString)) {
            return "dd";
        }
        if ("MONTH".equals(partString)) {
            return "mm";
        }
        if ("MONTH3".equals(partString)) {
            return "mon";
        }
        if ("MONTHFULL".equals(partString)) {
            return "month";
        }
        if ("YEAR".equals(partString)) {
            return "yyyy";
        }
        if ("YEAR2".equals(partString)) {
            return "yy";
        }
        if ("HOUR".equals(partString)) {
            return "h";
        }
        if ("HOUR12".equals(partString)) {
            return "hh12";
        }
        if ("HOUR24".equals(partString)) {
            return "hh24";
        }
        if ("MINUTE".equals(partString)) {
            return "mi";
        }
        if ("SECOND".equals(partString)) {
            return "ss";
        }
        if ("WEEK".equals(partString)) {
            return "w";
        }
        if ("QUARTER".equals(partString)) {
            return "q";
        }
        if ("MILLISECOND".equals(partString)) {
            return "ff";
        }
        if ("AMPM".equals(partString)) {
            return "am";
        }
        throw new AxionException(22006);
    }
}

