/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.io.BufferedDataInputStream;
import org.axiondb.types.BaseDataType;
import org.axiondb.types.BlobSource;
import org.axiondb.types.ByteArrayBlob;
import org.axiondb.types.ClobSource;
import org.axiondb.types.FileLobLocatorFactory;
import org.axiondb.types.FileLobSource;
import org.axiondb.types.FileOffsetLobLocatorFactory;
import org.axiondb.types.LobLocator;
import org.axiondb.types.LobLocatorFactory;
import org.axiondb.types.StringClob;
import org.axiondb.util.ExceptionConverter;

public class LOBType
extends BaseDataType {
    private transient File _lobDir = null;
    private BufferedDataInputStream _in = null;
    private LobLocatorFactory _locatorFactory = new FileLobLocatorFactory();

    public int getJdbcType() {
        return 2004;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean accepts(Object value) {
        return null == value || value instanceof String || value instanceof byte[] || value instanceof Clob || value instanceof Blob || value instanceof LobLocator;
    }

    public int getColumnDisplaySize() {
        return 0;
    }

    public Object convert(Object value) throws IllegalArgumentException {
        if ("newlob()".equals(value)) {
            LobLocator loc = this._locatorFactory.makeLobLocator(this.getLobDir());
            return loc;
        }
        if (null == value) {
            return null;
        }
        if (value instanceof LobLocator) {
            return value;
        }
        if (value instanceof String) {
            return new StringClob((String)value);
        }
        if (value instanceof byte[]) {
            return new ByteArrayBlob((byte[])value);
        }
        if (value instanceof Clob) {
            return value;
        }
        if (value instanceof Blob) {
            return value;
        }
        throw new IllegalArgumentException("Can't convert " + value.getClass().getName() + " " + value + ".");
    }

    public Blob toBlob(Object value) throws AxionException {
        Object obj = this.convert(value);
        if (obj instanceof Blob) {
            return (Blob)obj;
        }
        if (obj instanceof LobLocator) {
            return this.makeBlobSource((LobLocator)obj);
        }
        if (null == obj) {
            return null;
        }
        throw new AxionException("Expected Blob or LobLocator, found " + obj);
    }

    public Clob toClob(Object value) throws AxionException {
        Object obj = this.convert(value);
        if (obj instanceof Clob) {
            return (Clob)obj;
        }
        if (obj instanceof LobLocator) {
            return this.makeClobSource((LobLocator)obj);
        }
        if (null == obj) {
            return null;
        }
        throw new AxionException("Expected Clob or LobLocator, found " + obj);
    }

    public String toString(Object value) throws AxionException {
        Clob clob = this.toClob(value);
        if (null == clob) {
            return null;
        }
        StringBuffer buf = new StringBuffer(2048);
        Reader in = null;
        try {
            in = clob.getCharacterStream();
            int c22 = in.read();
            while (c22 != -1) {
                buf.append((char)c22);
                c22 = in.read();
            }
            String c22 = buf.toString();
            return c22;
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
        catch (SQLException e) {
            throw new AxionException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        return "LOB";
    }

    public DataType makeNewInstance() {
        return new LOBType();
    }

    public Object read(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return this._locatorFactory.read(in);
        }
        return null;
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeBoolean(false);
        } else if (value instanceof LobLocator) {
            out.writeBoolean(true);
            this._locatorFactory.write((LobLocator)value, out);
        } else if (value instanceof StringClob) {
            LobLocator loc = this.writeStringClob((StringClob)value);
            out.writeBoolean(true);
            this._locatorFactory.write(loc, out);
        } else if (value instanceof ByteArrayBlob) {
            LobLocator loc = this.writeByteArrayBlob((ByteArrayBlob)value);
            out.writeBoolean(true);
            this._locatorFactory.write(loc, out);
        } else if (value instanceof StringClob) {
            LobLocator loc = this.writeStringClob((StringClob)value);
            out.writeBoolean(true);
            this._locatorFactory.write(loc, out);
        } else {
            throw new IllegalArgumentException(value.getClass().getName() + ":" + value);
        }
    }

    public File getLobDir() {
        return this._lobDir;
    }

    public void setLobDir(File lobDir) throws AxionException {
        FileLobSource.FS.closeInputStream(this._in);
        this._lobDir = lobDir;
        if (!this._lobDir.exists() || this._lobDir.isDirectory()) {
            this._locatorFactory = new FileLobLocatorFactory();
        } else {
            this._in = FileLobSource.FS.openBufferedDIS(this.getLobDir());
            this._locatorFactory = new FileOffsetLobLocatorFactory();
        }
    }

    public short getSearchableCode() {
        return 0;
    }

    protected BufferedDataInputStream getLobFile() {
        return this._in;
    }

    protected LobLocator writeStringClob(StringClob value) throws IOException {
        LobLocator loc = this._locatorFactory.makeLobLocator(this.getLobDir());
        Writer clobout = null;
        try {
            ClobSource clob = this.makeClobSource(loc);
            clobout = clob.setCharacterStream(0L);
            clobout.write(value.getString());
        }
        catch (AxionException e) {
            throw ExceptionConverter.convertToIOException(e);
        }
        catch (SQLException e) {
            throw ExceptionConverter.convertToIOException(e);
        }
        finally {
            try {
                clobout.close();
            }
            catch (Exception e) {}
        }
        return loc;
    }

    protected LobLocator writeByteArrayBlob(ByteArrayBlob value) throws IOException {
        LobLocator loc = this._locatorFactory.makeLobLocator(this.getLobDir());
        OutputStream blobout = null;
        try {
            BlobSource blob = this.makeBlobSource(loc);
            blobout = blob.setBinaryStream(0L);
            blobout.write(value.getBytes());
        }
        catch (AxionException e) {
            throw ExceptionConverter.convertToIOException(e);
        }
        catch (SQLException e) {
            throw ExceptionConverter.convertToIOException(e);
        }
        finally {
            try {
                blobout.close();
            }
            catch (Exception e) {}
        }
        return loc;
    }

    protected BlobSource makeBlobSource(LobLocator loc) throws AxionException {
        return new BlobSource(loc.getLobSource(this.getLobDir(), this.getLobFile()));
    }

    protected ClobSource makeClobSource(LobLocator loc) throws AxionException {
        return new ClobSource(loc.getLobSource(this.getLobDir(), this.getLobFile()));
    }
}

