/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;

public class UpperFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new StringType();

    public UpperFunction() {
        super("UPPER");
    }

    public ConcreteFunction makeNewInstance() {
        return new UpperFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = this.getArgument(0).evaluate(row);
        String strval = (String)RETURN_TYPE.convert(val);
        if (null == strval) {
            return null;
        }
        return strval.toUpperCase();
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

