/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.util.Arrays;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.types.StringType;

public class SpaceFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType INTEGER_TYPE = new IntegerType();
    private static final DataType STRING_TYPE = new StringType();

    public SpaceFunction() {
        super("SPACE");
    }

    public ConcreteFunction makeNewInstance() {
        return new SpaceFunction();
    }

    public DataType getDataType() {
        return STRING_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object val = sel.evaluate(row);
        Integer i = (Integer)INTEGER_TYPE.convert(val);
        char[] spaces = new char[i.intValue()];
        Arrays.fill(spaces, ' ');
        return new String(spaces);
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

