/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.Index;
import org.axiondb.IndexLoader;
import org.axiondb.Table;
import org.axiondb.io.AxionFileSystem;

public abstract class BaseBTreeIndexLoader
implements IndexLoader {
    protected static AxionFileSystem FS = new AxionFileSystem();

    public Index loadIndex(Table table, File dataDirectory) throws AxionException {
        ObjectInputStream in = null;
        try {
            String name = dataDirectory.getName();
            File file = new File(dataDirectory, name + ".DATA");
            in = FS.openObjectInputSteam(file);
            int ver = in.readInt();
            if (ver != 1) {
                throw new AxionException("Can't parse data file " + file + " for index " + name + ", unrecognized data file version " + ver);
            }
            String col = in.readUTF();
            boolean unique = in.readBoolean();
            Index index = this.makeIndex(name, table.getColumn(col), unique, dataDirectory);
            FS.closeInputStream(in);
            return index;
        }
        catch (IOException e) {
            try {
                throw new AxionException(e);
            }
            catch (Throwable throwable) {
                FS.closeInputStream(in);
                throw throwable;
            }
        }
    }

    public void saveIndex(Index index, File dataDirectory) throws AxionException {
        ObjectOutputStream out = null;
        try {
            String name = index.getName();
            File file = new File(dataDirectory, name + ".DATA");
            out = FS.createObjectOutputSteam(file);
            out.writeInt(1);
            out.writeUTF(index.getIndexedColumn().getName());
            out.writeBoolean(index.isUnique());
            FS.closeOutputStream(out);
        }
        catch (IOException e) {
            try {
                throw new AxionException(e);
            }
            catch (Throwable throwable) {
                FS.closeOutputStream(out);
                throw throwable;
            }
        }
        this.save(index, dataDirectory);
    }

    public abstract void saveIndexAfterTruncate(Index var1, File var2) throws AxionException;

    public abstract void save(Index var1, File var2) throws AxionException;

    protected abstract Index makeIndex(String var1, Column var2, boolean var3, File var4) throws AxionException;
}

