/* 
 *   Creation Date: <1999/02/22 22:46:22 samuel>
 *   Time-stamp: <2001/09/29 22:25:48 samuel>
 *   
 *	<debugger.h>
 *	
 *	World interface of the debugger
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_DEBUGGER
#define _H_DEBUGGER

#include <sys/types.h>

extern void 	debugger_init( void );
extern void 	debugger_cleanup( void );

extern int	debugger_enabled( void );
extern int	debugger_attached( void );

/*******************************************/
/*	montior.c / nub.c		   */
/*******************************************/

extern void 	refresh_debugger_window( void );
extern void 	refresh_debugger( void );

/* debug actions */
enum{  
	kDbgNOP=0, kDbgGo, kDbgGoRFI, kDbgStep, kDbgExit, kDbgStop
};


/*******************************************/
/*	cmdline.c / nub.c		   */
/*******************************************/

extern int	printm(const char *fmt,...)
                __attribute__ ((format (printf, 1, 2)));

extern void	perrorm(const char *fmt,... )
                __attribute__ ((format (printf, 1, 2)));

extern int	logprint(const char *fmt,... )
                __attribute__ ((format (printf, 1, 2)));

extern int	async_print(const char *fmt,... )
                __attribute__ ((format (printf, 1, 2)));

typedef int (*dbg_cmd_fp)( int argv, char **argc );
extern void	add_cmd( char *cmdname, char *help, int dummy, dbg_cmd_fp func );


/*******************************************/
/*	breakpoints.c			   */
/*******************************************/

#define BREAKPOINT_OPCODE	0x01234567	/* 0 is used by MacOS... */

extern int	is_stop_breakpoint( ulong mvptr );

#define HARD_BREAKPOINT \
	({ printm("Hardcoded breakpoint in '"__FILE__"'\n"); stop_emulation(); })

#endif   /* _H_DEBUGGER */
