/* 
 *   Creation Date: <2000/10/28 17:38:39 samuel>
 *   Time-stamp: <2001/09/22 19:07:02 samuel>
 *   
 *	<molrcget.c>
 *	
 *	Stand alone interface to the molrc config file
 *   
 *   Copyright (C) 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */


#include "mol_config.h"
#include "res_manager.h"
#include "debugger.h"
#include "version.h"
#include <stdarg.h>

int in_security_mode = 1;

enum { kRetStr=1, kRetFullStr, kRetBool, kRetNumeric, kIndStr };
enum { kPrintLockfile=1, kPrintLibdir, kPrintLibdirHC };


static int
doit( int action, char *res, int index, int field )
{
	int i;
	char *s = get_str_res(res);
	
	if( !s )
		return -1;
	
	switch( action ){
	case kRetBool:
		return !get_bool_res( res );
	case kRetNumeric:
		printf( "%ld\n", get_numeric_res(res) );
		break;
	case kRetFullStr:
		for(i=0; (s=get_str_res_ind(res, 0, i)) ;i++ )
			printf( "%s ", s );
		printf("\n");
		return 0;
	case kRetStr:
		printf("%s\n", s );
		break;
	case kIndStr:
		s = get_str_res_ind( res, index, field );
		if( !s )
			return -1;
		printf("%s\n", s );
		break;
	default:
		printf("Internal error\n");
		break;
	}
	return 0;
}

int
main( int argc, char **argv  )
{
	int i, n=-1, ret=0;
	int action = kRetStr;
	int nnn = argc;
	int field=0, index=0;
	int print_ind=0;
	int test_molrc=0;
	char *res;

	if( !getuid() )
		in_security_mode = 0;
	
	for(i=1; i<argc; i++ )
		if( !strcmp("--", argv[i]) ) {
			n=i;
			nnn=i;
			break;
		}

	/* Parse getmolconfig options */
	for( ;; ){
		int c;
		if( (c=getopt( nnn, argv, "tvVpPbnlLahf:i:" )) == -1 )
			break;

		switch(c) {
		case 0:
			break;
		case 'b':
			action = kRetBool;
			break;
		case 'n':
			action = kRetNumeric;
			break;
		case 'l':
		case 'a':
			action = kRetFullStr;
			break;
		case 'L':
			print_ind = kPrintLockfile;
			break;
		case 'f':
			if( optarg ) {
				sscanf(optarg, "%d", &field );
				action = kIndStr;
			}
			break;
		case 'i':
			if( optarg ) {
				sscanf(optarg, "%d", &index );
				action = kIndStr;
			}
			break;
		case 'p': /* libdir */
			print_ind = kPrintLibdir;
			break;
		case 'P': /* hardcoded libdir */
			print_ind = kPrintLibdirHC;
			break;
		case '?':
		case 'h':
			fprintf(stderr, "Usage: molrcget [-t] [-bnla] [-pP] [-i index] [-f field] RESOURCE [-- MOLOPTIONS]\n");
			exit(1);
			break;
		case 'V':
			printf("%d.%d.%d\n", MAJOR_VERSION, MINOR_VERSION, PATCH_LEVEL );
			return 0;
		case 't': /* test that the molrc file exist */
			test_molrc=1;
			break;
		default:
			fprintf(stderr, "?? getopt returned unexpected value %d\n", c );
			break;
		}
	}
	res = argv[nnn-1];

	optind = 0;
	if( n<0 )
		res_manager_init( 0, 1, argv );
	else
		res_manager_init( 0, argc-n, &argv[n] );

	if( print_ind ) {
		char buf[256];

		switch(print_ind) {
		case kPrintLibdir:
			printf("%s\n", getcwd( buf, sizeof(buf)));
			break;
		case kPrintLibdirHC:
			printf( "%s\n", MOL_LIB_DIR );
			break;
		case kPrintLockfile:
			printf( "%s\n", get_lockfile() );
			break;
		default:
			printf("Internal error\n");
			return 1;
		}
		return 0;
	}
	if( !test_molrc )
		ret = doit( action, res, index, field );
	res_manager_cleanup();
	return ret;
}


int 
printm(const char *fmt,... ) 
{
        va_list args;
	int ret;

	va_start( args, fmt );
	ret = vfprintf( stderr, fmt, args ); 
	va_end( args );	

	return ret;
}
