/* 
 *   Creation Date: <1999/03/06 13:39:52 samuel>
 *   Time-stamp: <2000/12/31 03:27:25 samuel>
 *   
 *	<pci.h>
 *	
 *	PCI top-level driver (used by bandit, chaos etc)
 *   
 *   Copyright (C) 1999, 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_PCI
#define _H_PCI

#include "promif.h"

#include <sys/types.h>

typedef void (*pci_map_base_fp)( int regnum, ulong base, int add_map, void *usr );

typedef struct pci_dev_info 
{
	short	vendor_id;
	short	device_id;
	char	revision;	
	short	device_class;
} pci_dev_info_t;

extern int 	pci_init( void );

extern void 	pci_bridges_init( void );
extern void 	pci_bridges_cleanup( void );

extern void 	write_pci_config( int bus, int dev_fn, int offs, ulong val, int len );
extern ulong 	read_pci_config( int bus, int dev_fn, int offs, int len );

extern int 	add_pci_bus( int busnum );
extern int 	add_pci_device( int bus, int dev_fn, pci_dev_info_t *dev_info, void *usr );
extern void 	set_pci_dev_usr_info( int bus, int dev_fn, void *usr );

extern int 	use_pci_rom( char *res_name, char *fallback_name, int bus_id, int dev_fn );
extern int 	set_pci_base( int bus, int dev_fn, int ind, ulong bmask, pci_map_base_fp proc );

extern int 	pci_device_loc( mol_device_node_t *dev, int *bus_ptr, int *devfn_ptr );
extern int 	pci_get_bus_number( mol_device_node_t *dev, int *first_bus, int *last_bus );

extern void 	pci_assign_addresses( void );

#endif   /* _H_PCI */
