/* null.c
 *
 * Copyright (c) 1999 Scott Manley, Barath Raghavan, Jack Moffitt, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "mixer.h"


/* Null Module.... generates complete silence */
Mod_Ptr mod_null_init(Mod_Ptr out){
Mod_Ptr new;
new=malloc(sizeof(Mod_Struct));
sprintf(new->name,"Null %X",new);
new->Mod_Type=MOD_NULL;
new->volume=1.0;
new->num_ints=0;
new->num_floats=0;
new->num_connections=1;
new->param_i=NULL;
new->param_f=NULL;
new->connections=malloc(sizeof(Mod_Ptr));
new->connections[0]=out;
new->gen_param=NULL;
new->format=out->format;
return new;
}


void mod_null_get(Mod_Ptr set,int *adat){
int i;
for(i=0;i<BUF_SIZE;i++)
  adat[i]=0;
}



/* Thru mixer module, again pretty much redundant, sends input to output
   after scaling with volume control */

Mod_Ptr mod_thru_init(Mod_Ptr out){
Mod_Ptr new;
new=malloc(sizeof(Mod_Struct));
sprintf(new->name,"Null %X",new);
new->Mod_Type=MOD_THRU;
new->volume=1.0;
new->num_ints=0;
new->num_floats=0;
new->num_connections=2;
new->param_i=NULL;
new->param_f=NULL;
new->connections=malloc(2*sizeof(Mod_Ptr));
new->connections[0]=out;
new->connections[1]=NULL;
new->gen_param=NULL;
new->format=out->format;
return new;
}

void mod_thru_get(Mod_Ptr set,int *adat){
int i;
  get_audio(set->connections[1],adat); 
  for(i=0;i<BUF_SIZE;i++)
    adat[i]=adat[i]*set->volume;
}

/* Thru mixer module, two inputs with a cross fader and some parameters 
   to say what way the cross fade is working */
Mod_Ptr mod_mixer_init(Mod_Ptr out){
Mod_Ptr new;
new=malloc(sizeof(Mod_Struct));
sprintf(new->name,"Null %X",new);
new->Mod_Type=MOD_THRU;
new->volume=1.0;
new->num_ints=0;
new->num_floats=2;
new->num_connections=3;
new->param_i=NULL;
new->param_f=malloc(2*sizeof[float]);
new->param_f[0]=0.5;
new->param_f[1]=0;
new->connections=malloc(3*sizeof(Mod_Ptr));
new->connections[0]=out;
new->connections[1]=NULL;
new->connections[2]=NULL;
new->gen_param=NULL;
new->format=out->format;
return new;
}

void mod_mixer_get(Mod_Ptr set,int *adat){
static int buf[BUF_SIZE];
int i;

  get_audio(set->connections[1],adat);
  get_audio(set->connections[2],buf);  
  for(i=0;i<BUF_SIZE;i++)
    adat[i]=(adat[i]*set->param_f[0] + buf[i]*(1-set->param_f[0]) ) *set->volume;
}





