/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KFOLDINGPROGRESSWIDGET_H
#define KFOLDINGPROGRESSWIDGET_H

#include <qpixmap.h>
#include <qlabel.h>


/**
@author Kevin Hessels
*/
class kfoldingProgressWidget : public QLabel
{

Q_OBJECT

public:
	kfoldingProgressWidget( QWidget* parent = 0L, const char* name = 0L, Orientation type = Qt::Horizontal, const QString& image = QString::null );
	virtual ~kfoldingProgressWidget();
	
	void setImage( const QString& );
	void setOrientation( Orientation );
		
	virtual int widthForHeight( int ) const;
	virtual int heightForWidth( int ) const;
	
public slots:
	void slotSetPercentage( int );
	virtual void update();

private:
	void showPixmap();

	int		_percent;
	
	Orientation	_orientation;
	QPixmap		_orig;
};

#endif
