/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kfoldingprogresswidget.h"

#include <qimage.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qpen.h>

#include <kdebug.h>
#include <kimageeffect.h>
#include <kpixmapeffect.h>
#include <kpixmapsplitter.h>
#include <kstandarddirs.h>


kfoldingProgressWidget::kfoldingProgressWidget(QWidget *parent, const char *name, Orientation orient, const QString& image ) 
	: QLabel(parent, name),
	  _percent( 0 ),
	  _orientation( orient )
{
	_orig = QPixmap( image );
	showPixmap();
	return;
} // kfoldingProgressWidget ctor



kfoldingProgressWidget::~kfoldingProgressWidget()
{
	return;
} // kfoldingProgressWidget dtor



void kfoldingProgressWidget::update()
{
	showPixmap();
	QLabel::update();
	return;
} // update


void kfoldingProgressWidget::setImage( const QString& image )
{
	_orig = QPixmap( image );
	if ( _orig.isNull() ) {
		_orig = QPixmap( locate( "data", "kfolding/pics/foldinglogo.png" ) );
	}
	else {
		update();
	}	
	return;
} // setImage


void kfoldingProgressWidget::setOrientation( Orientation newOrientation )
{
	if ( newOrientation != _orientation ) {
		_orientation = newOrientation;
		
		if ( Qt::Horizontal == _orientation ) {
			kdDebug() << "Switch to Horizontal" << endl;
		}
		else if ( Qt::Vertical == _orientation ) {
			kdDebug() << "Switch to Vertical" << endl;
		}
	} // if
	showPixmap();
	return;
} // setOrientation



int kfoldingProgressWidget::widthForHeight( int height ) const
{
	float width;
	
	width = ( ( _orig.width() * height ) / _orig.height() );
	return ( int ) width;   
} // widthForHeight
        
        

int kfoldingProgressWidget::heightForWidth( int width ) const
{
	float height;
	
	height = ( ( _orig.width() * width ) / _orig.height() );
	return ( int ) height;
} // heightForWidth



void kfoldingProgressWidget::slotSetPercentage( int percent )
{
	_percent = percent;
	showPixmap();
	return;
} // slotSetPercentage


void kfoldingProgressWidget::showPixmap()
{
	int w, h;
	w = h = 0;
	
	if ( _orig.isNull() )
		return;
	
	QImage graph = _orig.convertToImage();
	
	// compose the graph - if 0% - all gray, if 100, all coloured
	if ( _percent == 0 ) {
		graph = KImageEffect::toGray( graph, true );
	}
	else if ( _percent > 0 && _percent < 100 )  {
		QImage baseImg = KImageEffect::toGray( graph, true );
		QPixmap base( baseImg );

		int colourWidth  = ( int ) ( ( 0.01 * _percent ) * _orig.width() );
		bitBlt( &base, 0, 0, &_orig, 0, 0, colourWidth, _orig.height() );
		
		// draw a line at the boundary
		QPainter painter;
		QPen pen( red, 2 );
		painter.begin( &base );
		painter.setPen( pen );
		painter.drawLine( colourWidth, 0, colourWidth, base.height() );
		painter.end();
		
		graph = base.convertToImage();
	} 
	else if ( _percent == 100 ) {
		// nothing to do!
	} // else
	
	
	// resize & rotate the image, as necessary
	if ( _orientation == Qt::Vertical ) {
		graph = KImageEffect::rotate( graph, KImageEffect::Rotate270 );
	
		h = height();
		w = ( int ) ( ( _orig.height() * h ) / _orig.width() );
	} 
	else if ( _orientation == Qt::Horizontal ) {
		h = height();
		w = widthForHeight( h );
	} // else
	graph = graph.smoothScale( w, h, QImage::ScaleFree );
	
	// display the image
	QPixmap pix( graph );
	setPixmap( pix );
	return;
} // showPixmap


#include "kfoldingprogresswidget.moc"
